/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.conn;

import com.gemstone.gnu.trove.THashMap;
import com.pivotal.gemfirexd.internal.engine.sql.GeneralizedStatement;
import com.pivotal.gemfirexd.internal.iapi.db.Database;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheFactory;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheManager;
import com.pivotal.gemfirexd.internal.iapi.services.cache.Cacheable;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheableFactory;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.JavaFactory;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.Serviceable;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleSupportable;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertySetCallback;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.LanguageFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.Statement;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.NodeFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizerFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Parser;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompilerFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.sql.GenericStatement;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParserImpl;
import com.pivotal.gemfirexd.internal.impl.sql.conn.CachedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.conn.GenericLanguageConnectionContext;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

public class GenericLanguageConnectionFactory
implements LanguageConnectionFactory,
CacheableFactory,
PropertySetCallback,
ModuleControl,
ModuleSupportable {
    private ExecutionFactory ef;
    private OptimizerFactory of;
    private TypeCompilerFactory tcf;
    private DataValueFactory dvf;
    private UUIDFactory uuidFactory;
    private JavaFactory javaFactory;
    private ClassFactory classFactory;
    private NodeFactory nodeFactory;
    private PropertyFactory pf;
    private final AtomicInteger nextLCCInstanceNumber = new AtomicInteger(0);
    private int cacheSize = 100;
    private CacheManager singleStatementCache;

    @Override
    public Statement getStatement(SchemaDescriptor compilationSchema, String statementText, short execFlags, boolean createGeneralizedStatement, THashMap ncjMetaData) {
        if (createGeneralizedStatement) {
            return new GeneralizedStatement(compilationSchema, statementText, execFlags, ncjMetaData);
        }
        return new GenericStatement(compilationSchema, statementText, execFlags, ncjMetaData);
    }

    @Override
    public LanguageConnectionContext newLanguageConnectionContext(ContextManager cm, TransactionController tc, LanguageFactory lf, Database db, String userName, String drdaID, long connId, boolean isRemote, String dbname) throws StandardException {
        return new GenericLanguageConnectionContext(cm, tc, lf, this, db, userName, this.getNextLCCInstanceNumber(), drdaID, connId, isRemote, dbname);
    }

    @Override
    public Cacheable newCacheable(CacheManager cm) {
        return new CachedStatement();
    }

    @Override
    public UUIDFactory getUUIDFactory() {
        return this.uuidFactory;
    }

    @Override
    public ClassFactory getClassFactory() {
        return this.classFactory;
    }

    @Override
    public JavaFactory getJavaFactory() {
        return this.javaFactory;
    }

    @Override
    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    @Override
    public final ExecutionFactory getExecutionFactory() {
        return this.ef;
    }

    @Override
    public PropertyFactory getPropertyFactory() {
        return this.pf;
    }

    @Override
    public OptimizerFactory getOptimizerFactory() {
        return this.of;
    }

    @Override
    public TypeCompilerFactory getTypeCompilerFactory() {
        return this.tcf;
    }

    @Override
    public DataValueFactory getDataValueFactory() {
        return this.dvf;
    }

    @Override
    public boolean canSupport(String identifier, Properties startParams) {
        return Monitor.isDesiredType(startParams, 130);
    }

    private int statementCacheSize(Properties startParams) {
        String wantCacheProperty = null;
        wantCacheProperty = PropertyUtil.getPropertyFromSet(startParams, "gemfirexd.language.statementCacheSize");
        SanityManager.DEBUG((String)"StatementCacheInfo", (String)("Cacheing implementation chosen if null or 0<" + wantCacheProperty));
        if (wantCacheProperty != null) {
            try {
                this.cacheSize = Integer.parseInt(wantCacheProperty);
            }
            catch (NumberFormatException nfe) {
                this.cacheSize = 100;
            }
        }
        return this.cacheSize;
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        this.dvf = (DataValueFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory", startParams);
        this.javaFactory = (JavaFactory)Monitor.startSystemModule("com.pivotal.gemfirexd.internal.iapi.services.compiler.JavaFactory");
        this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        this.classFactory = (ClassFactory)Monitor.getServiceModule(this, "com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory");
        if (this.classFactory == null) {
            this.classFactory = (ClassFactory)Monitor.findSystemModule("com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory");
        }
        this.setValidation();
        this.ef = (ExecutionFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory", startParams);
        this.of = (OptimizerFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizerFactory", startParams);
        this.tcf = (TypeCompilerFactory)Monitor.startSystemModule("com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompilerFactory");
        this.nodeFactory = (NodeFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.sql.compile.NodeFactory", startParams);
        int cacheSize = this.statementCacheSize(startParams);
        if (cacheSize > 0) {
            CacheFactory cacheFactory = (CacheFactory)Monitor.startSystemModule("com.pivotal.gemfirexd.internal.iapi.services.cache.CacheFactory");
            this.singleStatementCache = cacheFactory.newCacheManager(this, "StatementCache", cacheSize / 4, cacheSize);
        }
    }

    @Override
    public CacheManager getStatementCache() {
        return this.singleStatementCache;
    }

    @Override
    public void stop() {
    }

    @Override
    public void init(boolean dbOnly, Dictionary p) {
    }

    @Override
    public boolean validate(String key, Serializable value, Dictionary p) throws StandardException {
        if (value == null) {
            return true;
        }
        if (key.equals("gemfirexd.authz-default-connection-mode")) {
            String value_s = (String)((Object)value);
            if (!(value_s == null || StringUtil.SQLEqualsIgnoreCase(value_s, "NOACCESS") || StringUtil.SQLEqualsIgnoreCase(value_s, "READONLYACCESS") || StringUtil.SQLEqualsIgnoreCase(value_s, "FULLACCESS"))) {
                throw StandardException.newException("4250B", (Object)key, (Object)value_s);
            }
            return true;
        }
        if (key.equals("gemfirexd.authz-read-only-access-users") || key.equals("gemfirexd.authz-full-access-users")) {
            String[] newList_a;
            String value_s = (String)((Object)value);
            try {
                newList_a = IdUtil.parseIdList(value_s);
            }
            catch (StandardException se) {
                throw StandardException.newException("4250B", se, (Object)key, (Object)value_s);
            }
            String dups = IdUtil.dups(newList_a);
            if (dups != null) {
                throw StandardException.newException("4250D", (Object)key, (Object)dups);
            }
            String otherList = key.equals("gemfirexd.authz-read-only-access-users") ? (String)p.get("gemfirexd.authz-full-access-users") : (String)p.get("gemfirexd.authz-read-only-access-users");
            String[] otherList_a = IdUtil.parseIdList(otherList);
            String both = IdUtil.intersect(newList_a, otherList_a);
            if (both != null) {
                throw StandardException.newException("4250C", both);
            }
            return true;
        }
        return false;
    }

    @Override
    public Serviceable apply(String key, Serializable value, Dictionary p) {
        return null;
    }

    @Override
    public Serializable map(String key, Serializable value, Dictionary p) {
        return null;
    }

    protected void setValidation() throws StandardException {
        this.pf = (PropertyFactory)Monitor.findServiceModule(this, "com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory");
        this.pf.addPropertySetNotification(this);
    }

    @Override
    public Parser newParser(CompilerContext cc) {
        return new ParserImpl(cc);
    }

    protected final int getNextLCCInstanceNumber() {
        return this.nextLCCInstanceNumber.incrementAndGet();
    }
}

