/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.catalog.types.RoutineAliasInfo;
import com.pivotal.gemfirexd.internal.engine.sql.compile.ParameterizedConstantNode;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.AliasDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.JSQLType;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaToSQLValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MethodCallNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParameterNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SQLToJavaValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UntypedNullConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;

public class StaticMethodCallNode
extends MethodCallNode {
    public TableName procedureName;
    protected LocalField[] outParamArrays;
    protected int[] applicationParameterNumbers;
    protected boolean isSystemCode;
    protected boolean alreadyBound;
    protected LocalField returnsNullOnNullState;
    protected AliasDescriptor ad;
    private boolean isResolverCode;
    private String closeMatch;

    @Override
    public String getMethodName() {
        return this.procedureName != null ? this.procedureName.getFullTableName() : this.methodName;
    }

    @Override
    public void init(Object methodName, Object javaClassName) {
        if (methodName instanceof String) {
            this.init(methodName);
        } else {
            this.procedureName = (TableName)methodName;
            this.init(this.procedureName.getTableName());
        }
        this.javaClassName = (String)javaClassName;
    }

    @Override
    public JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        if (this.alreadyBound) {
            return this;
        }
        this.bindParameters(fromList, subqueryList, aggregateVector);
        if (this.javaClassName == null) {
            CompilerContext cc = this.getCompilerContext();
            String schemaName = this.procedureName.getSchemaName();
            boolean noSchema = schemaName == null;
            SchemaDescriptor sd = this.getSchemaDescriptor(schemaName, schemaName != null);
            this.resolveRoutine(fromList, subqueryList, aggregateVector, sd);
            if (this.ad == null && noSchema && !this.forCallStatement) {
                sd = this.getSchemaDescriptor("SYSFUN", true);
                this.resolveRoutine(fromList, subqueryList, aggregateVector, sd);
            }
            if (this.ad == null) {
                StringBuilder procSignature = new StringBuilder();
                procSignature.append(this.procedureName);
                String[] argTypes = this.getObjectSignature();
                if (argTypes != null) {
                    procSignature.append('(');
                    for (String arg : argTypes) {
                        procSignature.append(arg).append(',');
                    }
                    procSignature.setCharAt(procSignature.length() - 1, ')');
                }
                throw StandardException.newException("42Y03", (Object)procSignature.toString(), (Object)(this.closeMatch != null ? " Close match: " + this.closeMatch : ""));
            }
            cc.createDependency(this.ad);
            this.methodName = this.ad.getAliasInfo().getMethodName();
            this.javaClassName = this.ad.getJavaClassName();
            if (this.javaClassName.startsWith("com.pivotal.gemfirexd.internal.")) {
                if (this.hasDSID()) {
                    this.getCompilerContext().setOptimizeForWrite(true);
                }
                if (!sd.isSystemSchema()) {
                    throw StandardException.newException("42X51", (Throwable)null, (Object)this.javaClassName);
                }
            }
        }
        this.verifyClassExist(this.javaClassName);
        this.resolveMethodCall(this.javaClassName, true);
        this.alreadyBound = true;
        if (this.isPrivilegeCollectionRequired()) {
            this.getCompilerContext().addRequiredRoutinePriv(this.ad);
        }
        if (this.routineInfo != null) {
            TypeId returnTypeId;
            TypeDescriptor returnType;
            if (this.methodParms != null) {
                this.optimizeDomainValueConversion();
            }
            if ((returnType = this.routineInfo.getReturnType()) != null) {
                this.createTypeDependency(DataTypeDescriptor.getType(returnType));
            }
            if (returnType != null && !returnType.isRowMultiSet() && !returnType.isUserDefinedType() && (returnTypeId = TypeId.getBuiltInTypeId(returnType.getJDBCTypeId())).variableLength()) {
                DataTypeDescriptor returnValueDtd = new DataTypeDescriptor(returnTypeId, returnType.getPrecision(), returnType.getScale(), returnType.isNullable(), returnType.getMaximumWidth());
                ValueNode returnValueToSQL = (ValueNode)this.getNodeFactory().getNode(36, this, this.getContextManager());
                ValueNode returnValueCastNode = (ValueNode)this.getNodeFactory().getNode(60, returnValueToSQL, returnValueDtd, this.getContextManager());
                returnValueCastNode.setCollationInfo(returnType.getCollationType(), 1);
                JavaValueNode returnValueToJava = (JavaValueNode)this.getNodeFactory().getNode(28, returnValueCastNode, this.getContextManager());
                returnValueToJava.setCollationType(returnType.getCollationType());
                return returnValueToJava.bindExpression(fromList, subqueryList, aggregateVector);
            }
        }
        return this;
    }

    private void optimizeDomainValueConversion() throws StandardException {
        int count = this.methodParms.length;
        for (int parm = 0; parm < count; ++parm) {
            JavaValueNode paramIsJavaValueNode;
            if (!(this.methodParms[parm] instanceof SQLToJavaValueNode) || !(((SQLToJavaValueNode)this.methodParms[parm]).getSQLValueNode() instanceof JavaToSQLValueNode) || !((paramIsJavaValueNode = ((JavaToSQLValueNode)((SQLToJavaValueNode)this.methodParms[parm]).getSQLValueNode()).getJavaValueNode()) instanceof StaticMethodCallNode)) continue;
            StaticMethodCallNode paramIsMethodCallNode = (StaticMethodCallNode)paramIsJavaValueNode;
            if (paramIsMethodCallNode.routineInfo == null || !paramIsMethodCallNode.routineInfo.calledOnNullInput()) continue;
            this.methodParms[parm] = ((JavaToSQLValueNode)((SQLToJavaValueNode)this.methodParms[parm]).getSQLValueNode()).getJavaValueNode();
        }
    }

    private void resolveRoutine(FromList fromList, SubqueryList subqueryList, Vector aggregateVector, SchemaDescriptor sd) throws StandardException {
        if (sd.getUUID() != null) {
            List list = this.getDataDictionary().getRoutineList(sd.getUUID().toString(), this.methodName, this.forCallStatement ? (char)'P' : 'F');
            for (int i = list.size() - 1; i >= 0; --i) {
                AliasDescriptor proc = (AliasDescriptor)list.get(i);
                RoutineAliasInfo routineInfo = (RoutineAliasInfo)proc.getAliasInfo();
                this.closeMatch = routineInfo.toString(sd.getSchemaName());
                int parameterCount = routineInfo.getParameterCount();
                if (parameterCount != this.methodParms.length) continue;
                TypeDescriptor[] parameterTypes = routineInfo.getParameterTypes();
                int sigParameterCount = parameterCount;
                if (routineInfo.getMaxDynamicResultSets() > 0) {
                    ++sigParameterCount;
                }
                this.signature = new JSQLType[sigParameterCount];
                for (int p = 0; p < parameterCount; ++p) {
                    TypeId typeId;
                    TypeDescriptor td = parameterTypes[p];
                    TypeId parameterTypeId = typeId = TypeId.getTypeId(td);
                    int parameterMode = routineInfo.getParameterModes()[p];
                    if (parameterMode != 1) {
                        String arrayType;
                        switch (typeId.getJDBCTypeId()) {
                            case -5: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 8: {
                                arrayType = this.getTypeCompiler(typeId).getCorrespondingPrimitiveTypeName().concat("[]");
                                break;
                            }
                            default: {
                                arrayType = typeId.getCorrespondingJavaTypeName().concat("[]");
                            }
                        }
                        typeId = TypeId.getUserDefinedTypeId(arrayType, false);
                    }
                    DataTypeDescriptor methoddtd = new DataTypeDescriptor(typeId, td.getPrecision(), td.getScale(), td.isNullable(), td.getMaximumWidth());
                    this.signature[p] = new JSQLType(methoddtd);
                    ValueNode sqlParamNode = null;
                    if (this.methodParms[p] instanceof SQLToJavaValueNode) {
                        SQLToJavaValueNode sql2j = (SQLToJavaValueNode)this.methodParms[p];
                        sqlParamNode = sql2j.getSQLValueNode();
                    }
                    boolean isParameterMarker = true;
                    if (sqlParamNode == null || !sqlParamNode.requiresTypeFromContext()) {
                        if (parameterMode != 1) {
                            throw StandardException.newException("42886", (Object)RoutineAliasInfo.parameterMode(parameterMode), (Object)routineInfo.getParameterNames()[p]);
                        }
                        isParameterMarker = false;
                    } else {
                        ValueNode vn;
                        if (this.applicationParameterNumbers == null) {
                            this.applicationParameterNumbers = new int[parameterCount];
                        }
                        this.applicationParameterNumbers[p] = sqlParamNode instanceof UnaryOperatorNode ? ((vn = ((UnaryOperatorNode)sqlParamNode).getParameterOperand()).isParameterizedConstantNode() ? ((ParameterizedConstantNode)vn).getConstantNumber() : ((ParameterNode)vn).getParameterNumber()) : (sqlParamNode.isParameterizedConstantNode() ? ((ParameterizedConstantNode)sqlParamNode).getConstantNumber() : ((ParameterNode)sqlParamNode).getParameterNumber());
                    }
                    DataTypeDescriptor paramdtd = new DataTypeDescriptor(parameterTypeId, td.getPrecision(), td.getScale(), td.isNullable(), td.getMaximumWidth());
                    boolean needCast = false;
                    if (!isParameterMarker) {
                        if (sqlParamNode instanceof UntypedNullConstantNode) {
                            sqlParamNode.setType(paramdtd);
                        } else {
                            DataTypeDescriptor dts;
                            TypeId argumentTypeId;
                            if (sqlParamNode != null) {
                                argumentTypeId = sqlParamNode.getTypeId();
                                dts = sqlParamNode.getTypeServices();
                            } else {
                                dts = DataTypeDescriptor.getSQLDataTypeDescriptor(this.methodParms[p].getJavaTypeName());
                                if (dts == null) {
                                    throw StandardException.newException("X0X57.S", this.methodParms[p].getJavaTypeName());
                                }
                                argumentTypeId = dts.getTypeId();
                            }
                            if (!this.getTypeCompiler(parameterTypeId).storable(argumentTypeId, this.getClassFactory())) {
                                throw StandardException.newException("42821", (Object)parameterTypeId.getSQLTypeName(), (Object)argumentTypeId.getSQLTypeName(), (Object)sqlParamNode.toString());
                            }
                            if (!paramdtd.isExactTypeAndLengthMatch(dts)) {
                                needCast = true;
                            }
                        }
                    } else if (parameterTypeId.variableLength() && parameterMode != 4) {
                        needCast = true;
                    }
                    if (needCast) {
                        if (sqlParamNode == null) {
                            sqlParamNode = (ValueNode)this.getNodeFactory().getNode(36, this.methodParms[p], this.getContextManager());
                        }
                        ValueNode castNode = (ValueNode)this.getNodeFactory().getNode(60, sqlParamNode, paramdtd, this.getContextManager());
                        this.methodParms[p] = (JavaValueNode)this.getNodeFactory().getNode(28, castNode, this.getContextManager());
                        this.methodParms[p] = this.methodParms[p].bindExpression(fromList, subqueryList, aggregateVector);
                    }
                    if (!isParameterMarker) continue;
                    sqlParamNode.setType(paramdtd);
                }
                if (sigParameterCount != parameterCount) {
                    TypeId typeId = TypeId.getUserDefinedTypeId("java.sql.ResultSet[]", false);
                    DataTypeDescriptor dtd = new DataTypeDescriptor(typeId, 0, 0, false, -1);
                    this.signature[parameterCount] = new JSQLType(dtd);
                }
                this.routineInfo = routineInfo;
                this.ad = proc;
                if (!sd.isSystemSchema() || routineInfo.getReturnType() != null || routineInfo.getSQLAllowed() == 3) break;
                this.isSystemCode = true;
                break;
            }
        }
    }

    @Override
    public void generateOneParameter(ExpressionClassBuilder acb, MethodBuilder mb, int parameterNumber) throws StandardException {
        int parameterMode;
        SQLToJavaValueNode sql2j = null;
        if (this.methodParms[parameterNumber] instanceof SQLToJavaValueNode) {
            sql2j = (SQLToJavaValueNode)this.methodParms[parameterNumber];
        }
        if (this.routineInfo != null) {
            parameterMode = this.routineInfo.getParameterModes()[parameterNumber];
        } else {
            parameterMode = 1;
            if (sql2j != null && sql2j.getSQLValueNode().requiresTypeFromContext()) {
                ValueNode pn = sql2j.getSQLValueNode() instanceof UnaryOperatorNode ? ((UnaryOperatorNode)sql2j.getSQLValueNode()).getParameterOperand() : sql2j.getSQLValueNode();
                int applicationParameterNumber = pn.isParameterizedConstantNode() ? ((ParameterizedConstantNode)pn).getConstantNumber() : ((ParameterNode)pn).getParameterNumber();
                String parameterType = this.methodParameterTypes[parameterNumber];
                if (parameterType.endsWith("[]")) {
                    MethodBuilder constructor = acb.getConstructor();
                    acb.pushThisAsActivation(constructor);
                    constructor.callMethod((short)185, null, "getParameterValueSet", "com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet", 0);
                    constructor.push(applicationParameterNumber);
                    constructor.push(0);
                    constructor.callMethod((short)185, null, "setParameterMode", "void", 2);
                    constructor.endStatement();
                }
            }
        }
        switch (parameterMode) {
            case 0: 
            case 1: 
            case 2: {
                if (sql2j != null) {
                    sql2j.returnsNullOnNullState = this.returnsNullOnNullState;
                }
                super.generateOneParameter(acb, mb, parameterNumber);
                break;
            }
        }
        switch (parameterMode) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                String methodParameterType = this.methodParameterTypes[parameterNumber];
                String arrayType = methodParameterType.substring(0, methodParameterType.length() - 2);
                LocalField lf = acb.newFieldDeclaration(2, methodParameterType);
                if (this.outParamArrays == null) {
                    this.outParamArrays = new LocalField[this.methodParms.length];
                }
                this.outParamArrays[parameterNumber] = lf;
                mb.pushNewArray(arrayType, 1);
                mb.putField(lf);
                if (parameterMode == 4) break;
                mb.swap();
                mb.setArrayElement(0);
                mb.getField(lf);
                break;
            }
        }
    }

    @Override
    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        if (simplePredsOnly) {
            return false;
        }
        boolean pushable = true;
        pushable = pushable && super.categorize(referencedTabs, simplePredsOnly);
        return pushable;
    }

    @Override
    public String toString() {
        return "javaClassName: " + (this.javaClassName != null ? this.javaClassName : "null") + "\n" + super.toString();
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int i;
        boolean isInternalSQL;
        if (this.routineInfo != null && !this.routineInfo.calledOnNullInput() && this.routineInfo.getParameterCount() != 0) {
            this.returnsNullOnNullState = acb.newFieldDeclaration(2, "boolean");
        }
        if (this.returnsNullOnNullState != null) {
            mb.push(false);
            mb.setField(this.returnsNullOnNullState);
            mb.pushThis();
        }
        int nargs = this.generateParameters(acb, mb);
        LocalField functionEntrySQLAllowed = null;
        boolean bl = isInternalSQL = this.getCompilerContext().getReliability() == 0;
        if (this.routineInfo != null) {
            boolean isFunction;
            short sqlAllowed = this.routineInfo.getSQLAllowed();
            if (sqlAllowed != 3) {
                int sqlOperation = sqlAllowed == 1 ? 1 : (sqlAllowed == 0 ? 0 : 2);
                this.generateAuthorizeCheck(acb, mb, sqlOperation);
            }
            int statmentContextReferences = this.isSystemCode ? 2 : 1;
            boolean bl2 = isFunction = this.routineInfo.getReturnType() != null;
            if (isInternalSQL && !this.isSystemCode) {
                --statmentContextReferences;
                isFunction = false;
            }
            if (isFunction) {
                ++statmentContextReferences;
            }
            if (statmentContextReferences != 0) {
                acb.pushThisAsActivation(mb);
                mb.callMethod((short)185, null, "getLanguageConnectionContext", "com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext", 0);
                mb.callMethod((short)185, null, "getStatementContext", "com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext", 0);
                for (int scc = 1; scc < statmentContextReferences; ++scc) {
                    mb.dup();
                }
            }
            if (this.isSystemCode) {
                mb.callMethod((short)185, null, "setSystemCode", "void", 0);
            }
            if (isFunction) {
                functionEntrySQLAllowed = acb.newFieldDeclaration(2, "short");
                mb.callMethod((short)185, null, "getSQLAllowed", "short", 0);
                mb.setField(functionEntrySQLAllowed);
            }
            if (!isInternalSQL || this.isSystemCode) {
                mb.push(sqlAllowed);
                mb.push(false);
                mb.callMethod((short)185, null, "setSQLAllowed", "void", 2);
            }
        }
        boolean havingContextParameter = false;
        if (this.methodParameterTypes.length > 0) {
            havingContextParameter = this.methodParameterTypes[this.methodParameterTypes.length - 1].equalsIgnoreCase("com.pivotal.gemfirexd.procedure.ProcedureExecutionContext");
        }
        if (this.routineInfo != null) {
            int compiledResultSets = this.methodParameterTypes.length - this.methodParms.length;
            if (havingContextParameter) {
                --compiledResultSets;
            }
            LocalField procedureResultSetsHolder = null;
            if (compiledResultSets != 0) {
                MethodBuilder gdr;
                int maxDynamicResults = this.routineInfo.getMaxDynamicResultSets();
                if (maxDynamicResults > 0) {
                    gdr = acb.getClassBuilder().newMethodBuilder(1, "int", "getMaxDynamicResults");
                    gdr.push(maxDynamicResults);
                    gdr.methodReturn();
                    gdr.complete();
                }
                gdr = acb.getClassBuilder().newMethodBuilder(1, "java.sql.ResultSet[][]", "getDynamicResults");
                MethodBuilder cons = acb.getConstructor();
                procedureResultSetsHolder = acb.newFieldDeclaration(2, "java.sql.ResultSet[][]");
                gdr.getField(procedureResultSetsHolder);
                cons.pushNewArray("java.sql.ResultSet[]", compiledResultSets);
                cons.setField(procedureResultSetsHolder);
                for (i = 0; i < compiledResultSets; ++i) {
                    mb.pushNewArray("java.sql.ResultSet", 1);
                    mb.dup();
                    mb.getField(procedureResultSetsHolder);
                    mb.swap();
                    mb.setArrayElement(i);
                }
                gdr.methodReturn();
                gdr.complete();
                nargs += compiledResultSets;
            }
            if (havingContextParameter) {
                acb.pushGetExecutionFactoryExpression(mb);
                acb.pushThisAsActivation(mb);
                if (compiledResultSets != 0) {
                    mb.getField(procedureResultSetsHolder);
                } else {
                    mb.pushNull("java.sql.ResultSet[][]");
                }
                mb.push(this.methodName);
                mb.pushNull("java.lang.String");
                mb.callMethod((short)185, null, "getProcedureExecutionContext", "com.pivotal.gemfirexd.procedure.ProcedureExecutionContext", 4);
                ++nargs;
            }
        }
        String javaReturnType = this.getJavaTypeName();
        MethodBuilder mbnc = null;
        MethodBuilder mbcm = mb;
        if (this.returnsNullOnNullState != null) {
            mbnc = acb.newGeneratedFun(javaReturnType, 2, this.methodParameterTypes);
            Class<?>[] throwsSet = ((Method)this.method).getExceptionTypes();
            for (int te = 0; te < throwsSet.length; ++te) {
                mbnc.addThrownException(throwsSet[te].getName());
            }
            mbnc.getField(this.returnsNullOnNullState);
            mbnc.conditionalIf();
            mbnc.pushNull(javaReturnType);
            mbnc.startElseCode();
            if (!this.actualMethodReturnType.equals(javaReturnType)) {
                mbnc.pushNewStart(javaReturnType);
            }
            for (int pa = 0; pa < nargs; ++pa) {
                mbnc.getParameter(pa);
            }
            mbcm = mbnc;
        }
        mbcm.callMethod((short)184, this.method.getDeclaringClass().getName(), this.methodName, this.actualMethodReturnType, nargs);
        if (this.returnsNullOnNullState != null) {
            if (!this.actualMethodReturnType.equals(javaReturnType)) {
                if (this.actualMethodReturnType.equals("short") && javaReturnType.equals("java.lang.Integer")) {
                    mbnc.upCast("int");
                }
                mbnc.pushNewComplete(1);
            }
            mbnc.completeConditional();
            mbnc.methodReturn();
            mbnc.complete();
            mb.callMethod((short)182, acb.getClassBuilder().getFullName(), mbnc.getName(), javaReturnType, nargs);
            mbnc = null;
        }
        if (this.routineInfo != null) {
            if (functionEntrySQLAllowed != null) {
                acb.pushThisAsActivation(mb);
                mb.callMethod((short)185, null, "getLanguageConnectionContext", "com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext", 0);
                mb.callMethod((short)185, null, "getStatementContext", "com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext", 0);
                mb.getField(functionEntrySQLAllowed);
                mb.push(true);
                mb.callMethod((short)185, null, "setSQLAllowed", "void", 2);
            }
            if (this.outParamArrays != null) {
                MethodBuilder constructor = acb.getConstructor();
                acb.pushThisAsActivation(constructor);
                constructor.callMethod((short)185, null, "getParameterValueSet", "com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet", 0);
                acb.pushThisAsActivation(mb);
                mb.callMethod((short)185, null, "getParameterValueSet", "com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet", 0);
                int[] parameterModes = this.routineInfo.getParameterModes();
                for (i = 0; i < this.outParamArrays.length; ++i) {
                    int parameterMode = parameterModes[i];
                    if (parameterMode == 1) continue;
                    ValueNode sqlParamNode = ((SQLToJavaValueNode)this.methodParms[i]).getSQLValueNode();
                    int applicationParameterNumber = this.applicationParameterNumbers[i];
                    constructor.dup();
                    constructor.push(applicationParameterNumber);
                    constructor.push(parameterMode);
                    constructor.callMethod((short)185, null, "setParameterMode", "void", 2);
                    LocalField lf = this.outParamArrays[i];
                    mb.dup();
                    mb.push(applicationParameterNumber);
                    mb.callMethod((short)185, null, "getParameter", "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor", 1);
                    DataTypeDescriptor paramdtd = sqlParamNode.getTypeServices();
                    boolean isNumericType = paramdtd.getTypeId().isNumericTypeId();
                    boolean isAnsiUDT = paramdtd.getTypeId().getBaseTypeId().isAnsiUDT();
                    Class<?> componentClass = ((Method)this.method).getParameterTypes()[i].getComponentType();
                    boolean isPrimitive = componentClass != null ? componentClass.isPrimitive() : false;
                    if (isNumericType) {
                        if (!isPrimitive) {
                            mb.cast("com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue");
                        }
                    } else if (paramdtd.getTypeId().isBooleanTypeId() && !isPrimitive) {
                        mb.cast("com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue");
                    }
                    if (paramdtd.getTypeId().variableLength()) {
                        mb.dup();
                    }
                    mb.getField(lf);
                    boolean useSetValue = mb.getArrayElement(0);
                    if (isNumericType && !isPrimitive) {
                        mb.upCast("java.lang.Number");
                        useSetValue = true;
                    }
                    if (isAnsiUDT) {
                        mb.upCast("java.lang.Object");
                        useSetValue = true;
                    }
                    if (useSetValue) {
                        mb.callMethod((short)185, null, "setValue", "void", 1);
                    } else {
                        mb.push(true);
                        mb.pushNull("java.lang.String");
                        mb.callMethod((short)185, null, "setObjectForCast", "void", 3);
                    }
                    if (!paramdtd.getTypeId().variableLength()) continue;
                    mb.push(isNumericType ? paramdtd.getPrecision() : paramdtd.getMaximumWidth());
                    mb.push(paramdtd.getScale());
                    mb.push(isNumericType);
                    mb.callMethod((short)185, "com.pivotal.gemfirexd.internal.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
                }
                constructor.endStatement();
                mb.endStatement();
            }
        }
    }

    int getPrivType() {
        return 6;
    }

    public boolean hasDSID() {
        return "getDistributedMemberId()".equals(this.methodName) || this.procedureName != null && "DSID".equals(this.procedureName.getTableName());
    }
}

