/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class SpecialFunctionNode
extends ValueNode {
    String sqlName;
    private String methodName;
    private String methodType;

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        DataTypeDescriptor dtd;
        int nodeType = this.getNodeType();
        switch (nodeType) {
            case 109: 
            case 110: 
            case 125: 
            case 126: {
                switch (nodeType) {
                    case 110: {
                        this.sqlName = "USER";
                        break;
                    }
                    case 109: {
                        this.sqlName = "CURRENT_USER";
                        break;
                    }
                    case 125: {
                        this.sqlName = "SESSION_USER";
                        break;
                    }
                    case 126: {
                        this.sqlName = "SYSTEM_USER";
                    }
                }
                this.methodName = "getAuthorizationId";
                this.methodType = "java.lang.String";
                dtd = DataDictionary.TYPE_SYSTEM_IDENTIFIER;
                break;
            }
            case 6: {
                this.sqlName = "CURRENT SCHEMA";
                this.methodName = "getCurrentSchemaName";
                this.methodType = "java.lang.String";
                dtd = DataDictionary.TYPE_SYSTEM_IDENTIFIER;
                break;
            }
            case 210: {
                this.sqlName = "CURRENT_ROLE";
                this.methodName = "getCurrentRoleId";
                this.methodType = "java.lang.String";
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, false, 128);
                break;
            }
            case 5: {
                this.sqlName = "IDENTITY_VAL_LOCAL";
                this.methodName = "getIdentityValue";
                this.methodType = "java.lang.Long";
                dtd = DataTypeDescriptor.getSQLDataTypeDescriptor("java.math.BigDecimal", 38, 0, true, 38);
                break;
            }
            case 4: {
                this.sqlName = "CURRENT ISOLATION";
                this.methodName = "getCurrentIsolationLevelStr";
                this.methodType = "java.lang.String";
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 2);
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Invalid type for SpecialFunctionNode " + nodeType));
                dtd = null;
            }
        }
        this.checkReliability(this.sqlName, 64);
        this.setType(dtd);
        return this;
    }

    @Override
    protected int getOrderableVariantType() {
        return 2;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        mb.pushThis();
        mb.callMethod((short)185, "com.pivotal.gemfirexd.internal.iapi.sql.Activation", "getLanguageConnectionContext", "com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext", 0);
        int argCount = 0;
        if (this.methodName.equals("getCurrentRoleId")) {
            acb.pushThisAsActivation(mb);
            ++argCount;
        }
        mb.callMethod((short)185, null, this.methodName, this.methodType, argCount);
        String fieldType = this.getTypeCompiler().interfaceName();
        LocalField field = acb.newFieldDeclaration(2, fieldType);
        acb.generateDataValue(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType(), field);
    }

    @Override
    public String toString() {
        return super.toString() + this.sqlName;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) {
        if (this.isSameNodeType(o)) {
            SpecialFunctionNode other = (SpecialFunctionNode)o;
            return this.methodName.equals(other.methodName);
        }
        return false;
    }
}

