/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.types.UserDefinedTypeIdImpl;
import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.info.JVMInfo;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseTypeCompiler;

public final class NumericTypeCompiler
extends BaseTypeCompiler {
    @Override
    public String interfaceName() {
        return "com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 6: {
                return "double";
            }
            case 7: {
                return "int";
            }
            case 11: {
                return "long";
            }
            case 8: {
                return "float";
            }
            case 10: {
                return "short";
            }
            case 195: {
                return "byte";
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in getCorrespondingPrimitiveTypeName() - " + formatId));
        return null;
    }

    @Override
    public String getPrimitiveMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 6: {
                return "getDouble";
            }
            case 7: {
                return "getInt";
            }
            case 11: {
                return "getLong";
            }
            case 8: {
                return "getFloat";
            }
            case 10: {
                return "getShort";
            }
            case 195: {
                return "getByte";
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in getPrimitiveMethodName() - " + formatId));
        return null;
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 197: {
                return dts.getPrecision() + 2;
            }
            case 6: {
                return 54;
            }
            case 7: {
                return 11;
            }
            case 11: {
                return 20;
            }
            case 8: {
                return 25;
            }
            case 10: {
                return 6;
            }
            case 195: {
                return 4;
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in getCastToCharWidth() - " + formatId));
        return 0;
    }

    @Override
    public DataTypeDescriptor resolveArithmeticOperation(DataTypeDescriptor leftType, DataTypeDescriptor rightType, String operator) throws StandardException {
        int maximumWidth;
        NumericTypeCompiler higherTC;
        DataTypeDescriptor higherType;
        SanityManager.ASSERT((boolean)leftType.getTypeId().isNumericTypeId(), (String)"The left type is supposed to be a number because we're resolving an arithmetic operator");
        TypeId leftTypeId = leftType.getTypeId();
        TypeId rightTypeId = rightType.getTypeId();
        if (DVDSet.class.getName().equals(rightTypeId.getBaseTypeId().getSQLTypeName())) {
            rightTypeId = ((DataTypeDescriptor)((UserDefinedTypeIdImpl)rightTypeId.getBaseTypeId()).getClassParam()).getTypeId();
        }
        boolean supported = true;
        if (!rightTypeId.isNumericTypeId()) {
            supported = false;
        }
        if ("mod".equals(operator)) {
            switch (leftTypeId.getJDBCTypeId()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    supported = false;
                }
            }
            switch (rightTypeId.getJDBCTypeId()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    supported = false;
                }
            }
        }
        if (!supported) {
            throw StandardException.newException("42Y95", (Object)operator, (Object)leftType.getTypeId().getSQLTypeName(), (Object)rightType.getTypeId().getSQLTypeName());
        }
        if (rightTypeId.typePrecedence() > leftTypeId.typePrecedence()) {
            higherType = rightType;
            higherTC = (NumericTypeCompiler)this.getTypeCompiler(rightTypeId);
        } else {
            higherType = leftType;
            higherTC = (NumericTypeCompiler)this.getTypeCompiler(leftTypeId);
        }
        int precision = higherTC.getPrecision(operator, leftType, rightType);
        int scale = higherTC.getScale(operator, leftType, rightType);
        if (precision > 127) {
            int wholeDigits;
            int lscale = leftType.getScale();
            int rscale = rightType.getScale();
            int lprec = leftType.getPrecision();
            int rprec = rightType.getPrecision();
            if ("*".equals(operator)) {
                wholeDigits = lprec - lscale + (rprec - rscale);
                if (wholeDigits > 127) {
                    wholeDigits = 127;
                }
            } else if ("/".equals(operator)) {
                wholeDigits = lprec - lscale + rscale;
                if (wholeDigits > 123) {
                    wholeDigits = 123;
                }
            } else {
                wholeDigits = Math.max(lprec - lscale, rprec - rscale);
                if (operator != null && !"avg".equals(operator) && !"mod".equals(operator)) {
                    ++wholeDigits;
                }
                if (wholeDigits > 127) {
                    wholeDigits = 127;
                }
            }
            precision = 127;
            scale = precision - wholeDigits;
        }
        if (higherType.getTypeId().isDecimalTypeId()) {
            int n = maximumWidth = scale > 0 ? precision + 3 : precision + 1;
            if (maximumWidth < precision) {
                maximumWidth = Integer.MAX_VALUE;
            }
        } else {
            maximumWidth = higherType.getMaximumWidth();
        }
        boolean nullable = leftType.isNullable() || rightType.isNullable();
        return new DataTypeDescriptor(higherType.getTypeId(), precision, scale, nullable, maximumWidth);
    }

    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        return this.numberConvertible(otherType, forDataTypeFunction);
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return otherType.isNumericTypeId();
    }

    @Override
    public boolean storable(TypeId otherType, ClassFactory cf) {
        return this.numberStorable(this.getTypeId(), otherType, cf);
    }

    @Override
    String dataValueMethodName() {
        if (this.getStoredFormatIdFromTypeId() == 197) {
            return "getDecimalDataValue";
        }
        return super.dataValueMethodName();
    }

    @Override
    String nullMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 197: {
                return "getNullDecimal";
            }
            case 6: {
                return "getNullDouble";
            }
            case 7: {
                return "getNullInteger";
            }
            case 11: {
                return "getNullLong";
            }
            case 8: {
                return "getNullFloat";
            }
            case 10: {
                return "getNullShort";
            }
            case 195: {
                return "getNullByte";
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in nullMethodName() - " + formatId));
        return null;
    }

    private int getPrecision(String operator, DataTypeDescriptor leftType, DataTypeDescriptor rightType) {
        if (this.getStoredFormatIdFromTypeId() != 197) {
            return leftType.getPrecision();
        }
        long lscale = leftType.getScale();
        long rscale = rightType.getScale();
        long lprec = leftType.getPrecision();
        long rprec = rightType.getPrecision();
        long val = operator == null ? (long)this.getScale(operator, leftType, rightType) + Math.max(lprec - lscale, rprec - rscale) : (operator.equals("*") ? lprec + rprec : (operator.equals("sum") ? (long)this.getScale(operator, leftType, rightType) + Math.max(lprec - lscale, rprec - rscale) + 10L : (operator.equals("mod") || operator.equals("avg") ? (long)this.getScale(operator, leftType, rightType) + Math.max(lprec - lscale, rprec - rscale) : (operator.equals("/") ? lprec - lscale + rscale + (long)this.getScale(operator, leftType, rightType) : (long)this.getScale(operator, leftType, rightType) + Math.max(lprec - lscale, rprec - rscale) + 1L))));
        return (int)val;
    }

    private int getScale(String operator, DataTypeDescriptor leftType, DataTypeDescriptor rightType) {
        if (this.getStoredFormatIdFromTypeId() != 197) {
            return leftType.getScale();
        }
        long lscale = leftType.getScale();
        long rscale = rightType.getScale();
        long lprec = leftType.getPrecision();
        long rprec = rightType.getPrecision();
        long val = "*".equals(operator) ? lscale + rscale : ("/".equals(operator) ? Math.max(Math.max(lscale, rprec), 4L) : ("avg".equals(operator) ? Math.max(Math.max(lscale, rscale), 4L) : Math.max(lscale, rscale)));
        return (int)val;
    }

    @Override
    public void generateDataValue(MethodBuilder mb, int collationType, LocalField field) {
        if (!JVMInfo.J2ME && this.getTypeId().isDecimalTypeId()) {
            mb.upCast("java.lang.Number");
        }
        super.generateDataValue(mb, collationType, field);
    }
}

