/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.sql.compile.DistributedJoinStrategy;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.JoinStrategy;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizableList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RequiredRowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CostEstimateImpl;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Level2CostEstimateImpl;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OptimizerImpl;
import java.util.Arrays;

public class Level2OptimizerImpl
extends OptimizerImpl {
    private LanguageConnectionContext lcc;

    Level2OptimizerImpl(OptimizableList optimizableList, OptimizablePredicateList predicateList, DataDictionary dDictionary, boolean ruleBasedOptimization, boolean noTimeout, boolean useStatistics, int maxMemoryPerTable, JoinStrategy[] joinStrategies, DistributedJoinStrategy[] distJoinStrategies, int tableLockThreshold, RequiredRowOrdering requiredRowOrdering, int numTablesInQuery, LanguageConnectionContext lcc) throws StandardException {
        super(optimizableList, predicateList, dDictionary, ruleBasedOptimization, noTimeout, useStatistics, maxMemoryPerTable, joinStrategies, distJoinStrategies, tableLockThreshold, requiredRowOrdering, numTablesInQuery);
        this.optimizerTrace = lcc.getOptimizerTrace() || lcc.explainConnection();
        this.optimizerTraceHtml = lcc.getOptimizerTraceHtml();
        this.lcc = lcc;
        if (this.optimizerTrace) {
            this.trace(1, 0, 0, 0.0, null);
        }
    }

    @Override
    public int getLevel() {
        return 2;
    }

    @Override
    public CostEstimate newCostEstimate() {
        return new Level2CostEstimateImpl();
    }

    @Override
    public CostEstimateImpl getNewCostEstimate(double theCost, double theRowCount, double theSingleScanRowCount) {
        return new Level2CostEstimateImpl(theCost, theRowCount, theSingleScanRowCount);
    }

    @Override
    public void trace(int traceFlag, int intParam1, int intParam2, double doubleParam, Object objectParam1) {
        String traceString = null;
        if (!this.optimizerTrace) {
            return;
        }
        switch (traceFlag) {
            case 1: {
                traceString = "Optimization started at time " + this.timeOptimizationStarted + " using optimizer " + this.hashCode();
                break;
            }
            case 2: {
                traceString = "Optimization time exceeded at time " + this.currentTime + "\n" + this.bestCost();
                break;
            }
            case 3: {
                traceString = "No tables to optimize.";
                break;
            }
            case 4: {
                traceString = "We have a complete join order.";
                break;
            }
            case 5: {
                traceString = "Cost of sorting is " + this.sortCost;
                break;
            }
            case 6: {
                traceString = "No best plan found.";
                break;
            }
            case 7: {
                traceString = "Modifying access paths using optimizer " + this.hashCode() + " with bestJoinOrder " + Arrays.toString(this.bestJoinOrder) + " & bestJoinOrderColocatedTableGrp " + (this.bestJoinOrderColocatedTableGrp == null ? "null" : this.bestJoinOrderColocatedTableGrp);
                break;
            }
            case 8: {
                String basis = this.timeExceeded ? "time exceeded" : "cost";
                Optimizable thisOpt = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
                if (thisOpt.getBestAccessPath().getCostEstimate() == null) {
                    basis = "no best plan found";
                }
                traceString = "Short circuiting based on " + basis + " at join position " + this.joinPosition;
                break;
            }
            case 9: {
                traceString = this.buildJoinOrder("\n\nSkipping join order: ", true, intParam1, this.proposedJoinOrder);
                break;
            }
            case 10: {
                traceString = "User specified join order is not legal.";
                break;
            }
            case 11: {
                traceString = "User-specified join order has now been optimized.";
                break;
            }
            case 12: {
                traceString = this.buildJoinOrder("\n\nConsidering join order: ", false, intParam1, this.proposedJoinOrder);
                break;
            }
            case 13: {
                traceString = "Total cost of non-sort-avoidance plan is " + this.currentCost;
                break;
            }
            case 14: {
                traceString = "Total cost of sort avoidance plan is " + this.currentSortAvoidanceCost;
                break;
            }
            case 15: {
                traceString = "Total cost of non-sort-avoidance plan with sort cost added is " + this.currentCost;
                break;
            }
            case 16: {
                traceString = "Current plan is a sort avoidance plan.\n\tBest cost is : " + this.bestCost + "\n\tThis cost is : " + this.currentSortAvoidanceCost;
                break;
            }
            case 17: {
                traceString = "This is the cheapest plan so far.";
                break;
            }
            case 18: {
                traceString = "Plan is a " + (intParam1 == 1 ? "normal" : "sort avoidance") + " plan.";
                break;
            }
            case 19: {
                traceString = "Cost of cheapest plan is " + this.currentCost;
                break;
            }
            case 20: {
                traceString = "Sort needed for ordering: " + (intParam1 != 2) + "\n\tRow ordering: " + this.requiredRowOrdering;
                break;
            }
            case 21: {
                traceString = this.buildJoinOrder("\n\nRemembering join order as best: ", false, intParam1, this.bestJoinOrder);
                break;
            }
            case 22: {
                traceString = "Skipping access path due to excess memory usage, maximum is " + this.maxMemoryPerTable;
                break;
            }
            case 23: {
                traceString = "Cost of " + doubleParam + " scans is: " + objectParam1 + " for table " + intParam1;
                break;
            }
            case 24: {
                traceString = "Skipping HASH JOIN because optimizable is not materializable";
                break;
            }
            case 25: {
                traceString = "Skipping HASH JOIN because there are no hash key columns";
                break;
            }
            case 26: {
                int[] hashKeyColumns = (int[])objectParam1;
                traceString = "# hash key columns = " + hashKeyColumns.length;
                for (int index = 0; index < hashKeyColumns.length; ++index) {
                    traceString = "\n" + traceString + "hashKeyColumns[" + index + "] = " + hashKeyColumns[index];
                }
                break;
            }
            case 27: {
                traceString = "Calling optimizeIt() for join node";
                break;
            }
            case 28: {
                JoinStrategy js = (JoinStrategy)objectParam1;
                traceString = "\nConsidering join strategy " + js + " for table " + intParam1;
                break;
            }
            case 29: {
                traceString = "Remembering access path " + objectParam1 + " as truly the best for table " + intParam1 + " for plan type " + (intParam2 == 1 ? " normal " : "sort avoidance") + "\n";
                break;
            }
            case 30: {
                traceString = "No more conglomerates to consider for table " + intParam1;
                break;
            }
            case 31: {
                ConglomerateDescriptor cd = (ConglomerateDescriptor)objectParam1;
                String cdString = this.dumpConglomerateDescriptor(cd);
                traceString = "\nConsidering conglomerate " + cdString + " for table " + intParam1;
                break;
            }
            case 32: {
                traceString = "Scanning heap, but we have a full match on a unique key.";
                break;
            }
            case 33: {
                traceString = "Adding unordered optimizable, # of predicates = " + intParam1;
                break;
            }
            case 34: {
                traceString = "Changing access path for table " + intParam1;
                break;
            }
            case 35: {
                traceString = "Lock mode set to MODE_TABLE because no start or stop position";
                break;
            }
            case 36: {
                traceString = "Index does not cover query - cost including base row fetch is: " + doubleParam + " for table " + intParam1;
                break;
            }
            case 37: {
                traceString = "Lock mode set to MODE_RECORD because all start and stop positions are constant";
                break;
            }
            case 38: {
                ConglomerateDescriptor cd = (ConglomerateDescriptor)objectParam1;
                String cdString = this.dumpConglomerateDescriptor(cd);
                traceString = "Estimating cost of conglomerate: " + this.costForTable(cdString, intParam1);
                break;
            }
            case 39: {
                traceString = "Looking for user-specified index: " + objectParam1 + " for table " + intParam1;
                break;
            }
            case 40: {
                traceString = "Guaranteed to match a single row - cost is: " + doubleParam + " for table " + intParam1;
                break;
            }
            case 41: {
                traceString = this.costIncluding("1st column", objectParam1, intParam1);
                traceString = "Cost including extra first column selectivity is : " + objectParam1 + " for table " + intParam1;
                break;
            }
            case 42: {
                traceString = "Calling nextAccessPath() for base table " + objectParam1 + " with " + intParam1 + " predicates.";
                break;
            }
            case 43: {
                traceString = this.lockModeThreshold("MODE_TABLE", "greater", doubleParam, intParam1);
                break;
            }
            case 44: {
                traceString = this.lockModeThreshold("MODE_RECORD", "less", doubleParam, intParam1);
                break;
            }
            case 45: {
                traceString = this.costIncluding("start/stop", objectParam1, intParam1);
                break;
            }
            case 46: {
                traceString = this.costIncluding("qualifier", objectParam1, intParam1);
                break;
            }
            case 47: {
                traceString = this.costIncluding("non-qualifier", objectParam1, intParam1);
                break;
            }
            case 60: {
                traceString = this.costIncluding("selectivity from statistics", objectParam1, intParam1);
                break;
            }
            case 62: {
                traceString = this.costIncluding("statistics for index being considered", objectParam1, intParam1);
                break;
            }
            case 61: {
                traceString = "Selectivity from statistics found. It is " + doubleParam;
                break;
            }
            case 48: {
                traceString = "Index does not cover query: cost including row fetch is: " + this.costForTable(objectParam1, intParam1);
                break;
            }
            case 49: {
                traceString = "\nRemembering join strategy " + objectParam1 + " as best for table " + intParam1;
                break;
            }
            case 50: {
                traceString = "in best access path";
                break;
            }
            case 51: {
                traceString = "in best sort avoidance access path";
                break;
            }
            case 52: {
                traceString = "in best unknown access path";
                break;
            }
            case 53: {
                ConglomerateDescriptor cd = (ConglomerateDescriptor)objectParam1;
                String cdString = this.dumpConglomerateDescriptor(cd);
                traceString = "Cost of conglomerate " + cdString + " scan for table number " + intParam1 + " is : ";
                break;
            }
            case 54: {
                traceString = objectParam1.toString();
                break;
            }
            case 55: {
                traceString = "\tNumber of extra first column predicates is : " + intParam1 + ", extra first column selectivity is : " + doubleParam;
                break;
            }
            case 56: {
                traceString = "\tNumber of extra start/stop predicates is : " + intParam1 + ", extra start/stop selectivity is : " + doubleParam;
                break;
            }
            case 57: {
                traceString = "\tNumber of extra qualifiers is : " + intParam1 + ", extra qualifier selectivity is : " + doubleParam;
                break;
            }
            case 58: {
                traceString = "\tNumber of extra non-qualifiers is : " + intParam1 + ", extra non-qualifier selectivity is : " + doubleParam;
                break;
            }
            case 59: {
                traceString = "\tNumber of start/stop statistics predicates is : " + intParam1 + ", statistics start/stop selectivity is : " + doubleParam;
                break;
            }
            case 63: {
                traceString = "Using hash index, but we have a full match on a unique key so using sort avoidance plan.";
                break;
            }
            case 64: {
                traceString = "Skipping HASH JOIN for index";
                break;
            }
            case 65: {
                traceString = "Setting Replicated Table Group at " + intParam1 + " for table " + objectParam1;
                break;
            }
            case 66: {
                traceString = "Resetting DriverTableIndex from " + this.driverTableIdx + " to " + intParam1 + ", joinPosition=" + this.joinPosition + " Colocated Table Group = " + this.colocatedTableGrp + ", proposedJoinOrder = " + Arrays.toString(this.proposedJoinOrder);
            }
        }
        if (traceString == null) {
            SanityManager.THROWASSERT((String)"traceString expected to be non-null");
        }
        this.lcc.appendOptimizerTraceOutput(traceString + "\n");
    }

    private String costForTable(Object cost, int tableNumber) {
        return cost + " for table " + tableNumber;
    }

    private String bestCost() {
        return "Best cost = " + this.bestCost + "\n";
    }

    private String buildJoinOrder(String prefix, boolean addJoinOrderNumber, int joinOrderNumber, int[] joinOrder) {
        String joinOrderString = prefix;
        for (int i = 0; i <= this.joinPosition; ++i) {
            joinOrderString = joinOrderString + " " + joinOrder[i];
        }
        if (addJoinOrderNumber) {
            joinOrderString = joinOrderString + " " + joinOrderNumber;
        }
        return joinOrderString + " with assignedTableMap = " + this.assignedTableMap + " colocatedTableGrp = " + this.colocatedTableGrp + "\n\n";
    }

    private String lockModeThreshold(String lockMode, String relop, double rowCount, int threshold) {
        return "Lock mode set to " + lockMode + " because estimated row count of " + rowCount + " " + relop + " than threshold of " + threshold;
    }

    private String costIncluding(String selectivityType, Object objectParam1, int intParam1) {
        return "Cost including extra " + selectivityType + " start/stop selectivity is : " + this.costForTable(objectParam1, intParam1);
    }

    private String dumpConglomerateDescriptor(ConglomerateDescriptor cd) {
        return cd.toString();
    }
}

