/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gemfire.cache.hdfs.HDFSEventQueueAttributesFactory;
import com.gemstone.gemfire.cache.hdfs.HDFSStoreFactory;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NumericConstantNode;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import java.util.Iterator;
import java.util.Map;

public final class CreateHDFSStoreNode
extends DDLStatementNode {
    private String hdfsStoreName;
    private String nameNode;
    private HDFSStoreFactory hsf;
    private Map<Object, Object> otherAttribs;
    public static final String MAXQUEUEMEMORY = "maxqueuememory";
    public static final String BATCHSIZE = "batchsize";
    public static final String QUEUEPERSISTENT = "queuepersistent";
    public static final String DISKSTORENAME = "diskstorename";
    public static final String BATCHTIMEINTERVAL = "batchtimeinterval";
    public static final String DISKSYNCHRONOUS = "disksynchronous";
    public static final String MINORCOMPACT = "minorcompact";
    public static final String MAJORCOMPACT = "majorcompact";
    public static final String MAXINPUTFILESIZE = "maxinputfilesize";
    public static final String MININPUTFILECOUNT = "mininputfilecount";
    public static final String MAXINPUTFILECOUNT = "maxinputfilecount";
    public static final String MINORCOMPACTIONTHREADS = "minorcompactionthreads";
    public static final String MAJORCOMPACTIONINTERVAL = "majorcompactioninterval";
    public static final String MAJORCOMPACTIONTHREADS = "majorcompactionthreads";
    public static final String HOMEDIR = "homedir";
    public static final String CLIENTCONFIGFILE = "clientconfigfile";
    public static final String BLOCKCACHESIZE = "blockcachesize";
    public static final String MAXWRITEONLYFILESIZE = "maxwriteonlyfilesize";
    public static final String WRITEONLYFILEROLLOVERINTERVAL = "writeonlyfilerolloverinterval";
    public static final String PURGEINTERVAL = "purgeinterval";
    public static final String DISPATCHERTHREADS = "dispatcherthreads";

    @Override
    public void init(Object arg1, Object arg2, Object arg3) throws StandardException {
        this.hdfsStoreName = SharedUtils.SQLToUpperCase((String)((String)arg1));
        this.nameNode = (String)arg2;
        this.otherAttribs = (Map)arg3;
        this.hsf = Misc.getGemFireCache().createHDFSStoreFactory();
        this.hsf.setName(this.hdfsStoreName);
        this.hsf.setNameNodeURL(this.nameNode);
        HDFSEventQueueAttributesFactory hqf = new HDFSEventQueueAttributesFactory();
        HDFSStoreFactory.HDFSCompactionConfigFactory hcf = this.hsf.createCompactionConfigFactory(null);
        Iterator<Map.Entry<Object, Object>> entryItr = this.otherAttribs.entrySet().iterator();
        String diskStoreName = null;
        String homeDir = null;
        boolean isPersistent = false;
        while (entryItr.hasNext()) {
            int concurrency;
            String val;
            NumericConstantNode ncn;
            Map.Entry<Object, Object> entry = entryItr.next();
            String key = (String)entry.getKey();
            Object vn = entry.getValue();
            if (key.equalsIgnoreCase(MAXQUEUEMEMORY)) {
                ncn = (NumericConstantNode)vn;
                hqf.setMaximumQueueMemory(ncn.getValue().getInt());
                continue;
            }
            if (key.equalsIgnoreCase(BATCHSIZE)) {
                ncn = (NumericConstantNode)vn;
                hqf.setBatchSizeMB(ncn.getValue().getInt());
                continue;
            }
            if (key.equalsIgnoreCase(BATCHTIMEINTERVAL)) {
                ncn = (NumericConstantNode)vn;
                hqf.setBatchTimeInterval(ncn.getValue().getInt());
                continue;
            }
            if (key.equalsIgnoreCase(DISPATCHERTHREADS)) {
                ncn = (NumericConstantNode)vn;
                hqf.setDispatcherThreads(ncn.getValue().getInt());
                continue;
            }
            if (key.equalsIgnoreCase(QUEUEPERSISTENT)) {
                val = (String)vn;
                if (val.equalsIgnoreCase("true")) {
                    isPersistent = true;
                    hqf.setPersistent(true);
                    continue;
                }
                if (val.equalsIgnoreCase("false")) {
                    hqf.setPersistent(false);
                    continue;
                }
                throw StandardException.newException("XCY00.S", (Object)StringUtil.SQLToUpperCase(QUEUEPERSISTENT), (Object)val);
            }
            if (key.equalsIgnoreCase(DISKSTORENAME)) {
                if (Misc.getMemStoreBooting().isHadoopGfxdLonerMode()) continue;
                diskStoreName = (String)vn;
                hqf.setDiskStoreName(diskStoreName);
                continue;
            }
            if (key.equalsIgnoreCase(DISKSYNCHRONOUS)) {
                val = (String)vn;
                if (val.equalsIgnoreCase("true")) {
                    hqf.setDiskSynchronous(Boolean.TRUE.booleanValue());
                    continue;
                }
                if (val.equalsIgnoreCase("false")) {
                    hqf.setDiskSynchronous(Boolean.FALSE.booleanValue());
                    continue;
                }
                throw StandardException.newException("XCY00.S", (Object)StringUtil.SQLToUpperCase(DISKSYNCHRONOUS), (Object)val);
            }
            if (key.equalsIgnoreCase(MINORCOMPACT)) {
                val = (String)vn;
                if (val.equalsIgnoreCase("true")) {
                    hcf.setAutoCompaction(Boolean.TRUE.booleanValue());
                    continue;
                }
                if (val.equalsIgnoreCase("false")) {
                    hcf.setAutoCompaction(Boolean.FALSE.booleanValue());
                    continue;
                }
                throw StandardException.newException("XCY00.S", (Object)StringUtil.SQLToUpperCase(MINORCOMPACT), (Object)val);
            }
            if (key.equalsIgnoreCase(MAJORCOMPACT)) {
                val = (String)vn;
                if (val.equalsIgnoreCase("true")) {
                    hcf.setAutoMajorCompaction(Boolean.TRUE.booleanValue());
                    continue;
                }
                if (val.equalsIgnoreCase("false")) {
                    hcf.setAutoMajorCompaction(Boolean.FALSE.booleanValue());
                    continue;
                }
                throw StandardException.newException("XCY00.S", (Object)StringUtil.SQLToUpperCase(MAJORCOMPACT), (Object)val);
            }
            if (key.equalsIgnoreCase(MAXINPUTFILESIZE)) {
                ncn = (NumericConstantNode)vn;
                hcf.setMaxInputFileSizeMB(ncn.getValue().getInt());
                continue;
            }
            if (key.equalsIgnoreCase(MININPUTFILECOUNT)) {
                ncn = (NumericConstantNode)vn;
                hcf.setMinInputFileCount(ncn.getValue().getInt());
                continue;
            }
            if (key.equalsIgnoreCase(MAXINPUTFILECOUNT)) {
                ncn = (NumericConstantNode)vn;
                hcf.setMaxInputFileCount(ncn.getValue().getInt());
                continue;
            }
            if (key.equalsIgnoreCase(MINORCOMPACTIONTHREADS)) {
                ncn = (NumericConstantNode)vn;
                concurrency = ncn.getValue().getInt();
                if (concurrency <= 0) {
                    throw StandardException.newException("XCY00.S", (Object)StringUtil.SQLToUpperCase(MINORCOMPACTIONTHREADS), (Object)concurrency);
                }
                hcf.setMaxThreads(concurrency);
                continue;
            }
            if (key.equalsIgnoreCase(MAJORCOMPACTIONINTERVAL)) {
                ncn = (NumericConstantNode)vn;
                hcf.setMajorCompactionIntervalMins(ncn.getValue().getInt());
                continue;
            }
            if (key.equalsIgnoreCase(MAJORCOMPACTIONTHREADS)) {
                ncn = (NumericConstantNode)vn;
                concurrency = ncn.getValue().getInt();
                if (concurrency <= 0) {
                    throw StandardException.newException("XCY00.S", (Object)StringUtil.SQLToUpperCase(MAJORCOMPACTIONTHREADS), (Object)concurrency);
                }
                hcf.setMajorCompactionMaxThreads(concurrency);
                continue;
            }
            if (key.equalsIgnoreCase(HOMEDIR)) {
                homeDir = (String)vn;
                continue;
            }
            if (key.equalsIgnoreCase(CLIENTCONFIGFILE)) {
                this.hsf.setHDFSClientConfigFile((String)vn);
                continue;
            }
            if (key.equalsIgnoreCase(BLOCKCACHESIZE)) {
                ncn = (NumericConstantNode)vn;
                this.hsf.setBlockCacheSize(ncn.getValue().getFloat());
                continue;
            }
            if (key.equalsIgnoreCase(MAXWRITEONLYFILESIZE)) {
                ncn = (NumericConstantNode)vn;
                this.hsf.setMaxFileSize(ncn.getValue().getInt());
                continue;
            }
            if (key.equalsIgnoreCase(WRITEONLYFILEROLLOVERINTERVAL)) {
                ncn = (NumericConstantNode)vn;
                this.hsf.setFileRolloverInterval(ncn.getValue().getInt());
                continue;
            }
            if (!key.equalsIgnoreCase(PURGEINTERVAL)) continue;
            ncn = (NumericConstantNode)vn;
            hcf.setOldFilesCleanupIntervalMins(ncn.getValue().getInt());
        }
        if (isPersistent && diskStoreName == null && !Misc.getMemStoreBooting().isHadoopGfxdLonerMode()) {
            hqf.setDiskStoreName("GFXD-DEFAULT-DISKSTORE");
        }
        if (Misc.getMemStoreBooting().isHadoopGfxdLonerMode()) {
            hqf.setPersistent(false);
            hqf.setDiskStoreName(null);
        }
        this.hsf.setHDFSEventQueueAttributes(hqf.create());
        this.hsf.setHDFSCompactionConfig(hcf.create());
        if (homeDir == null) {
            homeDir = this.hdfsStoreName;
        }
        this.hsf.setHomeDir(Misc.getMemStore().generateHdfsStoreDirName(homeDir));
    }

    @Override
    public String statementToString() {
        return "CREATE HDFSSTORE";
    }

    @Override
    public ConstantAction makeConstantAction() {
        return this.getGenericConstantActionFactory().getCreateHDFSStoreConstantAction(this.hdfsStoreName, this.hsf);
    }
}

