/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.types.RoutineAliasInfo;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProcedureProxy;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DMLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaToSQLValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MethodCallNode;

public class CallStatementNode
extends DMLStatementNode {
    private JavaToSQLValueNode methodCall;

    @Override
    public void init(Object methodCall) {
        super.init(null);
        this.methodCall = (JavaToSQLValueNode)methodCall;
        this.methodCall.getJavaValueNode().markForCallStatement();
    }

    @Override
    public String toString() {
        return "CALL " + this.methodCall.toString() + "\n" + super.toString();
    }

    @Override
    public String statementToString() {
        return "CALL";
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.methodCall != null) {
            this.printLabel(depth, "methodCall: ");
            this.methodCall.treePrint(depth + 1);
        }
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        SanityManager.ASSERT((dd != null ? 1 : 0) != 0, (String)"Failed to get data dictionary");
        CompilerContext cc = this.getCompilerContext();
        cc.pushCurrentPrivType(this.getPrivType());
        this.methodCall = (JavaToSQLValueNode)this.methodCall.bindExpression((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), null, null);
        this.checkReliability();
        cc.popCurrentPrivType();
        cc.setOriginalExecFlags((short)(cc.getOriginalExecFlags() | 0x200));
    }

    @Override
    public void optimizeStatement() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        SanityManager.ASSERT((dd != null ? 1 : 0) != 0, (String)"Failed to get data dictionary");
        this.methodCall = (JavaToSQLValueNode)this.methodCall.preprocess(this.getCompilerContext().getNumTables(), (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), null, null);
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateParameterValueSet(acb);
        this.optimizeForOffHeap(true);
        JavaValueNode methodCallBody = this.methodCall.getJavaValueNode();
        methodCallBody.markReturnValueDiscarded();
        MethodBuilder userExprFun = acb.newGeneratedFun("void", 1);
        userExprFun.addThrownException("java.lang.Exception");
        methodCallBody.generate(acb, userExprFun);
        userExprFun.endStatement();
        userExprFun.methodReturn();
        userExprFun.complete();
        acb.pushThisAsActivation(mb);
        mb.push(((MethodCallNode)methodCallBody).getMethodName());
        mb.callMethod((short)185, null, "setObjectName", "void", 1);
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushMethodReference(mb, userExprFun);
        acb.pushThisAsActivation(mb);
        mb.callMethod((short)185, null, "getCallStatementResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.ResultSet", 2);
    }

    public ProcedureProxy getProcedureProxy() {
        return this.methodCall.getProcedureProxy();
    }

    @Override
    public int getStatementType() {
        return -2;
    }

    @Override
    public ResultDescription makeResultDescription() {
        return null;
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        if (v.skipChildren(this)) {
            return v.visit(this);
        }
        Visitable returnNode = super.accept(v);
        if (!v.stopTraversal()) {
            this.methodCall = (JavaToSQLValueNode)this.methodCall.accept(v);
        }
        return returnNode;
    }

    @Override
    int getPrivType() {
        return 6;
    }

    private void checkReliability() throws StandardException {
        if (this.getSQLAllowedInProcedure() == 0 && this.getCompilerContext().getReliability() == 2048) {
            throw StandardException.newException("42Z9D.S.1");
        }
    }

    private short getSQLAllowedInProcedure() {
        RoutineAliasInfo routineInfo = ((MethodCallNode)this.methodCall.getJavaValueNode()).routineInfo;
        SanityManager.ASSERT((routineInfo != null ? 1 : 0) != 0, (String)"Failed to get routineInfo");
        return routineInfo.getSQLAllowed();
    }
}

