/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;

public class BaseColumnNode
extends ValueNode {
    private String columnName;
    private TableName tableName;

    @Override
    public void init(Object columnName, Object tableName, Object dts) throws StandardException {
        this.columnName = (String)columnName;
        this.tableName = (TableName)tableName;
        this.setType((DataTypeDescriptor)dts);
    }

    @Override
    public String toString() {
        return "columnName: " + this.columnName + "\n" + "tableName: " + this.tableName + '\n' + super.toString();
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public String getTableName() {
        return this.tableName != null ? this.tableName.getTableName() : null;
    }

    @Override
    public String getSchemaName() {
        return this.tableName != null ? this.tableName.getSchemaName() : null;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        throw StandardException.newException("42Z50", this.nodeHeader());
    }

    @Override
    protected int getOrderableVariantType() {
        return 1;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) {
        if (this.isSameNodeType(o)) {
            BaseColumnNode other = (BaseColumnNode)o;
            return other.tableName.equals(other.tableName) && other.columnName.equals(this.columnName);
        }
        return false;
    }

    @Override
    public boolean hasExpression() {
        return false;
    }

    @Override
    public String ncjGenerateSql() {
        return this.columnName;
    }
}

