/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongvarchar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import java.util.SortedSet;

public class SYSTABLESRowFactory
extends CatalogRowFactory {
    public static final int SYSTABLES_COLUMN_COUNT = 20;
    public static final int SYSTABLES_TABLEID = 1;
    public static final int SYSTABLES_TABLENAME = 2;
    public static final int SYSTABLES_TABLETYPE = 3;
    public static final int SYSTABLES_SCHEMAID = 4;
    public static final int SYSTABLES_SCHEMANAME = 5;
    public static final int SYSTABLES_LOCKGRANULARITY = 6;
    public static final int SYSTABLES_SERVERGROUPS = 7;
    public static final int SYSTABLES_DATAPOLICY = 8;
    public static final int SYSTABLES_PARTITIONATTRS = 9;
    public static final int SYSTABLES_RESOLVER = 10;
    public static final int SYSTABLES_EXPIRATIONATTRS = 11;
    public static final int SYSTABLES_EVICTIONATTRS = 12;
    public static final int SYSTABLES_DISKATTRS = 13;
    public static final int SYSTABLES_LOADER = 14;
    public static final int SYSTABLES_WRITER = 15;
    public static final int SYSTABLES_LISTENERS = 16;
    public static final int SYSTABLES_ASYNCLISTENERS = 17;
    public static final int SYSTABLES_GATEWAYENABLED = 18;
    public static final int SYSTABLES_SENDERIDS = 19;
    public static final int SYSTABLES_OFFHEAPENABLED = 20;
    protected static final int SYSTABLES_INDEX1_ID = 0;
    protected static final int SYSTABLES_INDEX1_TABLENAME = 1;
    protected static final int SYSTABLES_INDEX1_SCHEMAID = 2;
    protected static final int SYSTABLES_INDEX2_ID = 1;
    protected static final int SYSTABLES_INDEX2_TABLEID = 1;
    private static final String[] uuids = new String[]{"80000018-00d0-fd77-3ed8-000a0a0b1900", "80000028-00d0-fd77-3ed8-000a0a0b1900", "8000001a-00d0-fd77-3ed8-000a0a0b1900", "8000001c-00d0-fd77-3ed8-000a0a0b1900"};
    private static final int[][] indexColumnPositions = new int[][]{{2, 4}, {1}};

    SYSTABLESRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(20, "SYSTABLES", indexColumnPositions, null, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String tabSType = null;
        String lockGranularity = null;
        String tableID = null;
        String schemaID = null;
        String tableName = null;
        if (td != null) {
            TableDescriptor descriptor = (TableDescriptor)td;
            SchemaDescriptor schema = (SchemaDescriptor)parent;
            UUID oid = descriptor.getUUID();
            if (oid == null) {
                oid = this.getUUIDFactory().createUUID();
                descriptor.setUUID(oid);
            }
            tableID = oid.toString();
            SanityManager.ASSERT((schema != null ? 1 : 0) != 0, (String)"Schema should not be null unless empty row is true");
            if (schema.getUUID() == null) {
                SanityManager.THROWASSERT((String)("schema " + schema + " has a null OID"));
            }
            schemaID = schema.getUUID().toString();
            tableName = descriptor.getName();
            int tabIType = descriptor.getTableType();
            switch (tabIType) {
                case 0: {
                    tabSType = "T";
                    break;
                }
                case 1: {
                    tabSType = "S";
                    break;
                }
                case 2: {
                    tabSType = "V";
                    break;
                }
                case 4: {
                    tabSType = "A";
                    break;
                }
                case 6: {
                    tabSType = "C";
                    break;
                }
                default: {
                    SanityManager.THROWASSERT((String)"invalid table type");
                }
            }
            char[] lockGChar = new char[]{descriptor.getLockGranularity()};
            lockGranularity = new String(lockGChar);
        }
        ExecRow row = this.getExecutionFactory().getValueRow(20);
        row.setColumn(1, new SQLChar(tableID));
        row.setColumn(2, new SQLVarchar(tableName));
        row.setColumn(3, new SQLChar(tabSType));
        row.setColumn(4, new SQLChar(schemaID));
        row.setColumn(6, new SQLChar(lockGranularity));
        String schemaName = "";
        String serverGroups = "";
        if (td != null) {
            SortedSet<String> sgsSet;
            TableDescriptor tableDesc = (TableDescriptor)td;
            SchemaDescriptor schema = (SchemaDescriptor)parent;
            schemaName = schema.getSchemaName();
            DistributionDescriptor distribDesc = tableDesc.getDistributionDescriptor();
            if (distribDesc != null && (sgsSet = distribDesc.getServerGroups()) != null) {
                serverGroups = SharedUtils.toCSV(sgsSet);
            }
        }
        row.setColumn(5, new SQLVarchar(schemaName));
        row.setColumn(7, new SQLVarchar(serverGroups));
        row.setColumn(8, new SQLVarchar("NORMAL"));
        row.setColumn(9, new SQLLongvarchar(null));
        row.setColumn(10, new SQLLongvarchar(null));
        row.setColumn(11, new SQLLongvarchar(null));
        row.setColumn(12, new SQLLongvarchar(null));
        row.setColumn(13, new SQLLongvarchar(null));
        row.setColumn(14, new SQLLongvarchar(null));
        row.setColumn(15, new SQLLongvarchar(null));
        row.setColumn(16, new SQLLongvarchar(null));
        row.setColumn(17, new SQLVarchar(null));
        row.setColumn(18, new SQLBoolean(false));
        row.setColumn(19, new SQLVarchar(null));
        row.setColumn(20, new SQLBoolean(false));
        return row;
    }

    ExecIndexRow buildEmptyIndexRow(int indexNumber, RowLocation rowLocation) throws StandardException {
        int ncols = this.getIndexColumnCount(indexNumber);
        ExecIndexRow row = this.getExecutionFactory().getIndexableRow(ncols + 1);
        row.setColumn(ncols + 1, rowLocation);
        switch (indexNumber) {
            case 0: {
                row.setColumn(1, new SQLVarchar());
                row.setColumn(2, new SQLChar());
                break;
            }
            case 1: {
                row.setColumn(1, new SQLChar());
            }
        }
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        int tableTypeEnum;
        SanityManager.ASSERT((row.nColumns() == 20 ? 1 : 0) != 0, (String)"Wrong number of columns for a SYSTABLES row");
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        DataValueDescriptor col = row.getColumn(1);
        String tableUUIDString = col.getString();
        UUID tableUUID = this.getUUIDFactory().recreateUUID(tableUUIDString);
        col = row.getColumn(2);
        String tableName = col.getString();
        col = row.getColumn(3);
        String tableType = col.getString();
        SanityManager.ASSERT((tableType.length() == 1 ? 1 : 0) != 0, (String)"Third column type incorrect");
        switch (tableType.charAt(0)) {
            case 'T': {
                tableTypeEnum = 0;
                break;
            }
            case 'S': {
                tableTypeEnum = 1;
                break;
            }
            case 'V': {
                tableTypeEnum = 2;
                break;
            }
            case 'A': {
                tableTypeEnum = 4;
                break;
            }
            case 'C': {
                tableTypeEnum = 6;
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)"Fourth column value invalid");
                tableTypeEnum = -1;
            }
        }
        col = row.getColumn(4);
        String schemaUUIDString = col.getString();
        UUID schemaUUID = this.getUUIDFactory().recreateUUID(schemaUUIDString);
        SchemaDescriptor schema = dd.getSchemaDescriptor(schemaUUID, null);
        col = row.getColumn(6);
        String lockGranularity = col.getString();
        SanityManager.ASSERT((lockGranularity.length() == 1 ? 1 : 0) != 0, (String)"Fifth column type incorrect");
        TableDescriptor tabDesc = ddg.newTableDescriptor(tableName, schema, tableTypeEnum, lockGranularity.charAt(0));
        tabDesc.setUUID(tableUUID);
        col = row.getColumn(7);
        DistributionDescriptor distribDesc = tabDesc.getDistributionDescriptorFromResolver();
        if (distribDesc != null) {
            distribDesc.setServerGroups(ServerGroupUtils.getServerGroups(col.toString()));
            tabDesc.setDistributionDescriptor(distribDesc);
        }
        return tabDesc;
    }

    protected String getTableName(ExecRow row) throws StandardException {
        DataValueDescriptor col = row.getColumn(2);
        return col.getString();
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("TABLEID", false), SystemColumnImpl.getIdentifierColumn("TABLENAME", false), SystemColumnImpl.getIndicatorColumn("TABLETYPE"), SystemColumnImpl.getUUIDColumn("SCHEMAID", false), SystemColumnImpl.getIdentifierColumn("TABLESCHEMANAME", false), SystemColumnImpl.getIndicatorColumn("LOCKGRANULARITY"), SystemColumnImpl.getColumn("SERVERGROUPS", 12, false), SystemColumnImpl.getColumn("DATAPOLICY", 12, false, 24), SystemColumnImpl.getColumn("PARTITIONATTRS", -1, true), SystemColumnImpl.getColumn("RESOLVER", -1, true), SystemColumnImpl.getColumn("EXPIRATIONATTRS", -1, true), SystemColumnImpl.getColumn("EVICTIONATTRS", -1, true), SystemColumnImpl.getColumn("DISKATTRS", -1, true), SystemColumnImpl.getIdentifierColumn("LOADER", true), SystemColumnImpl.getIdentifierColumn("WRITER", true), SystemColumnImpl.getColumn("LISTENERS", -1, true), SystemColumnImpl.getColumn("ASYNCLISTENERS", 12, true, 256), SystemColumnImpl.getColumn("GATEWAYENABLED", 16, false), SystemColumnImpl.getColumn("GATEWAYSENDERS", 12, true, 256), SystemColumnImpl.getColumn("OFFHEAPENABLED", 16, false)};
    }
}

