/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc.authentication;

import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.auth.callback.CredentialInitializer;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.SecurityUtils;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.JNDIAuthenticationSchemeBase;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.JNDIAuthenticationService;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public final class LDAPAuthenticationSchemeImpl
extends JNDIAuthenticationSchemeBase
implements CredentialInitializer {
    private static final String dfltLDAPURL = "ldap://";
    private String searchBaseDN;
    private String leftSearchFilter;
    private String rightSearchFilter;
    private boolean useUserPropertyAsDN;
    private String searchAuthDN;
    private String searchAuthPW;
    private final FileOutputStream traceOut;
    private static final String[] attrDN = new String[]{"dn", "distinguishedName"};
    private String searchGroupBase;
    private String searchGroupFilter;
    private String[] searchGroupAttributes;
    private String[] searchGroupUserAttributes;
    private static final String[] attrGroupDefault = new String[]{"member", "uniqueMember"};
    private static final String[] attrGroupUserDefault = new String[]{"uid"};
    private static final Pattern groupPattern = Pattern.compile("%GROUP%");
    private static final Pattern userAttrPattern = Pattern.compile("\\((\\w+)=$");

    public LDAPAuthenticationSchemeImpl(JNDIAuthenticationService as, Properties dbProperties) {
        super(as, dbProperties);
        this.traceOut = (FileOutputStream)this.initDirContextEnv.get("com.sun.naming.ldap.trace.ber");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public String authenticateUser(String userName, String userPassword, String databaseName, Properties info) throws SQLException {
        NamingException e;
        block36: {
            if (userName == null || userName.length() == 0 || userPassword == null || userPassword.length() == 0) {
                return userName == null || userName.length() == 0 ? "Empty user name" : "Empty password";
            }
            Context ctx = null;
            try {
                Properties env = (Properties)this.initDirContextEnv.clone();
                String userDN = null;
                if (this.useUserPropertyAsDN && (userDN = this.authenticationService.getProperty("gemfirexd.user.")) == null) {
                    userDN = this.authenticationService.getProperty("sqlfire.user.");
                }
                if (userDN == (String)null) {
                    userDN = this.getDNFromUID(userName);
                }
                if (GemFireXDUtils.TraceAuthentication) {
                    SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("User DN = [" + userDN + ']'));
                    GemFireXDUtils.dumpProperties(env, "LDAP connection authentication for uid=" + userName + " with ", "TraceAuthentication", GemFireXDUtils.TraceAuthentication, null);
                }
                env.put("java.naming.security.principal", userDN);
                env.put("java.naming.security.credentials", userPassword);
                ctx = this.privInitialDirContext(env);
                String string = null;
                return string;
            }
            catch (AuthenticationException jndiae) {
                String string = jndiae.toString();
                return string;
            }
            catch (NameNotFoundException jndinnfe) {
                String string = jndinnfe.toString();
                return string;
            }
            catch (NamingException jndine) {
                e = jndine;
                break block36;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException nme) {
                        NamingException e2 = nme;
                        if (GemFireXDUtils.TraceAuthentication) {
                            SanityManager.DEBUG_PRINT((String)"warning:TraceAuthentication", (String)"Exception occurred while closing the context acquired.", (Throwable)e2);
                        }
                        throw LDAPAuthenticationSchemeImpl.getLoginSQLException(e2);
                    }
                }
                if (this.traceOut != null) {
                    try {
                        this.traceOut.flush();
                    }
                    catch (IOException nme) {}
                }
            }
        }
        throw LDAPAuthenticationSchemeImpl.getLoginSQLException(e);
    }

    private DirContext privInitialDirContext(final Properties env) throws NamingException {
        try {
            return (InitialDirContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException, NamingException {
                    return new InitialDirContext(env);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof NamingException) {
                throw (NamingException)e;
            }
            throw (SecurityException)e;
        }
    }

    @Override
    protected void setJNDIProviderProperties() {
        String ldapSearchBase;
        if (this.initDirContextEnv.getProperty("java.naming.factory.initial") == (String)null) {
            this.initDirContextEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        if (this.initDirContextEnv.getProperty("java.naming.provider.url") == (String)null) {
            String ldapServer = this.authenticationService.getProperty("gemfirexd.auth-ldap-server");
            if (ldapServer == (String)null) {
                Monitor.logTextMessage("A011", "gemfirexd.auth-ldap-server");
                this.providerURL = "ldap:///";
            } else {
                this.providerURL = ldapServer.startsWith(dfltLDAPURL) || ldapServer.startsWith("ldaps://") ? ldapServer : (ldapServer.startsWith("//") ? "ldap:" + ldapServer : dfltLDAPURL + ldapServer);
            }
            this.initDirContextEnv.put("java.naming.provider.url", this.providerURL);
        }
        if (this.initDirContextEnv.getProperty("java.naming.security.authentication") == (String)null) {
            this.initDirContextEnv.put("java.naming.security.authentication", "simple");
        }
        this.searchBaseDN = (ldapSearchBase = this.authenticationService.getProperty("gemfirexd.auth-ldap-search-base")) != (String)null ? ldapSearchBase : "";
        this.searchAuthDN = this.authenticationService.getProperty("gemfirexd.auth-ldap-search-dn");
        this.searchAuthPW = this.authenticationService.getProperty("gemfirexd.auth-ldap-search-pw");
        this.searchGroupUserAttributes = attrGroupUserDefault;
        String searchFilterProp = this.authenticationService.getProperty("gemfirexd.auth-ldap-search-filter");
        if (searchFilterProp == (String)null) {
            this.leftSearchFilter = "(&(objectClass=inetOrgPerson)(uid=";
            this.rightSearchFilter = "))";
        } else if (StringUtil.SQLEqualsIgnoreCase(searchFilterProp, "gemfirexd.user")) {
            this.leftSearchFilter = "(&(objectClass=inetOrgPerson)(uid=";
            this.rightSearchFilter = "))";
            this.useUserPropertyAsDN = true;
        } else if (searchFilterProp.indexOf("%USERNAME%") != -1) {
            String userAttr;
            this.leftSearchFilter = searchFilterProp.substring(0, searchFilterProp.indexOf("%USERNAME%"));
            this.rightSearchFilter = searchFilterProp.substring(searchFilterProp.indexOf("%USERNAME%") + "%USERNAME%".length());
            Matcher userAttrMatch = userAttrPattern.matcher(this.leftSearchFilter);
            if (userAttrMatch.find() && (userAttr = userAttrMatch.group(1)) != null && !this.attributeExists(userAttr, this.searchGroupUserAttributes)) {
                int nAttrs = this.searchGroupUserAttributes.length;
                String[] userAttrs = Arrays.copyOf(this.searchGroupUserAttributes, nAttrs + 1);
                userAttrs[nAttrs] = userAttr;
                this.searchGroupUserAttributes = userAttrs;
            }
        } else {
            this.leftSearchFilter = "(&(" + searchFilterProp + ")" + "(objectClass=inetOrgPerson)(uid=";
            this.rightSearchFilter = "))";
        }
        String ldapGroupSearchBase = this.authenticationService.getProperty("gemfirexd.group-ldap-search-base");
        this.searchGroupBase = ldapGroupSearchBase != null ? ldapGroupSearchBase : this.searchBaseDN;
        String ldapGroupSearchFilter = this.authenticationService.getProperty("gemfirexd.group-ldap-search-filter");
        this.searchGroupFilter = ldapGroupSearchFilter != null ? ldapGroupSearchFilter : "(&(|(objectClass=group)(objectClass=groupOfNames)(objectClass=groupOfMembers)(objectClass=groupOfUniqueNames))(|(cn=%GROUP%)(name=%GROUP%)))";
        String ldapGroupSearchAttrs = this.authenticationService.getProperty("gemfirexd.group-ldap-member-attributes");
        if (ldapGroupSearchAttrs != null) {
            this.searchGroupAttributes = ldapGroupSearchAttrs.split(",");
            for (int i = 0; i < this.searchGroupAttributes.length; ++i) {
                this.searchGroupAttributes[i] = this.searchGroupAttributes[i].trim();
            }
        } else {
            this.searchGroupAttributes = attrGroupDefault;
        }
        if (SanityManager.DEBUG_ON((String)"TraceAuthentication")) {
            PrintWriter iDbgStream = SanityManager.GET_DEBUG_STREAM();
            iDbgStream.println("\n\n+ LDAP Authentication Configuration:\n   - provider URL [" + this.providerURL + "]\n" + "   - search base [" + this.searchBaseDN + "]\n" + "   - search filter to be [" + this.leftSearchFilter + "<uid>" + this.rightSearchFilter + "]\n" + "   - use local DN [" + (this.useUserPropertyAsDN ? "true" : "false") + "]\n" + "   - group search base [" + this.searchGroupBase + "]\n" + "   - group search filter [" + this.searchGroupFilter + "]\n" + "   - group search attributes " + Arrays.toString(this.searchGroupAttributes) + '\n' + "   - group user attributes " + Arrays.toString(this.searchGroupUserAttributes) + '\n');
        }
        if (SanityManager.DEBUG_ON((String)"TraceAuthentication")) {
            FileOutputStream fos = null;
            try {
                fos = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws SecurityException, IOException {
                        return new FileOutputStream("GemFireXDLDAP.out");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
            if (fos != null) {
                this.initDirContextEnv.put("com.sun.naming.ldap.trace.ber", fos);
            }
        }
    }

    private String getDNFromUID(String uid) throws NamingException {
        boolean hasMoreResults;
        NamingEnumeration<SearchResult> results;
        Properties env = null;
        if (this.searchAuthDN != (String)null) {
            env = (Properties)this.initDirContextEnv.clone();
            env.put("java.naming.security.principal", this.searchAuthDN);
            env.put("java.naming.security.credentials", this.searchAuthPW);
        } else {
            env = this.initDirContextEnv;
        }
        if (GemFireXDUtils.TraceAuthentication) {
            GemFireXDUtils.dumpProperties(env, "Initializing DN for uid=" + uid + " with ", "TraceAuthentication", GemFireXDUtils.TraceAuthentication, null);
        }
        DirContext ctx = this.privInitialDirContext(env);
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(attrDN);
        String searchFilter = this.leftSearchFilter + uid + this.rightSearchFilter;
        if (GemFireXDUtils.TraceAuthentication) {
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("Searching for DN for uid=" + uid + ", baseDN=" + this.searchBaseDN + ", searchFilter=" + searchFilter));
        }
        if ((results = ctx.search(this.searchBaseDN, searchFilter, ctls)) == null || !results.hasMore()) {
            throw new NameNotFoundException();
        }
        SearchResult result = results.next();
        try {
            hasMoreResults = results.hasMore();
        }
        catch (NamingException ne) {
            hasMoreResults = false;
        }
        if (hasMoreResults) {
            if (SanityManager.DEBUG_ON((String)"TraceAuthentication")) {
                PrintWriter iDbgStream = SanityManager.GET_DEBUG_STREAM();
                iDbgStream.println(" - LDAP Authentication request failure: search filter [" + searchFilter + "]" + ", retrieve more than one occurence in " + "LDAP server [" + this.providerURL + "]");
            }
            throw new NameNotFoundException();
        }
        NameParser parser = ctx.getNameParser(this.searchBaseDN);
        Name userDN = parser.parse(this.searchBaseDN);
        if (userDN == (Name)null) {
            throw new NameNotFoundException();
        }
        userDN.addAll(parser.parse(result.getName()));
        return userDN.toString();
    }

    /*
     * Exception decompiling
     */
    private void resolveDNForGroup(DirContext ctx, String baseDN, String searchFilter, String[] searchAttributes, boolean topLevel, String group, List<String> groupMembers) throws NamingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean attributeExists(String attr, String[] attrs) {
        for (String a : attrs) {
            if (!attr.equalsIgnoreCase(a)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getLDAPGroupMembers(String ldapGroup) throws NamingException {
        Properties env = null;
        if (this.searchAuthDN != (String)null) {
            env = (Properties)this.initDirContextEnv.clone();
            env.put("java.naming.security.principal", this.searchAuthDN);
            env.put("java.naming.security.credentials", this.searchAuthPW);
        } else {
            env = this.initDirContextEnv;
        }
        if (GemFireXDUtils.TraceAuthentication) {
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("Initializing search for LDAP group=" + ldapGroup));
        }
        DirContext ctx = this.privInitialDirContext(env);
        String searchFilter = groupPattern.matcher(this.searchGroupFilter).replaceAll(ldapGroup);
        if (GemFireXDUtils.TraceAuthentication) {
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("Searching for LDAP group=" + ldapGroup + ", groupBase=" + this.searchGroupBase + ", searchFilter=" + searchFilter));
        }
        ArrayList<String> groupMembers = new ArrayList<String>();
        this.resolveDNForGroup(ctx, this.searchGroupBase, searchFilter, this.searchGroupAttributes, true, ldapGroup, groupMembers);
        ctx.close();
        THashSet uniqueMembers = new THashSet(groupMembers);
        return uniqueMembers;
    }

    public String toString() {
        return "LDAP";
    }

    @Override
    public Properties getCredentials(Properties securityProps) throws SQLException {
        return SecurityUtils.getCredentials(securityProps);
    }
}

