/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.shared.FinalizeHolder;
import com.gemstone.gemfire.internal.shared.FinalizeObject;
import com.gemstone.gemfire.internal.util.BlobHelper;
import com.pivotal.gemfirexd.execute.CallbackStatement;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.ddl.DDLConflatable;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLFinishMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLQueueEntry;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegionQueue;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdWaitingReplyProcessor;
import com.pivotal.gemfirexd.internal.engine.distributed.QueryCancelFunction;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ConstantValueSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.NonUpdatableRowsResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.DerbySQLException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineStatement;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.PreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.ConnectionChild;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.TransactionResourceImpl;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericResultDescription;
import com.pivotal.gemfirexd.internal.impl.sql.StatementStats;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateSchemaConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.LockTableConstantAction;
import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EmbedStatement
extends ConnectionChild
implements EngineStatement,
CallbackStatement {
    private final Connection applicationConnection;
    protected EngineStatement applicationStatement;
    protected Activation activation;
    int updateCount = -1;
    java.sql.ResultSet results;
    ResultSet iapiResultSet = null;
    PreparedStatement gps = null;
    private static final String[] ignoreStatesForClientDDLRetry = new String[]{"42X05", "42X65", "42Y07", "X0X05", "X0X99", "01504", "X0Y32", "X0Y68"};
    protected static final HashSet<String> ignoreStateSetForClientDDLRetry = new HashSet(ignoreStatesForClientDDLRetry.length);
    protected EmbedResultSet autoGeneratedKeysResultSet;
    private String cursorName;
    private final boolean forMetaData;
    int resultSetType;
    int resultSetConcurrency;
    private int resultSetHoldability;
    final LanguageConnectionContext lcc;
    private SQLWarning warnings;
    String SQLText;
    private int fetchSize = 1;
    private int fetchDirection = 1000;
    int MaxFieldSize;
    long timeoutMillis;
    private boolean active = true;
    ArrayList<Object> batchStatements;
    int batchStatementCurrentIndex = 0;
    int executeBatchInProgress = 0;
    int maxRows;
    protected ParameterValueSet pvs;
    protected boolean isPoolable = false;
    final long statementID;
    int executionID;
    long rootID;
    int statementLevel;
    protected StatementStats stats;
    protected FinalizeStatement finalizer;
    private java.sql.ResultSet[] dynamicResults;
    private int currentDynamicResultSet;

    public static final SQLWarning ignoreDDLForClientRetry(LanguageConnectionContext lcc, Throwable t) {
        if (lcc != null && lcc.isPossibleDuplicate()) {
            String messageId = null;
            Object[] args = null;
            String sqlState = null;
            if (t.getClass() == StandardException.class) {
                StandardException se = (StandardException)t;
                messageId = se.getMessageId();
                args = se.getArguments();
                sqlState = se.getSQLState();
            } else if (t instanceof DerbySQLException) {
                DerbySQLException de = (DerbySQLException)((Object)t);
                messageId = de.getMessageId();
                args = de.getArguments();
                sqlState = StandardException.getSQLStateFromIdentifier(messageId);
            }
            if (sqlState != null && ignoreStateSetForClientDDLRetry.contains(sqlState)) {
                return StandardException.newWarning(messageId, args, t);
            }
        }
        return null;
    }

    public static void fillInColumnName(StandardException se, String columnName, Activation a) {
        Object[] args;
        if (columnName == null && a == null) {
            return;
        }
        String msgId = se.getMessageId();
        if ("22003".equals(msgId) || "22018".equals(msgId)) {
            Object[] args2 = se.getArguments();
            if (args2 != null && (args2.length == 1 || args2.length > 1 && args2[1] == null)) {
                String colName;
                Object[] newArgs = new Object[2];
                String string = colName = columnName == null ? a.getCurrentColumnName() : columnName;
                if (colName == null) {
                    colName = "unknown";
                }
                newArgs[0] = args2[0];
                newArgs[1] = colName;
                se.setArguments(newArgs);
            }
        } else if ("22005".equals(msgId) || "XCL12.S".equals(msgId) || "22005.S.1".equals(msgId)) {
            Object[] args3 = se.getArguments();
            if (args3 != null && (args3.length == 2 || args3.length > 2 && args3[2] == null)) {
                String colName;
                Object[] newArgs = new Object[3];
                String string = colName = columnName == null ? a.getCurrentColumnName() : columnName;
                if (colName == null) {
                    colName = "unknown";
                }
                newArgs[0] = args3[0];
                newArgs[1] = args3[1];
                newArgs[2] = colName;
                se.setArguments(newArgs);
            }
        } else if (("22007.S.180".equals(msgId) || "22007.S.181".equals(msgId)) && ((args = se.getArguments()) == null || args.length == 0 || args.length > 0 && args[0] == null)) {
            String colName;
            Object[] newArgs = new Object[1];
            String string = colName = columnName == null ? a.getCurrentColumnName() : columnName;
            if (colName == null) {
                colName = "unknown";
            }
            newArgs[0] = colName;
            se.setArguments(newArgs);
        }
    }

    protected final void setResults(EmbedResultSet ers) {
        this.results = ers;
        FinalizeStatement finalizer = this.finalizer;
        if (finalizer != null) {
            if (ers != null) {
                finalizer.addSingleUseActivation(ers.singleUseActivation);
            } else {
                finalizer.clearAllSingleUseActivations();
            }
        }
    }

    @Override
    public final void setResultSet(java.sql.ResultSet rs) {
        if (rs instanceof EmbedResultSet) {
            this.setResults((EmbedResultSet)rs);
        } else {
            this.results = rs;
        }
    }

    @Override
    public final void setUpdateCount(int count) {
        this.updateCount = count;
    }

    protected void postBatchExecution() throws StandardException, SQLException {
    }

    protected FinalizeStatement newFinalizer(EmbedStatement stmt) {
        return new FinalizeStatement(stmt);
    }

    public final long getID() {
        return this.statementID;
    }

    public final long getRootID() {
        return this.rootID;
    }

    public final long setRootID(long rootID) {
        this.rootID = rootID;
        return this.rootID;
    }

    public final long getStatementLevel() {
        return this.statementLevel;
    }

    public final long setStatementLevel(int val) {
        this.statementLevel = val;
        return this.statementLevel;
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        throw new AssertionError((Object)"unexpected execution: JDBC 4.0 only method");
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        throw new AssertionError((Object)"unexpected execution: JDBC 4.0 only method");
    }

    public EmbedStatement(EmbedConnection connection, boolean forMetaData, int resultSetType, int resultSetConcurrency, int resultSetHoldability, long stmtID, long rootID, int stmtLevel) throws SQLException {
        super(connection);
        this.forMetaData = forMetaData;
        this.statementID = stmtID;
        this.executionID = 0;
        this.rootID = rootID;
        this.statementLevel = stmtLevel;
        this.checkAttributes(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.lcc = this.getEmbedConnection().getLanguageConnection();
        this.lcc.setStatementId(this.statementID);
        if (!this.getEmbedConnection().isNestedConnection() && this.lcc.getDeafultQueryTimeOut() > 0) {
            this.setQueryTimeout(this.lcc.getDeafultQueryTimeOut());
        } else {
            this.timeoutMillis = this.getEmbedConnection().getDefaultNestedConnQueryTimeOut();
        }
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.getStatementIDs(this.statementID, this.rootID, this.statementLevel);
        }
        this.applicationConnection = this.getEmbedConnection().getApplicationConnection();
        this.applicationStatement = this;
        this.finalizer = this.newFinalizer(this);
    }

    @Override
    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql, true, false, 2, null, null);
        if (this.results == null) {
            SanityManager.THROWASSERT((String)"no results returned on executeQuery()");
        }
        return this.results;
    }

    public int executeUpdateByPassQueryInfo(String sql, boolean needGfxdSubactivation, boolean flattenSubquery, int activationFlags, FunctionContext fnContext) throws SQLException {
        this.execute(sql, false, true, 2, null, null, false, false, needGfxdSubactivation, flattenSubquery, activationFlags, fnContext);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql, false, true, 2, null, null);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.execute(sql, false, true, autoGeneratedKeys, null, null);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.execute(sql, false, true, columnIndexes == null || columnIndexes.length == 0 ? 2 : 1, columnIndexes, null);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.execute(sql, false, true, columnNames == null || columnNames.length == 0 ? 2 : 1, null, columnNames);
        return this.updateCount;
    }

    final void checkIfInMiddleOfBatch() throws SQLException {
        if (this.batchStatements != null && this.batchStatementCurrentIndex > 0) {
            throw this.newSQLException("XJ068.S");
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.active) {
            try {
                this.checkExecStatus();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return !this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (!this.active) {
                return;
            }
            this.iapiResultSet = null;
            FinalizeStatement finalizer = this.finalizer;
            if (finalizer != null) {
                finalizer.clearAll();
                this.finalizer = null;
            }
            this.closeActions();
            this.active = false;
            this.clearResultSets();
            this.stats = null;
            this.cursorName = null;
            this.warnings = null;
            this.SQLText = null;
            this.batchStatements = null;
            this.batchStatementCurrentIndex = 0;
            this.executeBatchInProgress = 0;
        }
    }

    public final boolean isActive() {
        return this.active;
    }

    public final boolean hasBatch() {
        return this.batchStatements != null && this.batchStatements.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearBatchIfPossible() {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.batchStatements = null;
        }
    }

    public void clearParameters() throws SQLException {
    }

    void closeActions() throws SQLException {
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkStatus();
        return this.MaxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkStatus();
        if (max < 0) {
            throw this.newSQLException("XJ066.S", new Integer(max));
        }
        this.MaxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkStatus();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkStatus();
        if (max < 0) {
            throw this.newSQLException("XJ063.S", new Integer(max));
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkStatus();
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        this.checkStatus();
        return (int)(this.timeoutMillis / 1000L);
    }

    @Override
    public final void setQueryTimeout(int seconds) throws SQLException {
        EmbedConnection conn;
        int timeOutForOuterStmt;
        this.checkStatus();
        if (seconds < 0) {
            throw this.newSQLException("XJ074.S", new Integer(seconds));
        }
        if (GemFireXDUtils.TraceExecution) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("EmbedStatement#setQueryTimeout timeout=" + seconds + " seconds"));
        }
        if ((timeOutForOuterStmt = (int)((conn = this.getEmbedConnection()).getDefaultNestedConnQueryTimeOut() / 1000L)) > 0 && seconds > timeOutForOuterStmt) {
            this.addWarning(StandardException.newWarning("01509", new Object[]{seconds, timeOutForOuterStmt, timeOutForOuterStmt}, null));
            this.timeoutMillis = conn.getDefaultNestedConnQueryTimeOut();
        } else {
            this.timeoutMillis = (long)seconds * 1000L;
        }
        if (!conn.isNestedConnection()) {
            this.getEmbedConnection().getLanguageConnectionContext().setLastStatementQueryTimeOut(this.timeoutMillis);
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (GemFireXDUtils.TraceExecution) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("EmbedStatement#cancel statementId=" + this.statementID + " activation=" + this.activation));
        }
        if (this.activation != null && !this.activation.isClosed()) {
            this.activation.cancelOnUserRequest();
        }
        QueryCancelFunction.QueryCancelFunctionArgs args = QueryCancelFunction.newQueryCancelFunctionArgs(this.statementID, this.executionID, this.lcc.getConnectionId());
        Set<DistributedMember> dataStores = GemFireXDUtils.getGfxdAdvisor().adviseDataStores(null);
        InternalDistributedMember myId = GemFireStore.getMyId();
        dataStores.remove(myId);
        if (dataStores.size() > 0) {
            FunctionService.onMembers(dataStores).withArgs((Object)args).execute("gfxd-QueryCancelFunction");
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkStatus();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkStatus();
        this.warnings = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkStatus();
        this.cursorName = name;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, false, false, 2, null, null);
    }

    private boolean execute(String sql, boolean executeQuery, boolean executeUpdate, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames) throws SQLException {
        return this.execute(sql, executeQuery, executeUpdate, autoGeneratedKeys, columnIndexes, columnNames, true, false, false, true, 0, null);
    }

    public java.sql.ResultSet executeQueryByPassQueryInfo(String sql, boolean needGfxdSubactivation, boolean flattenSubquery, int activationFlags, FunctionContext fnContext) throws SQLException {
        this.execute(sql, true, false, 2, null, null, false, true, needGfxdSubactivation, flattenSubquery, activationFlags, fnContext);
        if (this.results == null) {
            SanityManager.THROWASSERT((String)"no results returned on executeQuery()");
        }
        return this.results;
    }

    /*
     * Exception decompiling
     */
    private boolean execute(String sql, boolean executeQuery, boolean executeUpdate, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames, boolean createQueryInfo, boolean skipContextRestore, boolean needGfxdSubactivation, boolean flattenSubquery, int activationFlags, FunctionContext fnContext) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateParameterizedData(PreparedStatement preparedStatement) throws StandardException {
        int validateResult;
        ConstantValueSet cvs = (ConstantValueSet)this.lcc.getConstantValueSet(null);
        GenericPreparedStatement gps = (GenericPreparedStatement)preparedStatement;
        if (cvs != null && (validateResult = cvs.validateParameterizedData()) != -1) {
            QueryInfo qInfo = gps.getQueryInfo();
            if (qInfo != null) {
                qInfo.throwExceptionForInvalidParameterizedData(validateResult);
            } else {
                throw StandardException.newException("42821", (Object)cvs.getParamTypes()[validateResult].getTypeId().getSQLTypeName(), (Object)cvs.getOrigTypeCompilers().get(validateResult).getCorrespondingPrimitiveTypeName(), (Object)("non-null column " + Integer.toString(validateResult + 1)));
            }
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql, false, false, autoGeneratedKeys, null, null);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql, false, true, columnIndexes == null || columnIndexes.length == 0 ? 2 : 1, columnIndexes, null);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql, false, true, columnNames == null || columnNames.length == 0 ? 2 : 1, null, columnNames);
    }

    @Override
    public final java.sql.ResultSet getResultSet() throws SQLException {
        this.checkStatus();
        return this.results;
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        this.checkStatus();
        return this.updateCount;
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    @Override
    public final int getResultSetType() throws SQLException {
        this.checkStatus();
        return this.resultSetType;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkStatus();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw this.newSQLException("XJ064.S", new Integer(direction));
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkStatus();
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkStatus();
        if (rows < 0 || this.getMaxRows() != 0 && rows > this.getMaxRows()) {
            throw this.newSQLException("XJ065.S", new Integer(rows));
        }
        if (rows > 0) {
            this.fetchSize = rows;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkStatus();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkStatus();
        return this.resultSetConcurrency;
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        this.checkStatus();
        return this.resultSetHoldability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.batchStatements == null) {
                this.batchStatements = new ArrayList();
            }
            this.batchStatements.add(sql);
            ++this.batchStatementCurrentIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearBatch() throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.batchStatements = null;
            this.batchStatementCurrentIndex = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetBatch() throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.batchStatementCurrentIndex = 0;
            if (this.batchStatements != null) {
                for (int i = this.batchStatements.size() - 1; i >= 0; --i) {
                    ((ParameterValueSet)this.batchStatements.get(i)).clearParameters();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            SQLException sqle;
            ++this.executeBatchInProgress;
            this.setupContextStack(true);
            int i = 0;
            this.clearResultSets();
            ArrayList<Object> stmts = this.batchStatements;
            if (!this.isPrepared()) {
                this.batchStatements = null;
            }
            int size = stmts == null ? 0 : this.batchStatementCurrentIndex;
            int[] returnUpdateCountForBatch = new int[size];
            GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
            try {
                Object tran;
                if (observer != null) {
                    observer.beforeBatchQueryExecution(this, stmts != null ? stmts.size() : 0);
                }
                while (i < size) {
                    if (this.executeBatchElement(stmts.get(i))) {
                        throw this.newSQLException("XJ04B.S");
                    }
                    returnUpdateCountForBatch[i] = this.getUpdateCount();
                    ++i;
                }
                this.postBatchExecution();
                this.commitIfAutoCommit();
                if (this.lcc != null && !((GemFireTransaction)(tran = (Object)((GemFireTransaction)this.lcc.getTransactionExecute()))).isTransactional()) {
                    ((GemFireTransaction)tran).releaseAllLocks(false, false);
                }
                if (observer != null) {
                    observer.afterBatchQueryExecution(this, size);
                }
                tran = returnUpdateCountForBatch;
                return tran;
            }
            catch (StandardException se) {
                sqle = this.handleException(se);
            }
            catch (SQLException sqle2) {
                sqle = sqle2;
            }
            finally {
                this.restoreContextStack();
            }
            int[] successfulUpdateCount = new int[i];
            int j = 0;
            while (true) {
                if (j >= i) {
                    BatchUpdateException batch = new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), successfulUpdateCount);
                    batch.setNextException(sqle);
                    batch.initCause(sqle);
                    throw batch;
                }
                successfulUpdateCount[j] = returnUpdateCountForBatch[j];
                ++j;
            }
        }
    }

    boolean executeBatchElement(Object batchElement) throws SQLException, StandardException {
        return this.execute((String)batchElement, false, true, 2, null, null);
    }

    @Override
    public final Connection getConnection() throws SQLException {
        this.checkStatus();
        Connection appConn = this.getEmbedConnection().getApplicationConnection();
        if (appConn != this.applicationConnection || appConn == null) {
            throw Util.noCurrentConnection();
        }
        return appConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean getMoreResults(int current) throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.dynamicResults == null) {
                this.clearResultSets();
                return false;
            }
            switch (current) {
                default: {
                    int startingClose = 0;
                    break;
                }
                case 1: {
                    int startingClose = this.currentDynamicResultSet;
                    break;
                }
                case 2: {
                    int startingClose = this.dynamicResults.length;
                }
            }
            SQLException se = null;
            for (int i = startingClose; i <= this.currentDynamicResultSet && i < this.dynamicResults.length; ++i) {
                java.sql.ResultSet lrs = this.dynamicResults[i];
                if (lrs == null) continue;
                try {
                    lrs.close();
                    continue;
                }
                catch (SQLException sqle) {
                    if (se == null) {
                        se = sqle;
                        continue;
                    }
                    se.setNextException(sqle);
                    continue;
                }
                finally {
                    this.dynamicResults[i] = null;
                }
            }
            if (se != null) {
                throw se;
            }
            this.updateCount = -1;
            while (++this.currentDynamicResultSet < this.dynamicResults.length) {
                java.sql.ResultSet lrs = this.dynamicResults[this.currentDynamicResultSet];
                if (lrs == null) continue;
                if (lrs instanceof EmbedResultSet) {
                    if (((EmbedResultSet)lrs).isClosed) {
                        this.dynamicResults[this.currentDynamicResultSet] = null;
                        continue;
                    }
                } else if (lrs.isClosed()) {
                    this.dynamicResults[this.currentDynamicResultSet] = null;
                    continue;
                }
                this.setResultSet(lrs);
                return true;
            }
            this.setResults(null);
            return false;
        }
    }

    @Override
    public final java.sql.ResultSet getGeneratedKeys() throws SQLException {
        this.checkStatus();
        if (this.autoGeneratedKeysResultSet == null) {
            return null;
        }
        return this.autoGeneratedKeysResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean executeStatement(Activation a, boolean executeQuery, boolean executeUpdate, boolean createQueryInfo, boolean isContextSet, boolean skipContextRestore, boolean isPreparedBatch) throws SQLException {
        if (this.stats != null) {
            this.stats.incStat(2, createQueryInfo, 1L);
        }
        SQLException throwEx = null;
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean retval;
            boolean origAutoCommit;
            boolean ddlNestedTransaction;
            GemFireXDQueryObserver observer;
            block108: {
                observer = GemFireXDQueryObserverHolder.getInstance();
                if (observer != null) {
                    observer.beforeQueryExecution(this, a);
                }
                this.clearResultSets(isPreparedBatch);
                boolean distribute = false;
                DDLConstantAction ddlAction = null;
                ddlNestedTransaction = false;
                boolean stmtSuccess = false;
                origAutoCommit = this.localConn.getAutoCommit();
                if (!isContextSet) {
                    this.setupContextStack(true);
                }
                this.pvs = a.getParameterValueSet();
                try {
                    block105: {
                        long sequenceId;
                        boolean hdfsPersistenceSuccess;
                        HashSet<DistributedMember> memberThatPersistOnHDFS;
                        Set<DistributedMember> otherMembers;
                        DDLConflatable ddl;
                        Long ddlId;
                        InternalDistributedSystem sys;
                        block106: {
                            DDLConflatable schemaDDL;
                            GfxdDDLRegionQueue ddlQ;
                            block107: {
                                GemFireTransaction tran;
                                boolean connForRemote;
                                this.clearWarnings();
                                this.doCommitIfNeeded(isPreparedBatch, true);
                                ExecPreparedStatement ps = a.getPreparedStatement();
                                ps.rePrepare(this.lcc, a);
                                this.addWarning(ps.getCompileTimeWarnings());
                                ConstantAction act = ((GenericPreparedStatement)ps).getConstantAction();
                                sys = null;
                                GfxdWaitingReplyProcessor processor = null;
                                boolean disableLogging = false;
                                ddlQ = null;
                                ddlId = 0L;
                                if (this.lcc != null) {
                                    connForRemote = this.lcc.isConnectionForRemote();
                                    tran = (GemFireTransaction)this.lcc.getTransactionExecute();
                                } else {
                                    connForRemote = false;
                                    tran = null;
                                }
                                if (act != null && act instanceof DDLConstantAction) {
                                    if (!connForRemote) {
                                        ddlAction = (DDLConstantAction)act;
                                        distribute = ddlAction.isReplayable();
                                        if (distribute) {
                                            ddlQ = Misc.getMemStore().getDDLStmtQueue();
                                            ddlId = ddlQ.newUUID();
                                        }
                                        sys = Misc.getDistributedSystem();
                                        DistributionDescriptor.checkAvailableDataStore(this.lcc, null, "DDL " + this.SQLText);
                                        if (GemFireXDUtils.TraceDDLReplay) {
                                            SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("EmbedStatement: Starting execution of DDL statement with remoting: " + this.SQLText));
                                        }
                                        this.lcc.beginNestedTransactionExecute(false, false, "start of DDL execution for: " + this.SQLText);
                                        if (!origAutoCommit) {
                                            this.localConn.autoCommit = true;
                                        }
                                        ddlNestedTransaction = true;
                                        tran = (GemFireTransaction)this.lcc.getTransactionExecute();
                                        tran.setDDLId(ddlId);
                                    }
                                    if (tran != null) {
                                        tran.enableLogging();
                                        disableLogging = true;
                                    }
                                }
                                ddl = null;
                                String defaultSchema = null;
                                otherMembers = null;
                                memberThatPersistOnHDFS = null;
                                hdfsPersistenceSuccess = false;
                                if (GemFireXDUtils.TraceExecution) {
                                    String pvsStr;
                                    ParameterValueSet pvs;
                                    String sql = GemFireXDUtils.maskCreateUserPasswordFromSQLString(this.SQLText);
                                    if (this.isPrepared() && (pvs = this.getParameterValueSet()) != null && pvs.getParameterCount() > 0) {
                                        if (sql == null && pvs.getParameterCount() == 2) {
                                            pvs = pvs.getClone();
                                            pvs.getParameter(1).setValue("***");
                                        }
                                        pvsStr = ", args: " + pvs;
                                    } else {
                                        pvsStr = "";
                                    }
                                    if (sql == null) {
                                        sql = this.SQLText;
                                    }
                                    SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("EmbedStatement#executeStatement: executing " + sql + pvsStr + " ;statementId:" + this.getStatementUUID() + " ;statementLevel:" + this.statementLevel + " ;rootID:" + this.rootID));
                                }
                                try {
                                    block117: {
                                        block114: {
                                            block115: {
                                                DistributedMember selectedmember;
                                                Set<DistributedMember> dataStores;
                                                block116: {
                                                    TXStateProxy txProxy;
                                                    block113: {
                                                        if (this.cursorName != null) {
                                                            a.setCursorName(this.cursorName);
                                                        }
                                                        boolean executeHoldable = this.getExecuteHoldable();
                                                        a.setResultSetHoldability(executeHoldable);
                                                        a.reset(false);
                                                        a.setMaxRows(this.maxRows);
                                                        a.setPreparedBatch(isPreparedBatch);
                                                        a.setExecutionID(++this.executionID);
                                                        a.setTimeOutMillis(this.timeoutMillis);
                                                        ResultSet resultsToWrap = ps.execute(a, false, this.timeoutMillis, !skipContextRestore, false);
                                                        this.addWarning(a.getWarnings());
                                                        if (resultsToWrap.returnsRows()) {
                                                            if (executeUpdate) {
                                                                throw StandardException.newException("X0Y79.S");
                                                            }
                                                            EmbedResultSet lresults = this.factory.newEmbedResultSet(this.getEmbedConnection(), resultsToWrap, this.forMetaData, this, ps.isAtomic());
                                                            if (a.isSingleExecution()) {
                                                                lresults.singleUseActivation = a;
                                                            }
                                                            this.setResults(lresults);
                                                            this.updateCount = -1;
                                                            retval = true;
                                                        } else {
                                                            if (!isPreparedBatch && a.getAutoGeneratedKeysResultsetMode() && resultsToWrap.hasAutoGeneratedKeysResultSet()) {
                                                                resultsToWrap.getAutoGeneratedKeysResultset().open();
                                                                this.autoGeneratedKeysResultSet = this.factory.newEmbedResultSet(this.getEmbedConnection(), resultsToWrap.getAutoGeneratedKeysResultset(), false, this, ps.isAtomic());
                                                                int[] autoGeneratedColumns = resultsToWrap.getActivation().getAutoGeneratedKeysColumnIndexes();
                                                                ResultDescription oldDescription = resultsToWrap.getActivation().getResultDescription();
                                                                ResultColumnDescriptor[] savedDescriptors = new ResultColumnDescriptor[autoGeneratedColumns.length];
                                                                for (int i = 0; i < autoGeneratedColumns.length; ++i) {
                                                                    for (ResultColumnDescriptor rcd : oldDescription.getColumnInfo()) {
                                                                        if (rcd.getColumnPosition() != autoGeneratedColumns[i]) continue;
                                                                        savedDescriptors[i] = rcd;
                                                                    }
                                                                }
                                                                this.autoGeneratedKeysResultSet.setResultDescription(new GenericResultDescription(savedDescriptors, "INSERT"));
                                                            }
                                                            this.updateCount = resultsToWrap.modifiedRowCount();
                                                            if (this.lcc.getRunTimeStatisticsMode()) {
                                                                this.iapiResultSet = resultsToWrap;
                                                                this.gps = ps;
                                                            }
                                                            this.setResults(null);
                                                            int dynamicResultCount = 0;
                                                            if (a.getDynamicResults() != null) {
                                                                dynamicResultCount = this.processDynamicResults(a.getDynamicResults(), a.getMaxDynamicResults());
                                                            }
                                                            if (distribute) {
                                                                ddlAction = (DDLConstantAction)((GenericPreparedStatement)ps).getConstantAction();
                                                                distribute = ddlAction.isReplayable();
                                                                if (ddlAction instanceof IndexConstantAction) {
                                                                    SQLWarning warn = a.getWarnings();
                                                                    distribute = warn == null || !"01504".equals(warn.getSQLState());
                                                                }
                                                            }
                                                            resultsToWrap.close(false);
                                                            if (executeQuery && dynamicResultCount != 1) {
                                                                throw StandardException.newException("X0Y78.S");
                                                            }
                                                            if (executeUpdate && dynamicResultCount > 0) {
                                                                throw StandardException.newException("X0Y79.S");
                                                            }
                                                            if (dynamicResultCount == 0) {
                                                                if (a.isSingleExecution()) {
                                                                    a.close();
                                                                } else if (this.updateCount >= 0) {
                                                                    a.reset(false);
                                                                }
                                                                if (!distribute) {
                                                                    if (!origAutoCommit) {
                                                                        if (!(tran.isTransactional() || isPreparedBatch || act != null && act instanceof LockTableConstantAction)) {
                                                                            tran.releaseAllLocks(false, false);
                                                                        }
                                                                    } else {
                                                                        this.doCommitIfNeeded(isPreparedBatch, false);
                                                                    }
                                                                }
                                                            }
                                                            boolean bl = retval = dynamicResultCount > 0;
                                                            if (this.stats != null) {
                                                                this.stats.incStat(2, createQueryInfo, -1L);
                                                                this.stats.incStat(1, createQueryInfo, 1L);
                                                            }
                                                        }
                                                        if (!distribute) break block113;
                                                        GemFireStore memStore = Misc.getMemStore();
                                                        otherMembers = GfxdMessage.getOtherMembers();
                                                        if (otherMembers.size() == 0) {
                                                            distribute = false;
                                                        }
                                                        defaultSchema = this.localConn.getLanguageConnection().getDefaultSchema().getSchemaName();
                                                        Object additionalArgs = this.lcc.getContextObject();
                                                        this.lcc.setContextObject(null);
                                                        DDLConflatable schemaDDL2 = null;
                                                        boolean queueInitialized = ddlQ.isInitialized() && (memStore.initialDDLReplayInProgress() || memStore.initialDDLReplayDone());
                                                        CreateSchemaConstantAction csca = ddlAction.getImplicitSchemaCreated();
                                                        if (csca != null) {
                                                            long schemaDDLId = ddlQ.newUUID();
                                                            schemaDDL2 = new DDLConflatable(csca.toString(), defaultSchema, csca, null, null, schemaDDLId, queueInitialized);
                                                        }
                                                        ddl = new DDLConflatable(this.SQLText, defaultSchema, ddlAction, additionalArgs, schemaDDL2, ddlId, queueInitialized);
                                                        if (!distribute) break block114;
                                                        if (schemaDDL2 != null) {
                                                            SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("EmbedStatement: Implicit schema creation of " + schemaDDL2.getRegionToConflate() + " being enqueued"));
                                                        }
                                                        if (!GemFireXDUtils.getMyVMKind().isAccessor() || ddl == null || !ddl.isHDFSPersistent()) break block115;
                                                        dataStores = GfxdMessage.getDataStores();
                                                        selectedmember = null;
                                                        break block116;
                                                    }
                                                    if (!connForRemote && tran != null && (txProxy = tran.getCurrentTXStateProxy()) != null && !txProxy.batchingEnabled()) {
                                                        txProxy.flushPendingOps(null);
                                                    }
                                                    break block117;
                                                }
                                                while (dataStores.size() > 0) {
                                                    for (DistributedMember member : dataStores) {
                                                        if (Misc.getGemFireCache().isUnInitializedMember((InternalDistributedMember)member)) continue;
                                                        selectedmember = member;
                                                        break;
                                                    }
                                                    if (selectedmember == null) {
                                                        throw StandardException.newException("X0Z08.S", "execution of DDL " + this.SQLText);
                                                    }
                                                    memberThatPersistOnHDFS = new HashSet<DistributedMember>();
                                                    memberThatPersistOnHDFS.add(selectedmember);
                                                    processor = GfxdDDLMessage.getReplyProcessor(sys, memberThatPersistOnHDFS, true);
                                                    SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("EmbedStatement: Sending DDL statement " + this.SQLText + '[' + ddlId + "] to other VMs in the " + "distributed system for execution: " + selectedmember + ". This VM " + "is responsible for persisting the statement on HDFS. "));
                                                    GfxdDDLMessage.send(sys, processor, memberThatPersistOnHDFS, ddl, this.localConn.getConnectionID(), ddlId, this.lcc, true);
                                                    if (processor != null && processor.hasGrantedMembers()) {
                                                        hdfsPersistenceSuccess = true;
                                                        otherMembers.remove(selectedmember);
                                                        break;
                                                    }
                                                    dataStores.remove(selectedmember);
                                                }
                                                if (processor == null || !processor.hasGrantedMembers()) {
                                                    throw StandardException.newException("X0Z08.S", "execution of DDL " + this.SQLText);
                                                }
                                            }
                                            if (otherMembers.size() > 0) {
                                                processor = GfxdDDLMessage.getReplyProcessor(sys, otherMembers, true);
                                                SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("EmbedStatement: Sending DDL statement " + this.SQLText + '[' + ddlId + "] to other VMs in the " + "distributed system for execution: " + otherMembers));
                                                GfxdDDLMessage.send(sys, processor, otherMembers, ddl, this.localConn.getConnectionID(), ddlId, this.lcc);
                                            }
                                        }
                                        if (GemFireXDUtils.getMyVMKind().isAccessor() && (processor == null || !processor.hasGrantedMembers())) {
                                            throw StandardException.newException("X0Z08.S", "execution of DDL " + this.SQLText);
                                        }
                                    }
                                    if (GemFireXDUtils.getMyVMKind().isStore() && ddl != null && ddl.isHDFSPersistent() && !connForRemote) {
                                        SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("EmbedStatement: Persisting statement on HDFS " + this.SQLText + " this : " + GemFireStore.getMyId()));
                                        ArrayList<HDFSStoreImpl> destinationhdfsStores = EmbedStatement.getDestinationHDFSStoreForDDL(ddl, this.lcc);
                                        if (destinationhdfsStores != null && destinationhdfsStores.size() != 0) {
                                            EmbedStatement.persistOnHDFS(ddl, this.lcc, destinationhdfsStores);
                                        }
                                    }
                                    stmtSuccess = true;
                                    if (disableLogging) {
                                        tran.disableLogging();
                                    }
                                    if (tran != null) {
                                        tran.setDDLId(0L);
                                    }
                                    sequenceId = -1L;
                                    if (ddl == null) break block105;
                                    if (!stmtSuccess) break block106;
                                    if (!GemFireXDUtils.TraceDDLReplay) break block107;
                                }
                                catch (Throwable t) {
                                    try {
                                        if (GemFireXDUtils.TraceFunctionException) {
                                            SanityManager.DEBUG_PRINT((String)"TraceFunctionException", (String)("EmbedStatement: exception for SQL: " + this.SQLText), (Throwable)t);
                                        }
                                        throw t;
                                    }
                                    catch (Throwable throwable) {
                                        if (disableLogging) {
                                            tran.disableLogging();
                                        }
                                        if (tran != null) {
                                            tran.setDDLId(0L);
                                        }
                                        long sequenceId2 = -1L;
                                        if (ddl != null) {
                                            if (stmtSuccess) {
                                                DDLConflatable schemaDDL3;
                                                if (GemFireXDUtils.TraceDDLReplay) {
                                                    SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("EmbedStatement: Putting DDL statement in hidden region for remoting: " + ddl));
                                                }
                                                if ((schemaDDL3 = ddl.getImplicitSchema()) != null) {
                                                    ddl.setImplicitSchemaSequenceId(ddlQ.put(schemaDDL3.getId(), -1L, schemaDDL3, true, true));
                                                }
                                                sequenceId2 = ddlQ.put(ddlId, -1L, ddl, true, true);
                                            }
                                            if (distribute) {
                                                if (memberThatPersistOnHDFS != null && !hdfsPersistenceSuccess) {
                                                    SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("EmbedStatement: Sending GfxdDDLFinishMessage for " + this.SQLText + '[' + ddlId + "] to VM in the " + "distributed system for execution: " + memberThatPersistOnHDFS.iterator().next() + ". This VM was " + "responsible for persisting the statement on HDFS. "));
                                                    GfxdDDLFinishMessage.send(sys, (Set<DistributedMember>)memberThatPersistOnHDFS, ddl, this.localConn.getConnectionID(), ddlId, sequenceId2, stmtSuccess);
                                                } else {
                                                    if (memberThatPersistOnHDFS != null) {
                                                        otherMembers.add((DistributedMember)memberThatPersistOnHDFS.iterator().next());
                                                    }
                                                    SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("EmbedStatement: Sending GfxdDDLFinishMessage for DDL statement " + this.SQLText + '[' + ddlId + "] to other VMs in the " + "distributed system for execution: " + otherMembers + ". This VM " + "is responsible for persisting the statement on HDFS. "));
                                                    GfxdDDLFinishMessage.send(sys, otherMembers, ddl, this.localConn.getConnectionID(), ddlId, sequenceId2, stmtSuccess);
                                                }
                                            }
                                        }
                                        if (ddlNestedTransaction && stmtSuccess) {
                                            this.lcc.commitNestedTransactionExecute();
                                        }
                                        throw throwable;
                                    }
                                }
                                SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("EmbedStatement: Putting DDL statement in hidden region for remoting: " + ddl));
                            }
                            if ((schemaDDL = ddl.getImplicitSchema()) != null) {
                                ddl.setImplicitSchemaSequenceId(ddlQ.put(schemaDDL.getId(), -1L, schemaDDL, true, true));
                            }
                            sequenceId = ddlQ.put(ddlId, -1L, ddl, true, true);
                        }
                        if (distribute) {
                            if (memberThatPersistOnHDFS != null && !hdfsPersistenceSuccess) {
                                SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("EmbedStatement: Sending GfxdDDLFinishMessage for " + this.SQLText + '[' + ddlId + "] to VM in the " + "distributed system for execution: " + memberThatPersistOnHDFS.iterator().next() + ". This VM was " + "responsible for persisting the statement on HDFS. "));
                                GfxdDDLFinishMessage.send(sys, (Set<DistributedMember>)memberThatPersistOnHDFS, ddl, this.localConn.getConnectionID(), ddlId, sequenceId, stmtSuccess);
                            } else {
                                if (memberThatPersistOnHDFS != null) {
                                    otherMembers.add((DistributedMember)memberThatPersistOnHDFS.iterator().next());
                                }
                                SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("EmbedStatement: Sending GfxdDDLFinishMessage for DDL statement " + this.SQLText + '[' + ddlId + "] to other VMs in the " + "distributed system for execution: " + otherMembers + ". This VM " + "is responsible for persisting the statement on HDFS. "));
                                GfxdDDLFinishMessage.send(sys, otherMembers, ddl, this.localConn.getConnectionID(), ddlId, sequenceId, stmtSuccess);
                            }
                        }
                    }
                    if (ddlNestedTransaction && stmtSuccess) {
                        this.lcc.commitNestedTransactionExecute();
                    }
                    if (skipContextRestore && stmtSuccess || isContextSet) break block108;
                }
                catch (Throwable t) {
                    block111: {
                        boolean bl;
                        block112: {
                            SQLException abortEx;
                            block109: {
                                boolean processor;
                                block110: {
                                    try {
                                        SQLWarning ddlWarning;
                                        abortEx = null;
                                        if (ddlNestedTransaction) {
                                            try {
                                                this.lcc.abortNestedTransactionExecute();
                                            }
                                            catch (Throwable ae) {
                                                abortEx = TransactionResourceImpl.wrapInSQLException(ae);
                                            }
                                            if (!origAutoCommit && !this.localConn.isClosed()) {
                                                this.localConn.autoCommit = false;
                                            }
                                        }
                                        if (a.isSingleExecution()) {
                                            try {
                                                a.close();
                                            }
                                            catch (Throwable ae) {
                                                // empty catch block
                                            }
                                        }
                                        if (t.getClass() == StandardException.class) {
                                            EmbedStatement.fillInColumnName((StandardException)t, null, a);
                                            break block109;
                                        }
                                        if (ddlAction == null || (ddlWarning = EmbedStatement.ignoreDDLForClientRetry(this.lcc, t)) == null) break block109;
                                        this.addWarning(ddlWarning);
                                        processor = false;
                                        if (skipContextRestore && stmtSuccess || isContextSet) break block110;
                                    }
                                    catch (Throwable throwable) {
                                        if (!(skipContextRestore && stmtSuccess || isContextSet)) {
                                            this.restoreContextStack();
                                        }
                                        if (ddlNestedTransaction && !origAutoCommit && !this.localConn.isClosed()) {
                                            this.localConn.autoCommit = false;
                                        }
                                        if (observer != null && throwEx == null) {
                                            observer.afterQueryExecution(this, throwEx);
                                        }
                                        throw throwable;
                                    }
                                    this.restoreContextStack();
                                }
                                if (ddlNestedTransaction && !origAutoCommit && !this.localConn.isClosed()) {
                                    this.localConn.autoCommit = false;
                                }
                                if (observer != null && throwEx == null) {
                                    observer.afterQueryExecution(this, throwEx);
                                }
                                return processor;
                            }
                            throwEx = this.handleException(t);
                            EmbedStatement.setSQLExceptionCause(throwEx, abortEx);
                            if (ddlNestedTransaction) {
                                try {
                                    this.lcc.cleanupNestedTransactionExecute();
                                }
                                catch (Throwable cleanEx) {
                                    SQLException ce = TransactionResourceImpl.wrapInSQLException(cleanEx);
                                    EmbedStatement.setSQLExceptionCause(throwEx, ce);
                                }
                            }
                            if (this.stats != null) {
                                this.stats.incStat(2, createQueryInfo, -1L);
                            }
                            if (observer == null || !observer.afterQueryExecution(this, throwEx)) break block111;
                            boolean bl2 = bl = this.results != null;
                            if (skipContextRestore && stmtSuccess || isContextSet) break block112;
                            this.restoreContextStack();
                        }
                        if (ddlNestedTransaction && !origAutoCommit && !this.localConn.isClosed()) {
                            this.localConn.autoCommit = false;
                        }
                        if (observer != null && throwEx == null) {
                            observer.afterQueryExecution(this, throwEx);
                        }
                        return bl;
                    }
                    this.clearResultSets();
                    throw throwEx;
                }
                this.restoreContextStack();
            }
            if (ddlNestedTransaction && !origAutoCommit && !this.localConn.isClosed()) {
                this.localConn.autoCommit = false;
            }
            if (observer != null && throwEx == null) {
                observer.afterQueryExecution(this, throwEx);
            }
            return retval;
        }
    }

    final void doCommitIfNeeded(boolean isPreparedBatch, boolean markNeedCommit) throws SQLException {
        if (!this.forMetaData) {
            if (!isPreparedBatch) {
                this.commitIfNeeded();
                if (markNeedCommit) {
                    this.needCommit();
                }
            }
        } else if (this.lcc.getActivationCount() <= 1) {
            this.commitIfNeeded();
            if (markNeedCommit) {
                this.needCommit();
            }
        }
    }

    private static void setSQLExceptionCause(SQLException sqle, SQLException next) {
        if (sqle != null && next != null) {
            sqle.setNextException(next);
            Throwable nextEx = sqle;
            while (nextEx.getCause() != null) {
                nextEx = nextEx.getCause();
            }
            try {
                nextEx.initCause(next);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    final void addWarning(SQLWarning sw) {
        if (sw != null) {
            if (this.warnings == null) {
                this.warnings = sw;
            } else {
                this.warnings.setNextException(sw);
            }
        }
    }

    @Override
    public String getSQLText() {
        return this.SQLText;
    }

    public ParameterValueSet getParameterValueSet() {
        return this.pvs;
    }

    public Activation getActivation() {
        return this.activation;
    }

    public int getExecutionID() {
        return this.executionID;
    }

    public String getStatementUUID() {
        return this.getEmbedConnection().getConnectionID() + "-" + this.statementID + "-" + this.executionID;
    }

    public long getEstimatedMemoryUsage() throws StandardException {
        if (this.activation == null) {
            return 0L;
        }
        return this.activation.estimateMemoryUsage();
    }

    final void checkStatus() throws SQLException {
        if (!this.active) {
            Connection appConn = this.getEmbedConnection().getApplicationConnection();
            if (appConn == null || appConn.isClosed()) {
                throw Util.noCurrentConnection();
            }
            throw this.newSQLException("XJ012.S", "Statement");
        }
    }

    final void checkExecStatus() throws SQLException {
        this.checkStatus();
        EmbedConnection conn = this.localConn;
        Connection appConn = conn.getApplicationConnection();
        if (conn == appConn) {
            if (conn.isActive()) {
                return;
            }
            throw Util.noCurrentConnection();
        }
        if (appConn == this.applicationConnection && appConn != null && !appConn.isClosed()) {
            return;
        }
        this.active = false;
        throw Util.noCurrentConnection();
    }

    void clearResultSets() throws SQLException {
        this.clearResultSets(false);
    }

    public void resetForReuse() throws SQLException {
        this.iapiResultSet = null;
        this.clearResultSets();
        this.cursorName = null;
        this.warnings = null;
        this.SQLText = null;
        this.batchStatements = null;
        this.batchStatementCurrentIndex = 0;
        this.clearParameters();
    }

    public boolean hasDynamicResults() {
        return this.dynamicResults != null;
    }

    void clearResultSets(boolean isPreparedBatch) throws SQLException {
        SQLException sqle = null;
        try {
            java.sql.ResultSet results = this.results;
            if (results != null) {
                results.close();
                this.setResults(null);
            }
        }
        catch (SQLException s1) {
            sqle = s1;
        }
        try {
            if (!isPreparedBatch && this.autoGeneratedKeysResultSet != null) {
                this.autoGeneratedKeysResultSet.close();
                this.autoGeneratedKeysResultSet = null;
            }
        }
        catch (SQLException sauto) {
            if (sqle == null) {
                sqle = sauto;
            }
            sqle.setNextException(sauto);
        }
        if (this.dynamicResults != null) {
            for (int i = 0; i < this.dynamicResults.length; ++i) {
                java.sql.ResultSet lrs = this.dynamicResults[i];
                if (lrs == null) continue;
                try {
                    lrs.close();
                    continue;
                }
                catch (SQLException sdynamic) {
                    if (sqle == null) {
                        sqle = sdynamic;
                        continue;
                    }
                    sqle.setNextException(sdynamic);
                }
            }
            this.dynamicResults = null;
        }
        this.updateCount = -1;
        if (sqle != null) {
            throw sqle;
        }
    }

    void checkRequiresCallableStatement(Activation activation) throws SQLException {
        ParameterValueSet pvs = activation.getParameterValueSet();
        if (pvs == null) {
            return;
        }
        if (pvs.checkNoDeclaredOutputParameters()) {
            try {
                activation.close();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            throw this.newSQLException("XJ009.S", this.SQLText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferBatch(EmbedStatement other) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            other.batchStatements = this.batchStatements;
            this.batchStatements = null;
        }
    }

    public final void setApplicationStatement(EngineStatement s) {
        this.applicationStatement = s;
    }

    private int processDynamicResults(java.sql.ResultSet[][] holder, int maxDynamicResultSets) throws SQLException {
        int i;
        java.sql.ResultSet[] sorted = new java.sql.ResultSet[holder.length];
        int actualCount = 0;
        for (i = 0; i < holder.length; ++i) {
            java.sql.ResultSet[] param = holder[i];
            java.sql.ResultSet rs = param[0];
            param[0] = null;
            java.sql.ResultSet lrs = EmbedStatement.processDynamicResult(this.getEmbedConnection(), rs, this);
            if (lrs == null) continue;
            if (lrs instanceof EmbedResultSet) {
                ((EmbedResultSet)lrs).setResultsetIndex(i);
            }
            sorted[actualCount++] = lrs;
        }
        if (actualCount != 0) {
            this.dynamicResults = sorted;
            if (actualCount > maxDynamicResultSets) {
                this.addWarning(StandardException.newWarning("0100E"));
                for (i = maxDynamicResultSets; i < actualCount; ++i) {
                    sorted[i].close();
                    sorted[i] = null;
                }
                actualCount = maxDynamicResultSets;
            }
            this.updateCount = -1;
            this.setResultSet(sorted[0]);
            this.currentDynamicResultSet = 0;
        }
        return actualCount;
    }

    public static java.sql.ResultSet processDynamicResult(EmbedConnection conn, java.sql.ResultSet resultSet, EmbedStatement callStatement) {
        if (resultSet == null) {
            return null;
        }
        if (resultSet instanceof NonUpdatableRowsResultSet) {
            return resultSet;
        }
        if (!(resultSet instanceof EmbedResultSet)) {
            return null;
        }
        EmbedResultSet lrs = (EmbedResultSet)resultSet;
        if (lrs.getEmbedConnection().rootConnection != conn.rootConnection) {
            return null;
        }
        try {
            lrs.checkIfClosed("");
        }
        catch (SQLException ex) {
            return null;
        }
        lrs.setDynamicResultSet(callStatement);
        return lrs;
    }

    void resultSetClosing(EmbedResultSet closingLRS) throws SQLException {
        if (!this.getEmbedConnection().autoCommit) {
            return;
        }
        if (this.dynamicResults != null) {
            for (int i = 0; i < this.dynamicResults.length; ++i) {
                java.sql.ResultSet rs = this.dynamicResults[i];
                if (rs == null) continue;
                if (!(rs instanceof EmbedResultSet)) {
                    if (rs == null || rs.isClosed()) continue;
                    return;
                }
                EmbedResultSet lrs = (EmbedResultSet)rs;
                if (lrs.isClosed || lrs == closingLRS) continue;
                return;
            }
        }
        this.commitIfAutoCommit();
    }

    private boolean getExecuteHoldable() throws SQLException {
        if (this.resultSetHoldability == 2) {
            return false;
        }
        if (this.applicationStatement == this) {
            return true;
        }
        return this.applicationStatement.getResultSetHoldability() == 1;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkStatus();
        return this.isPoolable;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkStatus();
        this.isPoolable = poolable;
    }

    @Override
    public boolean isPrepared() {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.1");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.1");
    }

    public StatementStats getStatementStats() {
        return this.stats;
    }

    private void checkAttributes(int type, int concurrency, int holdability) throws SQLException {
        if (type == 1004 && concurrency == 1008) {
            throw this.newSQLException("0A000.S.22");
        }
    }

    public void reset(int newType, int newConcurrency, int newHoldability) throws SQLException {
        this.checkAttributes(newType, newConcurrency, newHoldability);
        this.resultSetType = newType;
        this.resultSetConcurrency = newConcurrency;
        this.resultSetHoldability = newHoldability;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this)) + ", " + this.SQLText;
    }

    public ResultSet getResultsToWrap() {
        return this.iapiResultSet;
    }

    public PreparedStatement getGPrepStmt() {
        return this.gps;
    }

    public static void persistOnHDFS(DDLConflatable ddl, LanguageConnectionContext lcc, ArrayList<HDFSStoreImpl> destinationhdfsStores) throws StandardException {
        ArrayList<String> storeNames = new ArrayList<String>();
        for (HDFSStoreImpl hdfsstore : destinationhdfsStores) {
            storeNames.add(hdfsstore.getName());
        }
        HashMap<String, ArrayList<DDLConflatable>> storeToDDLs = EmbedStatement.getListOfDDLsForHDFSStoreNames(storeNames, lcc);
        for (HDFSStoreImpl hdfsstore : destinationhdfsStores) {
            ArrayList<DDLConflatable> ddlListTobePersisted = storeToDDLs.get(hdfsstore.getName());
            ddlListTobePersisted.add(ddl);
            ArrayList<byte[]> keyList = new ArrayList<byte[]>();
            ArrayList<byte[]> valueList = new ArrayList<byte[]>();
            try {
                for (DDLConflatable ddlstmt : ddlListTobePersisted) {
                    SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("EmbedStatement: Persisting all statements on HDFS " + ddlstmt.getValueToConflate()));
                    byte[] valueBytes = BlobHelper.serializeToBlob((Object)ddlstmt);
                    byte[] keyBytes = BlobHelper.serializeToBlob((Object)ddlstmt.getId());
                    keyList.add(keyBytes);
                    valueList.add(valueBytes);
                }
            }
            catch (IOException e) {
                throw new InternalGemFireError("Could not serialize DDL statement", (Throwable)e);
            }
            try {
                hdfsstore.getDDLHoplogOrganizer().flush(keyList.iterator(), valueList.iterator());
            }
            catch (HDFSIOException e) {
                throw StandardException.newException("X0Z30.S", (Throwable)e, (Object)e.getMessage());
            }
        }
    }

    private static HashMap<String, ArrayList<DDLConflatable>> getListOfDDLsForHDFSStoreNames(ArrayList<String> listOfHDFSStores, LanguageConnectionContext lcc) throws StandardException {
        HashMap<String, ArrayList<DDLConflatable>> storeToDDLs = new HashMap<String, ArrayList<DDLConflatable>>();
        for (String storeName : listOfHDFSStores) {
            storeToDDLs.put(storeName, new ArrayList());
        }
        List<GfxdDDLQueueEntry> allDDLs = EmbedStatement.getAllDDLs();
        if (allDDLs == null) {
            return storeToDDLs;
        }
        for (GfxdDDLQueueEntry queueEntry : allDDLs) {
            ArrayList<HDFSStoreImpl> storesForDDL;
            Object qVal = queueEntry.getValue();
            if (!(qVal instanceof DDLConflatable) || (storesForDDL = EmbedStatement.getDestinationHDFSStoreForDDL((DDLConflatable)qVal, lcc)) == null) continue;
            for (HDFSStoreImpl store : storesForDDL) {
                if (!storeToDDLs.containsKey(store.getName())) continue;
                storeToDDLs.get(store.getName()).add((DDLConflatable)qVal);
            }
        }
        return storeToDDLs;
    }

    private static List<GfxdDDLQueueEntry> getAllDDLs() throws StandardException {
        List<GfxdDDLQueueEntry> ddlIter = null;
        GemFireStore memStore = Misc.getMemStore();
        GfxdDataDictionary dd = memStore.getDatabase().getDataDictionary();
        if (dd == null) {
            throw StandardException.newException("08006.D", "gemfirexd");
        }
        GfxdDDLRegionQueue ddlQ = new GfxdDDLRegionQueue(memStore.getDDLStmtQueue().getRegion());
        ddlQ.initializeQueue(dd, false);
        try {
            ddlIter = ddlQ.peekAndRemoveFromQueue(-1, -1);
        }
        catch (CacheException e) {
            throw Misc.processGemFireException((GemFireException)((Object)e), e, "reading of ddl queue", true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Misc.checkIfCacheClosing(e);
        }
        return ddlIter;
    }

    public static ArrayList<HDFSStoreImpl> getDestinationHDFSStoreForDDL(DDLConflatable ddl, LanguageConnectionContext lcc) {
        ArrayList<HDFSStoreImpl> hdfsStores = Misc.getGemFireCache().getAllHDFSStores();
        ArrayList<HDFSStoreImpl> destinationhdfsStores = null;
        if (hdfsStores.size() <= 0 || !ddl.isHDFSPersistent()) {
            return destinationhdfsStores;
        }
        if (ddl.getHDFSStoreName() != null) {
            HDFSStoreImpl hdfsStore = Misc.getGemFireCache().findHDFSStore(ddl.getHDFSStoreName());
            if (hdfsStore != null) {
                destinationhdfsStores = new ArrayList<HDFSStoreImpl>();
                destinationhdfsStores.add(hdfsStore);
            }
        } else if (ddl.isAlterTable() || ddl.isCreateTable()) {
            String regionPath = Misc.getRegionPath(ddl.getSchemaForTable(), ddl.getTableName(), lcc);
            destinationhdfsStores = EmbedStatement.getHDFSStore(regionPath);
        } else {
            destinationhdfsStores = hdfsStores;
        }
        return destinationhdfsStores;
    }

    private static ArrayList<HDFSStoreImpl> getHDFSStore(String regionPath) {
        ArrayList<HDFSStoreImpl> destinationhdfsStores = new ArrayList<HDFSStoreImpl>();
        LocalRegion region = Misc.getGemFireCache().getRegionByPath(regionPath, false);
        if (region == null) {
            return destinationhdfsStores;
        }
        if (region.getHDFSStoreName() == null) {
            return destinationhdfsStores;
        }
        HDFSStoreImpl hdfsStore = Misc.getGemFireCache().findHDFSStore(region.getHDFSStoreName());
        if (hdfsStore != null) {
            destinationhdfsStores.add(hdfsStore);
        }
        return destinationhdfsStores;
    }

    static {
        for (String s : ignoreStatesForClientDDLRetry) {
            ignoreStateSetForClientDDLRetry.add(s);
        }
    }

    protected static class FinalizeStatement
    extends FinalizeObject {
        private Activation singleUseActivation;
        private ArrayList<Activation> singleUseActivations;

        public FinalizeStatement(EmbedStatement stmt) {
            super((Object)stmt, true);
        }

        protected final FinalizeHolder getHolder() {
            return FinalizeStatement.getServerHolder();
        }

        protected void clearThis() {
            this.clearAllSingleUseActivations();
        }

        protected final void clearAllSingleUseActivations() {
            this.singleUseActivation = null;
            this.singleUseActivations = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addSingleUseActivation(Activation a) {
            Activation act = this.singleUseActivation;
            if (act == null) {
                this.singleUseActivation = a;
            } else if (act != a) {
                ArrayList<Activation> acts = this.singleUseActivations;
                if (acts == null) {
                    this.singleUseActivations = acts = new ArrayList(4);
                }
                ArrayList<Activation> arrayList = acts;
                synchronized (arrayList) {
                    acts.add(a);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clearSingleUseActivation(Activation a) {
            if (this.singleUseActivation == a) {
                this.singleUseActivation = null;
            } else {
                ArrayList<Activation> acts = this.singleUseActivations;
                if (acts != null) {
                    ArrayList<Activation> arrayList = acts;
                    synchronized (arrayList) {
                        if (acts.remove(a) && acts.size() == 0) {
                            this.singleUseActivations = null;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doFinalize() {
            ArrayList<Activation> acts;
            Activation act = this.singleUseActivation;
            if (act != null) {
                act.markUnused();
                this.singleUseActivation = null;
            }
            if ((acts = this.singleUseActivations) != null) {
                ArrayList<Activation> arrayList = acts;
                synchronized (arrayList) {
                    for (Activation a : acts) {
                        a.markUnused();
                    }
                    this.singleUseActivations = null;
                }
            }
            return true;
        }
    }
}

