/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineParameterMetaData;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeUtilities;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.sql.SQLException;

public class EmbedParameterSetMetaData
implements EngineParameterMetaData {
    private final ParameterValueSet pvs;
    private final DataTypeDescriptor[] types;
    private final int paramCount;

    protected EmbedParameterSetMetaData(ParameterValueSet pvs, DataTypeDescriptor[] types) {
        int paramCount = pvs.getParameterCount();
        this.pvs = pvs;
        this.paramCount = paramCount;
        this.types = types;
    }

    @Override
    public int getParameterCount() {
        return this.paramCount;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.checkPosition(param);
        if (this.types[param - 1].isNullable()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkPosition(param);
        return this.types[param - 1].getTypeId().isNumericTypeId();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkPosition(param);
        int outparamPrecision = -1;
        int precision = DataTypeUtilities.getPrecision(this.types[param - 1]);
        if (param == 1 && this.pvs.hasReturnOutputParameter()) {
            outparamPrecision = this.pvs.getPrecision(param);
        }
        return outparamPrecision == -1 ? precision : outparamPrecision;
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkPosition(param);
        if (param == 1 && this.pvs.hasReturnOutputParameter()) {
            return this.pvs.getScale(param);
        }
        return this.types[param - 1].getScale();
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkPosition(param);
        return this.types[param - 1].getTypeId().getJDBCTypeId();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkPosition(param);
        return this.types[param - 1].getTypeId().getSQLTypeName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkPosition(param);
        return this.types[param - 1].getTypeId().getResultSetMetaDataTypeName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.checkPosition(param);
        if (param == 1 && this.pvs.hasReturnOutputParameter()) {
            return 4;
        }
        return this.pvs.getParameterMode(param);
    }

    private void checkPosition(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw Util.generateCsSQLException("XCL13.S", (Object)new Integer(parameterIndex), new Integer(this.paramCount));
        }
    }

    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }
}

