/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.HarmonySerialClob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public abstract class EmbedCallableStatement
extends EmbedPreparedStatement
implements CallableStatement {
    private final boolean hasReturnOutputParameter;
    protected boolean wasNull;
    protected final boolean isNonCallableStatement;

    public EmbedCallableStatement(EmbedConnection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, long id, short execFlags) throws SQLException {
        super(conn, sql, false, resultSetType, resultSetConcurrency, resultSetHoldability, 2, null, null, id, execFlags, null, 0L, 0);
        ParameterValueSet pvs = this.getParms();
        this.hasReturnOutputParameter = pvs.hasReturnOutputParameter();
        this.isNonCallableStatement = !this.hasReturnOutputParameter && !this.preparedStatement.isCallableStatement();
    }

    @Override
    protected void checkRequiresCallableStatement(Activation activation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean executeStatement(Activation a, boolean executeQuery, boolean executeUpdate, boolean skipContextRestore) throws SQLException {
        if (this.isNonCallableStatement) {
            return super.executeStatement(a, executeQuery, executeUpdate, skipContextRestore);
        }
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.wasNull = false;
            try {
                this.getParms().validate();
            }
            catch (StandardException e) {
                throw EmbedResultSet.noStateChangeException(e, null);
            }
            boolean execResult = super.executeStatement(a, executeQuery, executeUpdate && !this.hasReturnOutputParameter, false);
            ParameterValueSet pvs = this.getParms();
            if (this.hasReturnOutputParameter) {
                SanityManager.ASSERT((this.results != null ? 1 : 0) != 0, (String)"null results even though we are supposed to have a return parameter");
                boolean gotRow = this.results.next();
                SanityManager.ASSERT((boolean)gotRow, (String)"the return resultSet didn't have any rows");
                try {
                    DataValueDescriptor returnValue = pvs.getReturnValueForSet();
                    returnValue.setValueFromResultSet(this.results, 1, true);
                }
                catch (StandardException e) {
                    throw EmbedResultSet.noStateChangeException(e, null);
                }
                finally {
                    this.results.close();
                    this.setResults(null);
                }
                execResult = false;
            }
            return execResult;
        }
    }

    @Override
    public final void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().registerOutParameter(parameterIndex - 1, sqlType, -1);
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public final void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.checkStatus();
        if (scale < 0) {
            throw this.newSQLException("XJ044.S", scale);
        }
        try {
            this.getParms().registerOutParameter(parameterIndex - 1, sqlType, scale);
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw Util.notImplemented("registerOutParameter");
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkStatus();
        return this.wasNull;
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            String v = this.getParms().getParameterForGet(parameterIndex - 1).getString();
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            boolean v = param.getBoolean();
            this.wasNull = !v && param.isNull();
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            byte b = param.getByte();
            this.wasNull = b == 0 && param.isNull();
            return b;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            short s = param.getShort();
            this.wasNull = s == 0 && param.isNull();
            return s;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            int v = param.getInt();
            this.wasNull = v == 0 && param.isNull();
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            long v = param.getLong();
            this.wasNull = v == 0L && param.isNull();
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            float v = param.getFloat();
            this.wasNull = (double)v == 0.0 && param.isNull();
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            double v = param.getDouble();
            this.wasNull = v == 0.0 && param.isNull();
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            byte[] v = this.getParms().getParameterForGet(parameterIndex - 1).getBytes();
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            Date v = this.getParms().getParameterForGet(parameterIndex - 1).getDate(this.getCal());
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            Time v = this.getParms().getParameterForGet(parameterIndex - 1).getTime(this.getCal());
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            Timestamp v = this.getParms().getParameterForGet(parameterIndex - 1).getTimestamp(this.getCal());
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.getDate(parameterIndex);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.getTime(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(parameterIndex);
    }

    @Override
    public final Object getObject(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            Object v = this.getParms().getParameterForGet(parameterIndex - 1).getObject();
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            Blob v = (Blob)param.getObject();
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            if (param instanceof SQLChar) {
                char[] chars = ((SQLChar)param).getCharArray(true);
                this.wasNull = chars == null;
                if (this.wasNull) {
                    return null;
                }
                return HarmonySerialClob.wrapChars(chars);
            }
            String str = param.getString();
            this.wasNull = str == null;
            if (this.wasNull) {
                return null;
            }
            return new HarmonySerialClob(str);
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkStatus();
        ParameterValueSet pvs = this.getParms();
        int numberOfParameters = pvs.getParameterCount();
        block4: for (int j = 1; j <= numberOfParameters; ++j) {
            switch (pvs.getParameterMode(j)) {
                case 0: 
                case 1: {
                    continue block4;
                }
                case 2: 
                case 4: {
                    throw this.newSQLException("XJ04C.S");
                }
            }
        }
        super.addBatch();
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public SQLXML getSQLXML(String parametername) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setNString(int index, String value) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setNCharacterStream(int index, Reader value, long length) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setNClob(int index, NClob value) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x, long length) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.1");
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.1");
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.1");
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.1");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.1");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.1");
    }
}

