/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.io;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.io.DirRandomAccessFile;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import com.pivotal.gemfirexd.internal.io.StorageRandomAccessFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class DirFile
extends File
implements StorageFile,
PrivilegedExceptionAction<Object> {
    private static final long serialVersionUID = -99617810905921770L;
    private long conglomId;
    private RandomAccessFile tmpFile;
    private FileChannel channel;
    private int capacity;
    private ByteBuffer reuseBuffer;
    private int readBytes;
    private long fileOffset;
    private static final int oneMB = 0x8FFFFFF;
    private int action;
    private static final int CREATE_FILE = 1;
    private static final int GET_FILE_CHANNEL = 2;
    private static final int GET_READ_BUFFER = 3;

    public DirFile(String path) {
        super(path);
    }

    public DirFile(String directoryName, String fileName) {
        super(directoryName, fileName);
    }

    DirFile(DirFile directoryName, String fileName) {
        super(directoryName, fileName);
    }

    @Override
    public StorageFile getParentDir() {
        String parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return new DirFile(parent);
    }

    static StorageFile getTempDir() throws IOException {
        File temp = File.createTempFile("derby", "tmp");
        DirFile parent = new DirFile(temp.getParent());
        temp.delete();
        return parent;
    }

    @Override
    public FileOutputStream getOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this);
    }

    @Override
    public OutputStream getOutputStream(boolean append) throws FileNotFoundException {
        return new FileOutputStream(this.getPath(), append);
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this);
    }

    @Override
    public synchronized int getExclusiveFileLock() {
        if (this.exists()) {
            this.delete();
        }
        try {
            RandomAccessFile lockFileOpen = new RandomAccessFile(this, "rw");
            lockFileOpen.getFD().sync();
            lockFileOpen.close();
        }
        catch (IOException ioe) {
            SanityManager.THROWASSERT((String)("Unable to create Exclusive Lock File " + this.getPath()), (Throwable)ioe);
        }
        return 0;
    }

    @Override
    public synchronized void releaseExclusiveFileLock() {
        if (this.exists()) {
            this.delete();
        }
    }

    @Override
    public StorageRandomAccessFile getRandomAccessFile(String mode) throws FileNotFoundException {
        if ("rws".equals(mode) || "rwd".equals(mode)) {
            mode = "rw";
        }
        return new DirRandomAccessFile(this, mode);
    }

    @Override
    public boolean renameTo(StorageFile newName) {
        return super.renameTo((File)((Object)newName));
    }

    @Override
    public boolean deleteAll() {
        if (!this.exists()) {
            return false;
        }
        if (this.isDirectory()) {
            String[] childList = super.list();
            String parentName = this.getPath();
            for (int i = 0; i < childList.length; ++i) {
                DirFile child;
                if (childList[i].equals(".") || childList[i].equals("..") || (child = new DirFile(parentName, childList[i])).deleteAll()) continue;
                return false;
            }
        }
        return this.delete();
    }

    @Override
    public URL getURL() throws MalformedURLException {
        return this.toURL();
    }

    public final DirFile createTemporaryFile(long conglomId) {
        this.conglomId = conglomId;
        this.action = 1;
        try {
            return (DirFile)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException e) {
            throw GemFireXDRuntimeException.newRuntimeException("PrivilegedActionException", e.getException());
        }
    }

    public final FileChannel getChannel() {
        this.action = 2;
        try {
            this.channel = (FileChannel)AccessController.doPrivileged(this);
            return this.channel;
        }
        catch (PrivilegedActionException e) {
            throw GemFireXDRuntimeException.newRuntimeException("PrivilegedActionException", e.getException());
        }
    }

    public final ByteBuffer getReadBuffer(int capacity, ByteBuffer reuseBuffer) {
        this.action = 3;
        this.capacity = capacity;
        this.reuseBuffer = reuseBuffer;
        try {
            return (ByteBuffer)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException e) {
            throw GemFireXDRuntimeException.newRuntimeException("PrivilegedActionException", e.getException());
        }
    }

    @Override
    public final Object run() throws StandardException {
        try {
            switch (this.action) {
                case 1: {
                    DirFile df = new DirFile(this, "T" + this.conglomId + ".tmp");
                    df.deleteOnExit();
                    if (!df.createNewFile()) {
                        throw StandardException.newException("XSDAJ.S");
                    }
                    return df;
                }
                case 2: {
                    this.tmpFile = new RandomAccessFile(this, "rw");
                    return this.tmpFile.getChannel();
                }
                case 3: {
                    if (this.capacity > 0x8FFFFFF) {
                        MappedByteBuffer b = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.capacity);
                        if (GemFireXDUtils.TraceTempFileIO) {
                            SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)("Mapped file=" + this + " bytes=" + b.limit()));
                        }
                        this.readBytes = b.limit();
                        return b;
                    }
                    this.reuseBuffer.clear();
                    this.readBytes = this.channel.read(this.reuseBuffer);
                    this.reuseBuffer.flip();
                    assert (this.reuseBuffer.limit() == this.readBytes) : "limit=" + this.reuseBuffer.limit() + " readBytes=" + this.readBytes;
                    return this.reuseBuffer;
                }
            }
            return null;
        }
        catch (FileNotFoundException fnf) {
            throw StandardException.newException("XSDA4.S", fnf);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDA4.S", ioe);
        }
    }

    public final int bytesRead() {
        return this.readBytes;
    }
}

