/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.drda;

import com.pivotal.gemfirexd.internal.impl.drda.CcsidManager;
import com.pivotal.gemfirexd.internal.impl.drda.CodePointNameTable;
import com.pivotal.gemfirexd.internal.impl.drda.DDMReader;
import com.pivotal.gemfirexd.internal.impl.drda.DDMWriter;
import com.pivotal.gemfirexd.internal.impl.drda.DRDAProtocolException;
import com.pivotal.gemfirexd.internal.impl.drda.EbcdicCcsidManager;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StreamTokenizer;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class TestProto {
    private static final CodePointNameTable codePointNameTable = new CodePointNameTable();
    private static final Hashtable codePointValueTable = new Hashtable();
    private static final Hashtable commandTable = new Hashtable();
    private static final CcsidManager ccsidManager = new EbcdicCcsidManager();
    private static final int CREATE_DSS_REQUEST = 1;
    private static final int CREATE_DSS_OBJECT = 2;
    private static final int END_DSS = 3;
    private static final int END_DDM_AND_DSS = 4;
    private static final int START_DDM = 5;
    private static final int END_DDM = 6;
    private static final int WRITE_BYTE = 7;
    private static final int WRITE_NETWORK_SHORT = 8;
    private static final int WRITE_NETWORK_INT = 9;
    private static final int WRITE_BYTES = 10;
    private static final int WRITE_CODEPOINT_4BYTES = 11;
    private static final int WRITE_SCALAR_1BYTE = 12;
    private static final int WRITE_SCALAR_2BYTES = 13;
    private static final int WRITE_SCALAR_BYTES = 14;
    private static final int WRITE_SCALAR_HEADER = 15;
    private static final int WRITE_SCALAR_STRING = 16;
    private static final int WRITE_SCALAR_PADDED_STRING = 17;
    private static final int WRITE_SCALAR_PADDED_BYTES = 18;
    private static final int WRITE_SHORT = 19;
    private static final int WRITE_INT = 20;
    private static final int WRITE_LONG = 21;
    private static final int WRITE_FLOAT = 22;
    private static final int WRITE_DOUBLE = 23;
    private static final int READ_REPLY_DSS = 24;
    private static final int READ_LENGTH_AND_CODEPOINT = 25;
    private static final int READ_CODEPOINT = 26;
    private static final int MARK_COLLECTION = 27;
    private static final int GET_CODEPOINT = 28;
    private static final int READ_BYTE = 29;
    private static final int READ_NETWORK_SHORT = 30;
    private static final int READ_SHORT = 31;
    private static final int READ_NETWORK_INT = 32;
    private static final int READ_INT = 33;
    private static final int READ_LONG = 34;
    private static final int READ_BOOLEAN = 35;
    private static final int READ_STRING = 36;
    private static final int READ_BYTES = 37;
    private static final int FLUSH = 38;
    private static final int DISPLAY = 39;
    private static final int CHECKERROR = 40;
    private static final int RESET = 41;
    private static final int CREATE_DSS_REPLY = 42;
    private static final int SKIP_DSS = 43;
    private static final int READ_SCALAR_2BYTES = 44;
    private static final int READ_SCALAR_1BYTE = 45;
    private static final int END_TEST = 46;
    private static final int SKIP_DDM = 47;
    private static final int INCLUDE = 48;
    private static final int SKIP_BYTES = 49;
    private static final int WRITE_PADDED_STRING = 50;
    private static final int WRITE_STRING = 51;
    private static final int WRITE_ENCODED_STRING = 52;
    private static final int WRITE_ENCODED_LDSTRING = 53;
    private static final int CHECK_SQLCARD = 54;
    private static final int MORE_DATA = 55;
    private static final int COMPLETE_TEST = 56;
    private static final int READ_SECMEC_SECCHKCD = 57;
    private static final String MULTIVAL_START = "MULTIVALSTART";
    private static final String MULTIVAL_SEP = "SEP";
    private static final String MULTIVAL_END = "MULTIVALEND";
    private Socket monitorSocket = null;
    private InputStream monitorIs = null;
    private OutputStream monitorOs = null;
    private DDMWriter writer = new DDMWriter(ccsidManager, null, null);
    private DDMReader reader;
    private boolean failed = false;
    private StreamTokenizer tkn;
    private String current_filename;
    private int port;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestProto(String filename, int port) {
        this.current_filename = filename;
        this.port = port;
        this.getConnection();
        try {
            this.reader = new DDMReader(ccsidManager, this.monitorIs);
            this.processFile(filename);
        }
        catch (Exception e) {
            int line = 0;
            if (this.tkn != null) {
                line = this.tkn.lineno();
            }
            System.err.println("Unexpected exception in line " + line + " file: " + this.current_filename);
            e.printStackTrace();
        }
        finally {
            this.closeConnection();
        }
    }

    private void processIncludeFile() throws IOException, DRDAProtocolException {
        String fileName = this.getString();
        StreamTokenizer saveTkn = this.tkn;
        this.processFile(fileName);
        this.tkn = saveTkn;
    }

    private void processFile(String filename) throws IOException, DRDAProtocolException {
        int val;
        BufferedReader fr;
        String prev_filename = this.current_filename;
        this.current_filename = filename;
        String hostName = TestProto.getHostName();
        try {
            fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
        }
        catch (FileNotFoundException fnfe) {
            String userdir = System.getProperty("user.dir");
            String sep = System.getProperty("file.separator");
            fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(userdir + sep + filename), "UTF-8"));
        }
        this.tkn = new StreamTokenizer(fr);
        while ((val = this.tkn.nextToken()) != -1) {
            switch (val) {
                case -2: {
                    break;
                }
                case -3: {
                    this.processCommand();
                    break;
                }
            }
        }
        this.current_filename = prev_filename;
    }

    private void getConnection() {
        String hostName = TestProto.getHostName();
        try {
            this.monitorSocket = new Socket(hostName, this.port);
        }
        catch (UnknownHostException e) {
            System.err.println("Don't know about host: " + hostName);
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: " + hostName);
            System.exit(1);
        }
        try {
            this.monitorIs = this.monitorSocket.getInputStream();
            this.monitorOs = this.monitorSocket.getOutputStream();
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: " + hostName);
            System.exit(1);
        }
    }

    private void closeConnection() {
        try {
            this.monitorIs.close();
            this.monitorOs.close();
            this.monitorSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void reset() {
        this.closeConnection();
        this.getConnection();
        this.reader.initialize(this.monitorIs);
        this.writer.reset(null);
    }

    private void completeTest() {
        this.closeConnection();
    }

    private static void init() {
        commandTable.put("createdssrequest", 1);
        commandTable.put("createdssobject", 2);
        commandTable.put("createdssreply", 42);
        commandTable.put("enddss", 3);
        commandTable.put("enddss", 3);
        commandTable.put("endddmanddss", 4);
        commandTable.put("startddm", 5);
        commandTable.put("endddm", 6);
        commandTable.put("writebyte", 7);
        commandTable.put("writenetworkshort", 8);
        commandTable.put("writenetworkint", 9);
        commandTable.put("writebytes", 10);
        commandTable.put("writecodepoint4bytes", 11);
        commandTable.put("writescalar1byte", 12);
        commandTable.put("writescalar2bytes", 13);
        commandTable.put("writescalarbytes", 14);
        commandTable.put("writescalarheader", 15);
        commandTable.put("writescalarstring", 16);
        commandTable.put("writescalarpaddedstring", 17);
        commandTable.put("writescalarpaddedbytes", 18);
        commandTable.put("writeshort", 19);
        commandTable.put("writeint", 20);
        commandTable.put("writelong", 21);
        commandTable.put("writefloat", 22);
        commandTable.put("writedouble", 23);
        commandTable.put("readreplydss", 24);
        commandTable.put("readlengthandcodepoint", 25);
        commandTable.put("readcodepoint", 26);
        commandTable.put("markcollection", 27);
        commandTable.put("getcodepoint", 28);
        commandTable.put("readbyte", 29);
        commandTable.put("readnetworkshort", 30);
        commandTable.put("readshort", 31);
        commandTable.put("readint", 33);
        commandTable.put("readlong", 34);
        commandTable.put("readboolean", 35);
        commandTable.put("readstring", 36);
        commandTable.put("readbytes", 37);
        commandTable.put("flush", 38);
        commandTable.put("display", 39);
        commandTable.put("checkerror", 40);
        commandTable.put("reset", 41);
        commandTable.put("skipdss", 43);
        commandTable.put("skipddm", 47);
        commandTable.put("readscalar2bytes", 44);
        commandTable.put("readscalar1byte", 45);
        commandTable.put("endtest", 46);
        commandTable.put("include", 48);
        commandTable.put("skipbytes", 49);
        commandTable.put("writepaddedstring", 50);
        commandTable.put("writestring", 51);
        commandTable.put("writeencodedstring", 52);
        commandTable.put("writeencodedldstring", 53);
        commandTable.put("checksqlcard", 54);
        commandTable.put("moredata", 55);
        commandTable.put("completetest", 56);
        commandTable.put("readsecmecandsecchkcd", 57);
        Enumeration e = codePointNameTable.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            codePointValueTable.put(codePointNameTable.get(key), key);
        }
    }

    private void processCommand() throws IOException, DRDAProtocolException {
        Integer icmd = (Integer)commandTable.get(this.tkn.sval.toLowerCase(Locale.ENGLISH));
        if (icmd == null) {
            System.err.println("Unknown command, " + this.tkn.sval + " in line " + this.tkn.lineno());
            System.exit(1);
        }
        int cmd = icmd;
        switch (cmd) {
            case 48: {
                this.processIncludeFile();
                break;
            }
            case 1: {
                this.writer.createDssRequest();
                break;
            }
            case 2: {
                this.writer.createDssObject();
                break;
            }
            case 42: {
                this.writer.createDssReply();
                break;
            }
            case 3: {
                this.tkn.nextToken();
                this.tkn.pushBack();
                if (this.tkn.sval != null && this.tkn.sval.startsWith("0x")) {
                    this.writer.endDss(this.getBytes()[0]);
                    break;
                }
                this.writer.endDss();
                break;
            }
            case 6: {
                this.writer.endDdm();
                break;
            }
            case 4: {
                this.writer.endDdmAndDss();
                break;
            }
            case 5: {
                this.writer.startDdm(this.getCP());
                break;
            }
            case 16: {
                this.writer.writeScalarString(this.getCP(), this.getString());
                break;
            }
            case 13: {
                this.writer.writeScalar2Bytes(this.getCP(), this.getIntOrCP());
                break;
            }
            case 12: {
                this.writer.writeScalar1Byte(this.getCP(), this.getInt());
                break;
            }
            case 14: {
                this.writer.writeScalarBytes(this.getCP(), this.getBytes());
                break;
            }
            case 18: {
                this.writer.writeScalarPaddedBytes(this.getCP(), this.getBytes(), this.getInt(), TestProto.ccsidManager.space);
                break;
            }
            case 7: {
                this.writer.writeByte(this.getInt());
                break;
            }
            case 10: {
                this.writer.writeBytes(this.getBytes());
                break;
            }
            case 19: {
                this.writer.writeShort(this.getInt());
                break;
            }
            case 20: {
                this.writer.writeInt(this.getInt());
                break;
            }
            case 11: {
                this.writer.writeCodePoint4Bytes(this.getCP(), this.getInt());
                break;
            }
            case 51: {
                String str = this.getString();
                this.writer.writeBytes(this.getEBCDIC(str));
                break;
            }
            case 52: {
                this.writeEncodedString(this.getString(), this.getString());
                break;
            }
            case 53: {
                this.writeEncodedLDString(this.getString(), this.getString(), this.getInt());
                break;
            }
            case 50: {
                String str = this.getString();
                this.writer.writeBytes(this.getEBCDIC(str));
                int reqLen = this.getInt();
                int strLen = str.length();
                if (strLen >= reqLen) break;
                this.writer.padBytes(TestProto.ccsidManager.space, reqLen - strLen);
                break;
            }
            case 24: {
                this.reader.readReplyDss();
                break;
            }
            case 43: {
                this.skipDss();
                break;
            }
            case 47: {
                this.skipDdm();
                break;
            }
            case 55: {
                String str = this.getString();
                boolean expbool = str.equalsIgnoreCase("true");
                if (this.reader.moreData() && !expbool) {
                    this.fail("Failed - more data left");
                }
                if (this.reader.moreData() || !expbool) break;
                this.fail("Failed - no data left");
                break;
            }
            case 25: {
                this.readLengthAndCodePoint();
                break;
            }
            case 44: {
                this.readLengthAndCodePoint();
                int val = this.reader.readNetworkShort();
                this.checkIntOrCP(val);
                break;
            }
            case 45: {
                this.readLengthAndCodePoint();
                byte val = this.reader.readByte();
                this.checkIntOrCP(val);
                break;
            }
            case 57: {
                this.readSecMecAndSECCHKCD();
                break;
            }
            case 37: {
                byte[] byteArray = this.reader.readBytes();
                byte[] reqArray = this.getBytes();
                if (byteArray.length != reqArray.length) {
                    this.fail("Failed - byte array didn't match");
                }
                for (int i = 0; i < byteArray.length; ++i) {
                    if (byteArray[i] == reqArray[i]) continue;
                    this.fail("Failed - byte array didn't match");
                }
                break;
            }
            case 30: {
                int val = this.reader.readNetworkShort();
                this.checkIntOrCP(val);
                break;
            }
            case 38: {
                this.writer.finalizeChain(this.reader.getCurrChainState(), this.monitorOs);
                this.writer.reset(null);
                break;
            }
            case 39: {
                System.out.println(this.getString());
                break;
            }
            case 40: {
                this.checkError();
                break;
            }
            case 54: {
                this.checkSQLCARD(this.getInt(), this.getString());
                break;
            }
            case 56: {
                this.completeTest();
                break;
            }
            case 46: {
                if (!this.failed) {
                    System.out.println("PASSED");
                }
                this.failed = false;
                this.reset();
                break;
            }
            case 41: {
                this.reset();
                break;
            }
            case 49: {
                this.reader.skipBytes();
                break;
            }
            default: {
                System.out.println("unknown command in line " + this.tkn.lineno());
                while (this.tkn.nextToken() != 10) {
                }
                break block0;
            }
        }
    }

    private void skipDss() throws DRDAProtocolException {
        this.reader.readReplyDss();
        this.reader.skipDss();
    }

    private void skipDdm() throws DRDAProtocolException {
        this.reader.readLengthAndCodePoint(false);
        this.reader.skipBytes();
    }

    private int getInt() throws IOException {
        int mult = 1;
        int val = this.tkn.nextToken();
        if (this.tkn.sval != null && this.tkn.sval.equals("-")) {
            mult = -1;
            val = this.tkn.nextToken();
        }
        if (val != -2) {
            String str;
            if (this.tkn.sval == null) {
                System.err.println("Invalid string on line " + this.tkn.lineno());
                System.exit(1);
            }
            if (!(str = this.tkn.sval.toLowerCase(Locale.ENGLISH)).startsWith("0x")) {
                System.err.println("Expecting number, got " + this.tkn.sval + " on line " + this.tkn.lineno());
                System.exit(1);
            } else {
                return this.convertHex(str);
            }
        }
        return new Double(this.tkn.nval).intValue() * mult;
    }

    private int convertHex(String str) throws IOException {
        int retval = 0;
        int len = str.length();
        if (len % 2 == 1 || len > 10) {
            System.err.println("Invalid length for byte string, " + len + " on line " + this.tkn.lineno());
            System.exit(1);
        }
        for (int i = 2; i < len; ++i) {
            retval <<= 4;
            retval += Byte.valueOf(str.substring(i, i + 1), 16).byteValue();
        }
        return retval;
    }

    private boolean checkIntOrCP(int val) throws IOException {
        boolean rval = false;
        int tknType = this.tkn.nextToken();
        String reqVal = " ";
        if (tknType == -3 && this.tkn.sval.trim().equals(MULTIVAL_START)) {
            do {
                int nextVal = this.getIntOrCP();
                reqVal = reqVal + nextVal + " ";
                rval = rval || val == nextVal;
                this.tkn.nextToken();
            } while (this.tkn.sval.trim().equals(MULTIVAL_SEP));
            if (!this.tkn.sval.trim().equals(MULTIVAL_END)) {
                this.fail("Invalid test file format requires MULTIVALEND got: " + this.tkn.sval);
            }
        } else {
            this.tkn.pushBack();
            int nextVal = this.getIntOrCP();
            reqVal = " " + nextVal;
            boolean bl = rval = val == nextVal;
        }
        if (!rval) {
            this.fail("Failed - wrong val = " + val + " Required Value: " + reqVal);
        }
        return rval;
    }

    private int getIntOrCP() throws IOException {
        int val = this.tkn.nextToken();
        if (val == -2) {
            return new Double(this.tkn.nval).intValue();
        }
        if (val == -3) {
            return this.decodeCP(this.tkn.sval);
        }
        this.fail("Expecting number, got " + this.tkn.sval + " on line " + this.tkn.lineno());
        System.exit(1);
        return 0;
    }

    private byte[] getBytes() throws IOException {
        String str;
        byte[] retval = null;
        int val = this.tkn.nextToken();
        if (this.tkn.sval == null) {
            System.err.println("Invalid string on line " + this.tkn.lineno());
            System.exit(1);
        }
        if (!(str = this.tkn.sval.toLowerCase(Locale.ENGLISH)).startsWith("0x")) {
            return ccsidManager.convertFromUCS2(str);
        }
        int len = str.length();
        if (len % 2 == 1) {
            System.err.println("Invalid length for byte string, " + len + " on line " + this.tkn.lineno());
            System.exit(1);
        }
        retval = new byte[(len - 2) / 2];
        int j = 0;
        for (int i = 2; i < len; i += 2) {
            retval[j] = (byte)(Byte.valueOf(str.substring(i, i + 1), 16) << 4);
            int n = j++;
            retval[n] = (byte)(retval[n] + Byte.valueOf(str.substring(i + 1, i + 2), 16));
        }
        return retval;
    }

    private String getString() throws IOException {
        int val = this.tkn.nextToken();
        if (val == -2) {
            System.err.println("Expecting word, got " + this.tkn.nval + " on line " + this.tkn.lineno());
            System.exit(1);
        }
        return this.tkn.sval;
    }

    private int getCP() throws IOException {
        String strval = this.getString();
        return this.decodeCP(strval);
    }

    private int decodeCP(String strval) {
        Integer cp = (Integer)codePointValueTable.get(strval);
        if (cp == null) {
            System.err.println("Unknown codepoint, " + strval + " in line " + this.tkn.lineno());
            Exception e = new Exception();
            e.printStackTrace();
            System.exit(1);
        }
        return cp;
    }

    private void fail(String msg) throws IOException {
        System.out.println("FAILED - " + msg + " in line " + this.tkn.lineno());
        int val = this.tkn.nextToken();
        while (!(val == -1 || val == -3 && this.tkn.sval.toLowerCase(Locale.ENGLISH).equals("endtest"))) {
            val = this.tkn.nextToken();
        }
        this.failed = true;
        this.reset();
        Exception e = new Exception();
        e.printStackTrace();
    }

    private void checkError() throws IOException, DRDAProtocolException {
        int svrcod = 0;
        int invalidCodePoint = 0;
        byte prccnvcd = 0;
        byte synerrcd = 0;
        Vector<Integer> manager = new Vector<Integer>();
        Vector<Integer> managerLevel = new Vector<Integer>();
        this.reader.readReplyDss();
        int error = this.reader.readLengthAndCodePoint(false);
        int reqCP = this.getCP();
        if (error != reqCP) {
            this.cpError(error, reqCP);
            return;
        }
        block7: while (this.reader.moreDssData()) {
            int codepoint = this.reader.readLengthAndCodePoint(false);
            switch (codepoint) {
                case 4425: {
                    svrcod = this.reader.readNetworkShort();
                    continue block7;
                }
                case 12: {
                    invalidCodePoint = this.reader.readNetworkShort();
                    continue block7;
                }
                case 4415: {
                    prccnvcd = this.reader.readByte();
                    continue block7;
                }
                case 4426: {
                    synerrcd = this.reader.readByte();
                    continue block7;
                }
                case 5124: {
                    while (this.reader.moreDdmData()) {
                        manager.addElement(this.reader.readNetworkShort());
                        managerLevel.addElement(this.reader.readNetworkShort());
                    }
                    continue block7;
                }
            }
            this.reader.skipBytes();
        }
        int reqVal = this.getInt();
        if (svrcod != reqVal) {
            this.fail("wrong svrcod val = " + Integer.toHexString(svrcod) + ", required val = " + Integer.toHexString(reqVal));
            return;
        }
        if (error == 4677 && prccnvcd != (reqVal = this.getInt())) {
            this.fail("wrong prccnvd, val = " + Integer.toHexString(prccnvcd) + ", required val = " + Integer.toHexString(reqVal));
            return;
        }
        if (error == 4684) {
            reqVal = this.getInt();
            if (synerrcd != reqVal) {
                this.fail("wrong synerrcd, val = " + Integer.toHexString(synerrcd) + ", required val = " + Integer.toHexString(reqVal));
                return;
            }
            reqVal = this.getIntOrCP();
            if (invalidCodePoint != reqVal) {
                this.cpError(invalidCodePoint, reqVal);
                return;
            }
        }
        if (error == 4624) {
            for (int i = 0; i < manager.size(); ++i) {
                reqVal = this.getCP();
                int mgr = (Integer)manager.elementAt(i);
                if (mgr != reqVal) {
                    this.cpError(mgr, reqVal);
                    return;
                }
                int mgrLevel = (Integer)managerLevel.elementAt(i);
                if (mgrLevel == (reqVal = this.getInt())) continue;
                this.fail("wrong manager level, level = " + Integer.toHexString(mgrLevel) + ", required val = " + Integer.toHexString(reqVal));
                return;
            }
        }
    }

    private void readLengthAndCodePoint() throws IOException, DRDAProtocolException {
        int reqCP;
        int codepoint = this.reader.readLengthAndCodePoint(false);
        if (codepoint != (reqCP = this.getCP())) {
            this.cpError(codepoint, reqCP);
        }
    }

    private void readSecMecAndSECCHKCD() throws IOException, DRDAProtocolException {
        boolean notDone = true;
        int val = -1;
        do {
            int codepoint = this.reader.readLengthAndCodePoint(false);
            switch (codepoint) {
                case 4514: {
                    System.out.print("SECMEC=");
                    val = this.reader.readNetworkShort();
                    System.out.print(val + " ");
                    break;
                }
                case 4516: {
                    System.out.print("SECCHKCD=");
                    val = this.reader.readByte();
                    System.out.println(val);
                    notDone = false;
                    break;
                }
                default: {
                    notDone = false;
                }
            }
        } while (notDone);
    }

    private void cpError(int cp, int reqCP) throws IOException {
        String cpName = codePointNameTable.lookup(cp);
        String reqCPName = codePointNameTable.lookup(reqCP);
        this.fail("wrong codepoint val = " + Integer.toHexString(cp) + "(" + cpName + ")" + ", required codepoint = " + Integer.toHexString(reqCP) + "(" + reqCPName + ")");
    }

    private byte[] getEBCDIC(String str) {
        return ccsidManager.convertFromUCS2(str);
    }

    private void writeEncodedString(String str, String encoding) throws IOException {
        try {
            byte[] buf = str.getBytes(encoding);
            this.writer.writeBytes(buf);
        }
        catch (UnsupportedEncodingException e) {
            this.fail("Unsupported encoding " + encoding);
        }
    }

    private void writeEncodedLDString(String str, String encoding, int len) throws IOException {
        try {
            byte[] buf = str.getBytes(encoding);
            if (len == 2) {
                this.writer.writeShort(buf.length);
            } else {
                this.writer.writeInt(buf.length);
            }
            this.writer.writeBytes(buf);
        }
        catch (UnsupportedEncodingException e) {
            this.fail("Unsupported encoding " + encoding);
        }
    }

    private void checkSQLCARD(int sqlCode, String sqlState) throws IOException, DRDAProtocolException {
        this.reader.readReplyDss();
        int codepoint = this.reader.readLengthAndCodePoint(false);
        if (codepoint != 9224) {
            this.fail("Expecting SQLCARD got " + Integer.toHexString(codepoint));
            return;
        }
        byte nullind = this.reader.readByte();
        int code = this.reader.readNetworkInt();
        if (code != sqlCode) {
            this.fail("Expecting sqlCode " + sqlCode + " got " + Integer.toHexString(code));
            return;
        }
        String state = this.reader.readString(5, "UTF-8");
        if (!state.equals(sqlState)) {
            this.fail("Expecting sqlState " + sqlState + " got " + state);
            return;
        }
        this.reader.skipBytes();
    }

    private static String getHostName() {
        String hostName = System.getProperty("hostName");
        if (hostName == null) {
            hostName = "localhost";
        }
        return hostName;
    }

    static {
        TestProto.init();
    }
}

