/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.PermissionsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementPermission;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;

public class StatementRolePermission
extends StatementPermission {
    private String roleName;
    private int privType;

    public StatementRolePermission(String roleName, int privType) {
        this.roleName = roleName;
        this.privType = privType;
    }

    @Override
    public void check(LanguageConnectionContext lcc, String authid, boolean forGrant) throws StandardException {
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        switch (this.privType) {
            case 19: {
                throw StandardException.newException("4251A", "CREATE ROLE");
            }
            case 20: {
                throw StandardException.newException("4251A", "DROP ROLE");
            }
        }
        SanityManager.THROWASSERT((String)("Unexpected value (" + this.privType + ") for privType"));
    }

    @Override
    public PermissionsDescriptor getPermissionDescriptor(String authid, DataDictionary dd) throws StandardException {
        return null;
    }
}

