/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.context;

import com.gemstone.gemfire.internal.LogWriterImpl;
import com.gemstone.gemfire.internal.concurrent.ConcurrentHashSet;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.ShutdownException;
import com.pivotal.gemfirexd.internal.iapi.services.context.Context;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.SystemContext;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnectionContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayDeque;

public final class ContextService {
    private static ContextService factory;
    private HeaderPrintWriter errorStream;
    private ThreadLocal threadContextList = new ThreadLocal();
    private ConcurrentHashSet<ContextManager> allContexts;
    private static final int ALREADY_CURRENT = 1;
    private static final int CURRENT_NULL = 2;
    private static final int OLD_INACTIVE_CM_OVERWRITTEN = 4;
    private static final int IS_ADDED = 8;
    private static final int SERVICE_STOPPED = 16;
    private static final int ALREADY_CURRENT_IS_ADDED = 17;

    public ContextService() {
        this.errorStream = Monitor.getStream();
        factory = this;
        this.allContexts = new ConcurrentHashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        ContextService fact = factory;
        if (fact != null) {
            ContextService contextService = fact;
            synchronized (contextService) {
                fact.allContexts = null;
                fact.threadContextList = null;
                factory = null;
            }
        }
    }

    public static ContextService getFactory() {
        ContextService csf = factory;
        if (csf == null) {
            throw new ShutdownException();
        }
        return csf;
    }

    public static Context getContext(String contextId) {
        ContextManager cm = ContextService.getFactory().getCurrentContextManager();
        if (cm == null) {
            return null;
        }
        return cm.getContext(contextId);
    }

    public static Context getContextOrNull(String contextId) {
        ContextService csf = factory;
        if (csf == null) {
            return null;
        }
        ContextManager cm = csf.getCurrentContextManager();
        if (cm == null) {
            return null;
        }
        return cm.getContext(contextId);
    }

    public ContextManager getCurrentContextManager() {
        ThreadLocal tcl = this.threadContextList;
        if (tcl == null) {
            return null;
        }
        Object list = tcl.get();
        if (list instanceof ContextManager) {
            Thread me = Thread.currentThread();
            ContextManager cm = (ContextManager)list;
            if (cm.activeThread == me) {
                return cm;
            }
            return null;
        }
        if (list == null) {
            return null;
        }
        ArrayDeque stack = (ArrayDeque)list;
        return (ContextManager)stack.peek();
    }

    public void resetCurrentContextManager(ContextManager cm) {
        ThreadLocal tcl = this.threadContextList;
        if (tcl == null) {
            return;
        }
        if (Thread.currentThread() != cm.activeThread) {
            SanityManager.THROWASSERT((String)("resetCurrentContextManager - mismatch threads - current" + Thread.currentThread() + " - cm's " + cm.activeThread));
        }
        if (this.getCurrentContextManager() != cm) {
            SanityManager.THROWASSERT((String)("resetCurrentContextManager - mismatch contexts - " + Thread.currentThread()));
        }
        if (cm.activeCount < -1) {
            SanityManager.THROWASSERT((String)("resetCurrentContextManager - invalid count - current" + Thread.currentThread() + " - count " + cm.activeCount));
        }
        if (cm.activeCount == 0) {
            SanityManager.THROWASSERT((String)("resetCurrentContextManager - invalid count - current" + Thread.currentThread() + " - count " + cm.activeCount));
        }
        if (cm.activeCount > 0 && tcl.get() != cm) {
            SanityManager.THROWASSERT((String)("resetCurrentContextManager - invalid thread local " + Thread.currentThread() + " - object " + tcl.get()));
        }
        if (cm.activeCount != -1) {
            if (--cm.activeCount == 0) {
                cm.activeThread = null;
                if (cm.isEmpty()) {
                    tcl.set(null);
                }
            }
            return;
        }
        ArrayDeque stack = (ArrayDeque)tcl.get();
        Object oldCM = stack.pop();
        ContextManager nextCM = (ContextManager)stack.peek();
        boolean seenMultipleCM = false;
        boolean seenCM = false;
        for (Object stackCM : stack) {
            if (stackCM != nextCM) {
                seenMultipleCM = true;
            }
            if (stackCM != cm) continue;
            seenCM = true;
        }
        if (!seenCM) {
            cm.activeThread = null;
            cm.activeCount = 0;
        }
        if (GemFireXDUtils.TraceCM) {
            SanityManager.DEBUG_PRINT((String)"TraceCM", (String)("Reset active thread to " + cm.activeThread + " activeCount=" + cm.activeCount + " for cm " + ArrayUtils.objectRefString((Object)cm) + " with conn " + EmbedConnectionContext.getEmbedConnection(cm)));
        }
        if (nextCM != cm) {
            GemFireTransaction.switchContextManager(nextCM);
        }
        if (!seenMultipleCM) {
            nextCM.activeCount = stack.size();
            tcl.set(nextCM);
        }
    }

    private int addToThreadList(Thread me, ContextManager associateCM) {
        ArrayDeque<ContextManager> stack;
        ThreadLocal tcl = this.threadContextList;
        if (tcl == null) {
            return 16;
        }
        Object list = tcl.get();
        if (associateCM == list) {
            return 1;
        }
        if (list == null) {
            tcl.set(associateCM);
            return 2;
        }
        int res = 8;
        if (list instanceof ContextManager) {
            ContextManager threadsCM = (ContextManager)list;
            if (me == null) {
                me = Thread.currentThread();
            }
            if (threadsCM.activeThread != me) {
                tcl.set(associateCM);
                return 4;
            }
            stack = new ArrayDeque<ContextManager>(8);
            tcl.set(stack);
            for (int i = 0; i < threadsCM.activeCount; ++i) {
                stack.push(threadsCM);
            }
            threadsCM.activeCount = -1;
        } else {
            stack = (ArrayDeque<ContextManager>)list;
            if (stack.peekFirst() == associateCM) {
                res = 17;
            }
        }
        stack.push(associateCM);
        associateCM.activeCount = -1;
        if (SanityManager.TraceMemoryLeak && stack.size() > 10) {
            System.out.println("TraceMemoryLeak:ContextService:threadLocal " + stack.size());
        }
        return res;
    }

    public boolean setCurrentContextManager(ContextManager cm) {
        int result;
        Thread me = Thread.currentThread();
        if (cm.activeThread != null && me != cm.activeThread) {
            SanityManager.THROWASSERT((String)("setCurrentContextManager - mismatch threads - current " + me + " - cm's " + cm.activeThread + " for " + cm + " with conn " + EmbedConnectionContext.getEmbedConnection(cm)));
        }
        me = null;
        if (cm.activeThread == null) {
            cm.activeThread = me = Thread.currentThread();
        }
        if ((result = this.addToThreadList(me, cm)) < 8) {
            ++cm.activeCount;
        }
        if (GemFireXDUtils.TraceCM) {
            SanityManager.DEBUG_PRINT((String)"TraceCM", (String)("Set active thread to me " + cm.activeThread + " activeCount=" + cm.activeCount + " result=0x" + Integer.toHexString(result) + " for cm " + ArrayUtils.objectRefString((Object)cm) + " with conn " + EmbedConnectionContext.getEmbedConnection(cm)), (Throwable)new Throwable());
        }
        return (result & 1) != 1;
    }

    public ContextManager newContextManager() {
        ContextManager cm = new ContextManager(this, this.errorStream);
        new SystemContext(cm);
        this.allContexts.add((Object)cm);
        if (SanityManager.TraceMemoryLeak && this.allContexts.size() > 50) {
            System.out.println("TraceMemoryLeak:ContextService:allContexts " + this.allContexts.size());
        }
        return cm;
    }

    public void notifyAllActiveThreads(Context c) {
        Thread me = Thread.currentThread();
        for (ContextManager cm : this.allContexts) {
            Thread active = cm.activeThread;
            if (active == me || active == null || active.getThreadGroup() instanceof LogWriterImpl.GemFireThreadGroup && !((LogWriterImpl.GemFireThreadGroup)active.getThreadGroup()).isInterruptible()) continue;
            final Thread fActive = active;
            if (!cm.setInterrupted(c)) continue;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    fActive.interrupt();
                    return null;
                }
            });
        }
    }

    public static void removeContextManager(ContextManager cm) {
        ContextService fact = factory;
        if (fact != null) {
            fact.removeContext(cm);
        }
    }

    public final void removeContext(ContextManager cm) {
        ConcurrentHashSet<ContextManager> contexts = this.allContexts;
        if (contexts != null) {
            contexts.remove((Object)cm);
        }
    }

    public final ConcurrentHashSet<ContextManager> getAllContexts() {
        return this.allContexts;
    }
}

