/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.jdbc;

import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredStatement;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredStatementControl;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EnginePreparedStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class BrokeredPreparedStatement
extends BrokeredStatement
implements EnginePreparedStatement {
    final String sql;

    public BrokeredPreparedStatement(BrokeredStatementControl control, String sql) throws SQLException {
        super(control);
        this.sql = sql;
    }

    @Override
    public final ResultSet executeQuery() throws SQLException {
        return this.wrapResultSet(this.getPreparedStatement().executeQuery());
    }

    @Override
    public final int executeUpdate() throws SQLException {
        return this.getPreparedStatement().executeUpdate();
    }

    @Override
    public final void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getPreparedStatement().setNull(parameterIndex, sqlType);
    }

    @Override
    public final void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.getPreparedStatement().setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public final void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getPreparedStatement().setBoolean(parameterIndex, x);
    }

    @Override
    public final void setByte(int parameterIndex, byte x) throws SQLException {
        this.getPreparedStatement().setByte(parameterIndex, x);
    }

    @Override
    public final void setShort(int parameterIndex, short x) throws SQLException {
        this.getPreparedStatement().setShort(parameterIndex, x);
    }

    @Override
    public final void setInt(int parameterIndex, int x) throws SQLException {
        this.getPreparedStatement().setInt(parameterIndex, x);
    }

    @Override
    public final void setLong(int parameterIndex, long x) throws SQLException {
        this.getPreparedStatement().setLong(parameterIndex, x);
    }

    @Override
    public final void setFloat(int parameterIndex, float x) throws SQLException {
        this.getPreparedStatement().setFloat(parameterIndex, x);
    }

    @Override
    public final void setDouble(int parameterIndex, double x) throws SQLException {
        this.getPreparedStatement().setDouble(parameterIndex, x);
    }

    @Override
    public final void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getPreparedStatement().setBigDecimal(parameterIndex, x);
    }

    @Override
    public final void setString(int parameterIndex, String x) throws SQLException {
        this.getPreparedStatement().setString(parameterIndex, x);
    }

    @Override
    public final void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.getPreparedStatement().setBytes(parameterIndex, x);
    }

    @Override
    public final void setDate(int parameterIndex, Date x) throws SQLException {
        this.getPreparedStatement().setDate(parameterIndex, x);
    }

    @Override
    public final void setTime(int parameterIndex, Time x) throws SQLException {
        this.getPreparedStatement().setTime(parameterIndex, x);
    }

    @Override
    public final void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.getPreparedStatement().setTimestamp(parameterIndex, x);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getPreparedStatement().setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public final void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getPreparedStatement().setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public final void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getPreparedStatement().setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public final void addBatch() throws SQLException {
        this.getPreparedStatement().addBatch();
    }

    @Override
    public final void clearParameters() throws SQLException {
        this.getPreparedStatement().clearParameters();
    }

    @Override
    public final ResultSetMetaData getMetaData() throws SQLException {
        return this.getPreparedStatement().getMetaData();
    }

    @Override
    public final void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.getPreparedStatement().setObject(parameterIndex, x, targetSqlType, scale);
    }

    @Override
    public final void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.getPreparedStatement().setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public final void setObject(int parameterIndex, Object x) throws SQLException {
        this.getPreparedStatement().setObject(parameterIndex, x);
    }

    @Override
    public final boolean execute() throws SQLException {
        return this.getPreparedStatement().execute();
    }

    @Override
    public final void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.getPreparedStatement().setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public final void setRef(int i, Ref x) throws SQLException {
        this.getPreparedStatement().setRef(i, x);
    }

    @Override
    public final void setBlob(int i, Blob x) throws SQLException {
        this.getPreparedStatement().setBlob(i, x);
    }

    @Override
    public final void setClob(int i, Clob x) throws SQLException {
        this.getPreparedStatement().setClob(i, x);
    }

    @Override
    public final void setArray(int i, Array x) throws SQLException {
        this.getPreparedStatement().setArray(i, x);
    }

    @Override
    public final void setDate(int i, Date x, Calendar cal) throws SQLException {
        this.getPreparedStatement().setDate(i, x, cal);
    }

    @Override
    public final void setTime(int i, Time x, Calendar cal) throws SQLException {
        this.getPreparedStatement().setTime(i, x, cal);
    }

    @Override
    public final void setTimestamp(int i, Timestamp x, Calendar cal) throws SQLException {
        this.getPreparedStatement().setTimestamp(i, x, cal);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.getPreparedStatement().setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.getPreparedStatement().setCharacterStream(parameterIndex, reader);
    }

    PreparedStatement getPreparedStatement() throws SQLException {
        return this.control.getRealPreparedStatement();
    }

    @Override
    public final Statement getStatement() throws SQLException {
        return this.getPreparedStatement();
    }

    public PreparedStatement createDuplicateStatement(Connection conn, PreparedStatement oldStatement) throws SQLException {
        PreparedStatement newStatement = conn.prepareStatement(this.sql, this.resultSetType, this.resultSetConcurrency);
        this.setStatementState(oldStatement, newStatement);
        return newStatement;
    }

    @Override
    public final long getVersionCounter() throws SQLException {
        return ((EnginePreparedStatement)this.getPreparedStatement()).getVersionCounter();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setNString(int index, String value) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setNCharacterStream(int index, Reader value, long length) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setNClob(int index, NClob value) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.1");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.1");
    }
}

