/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.db;

import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.Authorizer;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.ConnectionUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Properties;

public final class PropertyInfo {
    public static Properties getTableProperties(String schemaName, String tableName) throws SQLException {
        return PropertyInfo.getConglomerateProperties(schemaName, tableName, false);
    }

    public static Properties getIndexProperties(String schemaName, String indexName) throws SQLException {
        return PropertyInfo.getConglomerateProperties(schemaName, indexName, true);
    }

    public static void setDatabaseProperty(String key, String value, boolean checkAuth) throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        try {
            if (checkAuth) {
                Authorizer a = lcc.getAuthorizer();
                a.authorize(null, 5);
            }
            TransactionController tc = lcc.getTransactionExecute();
            tc.setProperty(key, (Serializable)((Object)value), false);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    private PropertyInfo() {
    }

    private static Properties getConglomerateProperties(String schemaName, String conglomerateName, boolean isIndex) throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        TransactionController tc = lcc.getTransactionExecute();
        try {
            long conglomerateNumber;
            DataDictionary dd = lcc.getDataDictionary();
            SchemaDescriptor sd = dd.getSchemaDescriptor(schemaName, tc, true);
            if (!isIndex) {
                TableDescriptor td = dd.getTableDescriptor(conglomerateName, sd, tc);
                if (td == null || td.getTableType() == 2) {
                    return new Properties();
                }
                conglomerateNumber = td.getHeapConglomerateId();
            } else {
                ConglomerateDescriptor cd = dd.getConglomerateDescriptor(conglomerateName, sd, false);
                if (cd == null) {
                    return new Properties();
                }
                conglomerateNumber = cd.getConglomerateNumber();
            }
            ConglomerateController cc = tc.openConglomerate(conglomerateNumber, false, 0, 6, 5);
            Properties properties = tc.getUserCreateConglomPropList();
            cc.getTableProperties(properties);
            cc.close();
            return properties;
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }
}

