/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.types;

import com.pivotal.gemfirexd.internal.engine.types.SqlXmlHelper;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.XMLDataValue;
import com.sun.org.apache.xml.internal.serializer.DOMSerializer;
import com.sun.org.apache.xml.internal.serializer.OutputPropertiesFactory;
import com.sun.org.apache.xml.internal.serializer.Serializer;
import com.sun.org.apache.xml.internal.serializer.SerializerFactory;
import com.sun.org.apache.xml.internal.utils.PrefixResolverDefault;
import com.sun.org.apache.xpath.internal.XPath;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.objects.XNodeSet;
import com.sun.org.apache.xpath.internal.objects.XObject;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public final class SqlXmlHelperSun5
implements SqlXmlHelper {
    private Serializer serializer;
    private XPath query;
    private XPathContext xpContext;

    public SqlXmlHelperSun5() throws StandardException {
        try {
            this.loadSerializer();
        }
        catch (Throwable t) {
            throw StandardException.newException("XML01", t, (Object)t.getMessage());
        }
        this.query = null;
    }

    @Override
    public void compileXQExpr(String queryExpr, String opName, DocumentBuilder dBuilder) throws StandardException {
        try {
            this.query = new XPath(queryExpr, null, new PrefixResolverDefault(dBuilder.newDocument()), 0);
        }
        catch (Throwable te) {
            throw StandardException.newException("10000", te, (Object)opName, (Object)te.getMessage());
        }
    }

    @Override
    public String serializeToString(List<?> items, XMLDataValue xmlVal) throws IOException {
        if (items == null || items.size() == 0) {
            return "";
        }
        StringWriter sWriter = new StringWriter();
        SanityManager.ASSERT((this.serializer != null ? 1 : 0) != 0, (String)"Tried to serialize with uninitialized XML serializer.");
        this.serializer.setWriter(sWriter);
        DOMSerializer dSer = this.serializer.asDOMSerializer();
        int sz = items.size();
        Object obj = null;
        boolean lastItemWasString = false;
        for (int i = 0; i < sz; ++i) {
            obj = items.get(i);
            if (obj instanceof String) {
                if (lastItemWasString) {
                    sWriter.write(" ");
                }
                sWriter.write((String)obj);
                lastItemWasString = true;
                continue;
            }
            if (obj instanceof Attr) {
                if (xmlVal != null) {
                    xmlVal.markAsHavingTopLevelAttr();
                }
                dSer.serialize(obj);
                lastItemWasString = false;
                continue;
            }
            Node n = obj;
            if (n instanceof Text) {
                sWriter.write(n.getNodeValue());
            } else {
                dSer.serialize(n);
            }
            lastItemWasString = false;
        }
        sWriter.flush();
        return sWriter.toString();
    }

    public List<Object> evalXQExpression(XMLDataValue xmlContext, boolean returnResults, int[] resultXType, DocumentBuilder dBuilder, boolean recompileQuery, String queryExpr, String opName) throws Exception {
        if (recompileQuery) {
            this.compileXQExpr(queryExpr, opName, dBuilder);
        }
        SanityManager.ASSERT((this.query != null && this.query.getExpression() != null ? 1 : 0) != 0, (String)"Failed to locate compiled XML query expression.");
        if (xmlContext.getXType() != 0) {
            throw StandardException.newException("2200V", returnResults ? "XMLQUERY" : "XMLEXISTS");
        }
        Document docNode = null;
        docNode = dBuilder.parse(new InputSource(new StringReader(xmlContext.getString())));
        XPathContext xpContext = this.getXPathContext();
        xpContext.reset();
        XObject xOb = this.query.execute(xpContext, docNode, null);
        if (!returnResults) {
            if (xOb instanceof XNodeSet && ((XNodeSet)xOb).nodelist().getLength() > 0) {
                return Collections.emptyList();
            }
            if (!(xOb instanceof XNodeSet)) {
                return Collections.emptyList();
            }
            return null;
        }
        NodeList nodeList = null;
        int numItems = 0;
        if (!(xOb instanceof XNodeSet)) {
            numItems = 1;
        } else {
            nodeList = xOb.nodelist();
            numItems = nodeList.getLength();
        }
        ArrayList<Object> itemRefs = new ArrayList<Object>();
        if (nodeList == null) {
            itemRefs.add(xOb.str());
        } else {
            for (int i = 0; i < numItems; ++i) {
                itemRefs.add(nodeList.item(i));
            }
        }
        nodeList = null;
        resultXType[0] = numItems == 1 && itemRefs.get(0) instanceof Document ? 0 : 1;
        return itemRefs;
    }

    private XPathContext getXPathContext() {
        if (this.xpContext == null) {
            this.xpContext = new XPathContext();
        }
        return this.xpContext;
    }

    private void loadSerializer() throws IOException {
        Properties props = OutputPropertiesFactory.getDefaultMethodProperties("xml");
        props.setProperty("method", "xml");
        props.setProperty("omit-xml-declaration", "yes");
        props.setProperty("encoding", "UTF-8");
        this.serializer = SerializerFactory.getSerializer(props);
    }

    @Override
    public final boolean nullQuery() {
        return this.query == null;
    }
}

