/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.offheap.OffHeapRegionEntryHelper;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.gemstone.gnu.trove.TIntArrayList;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import com.pivotal.gemfirexd.internal.engine.distributed.ByteArrayDataOutput;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ColumnQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.ServerResolverUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.ResultWasNull;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeUtilities;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.HarmonySerialBlob;
import com.pivotal.gemfirexd.internal.iapi.types.HarmonySerialClob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDecimal;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.impl.sql.GenericColumnDescriptor;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.UTF8String;
import sun.misc.Unsafe;

public final class RowFormatter
implements Serializable {
    public final int offsetBytes;
    public final int offsetIsDefault;
    public final int schemaVersion;
    private final byte[] versionBytes;
    private final byte versionByte;
    public final int nVersionBytes;
    private final int maxVarWidth;
    private final int numVarWidthColumns;
    private final int varDataOffset;
    private transient EmbedResultSetMetaData metadata;
    private final boolean isTableFormatter;
    private final boolean isPrimaryKeyFormatter;
    private static final int OFFSET_BYTES_POS = 0;
    private static final int OFFSET_IS_DEFAULT_POS = 1;
    private static final int MAX_VAR_WIDTH_POS = 2;
    private static final int NUM_VAR_WIDTH_COLS_POS = 3;
    private static final int VAR_DATA_OFFSET_POS = 4;
    private static final int NUM_POS = 5;
    public static final int TOKEN_RECOVERY_VERSION = -1;
    static final int TOKEN_RECOVERY_VERSION_BYTES = RowFormatter.getCompactIntNumBytes(-1);
    int[] positionMap;
    public transient ColumnDescriptor[] columns;
    int numLobs;
    public final boolean isHeap;
    public final transient GemFireContainer container;
    public static final long OFFSET_AND_WIDTH_IS_NULL = -7L;
    public static final long OFFSET_AND_WIDTH_IS_DEFAULT = -6L;
    public static final int DELIMITER_FOR_PXF = 44;
    private static final Unsafe _unsafe = UnsafeWrapper.getUnsafe();
    private static final boolean littleEndian = OffHeapRegionEntryHelper.NATIVE_BYTE_ORDER_IS_LITTLE_ENDIAN;
    private static final int BYTE_ARRAY_OFFSET = _unsafe.arrayBaseOffset(byte[].class);
    private static final ColumnProcessor<byte[]> extractColumnBytes = new ColumnProcessor<byte[]>(){

        @Override
        public final int handleNull(byte[] outputBuffer, int varDataOffset, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            int offsetOffset = outputBuffer.length + targetOffsetFromMap;
            RowFormatter.writeInt(outputBuffer, targetFormat.getNullIndicator(varDataOffset), offsetOffset, targetFormat.offsetBytes);
            return varDataOffset;
        }

        @Override
        public final int handleDefault(byte[] outputBuffer, int varDataOffset, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            int offsetOffset = outputBuffer.length + targetOffsetFromMap;
            byte[] defaultBytes = cd.columnDefaultBytes;
            if (defaultBytes == null) {
                RowFormatter.writeInt(outputBuffer, targetFormat.getNullIndicator(varDataOffset), offsetOffset, targetFormat.offsetBytes);
                return varDataOffset;
            }
            RowFormatter.writeInt(outputBuffer, targetFormat.getVarDataOffset(varDataOffset), offsetOffset, targetFormat.offsetBytes);
            System.arraycopy(defaultBytes, 0, outputBuffer, varDataOffset, defaultBytes.length);
            return varDataOffset + defaultBytes.length;
        }

        @Override
        public final int handleFixed(byte[] row, int columnOffset, int columnWidth, byte[] outputBuffer, int varDataOffset, RowFormatter formatter, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            int targetWidth = targetFormat.columns[targetIndex].fixedWidth;
            if (targetWidth >= columnWidth) {
                System.arraycopy(row, columnOffset, outputBuffer, targetOffsetFromMap, columnWidth);
                return varDataOffset;
            }
            System.arraycopy(row, columnOffset, outputBuffer, targetOffsetFromMap, targetWidth);
            return varDataOffset;
        }

        @Override
        public final int handleVariable(byte[] row, int columnOffset, int columnWidth, byte[] outputBuffer, int varDataOffset, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            if (columnWidth > targetFormat.maxVarWidth) {
                columnWidth = targetFormat.maxVarWidth;
            }
            int offsetOffset = outputBuffer.length + targetOffsetFromMap;
            RowFormatter.writeInt(outputBuffer, targetFormat.getVarDataOffset(varDataOffset), offsetOffset, targetFormat.offsetBytes);
            if (targetFormat.isPrimaryKeyFormatter && RowFormatter.shouldTrimTrailingSpaces(cd)) {
                columnWidth = RowFormatter.trimTrailingSpaces(row, columnOffset, columnWidth);
            }
            System.arraycopy(row, columnOffset, outputBuffer, varDataOffset, columnWidth);
            return varDataOffset + columnWidth;
        }

        @Override
        public final int handleLob(byte[] row, byte[] output, int outputPosition, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            throw new UnsupportedOperationException("not expected to be invoked for cd " + cd);
        }
    };
    private static final ColumnProcessorOffHeap<byte[]> extractColumnBytesOffHeap = new ColumnProcessorOffHeap<byte[]>(){

        @Override
        public final int handleNull(byte[] outputBuffer, int varDataOffset, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            int offsetOffset = outputBuffer.length + targetOffsetFromMap;
            RowFormatter.writeInt(outputBuffer, targetFormat.getNullIndicator(varDataOffset), offsetOffset, targetFormat.offsetBytes);
            return varDataOffset;
        }

        @Override
        public final int handleDefault(byte[] outputBuffer, int varDataOffset, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            int offsetOffset = outputBuffer.length + targetOffsetFromMap;
            RowFormatter.writeInt(outputBuffer, targetFormat.offsetIsDefault, offsetOffset, targetFormat.offsetBytes);
            return varDataOffset;
        }

        @Override
        public final int handleFixed(UnsafeWrapper unsafe, long memAddress, int columnOffset, int columnWidth, byte[] outputBuffer, int varDataOffset, RowFormatter formatter, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            int targetWidth = targetFormat.columns[targetIndex].fixedWidth;
            if (targetWidth >= columnWidth) {
                UnsafeMemoryChunk.readUnsafeBytes((UnsafeWrapper)unsafe, (long)memAddress, (int)columnOffset, (byte[])outputBuffer, (int)targetOffsetFromMap, (int)columnWidth);
                return varDataOffset;
            }
            UnsafeMemoryChunk.readUnsafeBytes((UnsafeWrapper)unsafe, (long)memAddress, (int)columnOffset, (byte[])outputBuffer, (int)targetOffsetFromMap, (int)targetWidth);
            return varDataOffset;
        }

        @Override
        public final int handleVariable(UnsafeWrapper unsafe, long memAddress, int columnOffset, int columnWidth, byte[] outputBuffer, int varDataOffset, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            if (columnWidth > targetFormat.maxVarWidth) {
                columnWidth = targetFormat.maxVarWidth;
            }
            int offsetOffset = outputBuffer.length + targetOffsetFromMap;
            RowFormatter.writeInt(outputBuffer, targetFormat.getVarDataOffset(varDataOffset), offsetOffset, targetFormat.offsetBytes);
            if (targetFormat.isPrimaryKeyFormatter && RowFormatter.shouldTrimTrailingSpaces(cd)) {
                columnWidth = RowFormatter.trimTrailingSpaces(unsafe, memAddress, columnOffset, columnWidth);
            }
            UnsafeMemoryChunk.readUnsafeBytes((UnsafeWrapper)unsafe, (long)memAddress, (int)columnOffset, (byte[])outputBuffer, (int)varDataOffset, (int)columnWidth);
            return varDataOffset + columnWidth;
        }

        @Override
        public final int handleLob(UnsafeWrapper unsafe, long memAddress, byte[] output, int outputPosition, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            throw new UnsupportedOperationException("not expected to be invoked for cd " + cd);
        }
    };

    private static final int trimTrailingSpaces(byte[] row, int columnOffset, int columnWidth) {
        int byteOffset = columnOffset + columnWidth - 1;
        while (columnWidth > 0 && row[byteOffset] == 32) {
            --byteOffset;
            --columnWidth;
        }
        return columnWidth;
    }

    private static final int trimTrailingSpaces(UnsafeWrapper unsafe, long memAddress, int columnOffset, int columnWidth) {
        long memOffset = memAddress + (long)columnOffset + (long)columnWidth - 1L;
        while (columnWidth > 0 && unsafe.getByte(memOffset) == 32) {
            --memOffset;
            --columnWidth;
        }
        return columnWidth;
    }

    public static int writeInt(byte[] bytes, int intValue, int offset) {
        assert (bytes != null);
        if (littleEndian) {
            _unsafe.putInt(bytes, offset + BYTE_ARRAY_OFFSET, Integer.reverseBytes(intValue));
            return 4;
        }
        _unsafe.putInt(bytes, offset + BYTE_ARRAY_OFFSET, intValue);
        return 4;
    }

    public static void writeInt(byte[] bytes, int intValue, int offset, int numBytesToBeWritten) {
        assert (bytes != null);
        int index = offset;
        while (index < offset + numBytesToBeWritten) {
            bytes[index] = (byte)intValue;
            ++index;
            intValue >>>= 8;
        }
    }

    public static int writeCompactInt(byte[] bytes, int v, int offset) {
        long lv = InternalDataSerializer.encodeZigZag64((long)v);
        while (true) {
            if ((lv & 0xFFFFFFFFFFFFFF80L) == 0L) {
                bytes[offset] = (byte)lv;
                return offset;
            }
            bytes[offset] = (byte)(lv & 0x7FL | 0x80L);
            lv >>>= 7;
            ++offset;
        }
    }

    private static byte getCompactIntByte(int v) {
        long lv = InternalDataSerializer.encodeZigZag64((long)v);
        if ((lv & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return (byte)lv;
        }
        return (byte)(lv & 0x7FL | 0x80L);
    }

    public static int getCompactIntNumBytes(int v) {
        long lv = InternalDataSerializer.encodeZigZag64((long)v);
        int numBytes = 1;
        while ((lv & 0xFFFFFFFFFFFFFF80L) != 0L) {
            lv >>>= 7;
            ++numBytes;
        }
        return numBytes;
    }

    public static void writeInt(DataOutput out, int intValue, int numBytesToBeWritten) throws IOException {
        assert (out != null);
        int i = 0;
        while (i < numBytesToBeWritten) {
            out.writeByte((byte)intValue);
            ++i;
            intValue >>>= 8;
        }
    }

    public static int readInt(UnsafeWrapper unsafe, long memOffset, int numBytesToBeRead) {
        long endAddr = memOffset + (long)numBytesToBeRead;
        byte b = unsafe.getByte(memOffset);
        int intValue = b & 0xFF;
        int shift = 8;
        while (++memOffset < endAddr) {
            b = unsafe.getByte(memOffset);
            intValue |= (b & 0xFF) << shift;
            shift += 8;
        }
        if (b < 0) {
            for (int index = numBytesToBeRead; index < 4; ++index) {
                intValue |= 255 << shift;
                shift += 8;
            }
        }
        return intValue;
    }

    public static int readInt(byte[] bytes, int offset, int numBytesToBeRead) {
        assert (bytes != null);
        byte b = bytes[offset];
        int intValue = b & 0xFF;
        int endPos = offset + numBytesToBeRead;
        int shift = 8;
        while (++offset < endPos) {
            b = bytes[offset];
            intValue |= (b & 0xFF) << shift;
            shift += 8;
        }
        if (b < 0) {
            for (int index = numBytesToBeRead; index < 4; ++index) {
                intValue |= 255 << shift;
                shift += 8;
            }
        }
        return intValue;
    }

    public static int readInt(UnsafeWrapper unsafe, long memOffset) {
        if (littleEndian) {
            return Integer.reverseBytes(_unsafe.getInt(memOffset));
        }
        return _unsafe.getInt(memOffset);
    }

    public static int readInt(byte[] bytes, int offset) {
        assert (bytes != null);
        if (littleEndian) {
            return Integer.reverseBytes(_unsafe.getInt(bytes, offset + BYTE_ARRAY_OFFSET));
        }
        return _unsafe.getInt(bytes, offset + BYTE_ARRAY_OFFSET);
    }

    public static int readCompactInt(UnsafeWrapper unsafe, long memAddr, int offset) {
        assert (offset >= 0) : "offset should be >= 0";
        int shift = 0;
        long result = 0L;
        long bsAddr = memAddr + (long)offset;
        while (shift < 64) {
            byte b = unsafe.getByte(bsAddr);
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) == 0) {
                return (int)InternalDataSerializer.decodeZigZag64((long)result);
            }
            shift += 7;
            ++bsAddr;
        }
        throw new GemFireXDRuntimeException("Malformed variable length integer");
    }

    public static int readCompactInt(byte[] bytes, int offset) {
        int shift = 0;
        long result = 0L;
        while (shift < 64) {
            byte b = bytes[offset];
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) == 0) {
                return (int)InternalDataSerializer.decodeZigZag64((long)result);
            }
            shift += 7;
            ++offset;
        }
        throw new GemFireXDRuntimeException("Malformed variable length integer");
    }

    public static int writeLong(byte[] bytes, long longValue, int offset) {
        assert (bytes != null);
        if (littleEndian) {
            _unsafe.putLong(bytes, offset + BYTE_ARRAY_OFFSET, Long.reverseBytes(longValue));
            return 8;
        }
        _unsafe.putLong(bytes, offset + BYTE_ARRAY_OFFSET, longValue);
        return 8;
    }

    public static long readLong(UnsafeWrapper unsafe, long memOffset) {
        if (littleEndian) {
            return Long.reverseBytes(_unsafe.getLong(memOffset));
        }
        return _unsafe.getLong(memOffset);
    }

    public static long readLong(byte[] bytes, int offset) {
        assert (bytes != null);
        if (littleEndian) {
            return Long.reverseBytes(_unsafe.getLong(bytes, offset + BYTE_ARRAY_OFFSET));
        }
        return _unsafe.getLong(bytes, offset + BYTE_ARRAY_OFFSET);
    }

    public RowFormatter(ColumnDescriptorList cdl, String schemaName, String tableName, int schemaVersion, GemFireContainer container) {
        this(cdl, cdl.size(), schemaName, tableName, schemaVersion, container, false);
    }

    public RowFormatter(ColumnDescriptorList cdl, String schemaName, String tableName, int schemaVersion, GemFireContainer container, boolean isTableFormatter) {
        this(cdl, cdl.size(), schemaName, tableName, schemaVersion, container, isTableFormatter);
    }

    RowFormatter(ColumnQueryInfo[] cqi, int schemaVersion, GemFireContainer container) {
        this.schemaVersion = schemaVersion;
        this.nVersionBytes = this.getVersionNumBytes(schemaVersion);
        this.versionBytes = this.getVersionBytes(schemaVersion, this.nVersionBytes);
        this.versionByte = this.getVersionByte(schemaVersion, this.nVersionBytes);
        int[] colsInfo = this.initNumVarWidthCols(cqi);
        this.offsetBytes = colsInfo[0];
        this.offsetIsDefault = colsInfo[1];
        this.maxVarWidth = colsInfo[2];
        this.numVarWidthColumns = colsInfo[3];
        this.varDataOffset = colsInfo[4];
        this.container = container;
        int size = cqi.length;
        int[] positionMap = new int[size];
        ColumnDescriptor[] columns = new ColumnDescriptor[size];
        int fixedDataOffset = this.nVersionBytes;
        int nextNegativeVarDataOffsetOffset = -(this.offsetBytes * this.numVarWidthColumns);
        int nextLobIndex = 0;
        for (int index = 0; index < size; ++index) {
            ColumnDescriptor cd;
            columns[index] = cd = cqi[index].getColumnDescriptor();
            if (!cd.isLob) {
                int fixedWidth = cd.fixedWidth;
                if (fixedWidth != -1) {
                    assert (fixedWidth > -1);
                    positionMap[index] = fixedDataOffset;
                    fixedDataOffset += fixedWidth;
                    continue;
                }
                positionMap[index] = nextNegativeVarDataOffsetOffset;
                nextNegativeVarDataOffsetOffset += this.offsetBytes;
                continue;
            }
            positionMap[index] = ++nextLobIndex;
        }
        this.positionMap = positionMap;
        this.columns = columns;
        this.numLobs = nextLobIndex;
        this.isHeap = container == null || !container.isOffHeap();
        this.metadata = null;
        this.isTableFormatter = false;
        this.isPrimaryKeyFormatter = false;
    }

    public RowFormatter(ColumnDescriptor[] cdl, int size, int schemaVersion, GemFireContainer container, boolean isProjection) {
        this.schemaVersion = schemaVersion;
        this.nVersionBytes = this.getVersionNumBytes(schemaVersion);
        this.versionBytes = this.getVersionBytes(schemaVersion, this.nVersionBytes);
        this.versionByte = this.getVersionByte(schemaVersion, this.nVersionBytes);
        int[] colsInfo = this.initNumVarWidthCols(cdl, size);
        this.offsetBytes = colsInfo[0];
        this.offsetIsDefault = colsInfo[1];
        this.maxVarWidth = colsInfo[2];
        this.numVarWidthColumns = colsInfo[3];
        this.varDataOffset = colsInfo[4];
        this.container = container;
        int[] positionMap = new int[size];
        ColumnDescriptor[] columns = new ColumnDescriptor[size];
        int fixedDataOffset = this.nVersionBytes;
        int nextNegativeVarDataOffsetOffset = -(this.offsetBytes * this.numVarWidthColumns);
        int nextLobIndex = 0;
        for (int index = 0; index < size; ++index) {
            ColumnDescriptor cd = cdl[index];
            ColumnDescriptor columnDescriptor = columns[index] = isProjection ? cd : cd.cloneObject();
            if (cd.isLob) {
                positionMap[index] = ++nextLobIndex;
                continue;
            }
            int fixedWidth = cd.fixedWidth;
            if (fixedWidth != -1) {
                assert (fixedWidth > -1);
                positionMap[index] = fixedDataOffset;
                fixedDataOffset += fixedWidth;
                continue;
            }
            positionMap[index] = nextNegativeVarDataOffsetOffset;
            nextNegativeVarDataOffsetOffset += this.offsetBytes;
        }
        this.positionMap = positionMap;
        this.columns = columns;
        this.numLobs = nextLobIndex;
        boolean bl = this.isHeap = container == null || !container.isOffHeap();
        if (isProjection) {
            this.metadata = null;
            this.isTableFormatter = false;
        } else {
            this.metadata = this.getMetaData(container.getSchemaName(), container.getTableName(), schemaVersion);
            this.isTableFormatter = true;
            if (container != null) {
                container.hasLobs = this.hasLobs();
            }
        }
        this.isPrimaryKeyFormatter = false;
    }

    private RowFormatter(ColumnDescriptorList cdl, int size, String schemaName, String tableName, int schemaVersion, GemFireContainer container, boolean isTableFormatter) {
        this.schemaVersion = schemaVersion;
        this.nVersionBytes = this.getVersionNumBytes(schemaVersion);
        this.versionBytes = this.getVersionBytes(schemaVersion, this.nVersionBytes);
        this.versionByte = this.getVersionByte(schemaVersion, this.nVersionBytes);
        int[] colsInfo = this.initNumVarWidthCols(cdl, size);
        this.offsetBytes = colsInfo[0];
        this.offsetIsDefault = colsInfo[1];
        this.maxVarWidth = colsInfo[2];
        this.numVarWidthColumns = colsInfo[3];
        this.varDataOffset = colsInfo[4];
        this.container = container;
        int[] positionMap = new int[size];
        ColumnDescriptor[] columns = new ColumnDescriptor[size];
        int fixedDataOffset = this.nVersionBytes;
        int nextNegativeVarDataOffsetOffset = -(this.offsetBytes * this.numVarWidthColumns);
        int nextLobIndex = 0;
        for (int index = 0; index < size; ++index) {
            ColumnDescriptor cd = cdl.elementAt(index);
            ColumnDescriptor columnDescriptor = columns[index] = isTableFormatter ? cd.cloneObject() : cd;
            if (cd.isLob) {
                positionMap[index] = ++nextLobIndex;
                continue;
            }
            int fixedWidth = cd.fixedWidth;
            if (fixedWidth != -1) {
                assert (fixedWidth > -1);
                positionMap[index] = fixedDataOffset;
                fixedDataOffset += fixedWidth;
                continue;
            }
            positionMap[index] = nextNegativeVarDataOffsetOffset;
            nextNegativeVarDataOffsetOffset += this.offsetBytes;
        }
        this.positionMap = positionMap;
        this.columns = columns;
        this.numLobs = nextLobIndex;
        this.isHeap = container == null || !container.isOffHeap();
        this.metadata = this.getMetaData(schemaName, tableName, schemaVersion);
        this.isTableFormatter = isTableFormatter;
        this.isPrimaryKeyFormatter = false;
        if (isTableFormatter && container != null) {
            container.hasLobs = this.hasLobs();
        }
    }

    RowFormatter(ColumnDescriptorList cdl, FormatableBitSet validColumns, int schemaVersion, GemFireContainer container) {
        this.schemaVersion = schemaVersion;
        this.nVersionBytes = this.getVersionNumBytes(schemaVersion);
        this.versionBytes = this.getVersionBytes(schemaVersion, this.nVersionBytes);
        this.versionByte = this.getVersionByte(schemaVersion, this.nVersionBytes);
        int[] colsInfo = this.initNumVarWidthCols(cdl, validColumns);
        this.offsetBytes = colsInfo[0];
        this.offsetIsDefault = colsInfo[1];
        this.maxVarWidth = colsInfo[2];
        this.numVarWidthColumns = colsInfo[3];
        this.varDataOffset = colsInfo[4];
        this.container = container;
        int size = validColumns.getNumBitsSet();
        int[] positionMap = new int[size];
        ColumnDescriptor[] columns = new ColumnDescriptor[size];
        int fixedDataOffset = this.nVersionBytes;
        int nextNegativeVarDataOffsetOffset = -(this.offsetBytes * this.numVarWidthColumns);
        int nextLobIndex = 0;
        int colIndex = validColumns.anySetBit();
        int index = 0;
        while (colIndex != -1) {
            ColumnDescriptor cd;
            columns[index] = cd = cdl.elementAt(colIndex);
            if (cd.isLob) {
                positionMap[index] = ++nextLobIndex;
            } else {
                int fixedWidth = cd.fixedWidth;
                if (fixedWidth != -1) {
                    assert (fixedWidth > -1);
                    positionMap[index] = fixedDataOffset;
                    fixedDataOffset += fixedWidth;
                } else {
                    positionMap[index] = nextNegativeVarDataOffsetOffset;
                    nextNegativeVarDataOffsetOffset += this.offsetBytes;
                }
            }
            colIndex = validColumns.anySetBit(colIndex);
            ++index;
        }
        this.positionMap = positionMap;
        this.columns = columns;
        this.numLobs = nextLobIndex;
        this.isHeap = container == null || !container.isOffHeap();
        this.metadata = null;
        this.isTableFormatter = false;
        this.isPrimaryKeyFormatter = false;
    }

    RowFormatter(ColumnDescriptorList cdl, int[] validColumns, String schemaName, String tableName, int schemaVersion, GemFireContainer container, boolean isPrimaryKeyFormatter) {
        this.schemaVersion = schemaVersion;
        this.nVersionBytes = this.getVersionNumBytes(schemaVersion);
        this.versionBytes = this.getVersionBytes(schemaVersion, this.nVersionBytes);
        this.versionByte = this.getVersionByte(schemaVersion, this.nVersionBytes);
        int[] colsInfo = this.initNumVarWidthCols(cdl, validColumns);
        this.offsetBytes = colsInfo[0];
        this.offsetIsDefault = colsInfo[1];
        this.maxVarWidth = colsInfo[2];
        this.numVarWidthColumns = colsInfo[3];
        this.varDataOffset = colsInfo[4];
        this.container = container;
        int size = validColumns.length;
        int[] positionMap = new int[size];
        ColumnDescriptor[] columns = new ColumnDescriptor[size];
        int fixedDataOffset = this.nVersionBytes;
        int nextNegativeVarDataOffsetOffset = -(this.offsetBytes * this.numVarWidthColumns);
        int nextLobIndex = 0;
        for (int index = 0; index < size; ++index) {
            int colIndex = validColumns[index] - 1;
            ColumnDescriptor cd = cdl.elementAt(colIndex);
            columns[index] = cd.cloneObject();
            if (cd.isLob) {
                positionMap[index] = ++nextLobIndex;
                continue;
            }
            int fixedWidth = cd.fixedWidth;
            if (fixedWidth != -1) {
                assert (fixedWidth > -1);
                positionMap[index] = fixedDataOffset;
                fixedDataOffset += fixedWidth;
                continue;
            }
            positionMap[index] = nextNegativeVarDataOffsetOffset;
            nextNegativeVarDataOffsetOffset += this.offsetBytes;
        }
        this.positionMap = positionMap;
        this.columns = columns;
        this.numLobs = nextLobIndex;
        this.isHeap = container == null || !container.isOffHeap();
        this.metadata = this.getMetaData(schemaName, tableName, schemaVersion);
        this.isTableFormatter = false;
        this.isPrimaryKeyFormatter = isPrimaryKeyFormatter;
    }

    public final void getColumnPositions(TIntArrayList fixedColumns, TIntArrayList varColumns, TIntArrayList lobColumns, TIntArrayList allColumns, TIntArrayList allColumnsWithLobs) {
        for (ColumnDescriptor cd : this.columns) {
            int pos = cd.getPosition();
            if (!cd.isLob) {
                if (cd.fixedWidth != -1) {
                    fixedColumns.add(pos);
                } else {
                    varColumns.add(pos);
                }
                allColumns.add(pos);
            } else {
                lobColumns.add(pos);
            }
            allColumnsWithLobs.add(pos);
        }
    }

    private EmbedResultSetMetaData getMetaData(String schemaName, String tableName, int schemaVersion) {
        int size = this.getNumColumns();
        ResultColumnDescriptor[] gcds = new GenericColumnDescriptor[size];
        for (int index = 0; index < size; ++index) {
            ColumnDescriptor cd = this.columns[index];
            gcds[index] = new GenericColumnDescriptor(cd.getColumnName(), schemaName, tableName, cd.getPosition(), cd.getType(), cd.updatableByCursor(), cd.isAutoincrement());
        }
        return new EmbedResultSetMetaData(gcds, true, schemaVersion);
    }

    public final TableMetaData getMetaData() {
        return this.metadata;
    }

    public final boolean isTableFormatter() {
        return this.isTableFormatter;
    }

    public final DataTypeDescriptor getType(int columnPosition) {
        return this.columns[columnPosition - 1].columnType;
    }

    public final ColumnDescriptor getColumnDescriptor(int index) {
        return this.columns[index];
    }

    public final void getColumns(byte[] bytes, DataValueDescriptor[] dvds, int[] validColumns) throws StandardException {
        if (validColumns != null) {
            int nCols = validColumns.length;
            for (int index = 0; index < nCols; ++index) {
                int logicalPosition = validColumns[index];
                DataValueDescriptor dvd = dvds[index];
                if (logicalPosition > 0) {
                    DataValueDescriptor newDVD = this.getColumn(logicalPosition, bytes);
                    if (dvd == null || dvd.getTypeFormatId() == newDVD.getTypeFormatId()) {
                        dvds[index] = newDVD;
                        continue;
                    }
                    dvd.setValue(newDVD);
                    continue;
                }
                dvds[index] = null;
            }
        } else {
            for (int column = 1; column <= this.getNumColumns(); ++column) {
                DataValueDescriptor dvd = dvds[column - 1];
                DataValueDescriptor newDVD = this.getColumn(column, bytes);
                if (dvd == null || dvd.getTypeFormatId() == newDVD.getTypeFormatId()) {
                    dvds[column - 1] = newDVD;
                    continue;
                }
                dvd.setValue(newDVD);
            }
        }
    }

    public final void getColumns(OffHeapRow bs, DataValueDescriptor[] dvds, int[] validColumns) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bs.getLength();
        long memAddr = bs.getUnsafeAddress(0, bytesLen);
        if (validColumns != null) {
            int nCols = validColumns.length;
            for (int index = 0; index < nCols; ++index) {
                int logicalPosition = validColumns[index];
                DataValueDescriptor dvd = dvds[index];
                if (logicalPosition > 0) {
                    DataValueDescriptor newDVD = this.getColumn(logicalPosition, unsafe, memAddr, bytesLen, bs);
                    if (dvd == null || dvd.getTypeFormatId() == newDVD.getTypeFormatId()) {
                        dvds[index] = newDVD;
                        continue;
                    }
                    dvd.setValue(newDVD);
                    continue;
                }
                dvds[index] = null;
            }
        } else {
            for (int column = 1; column <= this.getNumColumns(); ++column) {
                DataValueDescriptor dvd = dvds[column - 1];
                DataValueDescriptor newDVD = this.getColumn(column, unsafe, memAddr, bytesLen, bs);
                if (dvd == null || dvd.getTypeFormatId() == newDVD.getTypeFormatId()) {
                    dvds[column - 1] = newDVD;
                    continue;
                }
                dvd.setValue(newDVD);
            }
        }
    }

    public final void getColumns(byte[][] byteArrays, DataValueDescriptor[] dvds, int[] validColumns) throws StandardException {
        if (validColumns != null) {
            int nCols = validColumns.length;
            for (int index = 0; index < nCols; ++index) {
                int logicalPosition = validColumns[index];
                DataValueDescriptor dvd = dvds[index];
                if (logicalPosition > 0) {
                    DataValueDescriptor newDVD = this.getColumn(logicalPosition, byteArrays);
                    if (dvd == null || dvd.getTypeFormatId() == newDVD.getTypeFormatId()) {
                        dvds[index] = newDVD;
                        continue;
                    }
                    dvd.setValue(newDVD);
                    continue;
                }
                dvds[index] = null;
            }
        } else {
            for (int column = 1; column <= this.getNumColumns(); ++column) {
                DataValueDescriptor dvd = dvds[column - 1];
                DataValueDescriptor newDVD = this.getColumn(column, byteArrays);
                if (dvd == null || dvd.getTypeFormatId() == newDVD.getTypeFormatId()) {
                    dvds[column - 1] = newDVD;
                    continue;
                }
                dvd.setValue(newDVD);
            }
        }
    }

    public final void getColumns(OffHeapRowWithLobs byteArrays, DataValueDescriptor[] dvds, int[] validColumns) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen0th = byteArrays.getLength();
        long memAddr0th = byteArrays.getUnsafeAddress(0, bytesLen0th);
        if (validColumns != null) {
            int nCols = validColumns.length;
            for (int index = 0; index < nCols; ++index) {
                int logicalPosition = validColumns[index];
                DataValueDescriptor dvd = dvds[index];
                if (logicalPosition > 0) {
                    DataValueDescriptor newDVD = this.getColumn(logicalPosition, unsafe, memAddr0th, bytesLen0th, byteArrays);
                    if (dvd == null || dvd.getTypeFormatId() == newDVD.getTypeFormatId()) {
                        dvds[index] = newDVD;
                        continue;
                    }
                    dvd.setValue(newDVD);
                    continue;
                }
                dvds[index] = null;
            }
        } else {
            int nCols = this.getNumColumns();
            for (int column = 1; column <= nCols; ++column) {
                DataValueDescriptor dvd = dvds[column - 1];
                DataValueDescriptor newDVD = this.getColumn(column, unsafe, memAddr0th, bytesLen0th, byteArrays);
                if (dvd == null || dvd.getTypeFormatId() == newDVD.getTypeFormatId()) {
                    dvds[column - 1] = newDVD;
                    continue;
                }
                dvd.setValue(newDVD);
            }
        }
    }

    public static final boolean qualifyRow(ExecRow row, boolean byteArrayStore, Qualifier[][] qual_list) throws StandardException {
        boolean row_qualifies = true;
        assert (row != null);
        assert (qual_list != null);
        assert (qual_list.length > 0);
        for (int i = 0; i < qual_list[0].length; ++i) {
            row_qualifies = false;
            Qualifier q = qual_list[0][i];
            DataValueDescriptor qual = q.getOrderable();
            row_qualifies = qual.compare(q.getOperator(), row, byteArrayStore, q.getColumnId() + 1, q.getOrderedNulls(), q.getUnknownRV());
            if (q.negateCompareResult()) {
                boolean bl = row_qualifies = !row_qualifies;
            }
            if (row_qualifies) continue;
            return false;
        }
        for (int and_idx = 1; and_idx < qual_list.length; ++and_idx) {
            row_qualifies = false;
            assert (qual_list[and_idx].length > 0);
            for (int or_idx = 0; or_idx < qual_list[and_idx].length; ++or_idx) {
                Qualifier q = qual_list[and_idx][or_idx];
                int col_id = q.getColumnId();
                assert (col_id < row.nColumns()) : "Qualifier is referencing a column not in the row.";
                DataValueDescriptor qual = q.getOrderable();
                assert (row.getColumn(q.getColumnId() + 1) != null) : "1:row = " + RowUtil.toString(row.getRowArray()) + "row.length = " + row.nColumns() + ";q.getColumnId() = " + q.getColumnId();
                row_qualifies = qual.compare(q.getOperator(), row, byteArrayStore, q.getColumnId() + 1, q.getOrderedNulls(), q.getUnknownRV());
                if (q.negateCompareResult()) {
                    boolean bl = row_qualifies = !row_qualifies;
                }
                if (row_qualifies) break;
            }
            if (!row_qualifies) break;
        }
        return row_qualifies;
    }

    public static final boolean qualifyRow(CompactCompositeKey key, Qualifier[][] qual_list) throws StandardException {
        boolean key_qualifies = true;
        assert (key != null);
        assert (qual_list != null);
        assert (qual_list.length > 0);
        for (int i = 0; i < qual_list[0].length; ++i) {
            key_qualifies = false;
            Qualifier q = qual_list[0][i];
            DataValueDescriptor qual = q.getOrderable();
            key_qualifies = qual.compare(q.getOperator(), key, q.getColumnId() + 1, q.getOrderedNulls(), q.getUnknownRV());
            if (q.negateCompareResult()) {
                boolean bl = key_qualifies = !key_qualifies;
            }
            if (key_qualifies) continue;
            return false;
        }
        for (int and_idx = 1; and_idx < qual_list.length; ++and_idx) {
            key_qualifies = false;
            assert (qual_list[and_idx].length > 0);
            for (int or_idx = 0; or_idx < qual_list[and_idx].length; ++or_idx) {
                Qualifier q = qual_list[and_idx][or_idx];
                int col_id = q.getColumnId();
                assert (col_id < key.nCols()) : "Qualifier is referencing a column not in the key.";
                DataValueDescriptor qual = q.getOrderable();
                assert (key.getKeyColumn(q.getColumnId()) != null) : "1:key = " + key + "row.length = " + key.nCols() + ";q.getColumnId() = " + q.getColumnId();
                key_qualifies = qual.compare(q.getOperator(), key, q.getColumnId() + 1, q.getOrderedNulls(), q.getUnknownRV());
                if (q.negateCompareResult()) {
                    boolean bl = key_qualifies = !key_qualifies;
                }
                if (key_qualifies) break;
            }
            if (!key_qualifies) break;
        }
        return key_qualifies;
    }

    public final byte[] generateBytes(DataValueDescriptor[] dvds) throws StandardException {
        assert (!this.hasLobs()) : "unexpected generateBytes for row having LOBs: " + RowUtil.toString(dvds);
        int len = this.computeRowLength(dvds);
        byte[] bytes = new byte[len];
        this.writeVersion(bytes);
        int varDataOffset = this.varDataOffset;
        for (int index = 0; index < dvds.length; ++index) {
            varDataOffset += this.generateColumn(index, dvds[index], this.columns[index], bytes, varDataOffset);
        }
        return bytes;
    }

    public final byte[] generateBytes(DataValueDescriptor dvd) throws StandardException {
        assert (!this.hasLobs()) : "unexpected generateBytes for row having LOBs: " + dvd;
        int len = this.computeRowLength(dvd);
        byte[] bytes = new byte[len];
        this.writeVersion(bytes);
        this.generateColumn(0, dvd, this.columns[0], bytes, this.varDataOffset);
        return bytes;
    }

    public final byte[] generateBytesWithIdenticalDVDTypes(DataValueDescriptor[] dvds) throws StandardException {
        DataValueDescriptor[] newDVDs = null;
        for (int index = 0; index < dvds.length; ++index) {
            DataValueDescriptor dvd = dvds[index];
            DataTypeDescriptor dtd = this.columns[index].columnType;
            if (dtd.getDVDTypeFormatId() == dvd.getTypeFormatId()) continue;
            DataValueDescriptor newDVD = dtd.getNull();
            newDVD.setValue(dvd);
            if (newDVDs == null) {
                newDVDs = (DataValueDescriptor[])dvds.clone();
            }
            newDVDs[index] = newDVD;
        }
        return this.generateBytes(newDVDs == null ? dvds : newDVDs);
    }

    public final byte[] generateBytesWithIdenticalDVDType(DataValueDescriptor dvd) throws StandardException {
        DataTypeDescriptor dtd = this.columns[0].columnType;
        if (dtd.getDVDTypeFormatId() != dvd.getTypeFormatId()) {
            DataValueDescriptor newDVD = dtd.getNull();
            newDVD.setValue(dvd);
            return this.generateBytes(newDVD);
        }
        return this.generateBytes(dvd);
    }

    public final void writeVersion(byte[] bytes) {
        if (this.schemaVersion != 0) {
            assert (this.nVersionBytes > 0) : "unexpected versionBytes=" + this.nVersionBytes + " for version=" + this.schemaVersion;
            if (this.versionBytes == null) {
                bytes[0] = this.versionByte;
            } else {
                System.arraycopy(this.versionBytes, 0, bytes, 0, this.nVersionBytes);
            }
        }
    }

    public final void writeVersion(DataOutput out) throws IOException {
        if (this.schemaVersion != 0) {
            assert (this.nVersionBytes > 0) : "unexpected versionBytes=" + this.nVersionBytes + " for version=" + this.schemaVersion;
            if (this.versionBytes == null) {
                out.writeByte(this.versionByte);
            } else {
                out.write(this.versionBytes, 0, this.nVersionBytes);
            }
        }
    }

    static final int readVersion(byte[] bytes) {
        int schemaVersion = RowFormatter.readCompactInt(bytes, 0);
        assert (schemaVersion >= 0 || schemaVersion == -1) : "unexpected schemaVersion=" + schemaVersion + " for RF#readVersion";
        return schemaVersion;
    }

    static final int readVersion(UnsafeWrapper unsafe, long memAddr) {
        int schemaVersion = RowFormatter.readCompactInt(unsafe, memAddr, 0);
        assert (schemaVersion >= 0 || schemaVersion == -1) : "unexpected schemaVersion=" + schemaVersion + " for RF#readVersion";
        return schemaVersion;
    }

    public static byte[] convertPre11Row(byte[] row) {
        if (row != null) {
            byte[] newRow = new byte[row.length + TOKEN_RECOVERY_VERSION_BYTES];
            RowFormatter.writeCompactInt(newRow, -1, 0);
            System.arraycopy(row, 0, newRow, TOKEN_RECOVERY_VERSION_BYTES, row.length);
            return newRow;
        }
        return null;
    }

    public static byte[][] convertPre11Row(byte[][] row) {
        if (row != null) {
            byte[][] newRow = new byte[row.length][];
            newRow[0] = RowFormatter.convertPre11Row(row[0]);
            for (int i = 1; i < row.length; ++i) {
                newRow[i] = row[i];
            }
            return newRow;
        }
        return null;
    }

    public static byte[] convertPre11Row(ByteArrayDataInput in) throws IOException {
        int len = InternalDataSerializer.readArrayLength((DataInput)in);
        if (len >= 0) {
            byte[] newRow = new byte[len + TOKEN_RECOVERY_VERSION_BYTES];
            RowFormatter.writePre11Row(in, newRow, 0, len);
            return newRow;
        }
        return null;
    }

    private static void writePre11Row(ByteArrayDataInput in, byte[] newRow, int offset, int len) throws IOException {
        RowFormatter.writeCompactInt(newRow, -1, offset);
        in.readFully(newRow, TOKEN_RECOVERY_VERSION_BYTES + offset, len);
    }

    public static byte[][] convertPre11RowWithLobs(ByteArrayDataInput in) throws IOException {
        int nlen = InternalDataSerializer.readArrayLength((DataInput)in);
        if (nlen > 0) {
            byte[][] newRow = new byte[nlen][];
            newRow[0] = RowFormatter.convertPre11Row(in);
            for (int i = 1; i < nlen; ++i) {
                newRow[i] = InternalDataSerializer.readByteArray((DataInput)in);
            }
            return newRow;
        }
        return null;
    }

    public static byte[] convertPre11RowWithLobsToBytes(ByteArrayDataInput in, byte dscode) throws IOException {
        int pos = in.position();
        int nlen = InternalDataSerializer.readArrayLength((DataInput)in);
        if (nlen > 0) {
            int len;
            int mark = in.position();
            int totalLen = 1 + TOKEN_RECOVERY_VERSION_BYTES;
            for (int i = 0; i < nlen; ++i) {
                len = InternalDataSerializer.readArrayLength((DataInput)in);
                if (len <= 0) continue;
                in.skipBytes(len);
            }
            in.setPosition(mark);
            byte[] newRow = new byte[totalLen += in.position() - pos];
            int offset = 0;
            newRow[offset++] = dscode;
            offset = InternalDataSerializer.writeArrayLength((int)nlen, (byte[])newRow, (int)offset);
            for (int i = 0; i < nlen; ++i) {
                len = InternalDataSerializer.readArrayLength((DataInput)in);
                offset = InternalDataSerializer.writeArrayLength((int)(i != 0 ? len : len + TOKEN_RECOVERY_VERSION_BYTES), (byte[])newRow, (int)offset);
                if (i == 0) {
                    assert (TOKEN_RECOVERY_VERSION_BYTES == 1) : TOKEN_RECOVERY_VERSION_BYTES;
                    newRow[offset++] = (byte)InternalDataSerializer.encodeZigZag64((long)-1L);
                }
                if (len <= 0) continue;
                in.readFully(newRow, offset, len);
                offset += len;
            }
            return newRow;
        }
        return null;
    }

    public final byte[][] generateByteArrays(DataValueDescriptor[] dvds) throws StandardException {
        assert (this.hasLobs()) : "unexpected generateByteArrays for row not having LOBs: " + RowUtil.toString(dvds);
        byte[][] byteArrays = new byte[this.numLobs + 1][];
        int len = this.computeRowLength(dvds);
        byte[] bytes = new byte[len];
        this.writeVersion(bytes);
        int varDataOffset = this.varDataOffset;
        int lobIndex = 1;
        for (int index = 0; index < dvds.length; ++index) {
            ColumnDescriptor cd = this.columns[index];
            if (!cd.isLob) {
                varDataOffset += this.generateColumn(index, dvds[index], cd, bytes, varDataOffset);
                continue;
            }
            byteArrays[lobIndex++] = this.generateLobColumn(dvds[index], cd);
        }
        byteArrays[0] = bytes;
        return byteArrays;
    }

    public final Object generateRowData(DataValueDescriptor[] dvds) throws StandardException {
        if (this.numLobs == 0) {
            return this.generateBytes(dvds);
        }
        return this.generateByteArrays(dvds);
    }

    public final byte[][] createByteArraysWithDefaultLobs(byte[] rowBytes) {
        byte[][] rowByteArrays = new byte[this.numLobs + 1][];
        ColumnDescriptor[] cols = this.columns;
        rowByteArrays[0] = rowBytes;
        int i = 0;
        for (ColumnDescriptor cd : cols) {
            if (!cd.isLob) continue;
            rowByteArrays[++i] = cd.columnDefaultBytes;
        }
        return rowByteArrays;
    }

    public final void addColumn(ColumnDescriptor newCD) {
        int nCols = this.positionMap.length;
        int[] newPosMap = new int[nCols + 1];
        ColumnDescriptor[] newColumns = new ColumnDescriptor[nCols + 1];
        System.arraycopy(this.positionMap, 0, newPosMap, 0, nCols);
        System.arraycopy(this.columns, 0, newColumns, 0, nCols);
        newPosMap[nCols] = 0;
        newColumns[nCols] = newCD.cloneObject();
        this.positionMap = newPosMap;
        this.columns = newColumns;
        if (newCD.isLob) {
            ++this.numLobs;
        }
        if (this.metadata != null) {
            this.metadata = this.getMetaData(this.container.getSchemaName(), this.container.getTableName(), this.container.getCurrentSchemaVersion());
        }
    }

    public final void dropColumn(int columnPos) {
        int nCols = this.positionMap.length;
        int[] newPosMap = new int[nCols - 1];
        ColumnDescriptor[] newColumns = new ColumnDescriptor[nCols - 1];
        if (columnPos > 1) {
            System.arraycopy(this.positionMap, 0, newPosMap, 0, columnPos - 1);
            System.arraycopy(this.columns, 0, newColumns, 0, columnPos - 1);
            if (columnPos < nCols) {
                System.arraycopy(this.positionMap, columnPos, newPosMap, columnPos - 1, nCols - columnPos);
                System.arraycopy(this.columns, columnPos, newColumns, columnPos - 1, nCols - columnPos);
            }
        } else {
            System.arraycopy(this.positionMap, 1, newPosMap, 0, nCols - 1);
            System.arraycopy(this.columns, 1, newColumns, 0, nCols - 1);
        }
        if (this.columns[columnPos - 1].isLob) {
            --this.numLobs;
        }
        this.positionMap = newPosMap;
        this.columns = newColumns;
        this.dropColumnAdjustPositionInCD(columnPos);
        if (this.metadata != null) {
            this.metadata = this.getMetaData(this.container.getSchemaName(), this.container.getTableName(), this.container.getCurrentSchemaVersion());
        }
    }

    public final void dropColumnAdjustPositionInCD(int columnPos) {
        for (ColumnDescriptor cd : this.columns) {
            int pos = cd.getPosition();
            if (pos <= columnPos) continue;
            cd.setPosition(pos - 1);
        }
    }

    public final boolean hasLobs() {
        return this.numLobs > 0;
    }

    public final int numLobs() {
        return this.numLobs;
    }

    final byte[] setColumns(FormatableBitSet columns, DataValueDescriptor[] srcValues, byte[] rowToChange, RowFormatter currentFormat) throws StandardException {
        int newColWidth;
        int newRowLength;
        boolean isLatestSchema;
        boolean bl = isLatestSchema = this.schemaVersion == currentFormat.schemaVersion;
        if (columns == null) {
            if (isLatestSchema) {
                return this.generateBytes(srcValues);
            }
            return currentFormat.generateBytes(srcValues);
        }
        assert (columns.getNumBitsSet() > 0) : "setColumns with zero columns to set: " + RowUtil.toString(srcValues);
        if (rowToChange == null) {
            if (isLatestSchema) {
                return this.generateColumns(columns, srcValues);
            }
            return currentFormat.generateColumns(columns, srcValues);
        }
        int bitSetSize = columns.getLength();
        if (isLatestSchema) {
            newRowLength = rowToChange.length;
            int colIndex = columns.anySetBit();
            while (colIndex != -1) {
                ColumnDescriptor cd = this.columns[colIndex];
                int oldColWidth = this.getColumnWidth(colIndex, rowToChange, cd);
                newColWidth = cd.fixedWidth;
                if (newColWidth == -1) {
                    newColWidth = this.getVarColumnWidth(srcValues[colIndex], cd);
                }
                newRowLength += newColWidth - oldColWidth;
                colIndex = columns.anySetBit(colIndex);
            }
        } else {
            newRowLength = currentFormat.nVersionBytes;
            int nCols = currentFormat.positionMap.length;
            for (int colIndex = 0; colIndex < nCols; ++colIndex) {
                ColumnDescriptor cd = currentFormat.columns[colIndex];
                if (colIndex < bitSetSize && columns.isSet(colIndex)) {
                    newColWidth = cd.fixedWidth;
                    if (newColWidth == -1) {
                        newColWidth = currentFormat.getVarColumnWidth(srcValues[colIndex], cd);
                        newColWidth += currentFormat.offsetBytes;
                    }
                } else {
                    newColWidth = this.getTotalColumnWidth(colIndex, rowToChange, cd, currentFormat, false);
                }
                newRowLength += newColWidth;
            }
        }
        byte[] newBytes = new byte[newRowLength];
        currentFormat.writeVersion(newBytes);
        int varDataOffset = currentFormat.varDataOffset;
        int nCols = currentFormat.positionMap.length;
        for (int index = 0; index < nCols; ++index) {
            if (index < bitSetSize && columns.isSet(index)) {
                varDataOffset += currentFormat.generateColumn(index, srcValues[index], currentFormat.columns[index], newBytes, varDataOffset);
                continue;
            }
            varDataOffset += currentFormat.copyColumn(index, rowToChange, this, newBytes, index, varDataOffset);
        }
        return newBytes;
    }

    final byte[] setColumns(FormatableBitSet columns, DataValueDescriptor[] srcValues, UnsafeWrapper unsafe, long memAddr, int bytesLen, RowFormatter currentFormat, boolean isLatestSchema) throws StandardException {
        int newColWidth;
        int newRowLength;
        int bitSetSize = columns.getLength();
        if (isLatestSchema) {
            newRowLength = bytesLen;
            int colIndex = columns.anySetBit();
            while (colIndex != -1) {
                ColumnDescriptor cd = this.columns[colIndex];
                int oldColWidth = this.getColumnWidth(colIndex, unsafe, memAddr, bytesLen, cd);
                newColWidth = cd.fixedWidth;
                if (newColWidth == -1) {
                    newColWidth = this.getVarColumnWidth(srcValues[colIndex], cd);
                }
                newRowLength += newColWidth - oldColWidth;
                colIndex = columns.anySetBit(colIndex);
            }
        } else {
            newRowLength = currentFormat.nVersionBytes;
            int nCols = currentFormat.positionMap.length;
            for (int colIndex = 0; colIndex < nCols; ++colIndex) {
                ColumnDescriptor cd = currentFormat.columns[colIndex];
                if (colIndex < bitSetSize && columns.isSet(colIndex)) {
                    newColWidth = cd.fixedWidth;
                    if (newColWidth == -1) {
                        newColWidth = currentFormat.getVarColumnWidth(srcValues[colIndex], cd);
                        newColWidth += currentFormat.offsetBytes;
                    }
                } else {
                    newColWidth = this.getTotalColumnWidth(colIndex, unsafe, memAddr, bytesLen, cd, currentFormat, false);
                }
                newRowLength += newColWidth;
            }
        }
        byte[] newBytes = new byte[newRowLength];
        currentFormat.writeVersion(newBytes);
        int varDataOffset = currentFormat.varDataOffset;
        int nCols = currentFormat.positionMap.length;
        for (int index = 0; index < nCols; ++index) {
            if (index < bitSetSize && columns.isSet(index)) {
                varDataOffset += currentFormat.generateColumn(index, srcValues[index], currentFormat.columns[index], newBytes, varDataOffset);
                continue;
            }
            varDataOffset += currentFormat.copyColumn(index, unsafe, memAddr, bytesLen, this, newBytes, index, varDataOffset);
        }
        return newBytes;
    }

    final byte[] setColumns(FormatableBitSet columns, DataValueDescriptor[] srcValues, OffHeapRow rowToChange, RowFormatter currentFormat) throws StandardException {
        boolean isLatestSchema;
        boolean bl = isLatestSchema = this.schemaVersion == currentFormat.schemaVersion;
        if (columns == null) {
            if (isLatestSchema) {
                return this.generateBytes(srcValues);
            }
            return currentFormat.generateBytes(srcValues);
        }
        assert (columns.getNumBitsSet() > 0) : "setColumns with zero columns to set: " + RowUtil.toString(srcValues);
        if (rowToChange == null) {
            if (isLatestSchema) {
                return this.generateColumns(columns, srcValues);
            }
            return currentFormat.generateColumns(columns, srcValues);
        }
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = rowToChange.getLength();
        long memAddr = rowToChange.getUnsafeAddress(0, bytesLen);
        return this.setColumns(columns, srcValues, unsafe, memAddr, bytesLen, currentFormat, isLatestSchema);
    }

    final byte[] setColumns(FormatableBitSet columns, DataValueDescriptor[] srcValues, OffHeapByteSource rowToChange, RowFormatter currentFormat) throws StandardException {
        boolean isLatestSchema;
        boolean bl = isLatestSchema = this.schemaVersion == currentFormat.schemaVersion;
        if (columns == null) {
            if (isLatestSchema) {
                return this.generateBytes(srcValues);
            }
            return currentFormat.generateBytes(srcValues);
        }
        assert (columns.getNumBitsSet() > 0) : "setColumns with zero columns to set: " + RowUtil.toString(srcValues);
        if (rowToChange == null) {
            if (isLatestSchema) {
                return this.generateColumns(columns, srcValues);
            }
            return currentFormat.generateColumns(columns, srcValues);
        }
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = rowToChange.getLength();
        long memAddr = rowToChange.getUnsafeAddress(0, bytesLen);
        return this.setColumns(columns, srcValues, unsafe, memAddr, bytesLen, currentFormat, isLatestSchema);
    }

    final byte[] setColumn(int columnIndex, DataValueDescriptor srcValue, byte[] rowToChange, RowFormatter currentFormat) throws StandardException {
        int newRowLength;
        boolean isLatestSchema;
        boolean bl = isLatestSchema = this.schemaVersion == currentFormat.schemaVersion;
        if (isLatestSchema) {
            newRowLength = rowToChange.length;
            ColumnDescriptor cd = this.columns[columnIndex];
            int oldColWidth = this.getColumnWidth(columnIndex, rowToChange, cd);
            int newColWidth = cd.fixedWidth;
            DataTypeDescriptor dtd = cd.columnType;
            if (srcValue.getTypeFormatId() != dtd.getDVDTypeFormatId()) {
                DataValueDescriptor newValue = dtd.getNull();
                newValue.setValue(srcValue);
                srcValue = newValue;
            }
            if (newColWidth == -1) {
                newColWidth = this.getVarColumnWidth(srcValue, cd);
            }
            newRowLength += newColWidth - oldColWidth;
        } else {
            newRowLength = currentFormat.nVersionBytes;
            int nCols = currentFormat.positionMap.length;
            for (int colIndex = 0; colIndex < nCols; ++colIndex) {
                int newColWidth;
                ColumnDescriptor cd = currentFormat.columns[colIndex];
                if (colIndex == columnIndex) {
                    newColWidth = cd.fixedWidth;
                    DataTypeDescriptor dtd = cd.columnType;
                    if (srcValue.getTypeFormatId() != dtd.getDVDTypeFormatId()) {
                        DataValueDescriptor newValue = dtd.getNull();
                        newValue.setValue(srcValue);
                        srcValue = newValue;
                    }
                    if (newColWidth == -1) {
                        newColWidth = currentFormat.getVarColumnWidth(srcValue, cd);
                        newColWidth += currentFormat.offsetBytes;
                    }
                } else {
                    newColWidth = this.getTotalColumnWidth(colIndex, rowToChange, cd, currentFormat, false);
                }
                newRowLength += newColWidth;
            }
        }
        byte[] newBytes = new byte[newRowLength];
        currentFormat.writeVersion(newBytes);
        int varDataOffset = currentFormat.varDataOffset;
        int nCols = currentFormat.positionMap.length;
        for (int index = 0; index < nCols; ++index) {
            if (index == columnIndex) {
                varDataOffset += currentFormat.generateColumn(index, srcValue, currentFormat.columns[index], newBytes, varDataOffset);
                continue;
            }
            varDataOffset += currentFormat.copyColumn(index, rowToChange, this, newBytes, index, varDataOffset);
        }
        return newBytes;
    }

    final byte[] setColumn(int columnIndex, DataValueDescriptor srcValue, UnsafeWrapper unsafe, long memAddr, int bytesLen, RowFormatter currentFormat) throws StandardException {
        int newRowLength;
        boolean isLatestSchema;
        boolean bl = isLatestSchema = this.schemaVersion == currentFormat.schemaVersion;
        if (isLatestSchema) {
            newRowLength = bytesLen;
            ColumnDescriptor cd = this.columns[columnIndex];
            int oldColWidth = this.getColumnWidth(columnIndex, unsafe, memAddr, bytesLen, cd);
            int newColWidth = cd.fixedWidth;
            DataTypeDescriptor dtd = cd.columnType;
            if (srcValue.getTypeFormatId() != dtd.getDVDTypeFormatId()) {
                DataValueDescriptor newValue = dtd.getNull();
                newValue.setValue(srcValue);
                srcValue = newValue;
            }
            if (newColWidth == -1) {
                newColWidth = this.getVarColumnWidth(srcValue, cd);
            }
            newRowLength += newColWidth - oldColWidth;
        } else {
            newRowLength = currentFormat.nVersionBytes;
            int nCols = currentFormat.positionMap.length;
            for (int colIndex = 0; colIndex < nCols; ++colIndex) {
                int newColWidth;
                ColumnDescriptor cd = currentFormat.columns[colIndex];
                if (colIndex == columnIndex) {
                    newColWidth = cd.fixedWidth;
                    DataTypeDescriptor dtd = cd.columnType;
                    if (srcValue.getTypeFormatId() != dtd.getDVDTypeFormatId()) {
                        DataValueDescriptor newValue = dtd.getNull();
                        newValue.setValue(srcValue);
                        srcValue = newValue;
                    }
                    if (newColWidth == -1) {
                        newColWidth = currentFormat.getVarColumnWidth(srcValue, cd);
                        newColWidth += currentFormat.offsetBytes;
                    }
                } else {
                    newColWidth = this.getTotalColumnWidth(colIndex, unsafe, memAddr, bytesLen, cd, currentFormat, false);
                }
                newRowLength += newColWidth;
            }
        }
        byte[] newBytes = new byte[newRowLength];
        currentFormat.writeVersion(newBytes);
        int varDataOffset = currentFormat.varDataOffset;
        int nCols = currentFormat.positionMap.length;
        for (int index = 0; index < nCols; ++index) {
            if (index == columnIndex) {
                varDataOffset += currentFormat.generateColumn(index, srcValue, currentFormat.columns[index], newBytes, varDataOffset);
                continue;
            }
            varDataOffset += currentFormat.copyColumn(index, unsafe, memAddr, bytesLen, this, newBytes, index, varDataOffset);
        }
        return newBytes;
    }

    final byte[] setColumn(int columnIndex, DataValueDescriptor srcValue, OffHeapRow rowToChange, RowFormatter currentFormat) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = rowToChange.getLength();
        long memAddr = rowToChange.getUnsafeAddress(0, bytesLen);
        return this.setColumn(columnIndex, srcValue, unsafe, memAddr, bytesLen, currentFormat);
    }

    final byte[] setColumn(int columnIndex, DataValueDescriptor srcValue, OffHeapByteSource rowToChange, RowFormatter currentFormat) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = rowToChange.getLength();
        long memAddr = rowToChange.getUnsafeAddress(0, bytesLen);
        return this.setColumn(columnIndex, srcValue, unsafe, memAddr, bytesLen, currentFormat);
    }

    final byte[] setByteCompactColumns(FormatableBitSet columns, DataValueDescriptor[] srcValues) throws StandardException {
        if (columns == null) {
            return this.generateBytes(srcValues);
        }
        assert (columns.getNumBitsSet() > 0) : "setColumns with zero columns to set: " + RowUtil.toString(srcValues);
        int nCols = srcValues.length;
        int rowLength = this.nVersionBytes;
        int colIndex = columns.anySetBit();
        int index = 0;
        while (colIndex != -1 && colIndex < nCols) {
            ColumnDescriptor cd = this.columns[index];
            int colWidth = cd.fixedWidth;
            if (colWidth == -1) {
                colWidth = this.getVarColumnWidth(srcValues[colIndex], cd);
                colWidth += this.offsetBytes;
            }
            rowLength += colWidth;
            colIndex = columns.anySetBit(colIndex);
            ++index;
        }
        byte[] newBytes = new byte[rowLength];
        this.writeVersion(newBytes);
        int varDataOffset = this.varDataOffset;
        int colIndex2 = columns.anySetBit();
        int index2 = 0;
        while (colIndex2 != -1 && colIndex2 < nCols) {
            varDataOffset += this.generateColumn(index2, srcValues[colIndex2], this.columns[index2], newBytes, varDataOffset);
            colIndex2 = columns.anySetBit(colIndex2);
            ++index2;
        }
        return newBytes;
    }

    final byte[] setColumns(int nCols, DataValueDescriptor[] srcValues, byte[] rowToChange) throws StandardException {
        assert (nCols > 0) : "setColumns with zero columns to set: " + RowUtil.toString(srcValues);
        if (rowToChange == null) {
            return this.generateColumns(nCols, srcValues);
        }
        int newRowLength = rowToChange.length;
        for (int colIndex = 0; colIndex < nCols; ++colIndex) {
            ColumnDescriptor cd = this.columns[colIndex];
            int oldColWidth = this.getColumnWidth(colIndex, rowToChange, cd);
            int newColWidth = cd.fixedWidth;
            if (newColWidth == -1) {
                newColWidth = this.getVarColumnWidth(srcValues[colIndex], cd);
            }
            newRowLength += newColWidth - oldColWidth;
        }
        byte[] newBytes = new byte[newRowLength];
        this.writeVersion(newBytes);
        int varDataOffset = this.varDataOffset;
        int numCols = this.positionMap.length;
        for (int index = 0; index < numCols; ++index) {
            if (index < nCols) {
                varDataOffset += this.generateColumn(index, srcValues[index], this.columns[index], newBytes, varDataOffset);
                continue;
            }
            varDataOffset += this.copyColumn(index, rowToChange, this, newBytes, index, varDataOffset);
        }
        return newBytes;
    }

    final byte[] setColumns(int nCols, DataValueDescriptor[] srcValues, UnsafeWrapper unsafe, long memAddr, int bytesLen) throws StandardException {
        int newRowLength = bytesLen;
        for (int colIndex = 0; colIndex < nCols; ++colIndex) {
            ColumnDescriptor cd = this.columns[colIndex];
            int oldColWidth = this.getColumnWidth(colIndex, unsafe, memAddr, bytesLen, cd);
            int newColWidth = cd.fixedWidth;
            if (newColWidth == -1) {
                newColWidth = this.getVarColumnWidth(srcValues[colIndex], cd);
            }
            newRowLength += newColWidth - oldColWidth;
        }
        byte[] newBytes = new byte[newRowLength];
        this.writeVersion(newBytes);
        int varDataOffset = this.varDataOffset;
        int numCols = this.positionMap.length;
        for (int index = 0; index < numCols; ++index) {
            if (index < nCols) {
                varDataOffset += this.generateColumn(index, srcValues[index], this.columns[index], newBytes, varDataOffset);
                continue;
            }
            varDataOffset += this.copyColumn(index, unsafe, memAddr, bytesLen, this, newBytes, index, varDataOffset);
        }
        return newBytes;
    }

    final byte[] setColumns(int nCols, DataValueDescriptor[] srcValues, OffHeapRow rowToChange) throws StandardException {
        assert (nCols > 0) : "setColumns with zero columns to set: " + RowUtil.toString(srcValues);
        if (rowToChange == null) {
            return this.generateColumns(nCols, srcValues);
        }
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = rowToChange.getLength();
        long memAddr = rowToChange.getUnsafeAddress(0, bytesLen);
        return this.setColumns(nCols, srcValues, unsafe, memAddr, bytesLen);
    }

    final byte[] setColumns(int nCols, DataValueDescriptor[] srcValues, OffHeapByteSource rowToChange) throws StandardException {
        assert (nCols > 0) : "setColumns with zero columns to set: " + RowUtil.toString(srcValues);
        if (rowToChange == null) {
            return this.generateColumns(nCols, srcValues);
        }
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = rowToChange.getLength();
        long memAddr = rowToChange.getUnsafeAddress(0, bytesLen);
        return this.setColumns(nCols, srcValues, unsafe, memAddr, bytesLen);
    }

    final byte[][] setColumns(FormatableBitSet columns, DataValueDescriptor[] srcValues, OffHeapRowWithLobs rowToChange, OffHeapByteSource firstBytesToChange, RowFormatter currentFormat, boolean prepareForOffHeap) throws StandardException {
        FormatableBitSet byteArrayChanged;
        byte[][] newByteArrayArray;
        boolean copyLobsByValue;
        int newColWidth;
        int newFirstLength;
        long memAddr;
        int bytesLen;
        boolean isLatestSchema;
        boolean bl = isLatestSchema = this.schemaVersion == currentFormat.schemaVersion;
        if (columns == null) {
            if (isLatestSchema) {
                return this.generateByteArrays(srcValues);
            }
            return currentFormat.generateByteArrays(srcValues);
        }
        assert (columns.getNumBitsSet() > 0) : "setColumns with zero columns to set: " + RowUtil.toString(srcValues);
        int bitSetSize = columns.getLength();
        boolean hasFirstBytesChange = false;
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        if (rowToChange != null) {
            bytesLen = rowToChange.getLength();
            memAddr = rowToChange.getUnsafeAddress(0, bytesLen);
        } else {
            bytesLen = firstBytesToChange.getLength();
            memAddr = firstBytesToChange.getUnsafeAddress(0, bytesLen);
        }
        if (isLatestSchema) {
            newFirstLength = bytesLen;
            hasFirstBytesChange = false;
            int colIndex = columns.anySetBit();
            while (colIndex != -1) {
                ColumnDescriptor cd = this.columns[colIndex];
                if (!cd.isLob) {
                    int oldColWidth = this.getColumnWidth(colIndex, unsafe, memAddr, bytesLen, cd);
                    newColWidth = cd.fixedWidth;
                    if (newColWidth == -1) {
                        newColWidth = this.getVarColumnWidth(srcValues[colIndex], cd);
                    }
                    newFirstLength += newColWidth - oldColWidth;
                    hasFirstBytesChange = true;
                }
                colIndex = columns.anySetBit(colIndex);
            }
        } else {
            newFirstLength = currentFormat.nVersionBytes;
            int nCols = currentFormat.positionMap.length;
            for (int colIndex = 0; colIndex < nCols; ++colIndex) {
                ColumnDescriptor cd = currentFormat.columns[colIndex];
                if (cd.isLob) continue;
                if (colIndex < bitSetSize && columns.isSet(colIndex)) {
                    newColWidth = cd.fixedWidth;
                    if (newColWidth == -1) {
                        newColWidth = currentFormat.getVarColumnWidth(srcValues[colIndex], cd);
                        newColWidth += currentFormat.offsetBytes;
                    }
                } else {
                    newColWidth = this.getTotalColumnWidth(colIndex, unsafe, memAddr, bytesLen, cd, currentFormat, false);
                }
                newFirstLength += newColWidth;
                hasFirstBytesChange = true;
            }
        }
        boolean bl2 = copyLobsByValue = !isLatestSchema || !this.container.isInitialized() || !prepareForOffHeap;
        if (prepareForOffHeap) {
            newByteArrayArray = new byte[currentFormat.numLobs + 2][];
            byteArrayChanged = new FormatableBitSet(newByteArrayArray.length - 1);
        } else {
            newByteArrayArray = new byte[currentFormat.numLobs + 1][];
            byteArrayChanged = null;
        }
        byte[] newFirstBytes = null;
        if (hasFirstBytesChange || !this.container.isInitialized()) {
            newFirstBytes = new byte[newFirstLength];
            newByteArrayArray[0] = newFirstBytes;
            if (prepareForOffHeap) {
                byteArrayChanged.set(0);
            }
            currentFormat.writeVersion(newFirstBytes);
        } else {
            newByteArrayArray[0] = (byte[])(prepareForOffHeap ? null : (rowToChange != null ? rowToChange.getRowBytes() : firstBytesToChange.getRowBytes()));
        }
        int varDataOffset = currentFormat.varDataOffset;
        int nCols = currentFormat.positionMap.length;
        for (int index = 0; index < nCols; ++index) {
            int lobIndx;
            ColumnDescriptor cd = currentFormat.columns[index];
            if (index < bitSetSize && columns.isSet(index)) {
                DataValueDescriptor dvd = srcValues[index];
                if (!cd.isLob) {
                    varDataOffset += currentFormat.generateColumn(index, dvd, cd, newFirstBytes, varDataOffset);
                    continue;
                }
                lobIndx = currentFormat.positionMap[index];
                newByteArrayArray[lobIndx] = currentFormat.generateLobColumn(dvd, cd);
                if (!prepareForOffHeap) continue;
                byteArrayChanged.set(lobIndx);
                continue;
            }
            if (!cd.isLob) {
                if (!hasFirstBytesChange && this.container.isInitialized()) continue;
                varDataOffset += currentFormat.copyColumn(index, unsafe, memAddr, bytesLen, this, newFirstBytes, index, varDataOffset);
                continue;
            }
            int lobIndex = this.positionMap[index];
            Object lobBytes = lobIndex > 0 && rowToChange != null ? (Object)(copyLobsByValue ? rowToChange.getGfxdBytes(lobIndex) : null) : cd.columnDefaultBytes;
            if (isLatestSchema) {
                newByteArrayArray[lobIndex] = lobBytes;
                if (lobBytes == null || !prepareForOffHeap) continue;
                byteArrayChanged.set(lobIndex);
                continue;
            }
            lobIndx = currentFormat.positionMap[index];
            newByteArrayArray[lobIndx] = lobBytes;
            if (lobBytes == null && !copyLobsByValue || !prepareForOffHeap) continue;
            byteArrayChanged.set(lobIndx);
        }
        if (prepareForOffHeap) {
            newByteArrayArray[newByteArrayArray.length - 1] = byteArrayChanged.getByteArray();
        }
        return newByteArrayArray;
    }

    final byte[][] setColumns(FormatableBitSet columns, DataValueDescriptor[] srcValues, byte[][] rowToChange, byte[] firstBytesToChange, RowFormatter currentFormat) throws StandardException {
        int newFirstLength;
        boolean isLatestSchema;
        boolean bl = isLatestSchema = this.schemaVersion == currentFormat.schemaVersion;
        if (columns == null || rowToChange == null && firstBytesToChange == null) {
            if (isLatestSchema) {
                return this.generateByteArrays(srcValues);
            }
            return currentFormat.generateByteArrays(srcValues);
        }
        assert (columns.getNumBitsSet() > 0) : "setColumns with zero columns to set: " + RowUtil.toString(srcValues);
        int bitSetSize = columns.getLength();
        boolean hasFirstBytesChange = false;
        if (firstBytesToChange == null) {
            firstBytesToChange = rowToChange[0];
        }
        if (firstBytesToChange != null) {
            int newColWidth;
            if (isLatestSchema) {
                newFirstLength = firstBytesToChange.length;
                hasFirstBytesChange = false;
                int colIndex = columns.anySetBit();
                while (colIndex != -1) {
                    ColumnDescriptor cd = this.columns[colIndex];
                    if (!cd.isLob) {
                        int oldColWidth = this.getColumnWidth(colIndex, firstBytesToChange, cd);
                        newColWidth = cd.fixedWidth;
                        if (newColWidth == -1) {
                            newColWidth = this.getVarColumnWidth(srcValues[colIndex], cd);
                        }
                        newFirstLength += newColWidth - oldColWidth;
                        hasFirstBytesChange = true;
                    }
                    colIndex = columns.anySetBit(colIndex);
                }
            } else {
                newFirstLength = currentFormat.nVersionBytes;
                int nCols = currentFormat.positionMap.length;
                for (int colIndex = 0; colIndex < nCols; ++colIndex) {
                    ColumnDescriptor cd = currentFormat.columns[colIndex];
                    if (cd.isLob) continue;
                    if (colIndex < bitSetSize && columns.isSet(colIndex)) {
                        newColWidth = cd.fixedWidth;
                        if (newColWidth == -1) {
                            newColWidth = currentFormat.getVarColumnWidth(srcValues[colIndex], cd);
                            newColWidth += currentFormat.offsetBytes;
                        }
                    } else {
                        newColWidth = this.getTotalColumnWidth(colIndex, firstBytesToChange, cd, currentFormat, false);
                    }
                    newFirstLength += newColWidth;
                    hasFirstBytesChange = true;
                }
            }
        } else {
            firstBytesToChange = currentFormat.generateColumns(columns, srcValues);
            newFirstLength = 0;
        }
        byte[][] newByteArrayArray = new byte[currentFormat.numLobs + 1][];
        byte[] newFirstBytes = null;
        if (hasFirstBytesChange) {
            newFirstBytes = new byte[newFirstLength];
            newByteArrayArray[0] = newFirstBytes;
            currentFormat.writeVersion(newFirstBytes);
        } else {
            newByteArrayArray[0] = firstBytesToChange;
        }
        int varDataOffset = currentFormat.varDataOffset;
        int nCols = currentFormat.positionMap.length;
        for (int index = 0; index < nCols; ++index) {
            byte[] lobBytes;
            ColumnDescriptor cd = currentFormat.columns[index];
            if (index < bitSetSize && columns.isSet(index)) {
                DataValueDescriptor dvd = srcValues[index];
                if (!cd.isLob) {
                    varDataOffset += currentFormat.generateColumn(index, dvd, cd, newFirstBytes, varDataOffset);
                    continue;
                }
                newByteArrayArray[currentFormat.positionMap[index]] = currentFormat.generateLobColumn(dvd, cd);
                continue;
            }
            if (!cd.isLob) {
                if (!hasFirstBytesChange) continue;
                varDataOffset += currentFormat.copyColumn(index, firstBytesToChange, this, newFirstBytes, index, varDataOffset);
                continue;
            }
            int lobIndex = this.positionMap[index];
            byte[] byArray = lobBytes = lobIndex > 0 && rowToChange != null ? rowToChange[lobIndex] : cd.columnDefaultBytes;
            if (isLatestSchema) {
                newByteArrayArray[lobIndex] = lobBytes;
                continue;
            }
            newByteArrayArray[currentFormat.positionMap[index]] = lobBytes;
        }
        return newByteArrayArray;
    }

    final byte[][] setColumn(int columnIndex, DataValueDescriptor srcValue, OffHeapRowWithLobs rowToChange, OffHeapByteSource firstBytesToChange, RowFormatter currentFormat) throws StandardException {
        int newFirstLength;
        long memAddr;
        int bytesLen;
        boolean isLatestSchema = this.schemaVersion == currentFormat.schemaVersion;
        boolean hasFirstBytesChange = false;
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        if (rowToChange != null) {
            bytesLen = rowToChange.getLength();
            memAddr = rowToChange.getUnsafeAddress(0, bytesLen);
        } else {
            bytesLen = firstBytesToChange.getLength();
            memAddr = firstBytesToChange.getUnsafeAddress(0, bytesLen);
        }
        if (isLatestSchema) {
            newFirstLength = bytesLen;
            hasFirstBytesChange = false;
            ColumnDescriptor cd = this.columns[columnIndex];
            if (!cd.isLob) {
                int oldColWidth = this.getColumnWidth(columnIndex, unsafe, memAddr, bytesLen, cd);
                int newColWidth = cd.fixedWidth;
                DataTypeDescriptor dtd = cd.columnType;
                if (srcValue.getTypeFormatId() != dtd.getDVDTypeFormatId()) {
                    DataValueDescriptor newValue = dtd.getNull();
                    newValue.setValue(srcValue);
                    srcValue = newValue;
                }
                if (newColWidth == -1) {
                    newColWidth = this.getVarColumnWidth(srcValue, cd);
                }
                newFirstLength += newColWidth - oldColWidth;
                hasFirstBytesChange = true;
            }
        } else {
            newFirstLength = currentFormat.nVersionBytes;
            int nCols = currentFormat.positionMap.length;
            for (int colIndex = 0; colIndex < nCols; ++colIndex) {
                int newColWidth;
                ColumnDescriptor cd = currentFormat.columns[colIndex];
                if (cd.isLob) continue;
                if (colIndex == columnIndex) {
                    newColWidth = cd.fixedWidth;
                    DataTypeDescriptor dtd = cd.columnType;
                    if (srcValue.getTypeFormatId() != dtd.getDVDTypeFormatId()) {
                        DataValueDescriptor newValue = dtd.getNull();
                        newValue.setValue(srcValue);
                        srcValue = newValue;
                    }
                    if (newColWidth == -1) {
                        newColWidth = currentFormat.getVarColumnWidth(srcValue, cd);
                        newColWidth += currentFormat.offsetBytes;
                    }
                } else {
                    newColWidth = this.getTotalColumnWidth(colIndex, unsafe, memAddr, bytesLen, cd, currentFormat, false);
                }
                newFirstLength += newColWidth;
                hasFirstBytesChange = true;
            }
        }
        byte[][] newByteArrayArray = new byte[currentFormat.numLobs + 1][];
        byte[] newFirstBytes = null;
        if (hasFirstBytesChange) {
            newFirstBytes = new byte[newFirstLength];
            newByteArrayArray[0] = newFirstBytes;
            currentFormat.writeVersion(newFirstBytes);
        } else {
            newByteArrayArray[0] = rowToChange != null ? rowToChange.getRowBytes() : firstBytesToChange.getRowBytes();
        }
        int varDataOffset = currentFormat.varDataOffset;
        int nCols = currentFormat.positionMap.length;
        for (int index = 0; index < nCols; ++index) {
            ColumnDescriptor cd = currentFormat.columns[index];
            if (index == columnIndex) {
                if (!cd.isLob) {
                    varDataOffset += currentFormat.generateColumn(index, srcValue, cd, newFirstBytes, varDataOffset);
                    continue;
                }
                newByteArrayArray[currentFormat.positionMap[index]] = currentFormat.generateLobColumn(srcValue, cd);
                continue;
            }
            if (!cd.isLob) {
                if (!hasFirstBytesChange) continue;
                varDataOffset += currentFormat.copyColumn(index, unsafe, memAddr, bytesLen, this, newFirstBytes, index, varDataOffset);
                continue;
            }
            int lobIndex = this.positionMap[index];
            byte[] lobBytes = lobIndex > 0 && rowToChange != null ? rowToChange.getGfxdBytes(lobIndex) : cd.columnDefaultBytes;
            if (isLatestSchema) {
                newByteArrayArray[lobIndex] = lobBytes;
                continue;
            }
            newByteArrayArray[currentFormat.positionMap[index]] = lobBytes;
        }
        return newByteArrayArray;
    }

    final byte[][] setColumn(int columnIndex, DataValueDescriptor srcValue, byte[][] rowToChange, RowFormatter currentFormat) throws StandardException {
        int newFirstLength;
        boolean isLatestSchema = this.schemaVersion == currentFormat.schemaVersion;
        byte[] firstBytes = rowToChange[0];
        boolean hasFirstBytesChange = false;
        if (isLatestSchema) {
            newFirstLength = firstBytes.length;
            hasFirstBytesChange = false;
            ColumnDescriptor cd = this.columns[columnIndex];
            if (!cd.isLob) {
                int oldColWidth = this.getColumnWidth(columnIndex, firstBytes, cd);
                int newColWidth = cd.fixedWidth;
                DataTypeDescriptor dtd = cd.columnType;
                if (srcValue.getTypeFormatId() != dtd.getDVDTypeFormatId()) {
                    DataValueDescriptor newValue = dtd.getNull();
                    newValue.setValue(srcValue);
                    srcValue = newValue;
                }
                if (newColWidth == -1) {
                    newColWidth = this.getVarColumnWidth(srcValue, cd);
                }
                newFirstLength += newColWidth - oldColWidth;
                hasFirstBytesChange = true;
            }
        } else {
            newFirstLength = currentFormat.nVersionBytes;
            int nCols = currentFormat.positionMap.length;
            for (int colIndex = 0; colIndex < nCols; ++colIndex) {
                int newColWidth;
                ColumnDescriptor cd = currentFormat.columns[colIndex];
                if (cd.isLob) continue;
                if (colIndex == columnIndex) {
                    newColWidth = cd.fixedWidth;
                    DataTypeDescriptor dtd = cd.columnType;
                    if (srcValue.getTypeFormatId() != dtd.getDVDTypeFormatId()) {
                        DataValueDescriptor newValue = dtd.getNull();
                        newValue.setValue(srcValue);
                        srcValue = newValue;
                    }
                    if (newColWidth == -1) {
                        newColWidth = currentFormat.getVarColumnWidth(srcValue, cd);
                        newColWidth += currentFormat.offsetBytes;
                    }
                } else {
                    newColWidth = this.getTotalColumnWidth(colIndex, firstBytes, cd, currentFormat, false);
                }
                newFirstLength += newColWidth;
                hasFirstBytesChange = true;
            }
        }
        byte[][] newByteArrayArray = new byte[currentFormat.numLobs + 1][];
        byte[] newFirstBytes = null;
        if (hasFirstBytesChange) {
            newFirstBytes = new byte[newFirstLength];
            newByteArrayArray[0] = newFirstBytes;
            currentFormat.writeVersion(newFirstBytes);
        } else {
            newByteArrayArray[0] = firstBytes;
        }
        int varDataOffset = currentFormat.varDataOffset;
        int nCols = currentFormat.positionMap.length;
        for (int index = 0; index < nCols; ++index) {
            byte[] lobBytes;
            ColumnDescriptor cd = currentFormat.columns[index];
            if (index == columnIndex) {
                if (!cd.isLob) {
                    varDataOffset += currentFormat.generateColumn(index, srcValue, cd, newFirstBytes, varDataOffset);
                    continue;
                }
                newByteArrayArray[currentFormat.positionMap[index]] = currentFormat.generateLobColumn(srcValue, cd);
                continue;
            }
            if (!cd.isLob) {
                if (!hasFirstBytesChange) continue;
                varDataOffset += currentFormat.copyColumn(index, firstBytes, this, newFirstBytes, index, varDataOffset);
                continue;
            }
            int lobIndex = this.positionMap[index];
            byte[] byArray = lobBytes = lobIndex > 0 ? rowToChange[lobIndex] : cd.columnDefaultBytes;
            if (isLatestSchema) {
                newByteArrayArray[lobIndex] = lobBytes;
                continue;
            }
            newByteArrayArray[currentFormat.positionMap[index]] = lobBytes;
        }
        return newByteArrayArray;
    }

    final byte[][] setByteArrayCompactColumns(FormatableBitSet columns, DataValueDescriptor[] srcValues) throws StandardException {
        if (columns == null) {
            return this.generateByteArrays(srcValues);
        }
        assert (columns.getNumBitsSet() > 0) : "setColumns with zero columns to set: " + RowUtil.toString(srcValues);
        int nCols = srcValues.length;
        int firstRowLength = this.nVersionBytes;
        int colIndex = columns.anySetBit();
        int index = 0;
        while (colIndex != -1 && colIndex < nCols) {
            ColumnDescriptor cd = this.columns[index];
            if (!cd.isLob) {
                int colWidth = cd.fixedWidth;
                if (colWidth == -1) {
                    colWidth = this.getVarColumnWidth(srcValues[colIndex], cd);
                    colWidth += this.offsetBytes;
                }
                firstRowLength += colWidth;
            }
            colIndex = columns.anySetBit(colIndex);
            ++index;
        }
        byte[][] newByteArrayArray = new byte[this.numLobs + 1][];
        byte[] newFirstBytes = new byte[firstRowLength];
        newByteArrayArray[0] = newFirstBytes;
        this.writeVersion(newFirstBytes);
        int varDataOffset = this.varDataOffset;
        int colIndex2 = columns.anySetBit();
        int index2 = 0;
        while (colIndex2 != -1 && colIndex2 < nCols) {
            ColumnDescriptor cd = this.columns[index2];
            DataValueDescriptor dvd = srcValues[colIndex2];
            if (!cd.isLob) {
                varDataOffset += this.generateColumn(index2, dvd, cd, newFirstBytes, varDataOffset);
            } else {
                newByteArrayArray[this.positionMap[index2]] = this.generateLobColumn(dvd, cd);
            }
            colIndex2 = columns.anySetBit(colIndex2);
            ++index2;
        }
        return newByteArrayArray;
    }

    final byte[][] setColumns(int nCols, DataValueDescriptor[] srcValues, OffHeapRowWithLobs rowToChange, OffHeapByteSource firstBytesToChange) throws StandardException {
        long memAddr;
        int bytesLen;
        assert (nCols > 0) : "setColumns with zero columns to set: " + RowUtil.toString(srcValues);
        boolean hasFirstBytesChange = false;
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        if (rowToChange != null) {
            bytesLen = rowToChange.getLength();
            memAddr = rowToChange.getUnsafeAddress(0, bytesLen);
        } else {
            bytesLen = firstBytesToChange.getLength();
            memAddr = firstBytesToChange.getUnsafeAddress(0, bytesLen);
        }
        int newFirstLength = bytesLen;
        hasFirstBytesChange = false;
        for (int colIndex = 0; colIndex < nCols; ++colIndex) {
            ColumnDescriptor cd = this.columns[colIndex];
            if (cd.isLob) continue;
            int oldColWidth = this.getColumnWidth(colIndex, unsafe, memAddr, bytesLen, cd);
            int newColWidth = cd.fixedWidth;
            if (newColWidth == -1) {
                newColWidth = this.getVarColumnWidth(srcValues[colIndex], cd);
            }
            newFirstLength += newColWidth - oldColWidth;
            hasFirstBytesChange = true;
        }
        byte[][] newByteArrayArray = new byte[this.numLobs + 1][];
        byte[] newFirstBytes = null;
        if (hasFirstBytesChange) {
            newFirstBytes = new byte[newFirstLength];
            newByteArrayArray[0] = newFirstBytes;
            this.writeVersion(newFirstBytes);
        } else {
            newByteArrayArray[0] = rowToChange != null ? rowToChange.getRowBytes() : firstBytesToChange.getRowBytes();
        }
        int varDataOffset = this.varDataOffset;
        int numCols = this.positionMap.length;
        for (int index = 0; index < numCols; ++index) {
            ColumnDescriptor cd = this.columns[index];
            if (index < nCols) {
                DataValueDescriptor dvd = srcValues[index];
                if (!cd.isLob) {
                    varDataOffset += this.generateColumn(index, dvd, cd, newFirstBytes, varDataOffset);
                    continue;
                }
                newByteArrayArray[this.positionMap[index]] = this.generateLobColumn(dvd, cd);
                continue;
            }
            if (!cd.isLob) {
                if (!hasFirstBytesChange) continue;
                varDataOffset += this.copyColumn(index, unsafe, memAddr, bytesLen, this, newFirstBytes, index, varDataOffset);
                continue;
            }
            int lobIndex = this.positionMap[index];
            newByteArrayArray[lobIndex] = lobIndex != 0 && rowToChange != null ? rowToChange.getGfxdBytes(lobIndex) : cd.columnDefaultBytes;
        }
        return newByteArrayArray;
    }

    final byte[][] setColumns(int nCols, DataValueDescriptor[] srcValues, byte[][] rowToChange) throws StandardException {
        int newFirstLength;
        assert (nCols > 0) : "setColumns with zero columns to set: " + RowUtil.toString(srcValues);
        if (rowToChange == null) {
            return this.generateByteArrays(srcValues);
        }
        byte[] firstBytes = rowToChange[0];
        boolean hasFirstBytesChange = false;
        if (firstBytes != null) {
            newFirstLength = firstBytes.length;
            hasFirstBytesChange = false;
            for (int colIndex = 0; colIndex < nCols; ++colIndex) {
                ColumnDescriptor cd = this.columns[colIndex];
                if (cd.isLob) continue;
                int oldColWidth = this.getColumnWidth(colIndex, firstBytes, cd);
                int newColWidth = cd.fixedWidth;
                if (newColWidth == -1) {
                    newColWidth = this.getVarColumnWidth(srcValues[colIndex], cd);
                }
                newFirstLength += newColWidth - oldColWidth;
                hasFirstBytesChange = true;
            }
        } else {
            firstBytes = this.generateColumns(nCols, srcValues);
            newFirstLength = 0;
        }
        byte[][] newByteArrayArray = new byte[this.numLobs + 1][];
        byte[] newFirstBytes = null;
        if (hasFirstBytesChange) {
            newFirstBytes = new byte[newFirstLength];
            newByteArrayArray[0] = newFirstBytes;
            this.writeVersion(newFirstBytes);
        } else {
            newByteArrayArray[0] = firstBytes;
        }
        int varDataOffset = this.varDataOffset;
        int numCols = this.positionMap.length;
        for (int index = 0; index < numCols; ++index) {
            ColumnDescriptor cd = this.columns[index];
            if (index < nCols) {
                DataValueDescriptor dvd = srcValues[index];
                if (!cd.isLob) {
                    varDataOffset += this.generateColumn(index, dvd, cd, newFirstBytes, varDataOffset);
                    continue;
                }
                newByteArrayArray[this.positionMap[index]] = this.generateLobColumn(dvd, cd);
                continue;
            }
            if (!cd.isLob) {
                if (!hasFirstBytesChange) continue;
                varDataOffset += this.copyColumn(index, firstBytes, this, newFirstBytes, index, varDataOffset);
                continue;
            }
            int lobIndex = this.positionMap[index];
            newByteArrayArray[lobIndex] = lobIndex != 0 ? rowToChange[lobIndex] : cd.columnDefaultBytes;
        }
        return newByteArrayArray;
    }

    private final byte[] generateColumns(FormatableBitSet columns, DataValueDescriptor[] srcValues) throws StandardException {
        int newRowLength = this.nVersionBytes;
        int colIndex = columns.anySetBit();
        while (colIndex != -1) {
            ColumnDescriptor cd = this.columns[colIndex];
            int newColWidth = cd.fixedWidth;
            if (newColWidth == -1) {
                newColWidth = this.getVarColumnWidth(srcValues[colIndex], cd);
                newColWidth += this.offsetBytes;
            }
            newRowLength += newColWidth;
            colIndex = columns.anySetBit(colIndex);
        }
        byte[] newBytes = new byte[newRowLength];
        this.writeVersion(newBytes);
        int varDataOffset = this.varDataOffset;
        int bitSetSize = columns.getLength();
        int numCols = this.positionMap.length;
        for (int idx = 0; idx < numCols; ++idx) {
            ColumnDescriptor cd = this.columns[idx];
            if (cd.isLob) continue;
            if (idx < bitSetSize && columns.isSet(idx)) {
                varDataOffset += this.generateColumn(idx, srcValues[idx], this.columns[idx], newBytes, varDataOffset);
                continue;
            }
            int width = cd.fixedWidth;
            if (width != -1) continue;
            int offsetOffset = newRowLength + this.positionMap[idx];
            if (cd.columnDefault == null) {
                RowFormatter.writeInt(newBytes, this.getNullIndicator(varDataOffset), offsetOffset, this.offsetBytes);
                continue;
            }
            RowFormatter.writeInt(newBytes, this.offsetIsDefault, offsetOffset, this.offsetBytes);
        }
        return newBytes;
    }

    private final byte[] generateColumns(int nCols, DataValueDescriptor[] srcValues) throws StandardException {
        int newRowLength = this.nVersionBytes;
        for (int colIndex = 0; colIndex < nCols; ++colIndex) {
            ColumnDescriptor cd = this.columns[colIndex];
            int newColWidth = cd.fixedWidth;
            if (newColWidth == -1) {
                newColWidth = this.getVarColumnWidth(srcValues[colIndex], cd);
                newColWidth += this.offsetBytes;
            }
            newRowLength += newColWidth;
        }
        byte[] newBytes = new byte[newRowLength];
        this.writeVersion(newBytes);
        int varDataOffset = this.varDataOffset;
        int numCols = this.positionMap.length;
        for (int idx = 0; idx < numCols; ++idx) {
            ColumnDescriptor cd = this.columns[idx];
            if (cd.isLob) continue;
            if (idx < nCols) {
                varDataOffset += this.generateColumn(idx, srcValues[idx], this.columns[idx], newBytes, varDataOffset);
                continue;
            }
            int width = cd.fixedWidth;
            if (width != -1) continue;
            int offsetOffset = newRowLength + this.positionMap[idx];
            if (cd.columnDefault == null) {
                RowFormatter.writeInt(newBytes, this.getNullIndicator(varDataOffset), offsetOffset, this.offsetBytes);
                continue;
            }
            RowFormatter.writeInt(newBytes, this.offsetIsDefault, offsetOffset, this.offsetBytes);
        }
        return newBytes;
    }

    final byte[] setColumns(FormatableBitSet columns, byte[] srcRow, RowFormatter srcFormat, int[] baseColumnMap) throws StandardException {
        assert (columns.getNumBitsSet() > 0) : "setColumns with zero columns to set: " + Arrays.toString(srcRow);
        boolean isSameSchema = this.schemaVersion == srcFormat.schemaVersion;
        int newRowLength = this.nVersionBytes;
        int srcIndex = columns.anySetBit();
        int index = 0;
        while (srcIndex != -1) {
            ColumnDescriptor cd = srcFormat.columns[srcIndex];
            newRowLength += this.getTotalColumnWidth(srcIndex, srcRow, srcFormat, cd, index, isSameSchema);
            srcIndex = columns.anySetBit(srcIndex);
            ++index;
        }
        byte[] newBytes = new byte[newRowLength];
        this.writeVersion(newBytes);
        int varDataOffset = this.varDataOffset;
        int srcIndex2 = columns.anySetBit();
        int index2 = 0;
        while (srcIndex2 != -1) {
            varDataOffset += this.copyColumn(srcIndex2, srcRow, srcFormat, newBytes, index2, varDataOffset);
            if (baseColumnMap != null) {
                baseColumnMap[index2] = srcIndex2;
            }
            srcIndex2 = columns.anySetBit(srcIndex2);
            ++index2;
        }
        return newBytes;
    }

    final byte[] setColumns(FormatableBitSet columns, UnsafeWrapper unsafe, long memAddr, int bytesLen, RowFormatter srcFormat, int[] baseColumnMap) throws StandardException {
        boolean isSameSchema = this.schemaVersion == srcFormat.schemaVersion;
        int newRowLength = this.nVersionBytes;
        int srcIndex = columns.anySetBit();
        int index = 0;
        while (srcIndex != -1) {
            ColumnDescriptor cd = srcFormat.columns[srcIndex];
            newRowLength += this.getTotalColumnWidth(srcIndex, unsafe, memAddr, bytesLen, srcFormat, cd, index, isSameSchema);
            srcIndex = columns.anySetBit(srcIndex);
            ++index;
        }
        byte[] newBytes = new byte[newRowLength];
        this.writeVersion(newBytes);
        int varDataOffset = this.varDataOffset;
        int srcIndex2 = columns.anySetBit();
        int index2 = 0;
        while (srcIndex2 != -1) {
            varDataOffset += this.copyColumn(srcIndex2, unsafe, memAddr, bytesLen, srcFormat, newBytes, index2, varDataOffset);
            if (baseColumnMap != null) {
                baseColumnMap[index2] = srcIndex2;
            }
            srcIndex2 = columns.anySetBit(srcIndex2);
            ++index2;
        }
        return newBytes;
    }

    final byte[] setColumns(FormatableBitSet columns, OffHeapRow srcRow, RowFormatter srcFormat, int[] baseColumnMap) throws StandardException {
        assert (columns.getNumBitsSet() > 0) : "setColumns with zero columns to set: " + Arrays.toString(srcRow != null ? srcRow.getRowBytes() : null);
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = srcRow.getLength();
        long memAddr = srcRow.getUnsafeAddress(0, bytesLen);
        return this.setColumns(columns, unsafe, memAddr, bytesLen, srcFormat, baseColumnMap);
    }

    final byte[] setColumns(FormatableBitSet columns, OffHeapByteSource srcRow, RowFormatter srcFormat, int[] baseColumnMap) throws StandardException {
        assert (columns.getNumBitsSet() > 0) : "setColumns with zero columns to set: " + Arrays.toString(srcRow != null ? srcRow.getRowBytes() : null);
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = srcRow.getLength();
        long memAddr = srcRow.getUnsafeAddress(0, bytesLen);
        return this.setColumns(columns, unsafe, memAddr, bytesLen, srcFormat, baseColumnMap);
    }

    final byte[] setColumns(int[] columns, boolean zeroBased, byte[] srcRow, RowFormatter srcFormat) throws StandardException {
        int srcColIndex;
        assert (columns.length > 0) : "setColumns with zero columns to set: " + Arrays.toString(srcRow);
        boolean isSameSchema = this.schemaVersion == srcFormat.schemaVersion;
        int newRowLength = this.nVersionBytes;
        int numCols = columns.length;
        for (int index = 0; index < numCols; ++index) {
            srcColIndex = columns[index];
            if (!zeroBased) {
                --srcColIndex;
            }
            if (srcColIndex < 0) continue;
            ColumnDescriptor cd = srcFormat.columns[srcColIndex];
            newRowLength += this.getTotalColumnWidth(srcColIndex, srcRow, srcFormat, cd, index, isSameSchema);
        }
        byte[] newBytes = new byte[newRowLength];
        this.writeVersion(newBytes);
        int varDataOffset = this.varDataOffset;
        for (int index = 0; index < numCols; ++index) {
            srcColIndex = columns[index];
            if (!zeroBased) {
                --srcColIndex;
            }
            if (srcColIndex < 0) continue;
            varDataOffset += this.copyColumn(srcColIndex, srcRow, srcFormat, newBytes, index, varDataOffset);
        }
        return newBytes;
    }

    final byte[] setColumns(int[] columns, boolean zeroBased, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource srcRow, RowFormatter srcFormat) throws StandardException {
        int srcColIndex;
        boolean isSameSchema = this.schemaVersion == srcFormat.schemaVersion;
        int newRowLength = this.nVersionBytes;
        int numCols = columns.length;
        for (int index = 0; index < numCols; ++index) {
            srcColIndex = columns[index];
            if (!zeroBased) {
                --srcColIndex;
            }
            if (srcColIndex < 0) continue;
            ColumnDescriptor cd = srcFormat.columns[srcColIndex];
            newRowLength += this.getTotalColumnWidth(srcColIndex, unsafe, memAddr, bytesLen, srcFormat, cd, index, isSameSchema);
        }
        byte[] newBytes = new byte[newRowLength];
        this.writeVersion(newBytes);
        int varDataOffset = this.varDataOffset;
        for (int index = 0; index < numCols; ++index) {
            srcColIndex = columns[index];
            if (!zeroBased) {
                --srcColIndex;
            }
            if (srcColIndex < 0) continue;
            varDataOffset += this.copyColumn(srcColIndex, unsafe, memAddr, bytesLen, srcFormat, newBytes, index, varDataOffset);
        }
        return newBytes;
    }

    final byte[] setColumns(int[] columns, boolean zeroBased, OffHeapRow srcRow, RowFormatter srcFormat) throws StandardException {
        assert (columns.length > 0) : "setColumns with zero columns to set: " + Arrays.toString(srcRow != null ? srcRow.getRowBytes() : null);
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = srcRow.getLength();
        long memAddr = srcRow.getUnsafeAddress(0, bytesLen);
        return this.setColumns(columns, zeroBased, unsafe, memAddr, bytesLen, srcRow, srcFormat);
    }

    final byte[] setColumns(int[] columns, boolean zeroBased, OffHeapByteSource srcRow, RowFormatter srcFormat) throws StandardException {
        assert (columns.length > 0) : "setColumns with zero columns to set: " + Arrays.toString(srcRow != null ? srcRow.getRowBytes() : null);
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = srcRow.getLength();
        long memAddr = srcRow.getUnsafeAddress(0, bytesLen);
        return this.setColumns(columns, zeroBased, unsafe, memAddr, bytesLen, srcRow, srcFormat);
    }

    final byte[] copyColumns(int[] columns, boolean zeroBased, byte[] srcRow, RowFormatter srcFormat) throws StandardException {
        ColumnDescriptor cd;
        assert (columns.length > 0) : "setColumns with zero columns to set: " + Arrays.toString(srcRow);
        boolean isSameSchema = this.schemaVersion == srcFormat.schemaVersion;
        int newRowLength = this.nVersionBytes;
        int srcIndex = 0;
        int srcColIndex = columns[0];
        if (!zeroBased) {
            --srcColIndex;
        }
        int srcColZeroIndex = srcColIndex;
        int numCols = this.columns.length;
        for (int index = 0; index < numCols; ++index) {
            if (index == srcColIndex) {
                cd = srcFormat.columns[srcColIndex];
                newRowLength += this.getTotalColumnWidth(srcColIndex, srcRow, srcFormat, cd, index, isSameSchema);
                if (++srcIndex < columns.length) {
                    srcColIndex = columns[srcIndex];
                    if (zeroBased) continue;
                    --srcColIndex;
                    continue;
                }
                srcColIndex = -1;
                continue;
            }
            cd = this.columns[index];
            newRowLength += this.getTotalColumnWidth(index, null, this, cd, index, true);
        }
        byte[] newBytes = new byte[newRowLength];
        this.writeVersion(newBytes);
        int varDataOffset = this.varDataOffset;
        srcIndex = 0;
        srcColIndex = srcColZeroIndex;
        for (int index = 0; index < numCols; ++index) {
            if (index == srcColIndex) {
                varDataOffset += this.copyColumn(srcColIndex, srcRow, srcFormat, newBytes, index, varDataOffset);
                if (++srcIndex < columns.length) {
                    srcColIndex = columns[srcIndex];
                    if (zeroBased) continue;
                    --srcColIndex;
                    continue;
                }
                srcColIndex = -1;
                continue;
            }
            int offsetFromMap = this.positionMap[index];
            cd = this.columns[index];
            if (offsetFromMap >= this.nVersionBytes && !cd.isNullable) {
                DataValueDescriptor fixedZero = cd.columnType.getTypeId().getStaticZeroForFixedType();
                fixedZero.writeBytes(newBytes, offsetFromMap, cd.columnType);
                continue;
            }
            varDataOffset += this.generateColumn(index, null, cd, newBytes, varDataOffset);
        }
        return newBytes;
    }

    final byte[] copyColumns(int[] columns, boolean zeroBased, OffHeapByteSource srcRow, RowFormatter srcFormat) throws StandardException {
        ColumnDescriptor cd;
        assert (columns.length > 0) : "setColumns with zero columns to set: " + Arrays.toString(srcRow != null ? srcRow.getRowBytes() : null);
        boolean isSameSchema = this.schemaVersion == srcFormat.schemaVersion;
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = srcRow.getLength();
        long memAddr = srcRow.getUnsafeAddress(0, bytesLen);
        int newRowLength = this.nVersionBytes;
        int srcIndex = 0;
        int srcColIndex = columns[0];
        if (!zeroBased) {
            --srcColIndex;
        }
        int srcColZeroIndex = srcColIndex;
        int numCols = this.columns.length;
        for (int index = 0; index < numCols; ++index) {
            if (index == srcColIndex) {
                cd = srcFormat.columns[srcColIndex];
                newRowLength += this.getTotalColumnWidth(srcColIndex, unsafe, memAddr, bytesLen, srcFormat, cd, index, isSameSchema);
                if (++srcIndex < columns.length) {
                    srcColIndex = columns[srcIndex];
                    if (zeroBased) continue;
                    --srcColIndex;
                    continue;
                }
                srcColIndex = -1;
                continue;
            }
            cd = this.columns[index];
            newRowLength += this.getTotalColumnWidth(index, null, this, cd, index, true);
        }
        byte[] newBytes = new byte[newRowLength];
        this.writeVersion(newBytes);
        int varDataOffset = this.varDataOffset;
        srcIndex = 0;
        srcColIndex = srcColZeroIndex;
        for (int index = 0; index < numCols; ++index) {
            if (index == srcColIndex) {
                varDataOffset += this.copyColumn(srcColIndex, unsafe, memAddr, bytesLen, srcFormat, newBytes, index, varDataOffset);
                if (++srcIndex < columns.length) {
                    srcColIndex = columns[srcIndex];
                    if (zeroBased) continue;
                    --srcColIndex;
                    continue;
                }
                srcColIndex = -1;
                continue;
            }
            int offsetFromMap = this.positionMap[index];
            cd = this.columns[index];
            if (offsetFromMap >= this.nVersionBytes && !cd.isNullable) {
                DataValueDescriptor fixedZero = cd.columnType.getTypeId().getStaticZeroForFixedType();
                fixedZero.writeBytes(newBytes, offsetFromMap, cd.columnType);
                continue;
            }
            varDataOffset += this.generateColumn(index, null, cd, newBytes, varDataOffset);
        }
        return newBytes;
    }

    final byte[][] setColumns(FormatableBitSet columns, OffHeapRowWithLobs srcRowArrays, OffHeapByteSource srcRow, RowFormatter srcFormat, int[] baseColumnMap) throws StandardException {
        byte[] newBytes;
        ColumnDescriptor cd;
        long memAddr;
        int bytesLen;
        assert (columns.getNumBitsSet() > 0) : "setColumns with zero columns to set: " + ArrayUtils.objectString((Object)((Object)srcRowArrays));
        boolean isSameSchema = this.schemaVersion == srcFormat.schemaVersion;
        byte[][] newByteArrays = new byte[this.numLobs + 1][];
        int bitSetSize = columns.getLength();
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        if (srcRowArrays != null) {
            bytesLen = srcRowArrays.getLength();
            memAddr = srcRowArrays.getUnsafeAddress(0, bytesLen);
        } else {
            bytesLen = srcRow.getLength();
            memAddr = srcRow.getUnsafeAddress(0, bytesLen);
        }
        int newRowLength = this.nVersionBytes;
        boolean hasFirstBytesChange = false;
        int srcIndex = columns.anySetBit();
        int index = 0;
        while (srcIndex != -1) {
            cd = srcFormat.columns[srcIndex];
            if (!cd.isLob) {
                newRowLength += this.getTotalColumnWidth(srcIndex, unsafe, memAddr, bytesLen, srcFormat, cd, index, isSameSchema);
                hasFirstBytesChange = true;
            }
            srcIndex = columns.anySetBit(srcIndex);
            ++index;
        }
        if (hasFirstBytesChange) {
            newBytes = new byte[newRowLength];
            newByteArrays[0] = newBytes;
            this.writeVersion(newBytes);
        } else {
            newBytes = null;
        }
        int varDataOffset = this.varDataOffset;
        int srcIndex2 = columns.anySetBit();
        int index2 = 0;
        while (srcIndex2 != -1) {
            cd = srcFormat.columns[srcIndex2];
            if (!cd.isLob) {
                varDataOffset += this.copyColumn(srcIndex2, unsafe, memAddr, bytesLen, srcFormat, newBytes, index2, varDataOffset);
            } else {
                srcFormat.copyLobBytes(srcIndex2, index2, (byte[][])newByteArrays, srcRowArrays, columns, bitSetSize, cd, this);
            }
            if (baseColumnMap != null) {
                baseColumnMap[index2] = srcIndex2;
            }
            srcIndex2 = columns.anySetBit(srcIndex2);
            ++index2;
        }
        return newByteArrays;
    }

    final byte[][] setColumns(FormatableBitSet columns, byte[][] srcRowArrays, byte[] srcRow, RowFormatter srcFormat, int[] baseColumnMap) throws StandardException {
        byte[] newBytes;
        ColumnDescriptor cd;
        assert (columns.getNumBitsSet() > 0) : "setColumns with zero columns to set: " + ArrayUtils.objectString((Object)srcRowArrays);
        boolean isSameSchema = this.schemaVersion == srcFormat.schemaVersion;
        byte[][] newByteArrays = new byte[this.numLobs + 1][];
        if (srcRow == null && srcRowArrays != null) {
            srcRow = srcRowArrays[0];
        }
        int bitSetSize = columns.getLength();
        int newRowLength = this.nVersionBytes;
        boolean hasFirstBytesChange = false;
        int srcIndex = columns.anySetBit();
        int index = 0;
        while (srcIndex != -1) {
            cd = srcFormat.columns[srcIndex];
            if (!cd.isLob) {
                newRowLength += this.getTotalColumnWidth(srcIndex, srcRow, srcFormat, cd, index, isSameSchema);
                hasFirstBytesChange = true;
            }
            srcIndex = columns.anySetBit(srcIndex);
            ++index;
        }
        if (hasFirstBytesChange) {
            newBytes = new byte[newRowLength];
            newByteArrays[0] = newBytes;
            this.writeVersion(newBytes);
        } else {
            newBytes = null;
        }
        int varDataOffset = this.varDataOffset;
        int srcIndex2 = columns.anySetBit();
        int index2 = 0;
        while (srcIndex2 != -1) {
            cd = srcFormat.columns[srcIndex2];
            if (!cd.isLob) {
                varDataOffset += this.copyColumn(srcIndex2, srcRow, srcFormat, newBytes, index2, varDataOffset);
            } else {
                srcFormat.copyLobBytes(srcIndex2, index2, (byte[][])newByteArrays, srcRowArrays, columns, bitSetSize, cd, this);
            }
            if (baseColumnMap != null) {
                baseColumnMap[index2] = srcIndex2;
            }
            srcIndex2 = columns.anySetBit(srcIndex2);
            ++index2;
        }
        return newByteArrays;
    }

    final byte[][] setColumns(int[] columns, boolean zeroBased, OffHeapRowWithLobs srcRowArrays, OffHeapByteSource srcRow, RowFormatter srcFormat) throws StandardException {
        ColumnDescriptor cd;
        int srcIndex;
        long memAddr;
        int bytesLen;
        assert (columns.length > 0) : "setColumns with zero columns to set: " + ArrayUtils.objectString((Object)((Object)srcRowArrays));
        boolean isSameSchema = this.schemaVersion == srcFormat.schemaVersion;
        byte[][] newByteArrays = new byte[this.numLobs + 1][];
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        if (srcRowArrays != null) {
            bytesLen = srcRowArrays.getLength();
            memAddr = srcRowArrays.getUnsafeAddress(0, bytesLen);
        } else {
            bytesLen = srcRow.getLength();
            memAddr = srcRow.getUnsafeAddress(0, bytesLen);
        }
        boolean hasFirstBytesChange = false;
        int newRowLength = this.nVersionBytes;
        int numCols = columns.length;
        for (int index = 0; index < numCols; ++index) {
            srcIndex = columns[index];
            if (!zeroBased) {
                --srcIndex;
            }
            if (srcIndex < 0) continue;
            cd = srcFormat.columns[srcIndex];
            if (cd.isLob) continue;
            newRowLength += this.getTotalColumnWidth(srcIndex, unsafe, memAddr, bytesLen, srcFormat, cd, index, isSameSchema);
            hasFirstBytesChange = true;
        }
        if (hasFirstBytesChange) {
            byte[] newBytes = new byte[newRowLength];
            newByteArrays[0] = newBytes;
            this.writeVersion(newBytes);
            int varDataOffset = this.varDataOffset;
            int nCols = columns.length;
            for (int index = 0; index < nCols; ++index) {
                srcIndex = columns[index];
                if (!zeroBased) {
                    --srcIndex;
                }
                if (srcIndex < 0) continue;
                cd = srcFormat.columns[srcIndex];
                if (!cd.isLob) {
                    varDataOffset += this.copyColumn(srcIndex, unsafe, memAddr, bytesLen, srcFormat, newBytes, index, varDataOffset);
                    continue;
                }
                srcFormat.copyLobBytes(srcIndex, index, (byte[][])newByteArrays, srcRowArrays, cd, this);
            }
        } else {
            int nCols = columns.length;
            for (int index = 0; index < nCols; ++index) {
                srcIndex = columns[index];
                if (!zeroBased) {
                    --srcIndex;
                }
                if (srcIndex < 0) continue;
                cd = srcFormat.columns[srcIndex];
                if (!cd.isLob) continue;
                srcFormat.copyLobBytes(srcIndex, index, (byte[][])newByteArrays, srcRowArrays, cd, this);
            }
        }
        return newByteArrays;
    }

    final byte[][] setColumns(int[] columns, boolean zeroBased, byte[][] srcRowArrays, byte[] srcRow, RowFormatter srcFormat) throws StandardException {
        ColumnDescriptor cd;
        int srcIndex;
        assert (columns.length > 0) : "setColumns with zero columns to set: " + ArrayUtils.objectString((Object)srcRowArrays);
        boolean isSameSchema = this.schemaVersion == srcFormat.schemaVersion;
        byte[][] newByteArrays = new byte[this.numLobs + 1][];
        if (srcRow == null && srcRowArrays != null) {
            srcRow = srcRowArrays[0];
        }
        boolean hasFirstBytesChange = false;
        int newRowLength = this.nVersionBytes;
        int numCols = columns.length;
        for (int index = 0; index < numCols; ++index) {
            srcIndex = columns[index];
            if (!zeroBased) {
                --srcIndex;
            }
            if (srcIndex < 0) continue;
            cd = srcFormat.columns[srcIndex];
            if (cd.isLob) continue;
            newRowLength += this.getTotalColumnWidth(srcIndex, srcRow, srcFormat, cd, index, isSameSchema);
            hasFirstBytesChange = true;
        }
        if (hasFirstBytesChange) {
            byte[] newBytes = new byte[newRowLength];
            newByteArrays[0] = newBytes;
            this.writeVersion(newBytes);
            int varDataOffset = this.varDataOffset;
            int nCols = columns.length;
            for (int index = 0; index < nCols; ++index) {
                srcIndex = columns[index];
                if (!zeroBased) {
                    --srcIndex;
                }
                if (srcIndex < 0) continue;
                cd = srcFormat.columns[srcIndex];
                if (!cd.isLob) {
                    varDataOffset += this.copyColumn(srcIndex, srcRow, srcFormat, newBytes, index, varDataOffset);
                    continue;
                }
                srcFormat.copyLobBytes(srcIndex, index, (byte[][])newByteArrays, srcRowArrays, cd, this);
            }
        } else {
            int nCols = columns.length;
            for (int index = 0; index < nCols; ++index) {
                srcIndex = columns[index];
                if (!zeroBased) {
                    --srcIndex;
                }
                if (srcIndex < 0) continue;
                cd = srcFormat.columns[srcIndex];
                if (!cd.isLob) continue;
                srcFormat.copyLobBytes(srcIndex, index, (byte[][])newByteArrays, srcRowArrays, cd, this);
            }
        }
        return newByteArrays;
    }

    final byte[] setColumns(int nCols, byte[] srcRow, RowFormatter srcFormat) throws StandardException {
        assert (nCols > 0) : "setColumns with zero columns to set: " + Arrays.toString(srcRow);
        boolean isSameSchema = this.schemaVersion == srcFormat.schemaVersion;
        int newRowLength = this.nVersionBytes;
        for (int index = 0; index < nCols; ++index) {
            ColumnDescriptor cd = srcFormat.columns[index];
            newRowLength += this.getTotalColumnWidth(index, srcRow, srcFormat, cd, index, isSameSchema);
        }
        byte[] newBytes = new byte[newRowLength];
        this.writeVersion(newBytes);
        int varDataOffset = this.varDataOffset;
        for (int index = 0; index < nCols; ++index) {
            varDataOffset += this.copyColumn(index, srcRow, srcFormat, newBytes, index, varDataOffset);
        }
        return newBytes;
    }

    final byte[] setColumns(int nCols, UnsafeWrapper unsafe, long memAddr, int bytesLen, RowFormatter srcFormat) throws StandardException {
        boolean isSameSchema = this.schemaVersion == srcFormat.schemaVersion;
        int newRowLength = this.nVersionBytes;
        for (int index = 0; index < nCols; ++index) {
            ColumnDescriptor cd = srcFormat.columns[index];
            newRowLength += this.getTotalColumnWidth(index, unsafe, memAddr, bytesLen, srcFormat, cd, index, isSameSchema);
        }
        byte[] newBytes = new byte[newRowLength];
        this.writeVersion(newBytes);
        int varDataOffset = this.varDataOffset;
        for (int index = 0; index < nCols; ++index) {
            varDataOffset += this.copyColumn(index, unsafe, memAddr, bytesLen, srcFormat, newBytes, index, varDataOffset);
        }
        return newBytes;
    }

    final byte[] setColumns(int nCols, OffHeapRow srcRow, RowFormatter srcFormat) throws StandardException {
        assert (nCols > 0) : "setColumns with zero columns to set: " + Arrays.toString(srcRow != null ? srcRow.getRowBytes() : null);
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = srcRow.getLength();
        long memAddr = srcRow.getUnsafeAddress(0, bytesLen);
        return this.setColumns(nCols, unsafe, memAddr, bytesLen, srcFormat);
    }

    final byte[] setColumns(int nCols, OffHeapByteSource srcRow, RowFormatter srcFormat) throws StandardException {
        assert (nCols > 0) : "setColumns with zero columns to set: " + Arrays.toString(srcRow != null ? srcRow.getRowBytes() : null);
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = srcRow.getLength();
        long memAddr = srcRow.getUnsafeAddress(0, bytesLen);
        return this.setColumns(nCols, unsafe, memAddr, bytesLen, srcFormat);
    }

    final byte[][] setColumns(int nCols, OffHeapRowWithLobs srcRowArrays, OffHeapByteSource srcRow, RowFormatter srcFormat) throws StandardException {
        ColumnDescriptor cd;
        int index;
        long memAddr;
        int bytesLen;
        assert (nCols > 0) : "setColumns with zero columns to set: " + ArrayUtils.objectString((Object)((Object)srcRowArrays));
        boolean isSameSchema = this.schemaVersion == srcFormat.schemaVersion;
        byte[][] newByteArrays = new byte[this.numLobs + 1][];
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        if (srcRowArrays != null) {
            bytesLen = srcRowArrays.getLength();
            memAddr = srcRowArrays.getUnsafeAddress(0, bytesLen);
        } else {
            bytesLen = srcRow.getLength();
            memAddr = srcRow.getUnsafeAddress(0, bytesLen);
        }
        boolean hasFirstBytesChange = false;
        int newRowLength = this.nVersionBytes;
        for (index = 0; index < nCols; ++index) {
            cd = srcFormat.columns[index];
            if (cd.isLob) continue;
            newRowLength += this.getTotalColumnWidth(index, unsafe, memAddr, bytesLen, srcFormat, cd, index, isSameSchema);
            hasFirstBytesChange = true;
        }
        if (hasFirstBytesChange) {
            byte[] newBytes = new byte[newRowLength];
            newByteArrays[0] = newBytes;
            this.writeVersion(newBytes);
            int varDataOffset = this.varDataOffset;
            for (int index2 = 0; index2 < nCols; ++index2) {
                cd = srcFormat.columns[index2];
                if (!cd.isLob) {
                    varDataOffset += this.copyColumn(index2, unsafe, memAddr, bytesLen, srcFormat, newBytes, index2, varDataOffset);
                    continue;
                }
                srcFormat.copyLobBytes(index2, (byte[][])newByteArrays, srcRowArrays, nCols, cd, this);
            }
        } else {
            for (index = 0; index < nCols; ++index) {
                cd = srcFormat.columns[index];
                if (!cd.isLob) continue;
                srcFormat.copyLobBytes(index, (byte[][])newByteArrays, srcRowArrays, nCols, cd, this);
            }
        }
        return newByteArrays;
    }

    final byte[][] setColumns(int nCols, byte[][] srcRowArrays, byte[] srcRow, RowFormatter srcFormat) throws StandardException {
        ColumnDescriptor cd;
        int index;
        assert (nCols > 0) : "setColumns with zero columns to set: " + ArrayUtils.objectString((Object)srcRowArrays);
        boolean isSameSchema = this.schemaVersion == srcFormat.schemaVersion;
        byte[][] newByteArrays = new byte[this.numLobs + 1][];
        if (srcRow == null && srcRowArrays != null) {
            srcRow = srcRowArrays[0];
        }
        boolean hasFirstBytesChange = false;
        int newRowLength = this.nVersionBytes;
        for (index = 0; index < nCols; ++index) {
            cd = srcFormat.columns[index];
            if (cd.isLob) continue;
            newRowLength += this.getTotalColumnWidth(index, srcRow, srcFormat, cd, index, isSameSchema);
            hasFirstBytesChange = true;
        }
        if (hasFirstBytesChange) {
            byte[] newBytes = new byte[newRowLength];
            newByteArrays[0] = newBytes;
            this.writeVersion(newBytes);
            int varDataOffset = this.varDataOffset;
            for (int index2 = 0; index2 < nCols; ++index2) {
                cd = srcFormat.columns[index2];
                if (!cd.isLob) {
                    varDataOffset += this.copyColumn(index2, srcRow, srcFormat, newBytes, index2, varDataOffset);
                    continue;
                }
                srcFormat.copyLobBytes(index2, (byte[][])newByteArrays, srcRowArrays, nCols, cd, this);
            }
        } else {
            for (index = 0; index < nCols; ++index) {
                cd = srcFormat.columns[index];
                if (!cd.isLob) continue;
                srcFormat.copyLobBytes(index, (byte[][])newByteArrays, srcRowArrays, nCols, cd, this);
            }
        }
        return newByteArrays;
    }

    private void copyLobBytes(int index, int currentIndex, byte[][] newByteArrays, OffHeapRowWithLobs srcRowArrays, ColumnDescriptor cd, RowFormatter currentFormat) {
        int lobIndex = this.positionMap[index];
        int targetIndex = currentFormat.positionMap[currentIndex];
        newByteArrays[targetIndex] = lobIndex != 0 && srcRowArrays != null ? srcRowArrays.getGfxdBytes(lobIndex) : cd.columnDefaultBytes;
    }

    private void copyLobBytes(int index, int currentIndex, byte[][] newByteArrays, byte[][] srcRowArrays, ColumnDescriptor cd, RowFormatter currentFormat) {
        int lobIndex = this.positionMap[index];
        int targetIndex = currentFormat.positionMap[currentIndex];
        newByteArrays[targetIndex] = lobIndex != 0 && srcRowArrays != null ? srcRowArrays[lobIndex] : cd.columnDefaultBytes;
    }

    private void copyLobBytes(int index, int currentIndex, byte[][] newByteArrays, OffHeapRowWithLobs srcRowArrays, FormatableBitSet columns, int numChanged, ColumnDescriptor cd, RowFormatter currentFormat) {
        int lobIndex = this.positionMap[index];
        int targetIndex = currentFormat.positionMap[currentIndex];
        if (index < numChanged && columns.isSet(index)) {
            newByteArrays[targetIndex] = lobIndex != 0 && srcRowArrays != null ? srcRowArrays.getGfxdBytes(lobIndex) : cd.columnDefaultBytes;
        }
    }

    private void copyLobBytes(int index, int currentIndex, byte[][] newByteArrays, byte[][] srcRowArrays, FormatableBitSet columns, int numChanged, ColumnDescriptor cd, RowFormatter currentFormat) {
        int lobIndex = this.positionMap[index];
        int targetIndex = currentFormat.positionMap[currentIndex];
        if (index < numChanged && columns.isSet(index)) {
            newByteArrays[targetIndex] = lobIndex != 0 && srcRowArrays != null ? srcRowArrays[lobIndex] : cd.columnDefaultBytes;
        }
    }

    private void copyLobBytes(int index, byte[][] newByteArrays, OffHeapRowWithLobs srcRowArrays, int nCols, ColumnDescriptor cd, RowFormatter currentFormat) {
        int lobIndex = this.positionMap[index];
        int targetIndex = currentFormat.positionMap[index];
        if (index < nCols) {
            newByteArrays[targetIndex] = lobIndex != 0 && srcRowArrays != null ? srcRowArrays.getGfxdBytes(lobIndex) : cd.columnDefaultBytes;
        }
    }

    private void copyLobBytes(int index, byte[][] newByteArrays, byte[][] srcRowArrays, int nCols, ColumnDescriptor cd, RowFormatter currentFormat) {
        int lobIndex = this.positionMap[index];
        int targetIndex = currentFormat.positionMap[index];
        if (index < nCols) {
            newByteArrays[targetIndex] = lobIndex != 0 && srcRowArrays != null ? srcRowArrays[lobIndex] : cd.columnDefaultBytes;
        }
    }

    public final DataValueDescriptor getColumn(int logicalPosition, byte[] bytes) throws StandardException {
        DataValueDescriptor dvd;
        int index = logicalPosition - 1;
        int offsetFromMap = this.positionMap[index];
        ColumnDescriptor cd = this.columns[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, bytes, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            dvd = cd.columnType.getNull();
            int bytesRead = dvd.readBytes(bytes, offset, columnWidth);
            assert (bytesRead == columnWidth) : "bytesRead=" + bytesRead + ", columnWidth=" + columnWidth + " for " + dvd;
        } else if (offsetAndWidth == -7L) {
            dvd = cd.columnType.getNull();
        } else {
            assert (offsetAndWidth == -6L) : offsetAndWidth + " for pos=" + logicalPosition;
            dvd = cd.columnType.getNull();
            if (cd.columnDefault != null) {
                dvd.setValue(cd.columnDefault);
            }
        }
        if (GemFireXDUtils.TraceRowFormatter) {
            SanityManager.DEBUG_PRINT((String)"TraceRowFormatter", (String)("RowFormatter#getColumn(byte[]): for column at position " + logicalPosition + " returning DVD {" + dvd + ", type: " + cd.columnType + '}'));
        }
        return dvd;
    }

    public final DataValueDescriptor getColumn(int logicalPosition, OffHeapRow bytes) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        return this.getColumn(logicalPosition, unsafe, memAddr, bytesLen, bytes);
    }

    public final DataValueDescriptor getColumn(int logicalPosition, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapRow row) throws StandardException {
        DataValueDescriptor dvd;
        int index = logicalPosition - 1;
        int offsetFromMap = this.positionMap[index];
        ColumnDescriptor cd = this.columns[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            dvd = cd.columnType.getNull();
            int bytesRead = dvd.readBytes(unsafe, memAddr + (long)offset, columnWidth, row);
            assert (bytesRead == columnWidth) : "bytesRead=" + bytesRead + ", columnWidth=" + columnWidth + " for " + dvd;
        } else if (offsetAndWidth == -7L) {
            dvd = cd.columnType.getNull();
        } else {
            assert (offsetAndWidth == -6L) : offsetAndWidth + " for pos=" + logicalPosition;
            dvd = cd.columnType.getNull();
            if (cd.columnDefault != null) {
                dvd.setValue(cd.columnDefault);
            }
        }
        if (GemFireXDUtils.TraceRowFormatter) {
            SanityManager.DEBUG_PRINT((String)"TraceRowFormatter", (String)("RowFormatter#getColumn(byte[]): for column at position " + logicalPosition + " returning DVD {" + dvd + ", type: " + cd.columnType + '}'));
        }
        return dvd;
    }

    public final DataValueDescriptor getColumn(int logicalPosition, OffHeapRowWithLobs byteArrays) throws StandardException {
        return this.getColumn(logicalPosition, UnsafeMemoryChunk.getUnsafeWrapper(), 0L, 0, byteArrays);
    }

    public final DataValueDescriptor getColumn(int logicalPosition, UnsafeWrapper unsafe, long memAddr0th, int bytesLen0th, OffHeapRowWithLobs byteArrays) throws StandardException {
        DataValueDescriptor dvd;
        int index = logicalPosition - 1;
        int offsetFromMap = this.positionMap[index];
        ColumnDescriptor cd = this.columns[index];
        if (byteArrays != null) {
            if (!cd.isLob) {
                long offsetAndWidth;
                if (memAddr0th == 0L) {
                    bytesLen0th = byteArrays.getLength();
                    memAddr0th = byteArrays.getUnsafeAddress(0, bytesLen0th);
                }
                if ((offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr0th, bytesLen0th, offsetFromMap, cd)) >= 0L) {
                    int columnWidth = (int)offsetAndWidth;
                    int offset = (int)(offsetAndWidth >>> 32);
                    dvd = cd.columnType.getNull();
                    int bytesRead = dvd.readBytes(unsafe, memAddr0th + (long)offset, columnWidth, byteArrays);
                    assert (bytesRead == columnWidth) : "bytesRead=" + bytesRead + ", columnWidth=" + columnWidth + " for " + dvd;
                } else if (offsetAndWidth == -7L) {
                    dvd = cd.columnType.getNull();
                } else {
                    assert (offsetAndWidth == -6L) : offsetAndWidth;
                    dvd = cd.columnType.getNull();
                    if (cd.columnDefault != null) {
                        dvd.setValue(cd.columnDefault);
                    }
                }
            } else {
                dvd = cd.columnType.getNull();
                if (offsetFromMap != 0) {
                    Object lobRow = byteArrays.getGfxdByteSource(offsetFromMap);
                    if (lobRow != null) {
                        if (lobRow instanceof byte[]) {
                            byte[] bytes = (byte[])lobRow;
                            int bytesRead = dvd.readBytes(bytes, 0, bytes.length);
                            assert (bytesRead == bytes.length) : "bytesRead=" + bytesRead + ", bytesLen=" + bytes.length + " for " + dvd;
                        } else {
                            OffHeapByteSource bs = (OffHeapByteSource)((Object)lobRow);
                            int len = bs.getLength();
                            int bytesRead = dvd.readBytes(unsafe, bs.getUnsafeAddress(0, len), len, bs);
                            assert (bytesRead == len) : "bytesRead=" + bytesRead + ", bytesLen=" + len + " for " + dvd;
                        }
                    }
                } else if (cd.columnDefault != null) {
                    dvd.setValue(cd.columnDefault);
                }
            }
        } else {
            dvd = cd.columnType.getNull();
        }
        if (GemFireXDUtils.TraceRowFormatter) {
            SanityManager.DEBUG_PRINT((String)"TraceRowFormatter", (String)("RowFormatter#getColumn(byte[][]): for column at position " + logicalPosition + " returning DVD {" + dvd + ", type: " + cd.columnType + '}'));
        }
        return dvd;
    }

    public final DataValueDescriptor getColumn(int logicalPosition, byte[][] byteArrays) throws StandardException {
        DataValueDescriptor dvd;
        int index = logicalPosition - 1;
        int offsetFromMap = this.positionMap[index];
        ColumnDescriptor cd = this.columns[index];
        if (byteArrays != null) {
            if (!cd.isLob) {
                byte[] bytes = byteArrays[0];
                long offsetAndWidth = this.getOffsetAndWidth(index, bytes, offsetFromMap, cd);
                if (offsetAndWidth >= 0L) {
                    int columnWidth = (int)offsetAndWidth;
                    int offset = (int)(offsetAndWidth >>> 32);
                    dvd = cd.columnType.getNull();
                    int bytesRead = dvd.readBytes(bytes, offset, columnWidth);
                    assert (bytesRead == columnWidth) : "bytesRead=" + bytesRead + ", columnWidth=" + columnWidth + " for " + dvd;
                } else if (offsetAndWidth == -7L) {
                    dvd = cd.columnType.getNull();
                } else {
                    assert (offsetAndWidth == -6L) : offsetAndWidth;
                    dvd = cd.columnType.getNull();
                    if (cd.columnDefault != null) {
                        dvd.setValue(cd.columnDefault);
                    }
                }
            } else {
                dvd = cd.columnType.getNull();
                if (offsetFromMap != 0) {
                    byte[] bytes = byteArrays[offsetFromMap];
                    if (bytes != null) {
                        int bytesRead = dvd.readBytes(bytes, 0, bytes.length);
                        assert (bytesRead == bytes.length) : "bytesRead=" + bytesRead + ", bytesLen=" + bytes.length + " for " + dvd;
                    }
                } else if (cd.columnDefault != null) {
                    dvd.setValue(cd.columnDefault);
                }
            }
        } else {
            dvd = cd.columnType.getNull();
        }
        if (GemFireXDUtils.TraceRowFormatter) {
            SanityManager.DEBUG_PRINT((String)"TraceRowFormatter", (String)("RowFormatter#getColumn(byte[][]): for column at position " + logicalPosition + " returning DVD {" + dvd + ", type: " + cd.columnType + '}'));
        }
        return dvd;
    }

    public final int computeHashCode(int logicalPosition, byte[] bytes, int hash) {
        int colIndex = logicalPosition - 1;
        int offsetFromMap = this.positionMap[colIndex];
        ColumnDescriptor cd = this.columns[colIndex];
        long offsetAndWidth = this.getOffsetAndWidth(colIndex, bytes, offsetFromMap, cd);
        int typeId = cd.columnType.getTypeId().getTypeFormatId();
        if (offsetAndWidth >= 0L) {
            int width = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            if (typeId == 13) {
                int idx;
                for (idx = offset + width - 1; idx >= offset && bytes[idx] == 32; --idx) {
                }
                hash = ResolverUtils.addBytesToBucketHash((byte[])bytes, (int)offset, (int)(idx + 1 - offset), (int)hash, (int)typeId);
            } else {
                hash = ResolverUtils.addBytesToBucketHash((byte[])bytes, (int)offset, (int)width, (int)hash, (int)typeId);
                if (typeId == 5 || typeId == 27) {
                    int maxWidth = cd.getType().getMaximumWidth();
                    while (width++ < maxWidth) {
                        hash = ResolverUtils.addByteToHash((byte)32, (int)hash);
                    }
                }
            }
        } else if (offsetAndWidth == -7L) {
            hash = ResolverUtils.addByteToBucketHash((byte)0, (int)hash, (int)typeId);
        } else {
            assert (offsetAndWidth == -6L);
            byte[] defaultBytes = cd.columnDefaultBytes;
            hash = defaultBytes != null ? ResolverUtils.addBytesToBucketHash((byte[])defaultBytes, (int)hash, (int)typeId) : ResolverUtils.addByteToBucketHash((byte)0, (int)hash, (int)typeId);
        }
        return hash;
    }

    public final int computeHashCode(int logicalPosition, UnsafeWrapper unsafe, long memAddr, int bytesLen, int hash) {
        int colIndex = logicalPosition - 1;
        int offsetFromMap = this.positionMap[colIndex];
        ColumnDescriptor cd = this.columns[colIndex];
        long offsetAndWidth = this.getOffsetAndWidth(colIndex, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        int typeId = cd.columnType.getTypeId().getTypeFormatId();
        if (offsetAndWidth >= 0L) {
            int width = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            if (typeId == 13) {
                long idxAddr;
                long offsetAddr = memAddr + (long)offset;
                for (idxAddr = offsetAddr + (long)(width - 1); idxAddr >= offsetAddr && unsafe.getByte(idxAddr) == 32; --idxAddr) {
                }
                hash = ServerResolverUtils.addBytesToBucketHash(unsafe, offsetAddr, (int)(idxAddr + 1L - offsetAddr), hash, typeId);
            } else {
                hash = ServerResolverUtils.addBytesToBucketHash(unsafe, memAddr + (long)offset, width, hash, typeId);
            }
            if (typeId == 5 || typeId == 27) {
                int maxWidth = cd.getType().getMaximumWidth();
                while (width++ < maxWidth) {
                    hash = ResolverUtils.addByteToHash((byte)32, (int)hash);
                }
            }
        } else if (offsetAndWidth == -7L) {
            hash = ResolverUtils.addByteToBucketHash((byte)0, (int)hash, (int)typeId);
        } else {
            assert (offsetAndWidth == -6L);
            byte[] defaultBytes = cd.columnDefaultBytes;
            hash = defaultBytes != null ? ResolverUtils.addBytesToBucketHash((byte[])defaultBytes, (int)hash, (int)typeId) : ResolverUtils.addByteToBucketHash((byte)0, (int)hash, (int)typeId);
        }
        return hash;
    }

    public final DataValueDescriptor getNewNull(int logicalPosition) throws StandardException {
        ColumnDescriptor cd = this.columns[logicalPosition - 1];
        return cd.columnType.getNull();
    }

    public final void setDVDColumn(DataValueDescriptor result, int index, byte[] bytes) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        ColumnDescriptor cd = this.columns[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, bytes, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            DataTypeDescriptor dtd = cd.columnType;
            if (result.getTypeFormatId() == dtd.getDVDTypeFormatId()) {
                int bytesRead = result.readBytes(bytes, offset, columnWidth);
                assert (bytesRead == columnWidth) : "bytesRead=" + bytesRead + ", columnWidth=" + columnWidth + " for " + result;
            } else {
                DataTypeUtilities.setInDVD(result, bytes, offset, columnWidth, dtd);
            }
        } else if (offsetAndWidth == -7L) {
            result.restoreToNull();
        } else {
            assert (offsetAndWidth == -6L) : offsetAndWidth;
            if (cd.columnDefault != null) {
                result.setValue(cd.columnDefault);
            } else {
                result.restoreToNull();
            }
        }
        if (GemFireXDUtils.TraceRowFormatter) {
            SanityManager.DEBUG_PRINT((String)"TraceRowFormatter", (String)("RowFormatter#setDVDColumn(byte[]): for column at position " + (index + 1) + " returning DVD {" + result + ", type: " + cd.columnType + '}'));
        }
    }

    private final void setDVDColumn(DataValueDescriptor result, int index, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, int offsetFromMap, ColumnDescriptor cd) throws StandardException {
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            DataTypeDescriptor dtd = cd.columnType;
            if (result.getTypeFormatId() == dtd.getDVDTypeFormatId()) {
                int bytesRead = result.readBytes(unsafe, memAddr + (long)offset, columnWidth, bs);
                assert (bytesRead == columnWidth) : "bytesRead=" + bytesRead + ", columnWidth=" + columnWidth + " for " + result;
            } else {
                DataTypeUtilities.setInDVD(result, unsafe, memAddr + (long)offset, columnWidth, bs, dtd);
            }
        } else if (offsetAndWidth == -7L) {
            result.restoreToNull();
        } else {
            assert (offsetAndWidth == -6L) : offsetAndWidth;
            if (cd.columnDefault != null) {
                result.setValue(cd.columnDefault);
            } else {
                result.restoreToNull();
            }
        }
    }

    public final void setDVDColumn(DataValueDescriptor result, int index, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapRow bytes) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        ColumnDescriptor cd = this.columns[index];
        this.setDVDColumn(result, index, unsafe, memAddr, bytesLen, bytes, offsetFromMap, cd);
        if (GemFireXDUtils.TraceRowFormatter) {
            SanityManager.DEBUG_PRINT((String)"TraceRowFormatter", (String)("RowFormatter#setDVDColumn(OffHeapRow): for column at position " + (index + 1) + " returning DVD {" + result + ", type: " + cd.columnType + '}'));
        }
    }

    public final void setDVDColumn(DataValueDescriptor result, int index, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapRowWithLobs byteArrays) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            this.setDVDColumn(result, index, unsafe, memAddr, bytesLen, byteArrays, offsetFromMap, cd);
        } else if (offsetFromMap != 0) {
            Object lobRow = byteArrays.getGfxdByteSource(offsetFromMap);
            if (lobRow != null) {
                DataTypeDescriptor dtd = cd.columnType;
                if (lobRow instanceof byte[]) {
                    byte[] bytes = (byte[])lobRow;
                    if (result.getTypeFormatId() == dtd.getDVDTypeFormatId()) {
                        int bytesRead = result.readBytes(bytes, 0, bytes.length);
                        assert (bytesRead == bytes.length) : "bytesRead=" + bytesRead + ", bytesLen=" + bytes.length + " for " + result;
                    } else {
                        DataTypeUtilities.setInDVD(result, bytes, 0, bytes.length, dtd);
                    }
                } else {
                    OffHeapByteSource bs = (OffHeapByteSource)((Object)lobRow);
                    int len = bs.getLength();
                    long memOffset = bs.getUnsafeAddress(0, len);
                    if (result.getTypeFormatId() == dtd.getDVDTypeFormatId()) {
                        int bytesRead = result.readBytes(unsafe, memOffset, len, bs);
                        assert (bytesRead == len) : "bytesRead=" + bytesRead + ", bytesLen=" + len + " for " + result;
                    } else {
                        DataTypeUtilities.setInDVD(result, unsafe, memOffset, len, bs, dtd);
                    }
                }
            } else {
                result.restoreToNull();
            }
        } else if (cd.columnDefault != null) {
            result.setValue(cd.columnDefault);
        } else {
            result.restoreToNull();
        }
        if (GemFireXDUtils.TraceRowFormatter) {
            SanityManager.DEBUG_PRINT((String)"TraceRowFormatter", (String)("RowFormatter#setDVDColumn(OffHeapRowWithLobs): for column at position " + (index + 1) + " returning DVD {" + result + ", type: " + cd.columnType + '}'));
        }
    }

    public final byte[] extractReferencedKeysForPKOrNullIfNull(byte[] rowBytes, int[] columns, RowFormatter targetFormat, int[] targetColumns, RowFormatter targetTableFormat, int[] targetPkCols) {
        int sz = targetFormat.nVersionBytes;
        int numCols = columns.length;
        for (int index = 0; index < numCols; ++index) {
            int posIndex = columns[index] - 1;
            int width = this.getColumnWidth(posIndex, rowBytes, this.columns[posIndex]);
            if (width == 0) {
                return null;
            }
            sz += width;
            if (targetTableFormat.positionMap[targetColumns[index] - 1] >= 0) continue;
            sz += targetFormat.offsetBytes;
        }
        byte[] columnBytes = new byte[sz];
        int varOffset = targetFormat.varDataOffset;
        targetFormat.writeVersion(columnBytes);
        int nCols = columns.length;
        for (int index = 0; index < nCols; ++index) {
            int targetTablePos = targetColumns[index];
            int targetIndex = index;
            if (targetTablePos != targetPkCols[index]) {
                int j;
                for (j = 0; j < targetPkCols.length; ++j) {
                    if (targetTablePos != targetPkCols[j]) continue;
                    targetIndex = j;
                    break;
                }
                if (j >= targetPkCols.length) {
                    Assert.fail((Object)("unexpected failure in locating the referenced column " + targetTableFormat.columns[targetTablePos] + " in target PK formatter having columns " + Arrays.toString(targetFormat.columns)));
                }
            }
            varOffset = this.processColumn(rowBytes, columns[index] - 1, extractColumnBytes, columnBytes, varOffset, targetFormat, targetIndex);
        }
        return columnBytes;
    }

    public final byte[] extractReferencedKeysForPKOrNullIfNull(OffHeapByteSource rowBytes, int[] columns, RowFormatter targetFormat, int[] targetColumns, RowFormatter targetTableFormat, int[] targetPkCols) {
        int sz = targetFormat.nVersionBytes;
        int numCols = columns.length;
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = rowBytes.getLength();
        long memAddr = rowBytes.getUnsafeAddress(0, bytesLen);
        for (int index = 0; index < numCols; ++index) {
            int posIndex = columns[index] - 1;
            int width = this.getColumnWidth(posIndex, unsafe, memAddr, bytesLen, this.columns[posIndex]);
            if (width == 0) {
                return null;
            }
            sz += width;
            if (targetTableFormat.positionMap[targetColumns[index] - 1] >= 0) continue;
            sz += targetFormat.offsetBytes;
        }
        byte[] columnBytes = new byte[sz];
        int varOffset = targetFormat.varDataOffset;
        targetFormat.writeVersion(columnBytes);
        int nCols = columns.length;
        for (int index = 0; index < nCols; ++index) {
            int targetTablePos = targetColumns[index];
            int targetIndex = index;
            if (targetTablePos != targetPkCols[index]) {
                int j;
                for (j = 0; j < targetPkCols.length; ++j) {
                    if (targetTablePos != targetPkCols[j]) continue;
                    targetIndex = j;
                    break;
                }
                if (j >= targetPkCols.length) {
                    Assert.fail((Object)("unexpected failure in locating the referenced column " + targetTableFormat.columns[targetTablePos] + " in target PK formatter having columns " + Arrays.toString(targetFormat.columns)));
                }
            }
            varOffset = this.processColumn(unsafe, memAddr, bytesLen, columns[index] - 1, extractColumnBytesOffHeap, columnBytes, varOffset, targetFormat, targetIndex);
        }
        return columnBytes;
    }

    public final byte[] generateColumns(byte[] rowBytes, int[] columns, RowFormatter targetFormat) {
        ColumnDescriptor cd;
        int sz = targetFormat.nVersionBytes;
        int numCols = columns.length;
        boolean truncateSpaces = targetFormat.isPrimaryKeyFormatter;
        for (int index = 0; index < numCols; ++index) {
            int posIndex = columns[index] - 1;
            cd = this.columns[posIndex];
            if (cd.isLob) continue;
            sz += this.getColumnWidth(posIndex, rowBytes, cd, truncateSpaces);
            if (targetFormat.positionMap[index] >= 0) continue;
            sz += targetFormat.offsetBytes;
        }
        byte[] columnBytes = new byte[sz];
        targetFormat.writeVersion(columnBytes);
        int varOffset = targetFormat.varDataOffset;
        int nCols = columns.length;
        for (int index = 0; index < nCols; ++index) {
            cd = targetFormat.columns[index];
            if (cd.isLob) continue;
            varOffset = this.processColumn(rowBytes, columns[index] - 1, extractColumnBytes, columnBytes, varOffset, targetFormat, index);
        }
        return columnBytes;
    }

    public final byte[] generateColumns(OffHeapByteSource rowBytes, int[] columns, RowFormatter targetFormat) {
        ColumnDescriptor cd;
        int sz = targetFormat.nVersionBytes;
        int numCols = columns.length;
        boolean truncateSpaces = targetFormat.isPrimaryKeyFormatter;
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = rowBytes.getLength();
        long memAddr = rowBytes.getUnsafeAddress(0, bytesLen);
        for (int index = 0; index < numCols; ++index) {
            int posIndex = columns[index] - 1;
            cd = this.columns[posIndex];
            if (cd.isLob) continue;
            sz += this.getColumnWidth(posIndex, unsafe, memAddr, bytesLen, cd, truncateSpaces);
            if (targetFormat.positionMap[index] >= 0) continue;
            sz += targetFormat.offsetBytes;
        }
        byte[] columnBytes = new byte[sz];
        targetFormat.writeVersion(columnBytes);
        int varOffset = targetFormat.varDataOffset;
        for (int index = 0; index < numCols; ++index) {
            cd = targetFormat.columns[index];
            if (cd.isLob) continue;
            varOffset = this.processColumn(unsafe, memAddr, bytesLen, columns[index] - 1, extractColumnBytesOffHeap, columnBytes, varOffset, targetFormat, index);
        }
        return columnBytes;
    }

    public final void serializeColumns(byte[] rowBytes, DataOutput out, int[] fixedColumns, int[] varColumns, int targetFormatOffsetBytes, int targetFormatOffsetIsDefault, RowFormatter targetFormat) throws IOException {
        int width;
        int offset;
        long offsetAndWidth;
        long[] offsetAndWidths = null;
        int sz = targetFormat.nVersionBytes;
        int numVarWidths = 0;
        if (fixedColumns != null) {
            for (int pos : fixedColumns) {
                sz += this.columns[pos - 1].fixedWidth;
            }
        }
        if (varColumns != null) {
            boolean truncateSpaces = targetFormat.isPrimaryKeyFormatter;
            numVarWidths = varColumns.length;
            offsetAndWidths = new long[numVarWidths];
            for (int index = 0; index < numVarWidths; ++index) {
                byte[] defaultBytes;
                int varPosition = varColumns[index];
                offsetAndWidth = this.getOffsetAndWidth(varPosition, rowBytes, truncateSpaces);
                if (offsetAndWidth >= 0L) {
                    sz += (int)offsetAndWidth;
                } else if (offsetAndWidth == -6L && (defaultBytes = this.columns[varPosition - 1].columnDefaultBytes) != null) {
                    sz += defaultBytes.length;
                }
                sz += targetFormatOffsetBytes;
                offsetAndWidths[index] = offsetAndWidth;
            }
        }
        InternalDataSerializer.writeArrayLength((int)sz, (DataOutput)out);
        targetFormat.writeVersion(out);
        int varOffset = targetFormat.nVersionBytes;
        if (fixedColumns != null) {
            for (int pos : fixedColumns) {
                int posIndex = pos - 1;
                offset = this.positionMap[posIndex];
                width = this.columns[posIndex].fixedWidth;
                out.write(rowBytes, offset, width);
                varOffset += width;
            }
        }
        if (varColumns != null) {
            int index;
            for (index = 0; index < numVarWidths; ++index) {
                offsetAndWidth = offsetAndWidths[index];
                if (offsetAndWidth >= 0L) {
                    width = (int)offsetAndWidth;
                    offset = (int)(offsetAndWidth >>> 32);
                    out.write(rowBytes, offset, width);
                    offsetAndWidths[index] = targetFormat.getVarDataOffset(varOffset);
                    varOffset += width;
                    continue;
                }
                if (offsetAndWidth == -7L) {
                    offsetAndWidths[index] = targetFormat.getNullIndicator(varOffset);
                    continue;
                }
                assert (offsetAndWidth == -6L) : offsetAndWidth;
                offsetAndWidths[index] = targetFormatOffsetIsDefault;
            }
            for (index = 0; index < numVarWidths; ++index) {
                RowFormatter.writeInt(out, (int)offsetAndWidths[index], targetFormatOffsetBytes);
            }
        }
    }

    public final void serializeColumns(OffHeapByteSource rowBytes, DataOutput out, int[] fixedColumns, int[] varColumns, int targetFormatOffsetBytes, int targetFormatOffsetIsDefault, RowFormatter targetFormat) throws IOException {
        int width;
        int offset;
        long offsetAndWidth;
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = rowBytes.getLength();
        long memAddr = rowBytes.getUnsafeAddress(0, bytesLen);
        long[] offsetAndWidths = null;
        int sz = targetFormat.nVersionBytes;
        int numVarWidths = 0;
        if (fixedColumns != null) {
            for (int pos : fixedColumns) {
                sz += this.columns[pos - 1].fixedWidth;
            }
        }
        if (varColumns != null) {
            boolean truncateSpaces = targetFormat.isPrimaryKeyFormatter;
            numVarWidths = varColumns.length;
            offsetAndWidths = new long[numVarWidths];
            for (int index = 0; index < numVarWidths; ++index) {
                offsetAndWidth = this.getOffsetAndWidth(varColumns[index], unsafe, memAddr, bytesLen, truncateSpaces);
                if (offsetAndWidth >= 0L) {
                    sz += (int)offsetAndWidth;
                }
                sz += targetFormatOffsetBytes;
                offsetAndWidths[index] = offsetAndWidth;
            }
        }
        InternalDataSerializer.writeArrayLength((int)sz, (DataOutput)out);
        targetFormat.writeVersion(out);
        int varOffset = targetFormat.nVersionBytes;
        if (fixedColumns != null) {
            for (int pos : fixedColumns) {
                int posIndex = pos - 1;
                offset = this.positionMap[posIndex];
                width = this.columns[posIndex].fixedWidth;
                OffHeapRegionEntryHelper.copyBytesToDataOutput((UnsafeWrapper)unsafe, (long)(memAddr + (long)offset), (int)width, (DataOutput)out);
                varOffset += width;
            }
        }
        if (varColumns != null) {
            int index;
            for (index = 0; index < numVarWidths; ++index) {
                offsetAndWidth = offsetAndWidths[index];
                if (offsetAndWidth >= 0L) {
                    width = (int)offsetAndWidth;
                    offset = (int)(offsetAndWidth >>> 32);
                    OffHeapRegionEntryHelper.copyBytesToDataOutput((UnsafeWrapper)unsafe, (long)(memAddr + (long)offset), (int)width, (DataOutput)out);
                    offsetAndWidths[index] = targetFormat.getVarDataOffset(varOffset);
                    varOffset += width;
                    continue;
                }
                if (offsetAndWidth == -7L) {
                    offsetAndWidths[index] = targetFormat.getNullIndicator(varOffset);
                    continue;
                }
                assert (offsetAndWidth == -6L) : offsetAndWidth;
                byte[] defaultBytes = this.columns[varColumns[index] - 1].columnDefaultBytes;
                if (defaultBytes == null) {
                    offsetAndWidths[index] = targetFormat.getNullIndicator(varOffset);
                } else {
                    out.write(defaultBytes, 0, defaultBytes.length);
                    offsetAndWidths[index] = targetFormat.getVarDataOffset(varOffset);
                }
                offsetAndWidths[index] = targetFormatOffsetIsDefault;
            }
            for (index = 0; index < numVarWidths; ++index) {
                RowFormatter.writeInt(out, (int)offsetAndWidths[index], targetFormatOffsetBytes);
            }
        }
    }

    public final int getColumnsWidth(byte[] rowBytes, int[] fixedColumns, int[] varColumns, RowFormatter targetFormat) {
        assert (fixedColumns != null || varColumns != null);
        int sz = targetFormat.nVersionBytes;
        if (fixedColumns != null) {
            for (int pos : fixedColumns) {
                sz += this.columns[pos - 1].fixedWidth;
            }
        }
        if (varColumns != null) {
            int targetFormatOffsetBytes = targetFormat.offsetBytes;
            for (int pos : varColumns) {
                int posIndex = pos - 1;
                sz += this.getColumnWidth(posIndex, rowBytes, this.columns[posIndex]);
                sz += targetFormatOffsetBytes;
            }
        }
        return sz;
    }

    public final int getColumnsWidth(OffHeapByteSource rowBytes, int[] fixedColumns, int[] varColumns, RowFormatter targetFormat) {
        assert (fixedColumns != null || varColumns != null);
        int sz = targetFormat.nVersionBytes;
        if (fixedColumns != null) {
            for (int pos : fixedColumns) {
                sz += this.columns[pos - 1].fixedWidth;
            }
        }
        if (varColumns != null) {
            int targetFormatOffsetBytes = targetFormat.offsetBytes;
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = rowBytes.getLength();
            long memAddr = rowBytes.getUnsafeAddress(0, bytesLen);
            for (int pos : varColumns) {
                int posIndex = pos - 1;
                sz += this.getColumnWidth(posIndex, unsafe, memAddr, bytesLen, this.columns[posIndex]);
                sz += targetFormatOffsetBytes;
            }
        }
        return sz;
    }

    public final void writeAsUTF8BytesForPXF(int logicalPosition, byte[] bytes, ByteArrayDataOutput buffer) throws StandardException {
        int index = logicalPosition - 1;
        int offsetFromMap = this.positionMap[index];
        ColumnDescriptor cd = this.columns[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, bytes, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            DataTypeUtilities.writeAsUTF8BytesForPXF(bytes, offset, columnWidth, cd.columnType, buffer);
        } else {
            DataValueDescriptor dvd;
            assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
            if (offsetAndWidth == -6L && (dvd = cd.columnDefault) != null && !dvd.isNull()) {
                buffer.writeBytes(dvd.getString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void writeAsUTF8BytesForPXF(int logicalPosition, byte[][] byteArrays, ByteArrayDataOutput buffer) throws StandardException {
        int columnWidth;
        int offset;
        byte[] bytes;
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        int offsetFromMap = this.positionMap[index];
        if (cd.isLob) {
            bytes = offsetFromMap != 0 ? byteArrays[offsetFromMap] : cd.columnDefaultBytes;
            offset = 0;
            if (bytes == null) return;
            columnWidth = bytes.length;
        } else {
            bytes = byteArrays[0];
            long offsetAndWidth = this.getOffsetAndWidth(index, bytes, offsetFromMap, cd);
            if (offsetAndWidth >= 0L) {
                columnWidth = (int)offsetAndWidth;
                offset = (int)(offsetAndWidth >>> 32);
            } else {
                DataValueDescriptor dvd;
                assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
                if (offsetAndWidth != -6L || (dvd = cd.columnDefault) == null || dvd.isNull()) return;
                buffer.writeBytes(dvd.getString());
                return;
            }
        }
        DataTypeUtilities.writeAsUTF8BytesForPXF(bytes, offset, columnWidth, cd.columnType, buffer);
    }

    public final void writeAsUTF8BytesForPXF(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, ByteArrayDataOutput buffer) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            DataTypeUtilities.writeAsUTF8BytesForPXF(unsafe, memAddr + (long)offset, columnWidth, bs, cd.columnType, buffer);
        } else {
            DataValueDescriptor dvd;
            assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
            if (offsetAndWidth == -6L && (dvd = cd.columnDefault) != null && !dvd.isNull()) {
                buffer.writeBytes(dvd.getString());
            }
        }
    }

    public final void writeAsUTF8BytesForPXF(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long firstBSAddr, int firstBytesLen, OffHeapRowWithLobs byteArrays, ByteArrayDataOutput buffer) throws StandardException {
        if (!cd.isLob) {
            this.writeAsUTF8BytesForPXF(index, cd, unsafe, firstBSAddr, firstBytesLen, (OffHeapByteSource)byteArrays, buffer);
        } else {
            Object lob;
            int offsetFromMap = this.positionMap[index];
            Object object = lob = offsetFromMap != 0 ? (Object)byteArrays.getGfxdByteSource(offsetFromMap) : cd.columnDefaultBytes;
            if (lob != null) {
                if (lob instanceof byte[]) {
                    Object bytes = lob;
                    DataTypeUtilities.writeAsUTF8BytesForPXF((byte[])bytes, 0, ((byte[])bytes).length, cd.columnType, buffer);
                } else {
                    OffHeapByteSource bs = (OffHeapByteSource)((Object)lob);
                    int bytesLen = bs.getLength();
                    long memAddr = bs.getUnsafeAddress(0, bytesLen);
                    DataTypeUtilities.writeAsUTF8BytesForPXF(unsafe, memAddr, bytesLen, bs, cd.columnType, buffer);
                }
            }
        }
    }

    final DataValueDescriptor[] getAllColumns(byte[] bytes) throws StandardException {
        int numColumns = this.getNumColumns();
        DataValueDescriptor[] dvds = new DataValueDescriptor[numColumns];
        for (int index = 0; index < numColumns; ++index) {
            dvds[index] = this.getColumn(index + 1, bytes);
        }
        return dvds;
    }

    final DataValueDescriptor[] getAllColumns(OffHeapRow bytes) throws StandardException {
        int numColumns = this.getNumColumns();
        DataValueDescriptor[] dvds = new DataValueDescriptor[numColumns];
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        for (int index = 0; index < numColumns; ++index) {
            dvds[index] = this.getColumn(index + 1, unsafe, memAddr, bytesLen, bytes);
        }
        return dvds;
    }

    final DataValueDescriptor[] getAllColumns(OffHeapRowWithLobs byteArrays) throws StandardException {
        int numColumns = this.getNumColumns();
        DataValueDescriptor[] dvds = new DataValueDescriptor[numColumns];
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen0th = byteArrays.getLength();
        long memAddr0th = byteArrays.getUnsafeAddress(0, bytesLen0th);
        for (int index = 0; index < numColumns; ++index) {
            dvds[index] = this.getColumn(index + 1, unsafe, memAddr0th, bytesLen0th, byteArrays);
        }
        return dvds;
    }

    final DataValueDescriptor[] getAllColumns(byte[][] byteArrays) throws StandardException {
        int numColumns = this.getNumColumns();
        DataValueDescriptor[] dvds = new DataValueDescriptor[numColumns];
        for (int index = 0; index < numColumns; ++index) {
            dvds[index] = this.getColumn(index + 1, byteArrays);
        }
        return dvds;
    }

    public final int getNumColumns() {
        return this.positionMap.length;
    }

    private final int getVarDataOffset(int varDataOffset) {
        return this.schemaVersion != -1 ? varDataOffset : (varDataOffset > 0 ? varDataOffset - TOKEN_RECOVERY_VERSION_BYTES : varDataOffset + TOKEN_RECOVERY_VERSION_BYTES);
    }

    public final int getNullIndicator(int varOffset) {
        return this.schemaVersion != -1 ? -(varOffset + 1) : -(varOffset - TOKEN_RECOVERY_VERSION_BYTES + 1);
    }

    public final int readVarDataOffset(UnsafeWrapper unsafe, long memAddr, int offsetOffset) {
        int offset = RowFormatter.readInt(unsafe, memAddr + (long)offsetOffset, this.offsetBytes);
        return this.schemaVersion != -1 ? offset : (offset >= 0 ? offset + TOKEN_RECOVERY_VERSION_BYTES : offset - TOKEN_RECOVERY_VERSION_BYTES);
    }

    public final int readVarDataOffset(byte[] bytes, int offsetOffset) {
        int offset = RowFormatter.readInt(bytes, offsetOffset, this.offsetBytes);
        return this.schemaVersion != -1 ? offset : (offset >= 0 ? offset + TOKEN_RECOVERY_VERSION_BYTES : offset - TOKEN_RECOVERY_VERSION_BYTES);
    }

    public static final boolean shouldTrimTrailingSpaces(ColumnDescriptor cd) {
        int typeId = cd.getType().getTypeId().getTypeFormatId();
        return typeId == 13 || typeId == 27;
    }

    public final boolean isVarDataOffsetDefaultToken(int offset) {
        return this.schemaVersion != -1 ? offset == this.offsetIsDefault : offset - TOKEN_RECOVERY_VERSION_BYTES == this.offsetIsDefault;
    }

    private int generateColumn(int index, DataValueDescriptor dvd, ColumnDescriptor cd, byte[] bytes, int varDataOffset) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        assert (!cd.isLob) : "unexpected LOB column to generateColumn: " + cd;
        if (offsetFromMap < 0) {
            int offsetOffset = bytes.length + offsetFromMap;
            DataValueDescriptor defaultValue = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                if (defaultValue == null || !defaultValue.equals(dvd)) {
                    RowFormatter.writeInt(bytes, this.getVarDataOffset(varDataOffset), offsetOffset, this.offsetBytes);
                    int numBytesWritten = dvd.writeBytes(bytes, varDataOffset, cd.columnType);
                    assert (numBytesWritten == dvd.getLengthInBytes(cd.columnType));
                    return numBytesWritten;
                }
                RowFormatter.writeInt(bytes, this.offsetIsDefault, offsetOffset, this.offsetBytes);
                return 0;
            }
            RowFormatter.writeInt(bytes, this.getNullIndicator(varDataOffset), offsetOffset, this.offsetBytes);
            return 0;
        }
        assert (offsetFromMap >= this.nVersionBytes) : "unexpected offsetFromMap=" + offsetFromMap + " for schemaVersion=" + this.schemaVersion;
        if (dvd != null && !dvd.isNull()) {
            int numBytesWritten = dvd.writeBytes(bytes, offsetFromMap, cd.columnType);
            assert (numBytesWritten == dvd.getLengthInBytes(cd.columnType));
        }
        return 0;
    }

    private byte[] generateLobColumn(DataValueDescriptor dvd, ColumnDescriptor cd) throws StandardException {
        assert (cd.isLob) : "unexpected non-LOB column to generateLobColumn: " + cd;
        DataTypeDescriptor type = cd.columnType;
        int jdbcType = type.getJDBCTypeId();
        switch (jdbcType) {
            case 2000: 
            case 2004: {
                if (dvd != null && !dvd.isNull()) {
                    return dvd.getBytes();
                }
                return null;
            }
        }
        assert (jdbcType == 2005 || jdbcType == 2009 || jdbcType == 4002) : "unexpected LOB type to generateLobColumn: " + cd;
        if (dvd != null && !dvd.isNull()) {
            byte[] lobBytes = new byte[dvd.getLengthInBytes(type)];
            int numBytesWritten = dvd.writeBytes(lobBytes, 0, type);
            assert (numBytesWritten == lobBytes.length);
            return lobBytes;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int copyColumn(int srcIndex, byte[] srcBytes, RowFormatter srcFormat, byte[] outBytes, int outIndex, int varDataOffset) {
        int columnWidth;
        int srcOffset;
        int offsetFromMap = this.positionMap[outIndex];
        if (offsetFromMap >= this.nVersionBytes) {
            int srcOffsetOffset;
            int srcOffset2;
            ColumnDescriptor cd = this.columns[outIndex];
            int srcOffsetFromMap = srcFormat.positionMap[srcIndex];
            int columnWidth2 = cd.fixedWidth;
            if (srcOffsetFromMap >= srcFormat.nVersionBytes) {
                assert (columnWidth2 > 0) : "unexpected fixed width " + columnWidth2 + " for column: " + cd;
                System.arraycopy(srcBytes, srcOffsetFromMap, outBytes, offsetFromMap, columnWidth2);
                return 0;
            }
            ColumnDescriptor srcCD = srcFormat.columns[srcIndex];
            assert (cd.getType().equals(srcCD.getType())) : "unexpected change in column type from [" + srcCD + "] to [" + cd + "] from schemaVersion=" + srcFormat.schemaVersion + " to schemaVersion=" + this.schemaVersion;
            if (srcOffsetFromMap < 0 && (srcOffset2 = srcFormat.readVarDataOffset(srcBytes, srcOffsetOffset = srcBytes.length + srcOffsetFromMap)) >= srcFormat.nVersionBytes) {
                System.arraycopy(srcBytes, srcOffset2, outBytes, offsetFromMap, columnWidth2);
                return 0;
            }
            assert (srcCD.columnDefaultBytes != null);
            System.arraycopy(srcCD.columnDefaultBytes, 0, outBytes, offsetFromMap, columnWidth2);
            return 0;
        }
        if (offsetFromMap >= 0) return 0;
        int srcOffsetFromMap = srcFormat.positionMap[srcIndex];
        ColumnDescriptor srcCD = null;
        int outOffsetOffset = outBytes.length + offsetFromMap;
        if (srcOffsetFromMap < 0) {
            int srcBytesLength = srcBytes.length;
            int srcOffsetOffset = srcBytesLength + srcOffsetFromMap;
            srcOffset = srcFormat.readVarDataOffset(srcBytes, srcOffsetOffset);
            columnWidth = srcOffset >= srcFormat.nVersionBytes ? srcFormat.getVarColumnWidth(srcBytes, srcBytesLength, srcOffsetOffset, srcOffset) : 0;
        } else if (srcOffsetFromMap >= srcFormat.nVersionBytes) {
            srcOffset = srcOffsetFromMap;
            srcCD = srcFormat.columns[srcIndex];
            columnWidth = srcCD.fixedWidth;
        } else {
            srcCD = srcFormat.columns[srcIndex];
            if (srcCD.columnDefault != null) {
                srcOffset = srcFormat.offsetIsDefault;
                columnWidth = 0;
            } else {
                srcOffset = -1;
                columnWidth = 0;
            }
        }
        if (srcOffset >= srcFormat.nVersionBytes) {
            RowFormatter.writeInt(outBytes, this.getVarDataOffset(varDataOffset), outOffsetOffset, this.offsetBytes);
            System.arraycopy(srcBytes, srcOffset, outBytes, varDataOffset, columnWidth);
            return columnWidth;
        }
        if (srcOffset != srcFormat.offsetIsDefault) {
            RowFormatter.writeInt(outBytes, this.getNullIndicator(varDataOffset), outOffsetOffset, this.offsetBytes);
            return 0;
        }
        ColumnDescriptor cd = this.columns[outIndex];
        if (cd.columnDefault == srcCD.columnDefault) {
            RowFormatter.writeInt(outBytes, this.offsetIsDefault, outOffsetOffset, this.offsetBytes);
            return 0;
        }
        byte[] defaultBytes = srcCD.columnDefaultBytes;
        RowFormatter.writeInt(outBytes, this.getVarDataOffset(varDataOffset), outOffsetOffset, this.offsetBytes);
        System.arraycopy(defaultBytes, 0, outBytes, varDataOffset, defaultBytes.length);
        return defaultBytes.length;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int copyColumn(int srcIndex, UnsafeWrapper unsafe, long memAddr, int bytesLen, RowFormatter srcFormat, byte[] outBytes, int outIndex, int varDataOffset) {
        int columnWidth;
        int srcOffset;
        int offsetFromMap = this.positionMap[outIndex];
        if (offsetFromMap >= this.nVersionBytes) {
            int srcOffsetOffset;
            int srcOffset2;
            int srcOffsetFromMap = srcFormat.positionMap[srcIndex];
            ColumnDescriptor cd = this.columns[outIndex];
            int columnWidth2 = cd.fixedWidth;
            if (srcOffsetFromMap >= srcFormat.nVersionBytes) {
                assert (columnWidth2 > 0) : "unexpected fixed width " + columnWidth2 + " for column: " + cd;
                UnsafeMemoryChunk.readUnsafeBytes((UnsafeWrapper)unsafe, (long)memAddr, (int)srcOffsetFromMap, (byte[])outBytes, (int)offsetFromMap, (int)columnWidth2);
                return 0;
            }
            ColumnDescriptor srcCD = srcFormat.columns[srcIndex];
            assert (cd.getType().equals(srcCD.getType())) : "unexpected change in column type from [" + srcCD + "] to [" + cd + "] from schemaVersion=" + srcFormat.schemaVersion + " to schemaVersion=" + this.schemaVersion;
            if (srcOffsetFromMap < 0 && (srcOffset2 = srcFormat.readVarDataOffset(unsafe, memAddr, srcOffsetOffset = bytesLen + srcOffsetFromMap)) >= srcFormat.nVersionBytes) {
                UnsafeMemoryChunk.readUnsafeBytes((UnsafeWrapper)unsafe, (long)memAddr, (int)srcOffset2, (byte[])outBytes, (int)offsetFromMap, (int)columnWidth2);
                return 0;
            }
            assert (srcCD.columnDefaultBytes != null);
            System.arraycopy(srcCD.columnDefaultBytes, 0, outBytes, offsetFromMap, columnWidth2);
            return 0;
        }
        if (offsetFromMap >= 0) return 0;
        int srcOffsetFromMap = srcFormat.positionMap[srcIndex];
        ColumnDescriptor srcCD = null;
        int outOffsetOffset = outBytes.length + offsetFromMap;
        if (srcOffsetFromMap < 0) {
            int srcOffsetOffset = bytesLen + srcOffsetFromMap;
            srcOffset = srcFormat.readVarDataOffset(unsafe, memAddr, srcOffsetOffset);
            columnWidth = srcOffset >= srcFormat.nVersionBytes ? srcFormat.getVarColumnWidth(unsafe, memAddr, bytesLen, srcOffsetOffset, srcOffset) : 0;
        } else if (srcOffsetFromMap >= srcFormat.nVersionBytes) {
            srcOffset = srcOffsetFromMap;
            srcCD = srcFormat.columns[srcIndex];
            columnWidth = srcCD.fixedWidth;
        } else {
            srcCD = srcFormat.columns[srcIndex];
            if (srcCD.columnDefault != null) {
                srcOffset = srcFormat.offsetIsDefault;
                columnWidth = 0;
            } else {
                srcOffset = -1;
                columnWidth = 0;
            }
        }
        if (srcOffset >= srcFormat.nVersionBytes) {
            RowFormatter.writeInt(outBytes, this.getVarDataOffset(varDataOffset), outOffsetOffset, this.offsetBytes);
            UnsafeMemoryChunk.readUnsafeBytes((UnsafeWrapper)unsafe, (long)memAddr, (int)srcOffset, (byte[])outBytes, (int)varDataOffset, (int)columnWidth);
            return columnWidth;
        }
        if (srcOffset != srcFormat.offsetIsDefault) {
            RowFormatter.writeInt(outBytes, this.getNullIndicator(varDataOffset), outOffsetOffset, this.offsetBytes);
            return 0;
        }
        ColumnDescriptor cd = this.columns[outIndex];
        if (cd.columnDefault == srcCD.columnDefault) {
            RowFormatter.writeInt(outBytes, this.offsetIsDefault, outOffsetOffset, this.offsetBytes);
            return 0;
        }
        byte[] defaultBytes = srcCD.columnDefaultBytes;
        RowFormatter.writeInt(outBytes, this.getVarDataOffset(varDataOffset), outOffsetOffset, this.offsetBytes);
        System.arraycopy(defaultBytes, 0, outBytes, varDataOffset, defaultBytes.length);
        return defaultBytes.length;
    }

    private int computeRowLength(DataValueDescriptor[] dvds) throws StandardException {
        assert (dvds.length == this.positionMap.length) : "dvds.length=" + dvds.length + ";RowFormatter.size=" + this.positionMap.length;
        int dataLength = this.nVersionBytes;
        for (int index = 0; index < dvds.length; ++index) {
            ColumnDescriptor cd = this.columns[index];
            int columnWidth = cd.fixedWidth;
            if (columnWidth == -1) {
                dataLength += this.getVarColumnWidth(dvds[index], cd);
                dataLength += this.offsetBytes;
                continue;
            }
            dataLength += columnWidth;
        }
        return dataLength;
    }

    private int computeRowLength(DataValueDescriptor dvd) throws StandardException {
        assert (1 == this.positionMap.length) : "dvds.length=1;RowFormatter.size=" + this.positionMap.length;
        int dataLength = this.nVersionBytes;
        ColumnDescriptor cd = this.columns[0];
        int columnWidth = cd.fixedWidth;
        if (columnWidth == -1) {
            dataLength += this.getVarColumnWidth(dvd, cd);
            dataLength += this.offsetBytes;
        } else {
            dataLength += columnWidth;
        }
        return dataLength;
    }

    private int[] initNumVarWidthCols(ColumnDescriptorList cdl, int numCols) {
        int[] result = new int[5];
        result[4] = this.nVersionBytes;
        long maxDataLength = this.nVersionBytes;
        boolean hasUnknown = false;
        for (int index = 0; index < numCols; ++index) {
            ColumnDescriptor cd = cdl.elementAt(index);
            int width = this.calcMaxColumnWidth(cd, result);
            if (width >= 0) {
                maxDataLength += (long)width;
                continue;
            }
            hasUnknown = true;
        }
        if (hasUnknown || maxDataLength > Integer.MAX_VALUE) {
            maxDataLength = Integer.MAX_VALUE;
        }
        this.calcNumOffsetBytesToUse((int)maxDataLength, result[4], result);
        return result;
    }

    private int[] initNumVarWidthCols(ColumnDescriptor[] cdl, int numCols) {
        int[] result = new int[5];
        result[4] = this.nVersionBytes;
        long maxDataLength = this.nVersionBytes;
        boolean hasUnknown = false;
        for (int index = 0; index < numCols; ++index) {
            ColumnDescriptor cd = cdl[index];
            int width = this.calcMaxColumnWidth(cd, result);
            if (width >= 0) {
                maxDataLength += (long)width;
                continue;
            }
            hasUnknown = true;
        }
        if (hasUnknown || maxDataLength > Integer.MAX_VALUE) {
            maxDataLength = Integer.MAX_VALUE;
        }
        this.calcNumOffsetBytesToUse((int)maxDataLength, result[4], result);
        return result;
    }

    private int[] initNumVarWidthCols(ColumnDescriptorList cdl, FormatableBitSet validColumns) {
        int[] result = new int[5];
        result[4] = this.nVersionBytes;
        long maxDataLength = this.nVersionBytes;
        boolean hasUnknown = false;
        int colIndex = validColumns.anySetBit();
        while (colIndex != -1) {
            ColumnDescriptor cd = cdl.elementAt(colIndex);
            int width = this.calcMaxColumnWidth(cd, result);
            if (width >= 0) {
                maxDataLength += (long)width;
            } else {
                hasUnknown = true;
            }
            colIndex = validColumns.anySetBit(colIndex);
        }
        if (hasUnknown || maxDataLength > Integer.MAX_VALUE) {
            maxDataLength = Integer.MAX_VALUE;
        }
        this.calcNumOffsetBytesToUse((int)maxDataLength, result[4], result);
        return result;
    }

    private int[] initNumVarWidthCols(ColumnDescriptorList cdl, int[] validColumns) {
        int[] result = new int[5];
        result[4] = this.nVersionBytes;
        long maxDataLength = this.nVersionBytes;
        boolean hasUnknown = false;
        for (int pos : validColumns) {
            ColumnDescriptor cd = cdl.elementAt(pos - 1);
            int width = this.calcMaxColumnWidth(cd, result);
            if (width >= 0) {
                maxDataLength += (long)width;
                continue;
            }
            hasUnknown = true;
        }
        if (hasUnknown || maxDataLength > Integer.MAX_VALUE) {
            maxDataLength = Integer.MAX_VALUE;
        }
        this.calcNumOffsetBytesToUse((int)maxDataLength, result[4], result);
        return result;
    }

    private int[] initNumVarWidthCols(ColumnQueryInfo[] cqi) {
        int[] result = new int[5];
        result[4] = this.nVersionBytes;
        long maxDataLength = this.nVersionBytes;
        boolean hasUnknown = false;
        for (int index = 0; index < cqi.length; ++index) {
            ColumnDescriptor cd = cqi[index].getColumnDescriptor();
            int width = this.calcMaxColumnWidth(cd, result);
            if (width >= 0) {
                maxDataLength += (long)width;
                continue;
            }
            hasUnknown = true;
        }
        if (hasUnknown || maxDataLength > Integer.MAX_VALUE) {
            maxDataLength = Integer.MAX_VALUE;
        }
        this.calcNumOffsetBytesToUse((int)maxDataLength, result[4], result);
        return result;
    }

    private int calcMaxColumnWidth(ColumnDescriptor cd, int[] result) {
        if (!cd.isLob) {
            int width = RowFormatter.getFixedWidthInBytes(cd.columnType, cd);
            if (width >= 0) {
                result[4] = result[4] + width;
                return width;
            }
            result[3] = result[3] + 1;
            width = RowFormatter.getMaxWidthInBytes(cd.columnType);
            if (width < 0) {
                if (width == Integer.MIN_VALUE) {
                    return -1;
                }
                return -width;
            }
            return width;
        }
        return 0;
    }

    private void calcNumOffsetBytesToUse(int maxDataLength, int numVarLengthCols, int[] result) {
        int offsetIsDefault;
        int maxVarWidth;
        int offsetBytes;
        if (this.schemaVersion != -1) {
            offsetBytes = RowFormatter.getOffsetBytesForLength(maxDataLength, numVarLengthCols);
        } else {
            assert (this.nVersionBytes == TOKEN_RECOVERY_VERSION_BYTES) : "unexpected versionBytes=" + this.nVersionBytes + " TOKEN_RECOVERY_VERSION_BYTES=" + TOKEN_RECOVERY_VERSION_BYTES;
            offsetBytes = RowFormatter.getOffsetBytesForLength(maxDataLength - TOKEN_RECOVERY_VERSION_BYTES, numVarLengthCols);
        }
        switch (offsetBytes) {
            case 1: {
                maxVarWidth = 127;
                offsetIsDefault = -(maxVarWidth + 1);
                break;
            }
            case 2: {
                maxVarWidth = Short.MAX_VALUE;
                offsetIsDefault = -(maxVarWidth + 1);
                break;
            }
            case 3: {
                maxVarWidth = 0x7FFFFF;
                offsetIsDefault = -(maxVarWidth + 1);
                break;
            }
            default: {
                assert (offsetBytes == 4) : offsetBytes;
                maxVarWidth = Integer.MAX_VALUE;
                offsetIsDefault = Integer.MIN_VALUE;
            }
        }
        result[0] = offsetBytes;
        result[1] = offsetIsDefault;
        result[2] = maxVarWidth;
    }

    public static int getOffsetBytesForLength(long maxDataLength, int numVarLengthCols) {
        if (maxDataLength + (long)(numVarLengthCols * 1) <= 127L) {
            return 1;
        }
        if (maxDataLength + (long)(numVarLengthCols * 2) <= 32767L) {
            return 2;
        }
        if (maxDataLength + (long)(numVarLengthCols * 3) <= 0x7FFFFFL) {
            return 3;
        }
        return 4;
    }

    public static int getOffsetValueForDefault(int offsetBytes) {
        switch (offsetBytes) {
            case 1: {
                return -128;
            }
            case 2: {
                return Short.MIN_VALUE;
            }
            case 3: {
                return -8388608;
            }
        }
        assert (offsetBytes == 4) : offsetBytes;
        return Integer.MIN_VALUE;
    }

    private int getVersionNumBytes(int version) {
        return version != 0 ? RowFormatter.getCompactIntNumBytes(version) : 0;
    }

    private byte[] getVersionBytes(int version, int nbytes) {
        if (nbytes > 1) {
            byte[] vbytes = new byte[nbytes];
            RowFormatter.writeCompactInt(vbytes, version, 0);
            return vbytes;
        }
        return null;
    }

    private byte getVersionByte(int version, int nbytes) {
        return nbytes == 1 ? RowFormatter.getCompactIntByte(version) : (byte)0;
    }

    private int getVarColumnWidth(DataValueDescriptor dvd, ColumnDescriptor cd) throws StandardException {
        if (dvd != null) {
            DataValueDescriptor defaultValue = cd.columnDefault;
            if (defaultValue == null || !defaultValue.equals(dvd)) {
                return dvd.getLengthInBytes(cd.columnType);
            }
            return 0;
        }
        return 0;
    }

    private int getVarColumnWidth(UnsafeWrapper unsafe, long memAddr, int bytesLen, int offsetOffset, int offset) {
        while ((offsetOffset += this.offsetBytes) < bytesLen) {
            int nextColumnOffset = this.readVarDataOffset(unsafe, memAddr, offsetOffset);
            if (nextColumnOffset >= 0) {
                return nextColumnOffset - offset;
            }
            if (this.isVarDataOffsetDefaultToken(nextColumnOffset)) continue;
            return -nextColumnOffset - 1 - offset;
        }
        return bytesLen - this.numVarWidthColumns * this.offsetBytes - offset;
    }

    private int getVarColumnWidth(byte[] bytes, int bytesLen, int offsetOffset, int offset) {
        while ((offsetOffset += this.offsetBytes) < bytesLen) {
            int nextColumnOffset = this.readVarDataOffset(bytes, offsetOffset);
            if (nextColumnOffset >= 0) {
                return nextColumnOffset - offset;
            }
            if (this.isVarDataOffsetDefaultToken(nextColumnOffset)) continue;
            return -nextColumnOffset - 1 - offset;
        }
        return bytesLen - this.numVarWidthColumns * this.offsetBytes - offset;
    }

    private int getColumnWidth(int index, UnsafeWrapper unsafe, long memAddr, int bytesLen, ColumnDescriptor cd) {
        return this.getColumnWidth(index, unsafe, memAddr, bytesLen, cd, false);
    }

    private int getColumnWidth(int index, UnsafeWrapper unsafe, long memAddr, int bytesLen, ColumnDescriptor cd, boolean truncateSpaces) {
        int offsetOffset;
        int offset;
        int offsetFromMap = this.positionMap[index];
        if (offsetFromMap >= this.nVersionBytes) {
            int columnWidth = cd.fixedWidth;
            assert (columnWidth > 0) : "unexpected fixed width " + columnWidth + " for column: " + cd;
            return columnWidth;
        }
        if (offsetFromMap < 0 && (offset = this.readVarDataOffset(unsafe, memAddr, offsetOffset = bytesLen + offsetFromMap)) >= this.nVersionBytes) {
            if (truncateSpaces && RowFormatter.shouldTrimTrailingSpaces(cd)) {
                return RowFormatter.trimTrailingSpaces(unsafe, memAddr, offset, this.getVarColumnWidth(unsafe, memAddr, bytesLen, offsetOffset, offset));
            }
            return this.getVarColumnWidth(unsafe, memAddr, bytesLen, offsetOffset, offset);
        }
        return 0;
    }

    private int getColumnWidth(int index, byte[] bytes, ColumnDescriptor cd) {
        return this.getColumnWidth(index, bytes, cd, false);
    }

    private int getColumnWidth(int index, byte[] bytes, ColumnDescriptor cd, boolean truncateSpaces) {
        int size;
        int offsetOffset;
        int offset;
        int offsetFromMap = this.positionMap[index];
        if (offsetFromMap >= this.nVersionBytes) {
            int columnWidth = cd.fixedWidth;
            assert (columnWidth > 0) : "unexpected fixed width " + columnWidth + " for column: " + cd;
            return columnWidth;
        }
        if (offsetFromMap < 0 && (offset = this.readVarDataOffset(bytes, offsetOffset = (size = bytes.length) + offsetFromMap)) >= this.nVersionBytes) {
            if (truncateSpaces && RowFormatter.shouldTrimTrailingSpaces(cd)) {
                return RowFormatter.trimTrailingSpaces(bytes, offset, this.getVarColumnWidth(bytes, size, offsetOffset, offset));
            }
            return this.getVarColumnWidth(bytes, size, offsetOffset, offset);
        }
        return 0;
    }

    private int getTotalColumnWidth(int index, byte[] bytes, ColumnDescriptor currentFormatCD, RowFormatter currentFormat, boolean isLatestSchema) {
        int offsetFromMap = currentFormat.positionMap[index];
        if (offsetFromMap >= currentFormat.nVersionBytes) {
            int columnWidth = currentFormatCD.fixedWidth;
            assert (columnWidth > 0) : "unexpected fixed width " + columnWidth + " for column: " + currentFormatCD;
            return columnWidth;
        }
        if (offsetFromMap < 0) {
            int thisOffsetFromMap = offsetFromMap;
            if (isLatestSchema || (thisOffsetFromMap = this.positionMap[index]) < 0) {
                int size = bytes.length;
                int offsetOffset = size + thisOffsetFromMap;
                int offset = this.readVarDataOffset(bytes, offsetOffset);
                int len = currentFormat.offsetBytes;
                if (offset >= this.nVersionBytes) {
                    len += this.getVarColumnWidth(bytes, size, offsetOffset, offset);
                }
                return len;
            }
            if (thisOffsetFromMap >= this.nVersionBytes) {
                return currentFormat.offsetBytes + currentFormatCD.fixedWidth;
            }
            ColumnDescriptor srcCD = this.getColumnDescriptor(index);
            if (this != currentFormat && srcCD.columnDefault != currentFormatCD.columnDefault) {
                return currentFormat.offsetBytes + srcCD.columnDefaultBytes.length;
            }
            return currentFormat.offsetBytes;
        }
        return currentFormat.offsetBytes;
    }

    private int getTotalColumnWidth(int index, UnsafeWrapper unsafe, long memAddr, int bytesLen, ColumnDescriptor currentFormatCD, RowFormatter currentFormat, boolean isLatestSchema) {
        int offsetFromMap = currentFormat.positionMap[index];
        if (offsetFromMap >= currentFormat.nVersionBytes) {
            int columnWidth = currentFormatCD.fixedWidth;
            assert (columnWidth > 0) : "unexpected fixed width " + columnWidth + " for column: " + currentFormatCD;
            return columnWidth;
        }
        if (offsetFromMap < 0) {
            int thisOffsetFromMap = offsetFromMap;
            if (isLatestSchema || (thisOffsetFromMap = this.positionMap[index]) < 0) {
                int offsetOffset = bytesLen + thisOffsetFromMap;
                int offset = this.readVarDataOffset(unsafe, memAddr, offsetOffset);
                int len = currentFormat.offsetBytes;
                if (offset >= this.nVersionBytes) {
                    len += this.getVarColumnWidth(unsafe, memAddr, bytesLen, offsetOffset, offset);
                }
                return len;
            }
            if (thisOffsetFromMap >= this.nVersionBytes) {
                return currentFormat.offsetBytes + currentFormatCD.fixedWidth;
            }
            ColumnDescriptor srcCD = this.getColumnDescriptor(index);
            if (this != currentFormat && srcCD.columnDefault != currentFormatCD.columnDefault) {
                return currentFormat.offsetBytes + srcCD.columnDefaultBytes.length;
            }
            return currentFormat.offsetBytes;
        }
        return currentFormat.offsetBytes;
    }

    private int getTotalColumnWidth(int srcIndex, byte[] srcBytes, RowFormatter srcFormat, ColumnDescriptor srcCD, int index, boolean isSameSchema) {
        int offsetFromMap = this.positionMap[index];
        if (offsetFromMap >= this.nVersionBytes) {
            ColumnDescriptor cd = isSameSchema ? srcCD : this.columns[index];
            int columnWidth = cd.fixedWidth;
            assert (columnWidth > 0) : "unexpected fixed width " + columnWidth + " for column: " + cd;
            return columnWidth;
        }
        if (offsetFromMap < 0) {
            boolean sameFormat = srcFormat == this;
            int srcOffsetFromMap = offsetFromMap;
            if (sameFormat || (srcOffsetFromMap = srcFormat.positionMap[srcIndex]) < 0) {
                if (srcBytes == null) {
                    return this.offsetBytes;
                }
                int srcBytesLength = srcBytes.length;
                int offsetOffset = srcBytesLength + srcOffsetFromMap;
                int offset = srcFormat.readVarDataOffset(srcBytes, offsetOffset);
                int len = this.offsetBytes;
                if (offset > 0) {
                    len += srcFormat.getVarColumnWidth(srcBytes, srcBytesLength, offsetOffset, offset);
                }
                return len;
            }
            if (srcOffsetFromMap >= srcFormat.nVersionBytes) {
                return this.offsetBytes + srcCD.fixedWidth;
            }
            if (!sameFormat && srcCD.columnDefault != this.columns[index].columnDefault) {
                return this.offsetBytes + srcCD.columnDefaultBytes.length;
            }
            return this.offsetBytes;
        }
        return this.offsetBytes;
    }

    private int getTotalColumnWidth(int srcIndex, UnsafeWrapper unsafe, long memAddr, int bytesLen, RowFormatter srcFormat, ColumnDescriptor srcCD, int index, boolean isSameSchema) {
        int offsetFromMap = this.positionMap[index];
        if (offsetFromMap >= this.nVersionBytes) {
            ColumnDescriptor cd = isSameSchema ? srcCD : this.columns[index];
            int columnWidth = cd.fixedWidth;
            assert (columnWidth > 0) : "unexpected fixed width " + columnWidth + " for column: " + cd;
            return columnWidth;
        }
        if (offsetFromMap < 0) {
            boolean sameFormat = srcFormat == this;
            int srcOffsetFromMap = offsetFromMap;
            if (sameFormat || (srcOffsetFromMap = srcFormat.positionMap[srcIndex]) < 0) {
                if (memAddr == 0L) {
                    return this.offsetBytes;
                }
                int offsetOffset = bytesLen + srcOffsetFromMap;
                int offset = srcFormat.readVarDataOffset(unsafe, memAddr, offsetOffset);
                int len = this.offsetBytes;
                if (offset > 0) {
                    len += srcFormat.getVarColumnWidth(unsafe, memAddr, bytesLen, offsetOffset, offset);
                }
                return len;
            }
            if (srcOffsetFromMap >= srcFormat.nVersionBytes) {
                return this.offsetBytes + srcCD.fixedWidth;
            }
            if (!sameFormat && srcCD.columnDefault != this.columns[index].columnDefault) {
                return this.offsetBytes + srcCD.columnDefaultBytes.length;
            }
            return this.offsetBytes;
        }
        return this.offsetBytes;
    }

    public static int getFixedWidthInBytes(DataTypeDescriptor dtd, ColumnDescriptor cd) {
        int jdbcTypeId = dtd.getJDBCTypeId();
        switch (jdbcTypeId) {
            case 2000: 
            case 2004: 
            case 2005: 
            case 2009: 
            case 4002: {
                return 0;
            }
        }
        if (dtd.isNullable() || cd.columnDefault != null) {
            return -1;
        }
        int maxWidth = RowFormatter.getMaxWidthInBytes(dtd);
        if (maxWidth >= 0) {
            return maxWidth;
        }
        return -1;
    }

    private static int getMaxWidthInBytes(DataTypeDescriptor dtd) {
        int jdbcTypeId = dtd.getJDBCTypeId();
        switch (jdbcTypeId) {
            case -5: {
                return 8;
            }
            case -7: 
            case 16: {
                return 1;
            }
            case 91: {
                return 4;
            }
            case 6: 
            case 8: {
                return 8;
            }
            case 4: {
                return 4;
            }
            case 7: {
                return 4;
            }
            case 5: {
                return 2;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return 12;
            }
            case -6: {
                return 1;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2: 
            case 3: {
                return -(dtd.getMaximumWidth() + 1);
            }
            case -1: 
            case 1: 
            case 12: {
                return -(dtd.getMaximumWidth() * 3);
            }
            case 1111: 
            case 2006: {
                return Integer.MIN_VALUE;
            }
            case 2000: 
            case 2004: 
            case 2005: 
            case 2009: 
            case 4002: {
                return 0;
            }
        }
        throw new AssertionError((Object)("unsupported variable JDBC type: " + jdbcTypeId));
    }

    public static boolean isLob(DataTypeDescriptor dtd) {
        switch (dtd.getJDBCTypeId()) {
            case 2000: 
            case 2004: 
            case 2005: 
            case 2009: 
            case 4002: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLob(int dvdFormatId) {
        switch (dvdFormatId) {
            case 266: 
            case 443: 
            case 447: 
            case 458: 
            case 464: 
            case 478: {
                return true;
            }
        }
        return false;
    }

    public final <O> int processColumn(byte[] bytes, int index, ColumnProcessor<O> processColumn, O out, int writePosition, RowFormatter targetFormat, int targetIndex) {
        int offsetFromMap = this.positionMap[index];
        ColumnDescriptor cd = this.columns[index];
        int targetOffsetFromMap = targetFormat.positionMap[targetIndex];
        if (offsetFromMap >= this.nVersionBytes) {
            int columnWidth = cd.fixedWidth;
            if (targetOffsetFromMap >= targetFormat.nVersionBytes) {
                return processColumn.handleFixed(bytes, offsetFromMap, columnWidth, out, writePosition, this, index, targetFormat, targetIndex, targetOffsetFromMap);
            }
            if (targetOffsetFromMap < 0) {
                return processColumn.handleVariable(bytes, offsetFromMap, columnWidth, out, writePosition, this, cd, index, targetFormat, targetIndex, targetOffsetFromMap);
            }
            return processColumn.handleDefault(out, writePosition, this, cd, index, targetFormat, targetIndex, targetOffsetFromMap);
        }
        long offsetAndWidth = this.getOffsetAndWidth(index, bytes, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            if (targetOffsetFromMap < 0) {
                return processColumn.handleVariable(bytes, offset, columnWidth, out, writePosition, this, cd, index, targetFormat, targetIndex, targetOffsetFromMap);
            }
            if (targetOffsetFromMap >= targetFormat.nVersionBytes) {
                return processColumn.handleFixed(bytes, offset, columnWidth, out, writePosition, this, index, targetFormat, targetIndex, targetOffsetFromMap);
            }
            return processColumn.handleDefault(out, writePosition, this, cd, index, targetFormat, targetIndex, targetOffsetFromMap);
        }
        if (offsetAndWidth == -7L) {
            return processColumn.handleNull(out, writePosition, this, cd, index, targetFormat, targetIndex, targetOffsetFromMap);
        }
        assert (offsetAndWidth == -6L) : offsetAndWidth;
        return processColumn.handleDefault(out, writePosition, this, cd, index, targetFormat, targetIndex, targetOffsetFromMap);
    }

    public final <O> int processColumn(UnsafeWrapper unsafe, long memAddress, int bytesLen, int index, ColumnProcessorOffHeap<O> processColumn, O out, int writePosition, RowFormatter targetFormat, int targetIndex) {
        int offsetFromMap = this.positionMap[index];
        ColumnDescriptor cd = this.columns[index];
        int targetOffsetFromMap = targetFormat.positionMap[targetIndex];
        if (offsetFromMap >= this.nVersionBytes) {
            int columnWidth = cd.fixedWidth;
            if (targetOffsetFromMap >= targetFormat.nVersionBytes) {
                return processColumn.handleFixed(unsafe, memAddress, offsetFromMap, columnWidth, out, writePosition, this, index, targetFormat, targetIndex, targetOffsetFromMap);
            }
            if (targetOffsetFromMap < 0) {
                return processColumn.handleVariable(unsafe, memAddress, offsetFromMap, columnWidth, out, writePosition, this, cd, index, targetFormat, targetIndex, targetOffsetFromMap);
            }
            return processColumn.handleDefault(out, writePosition, this, cd, index, targetFormat, targetIndex, targetOffsetFromMap);
        }
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddress, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            if (targetOffsetFromMap < 0) {
                return processColumn.handleVariable(unsafe, memAddress, offset, columnWidth, out, writePosition, this, cd, index, targetFormat, targetIndex, targetOffsetFromMap);
            }
            if (targetOffsetFromMap >= targetFormat.nVersionBytes) {
                return processColumn.handleFixed(unsafe, memAddress, offset, columnWidth, out, writePosition, this, index, targetFormat, targetIndex, targetOffsetFromMap);
            }
            return processColumn.handleDefault(out, writePosition, this, cd, index, targetFormat, targetIndex, targetOffsetFromMap);
        }
        if (offsetAndWidth == -7L) {
            return processColumn.handleNull(out, writePosition, this, cd, index, targetFormat, targetIndex, targetOffsetFromMap);
        }
        assert (offsetAndWidth == -6L) : offsetAndWidth;
        return processColumn.handleDefault(out, writePosition, this, cd, index, targetFormat, targetIndex, targetOffsetFromMap);
    }

    public final byte[] getLob(OffHeapRowWithLobs byteArrays, int logicalPosition) {
        int index = logicalPosition - 1;
        if (byteArrays != null) {
            int offsetFromMap = this.positionMap[index];
            if (offsetFromMap > 0) {
                if (!this.columns[index].isLob) {
                    SanityManager.THROWASSERT((String)("unexpected non-LOB column at position " + logicalPosition + ", found: " + this.columns[index]));
                }
                return byteArrays.getGfxdBytes(offsetFromMap);
            }
            if (offsetFromMap == 0) {
                return this.columns[index].columnDefaultBytes;
            }
            SanityManager.THROWASSERT((String)("getLob: unexpected offsetFromMap=" + offsetFromMap + " for column at position " + logicalPosition + ", found: " + this.columns[index]));
            return null;
        }
        return this.columns[index].columnDefaultBytes;
    }

    public final void serializeLob(OffHeapRowWithLobs byteArrays, int logicalPosition, DataOutput out) throws IOException {
        int index = logicalPosition - 1;
        if (byteArrays != null) {
            int offsetFromMap = this.positionMap[index];
            if (offsetFromMap > 0) {
                if (!this.columns[index].isLob) {
                    SanityManager.THROWASSERT((String)("unexpected non-LOB column at position " + logicalPosition + ", found: " + this.columns[index]));
                }
                byteArrays.serializeGfxdBytes(offsetFromMap, out);
            } else if (offsetFromMap == 0) {
                InternalDataSerializer.writeByteArray((byte[])this.columns[index].columnDefaultBytes, (DataOutput)out);
            } else {
                SanityManager.THROWASSERT((String)("getLob: unexpected offsetFromMap=" + offsetFromMap + " for column at position " + logicalPosition + ", found: " + this.columns[index]));
            }
        } else {
            InternalDataSerializer.writeByteArray((byte[])this.columns[index].columnDefaultBytes, (DataOutput)out);
        }
    }

    public final byte[] getLob(byte[][] byteArrays, int logicalPosition) {
        int index = logicalPosition - 1;
        if (byteArrays != null) {
            int offsetFromMap = this.positionMap[index];
            if (offsetFromMap > 0) {
                if (!this.columns[index].isLob) {
                    SanityManager.THROWASSERT((String)("unexpected non-LOB column at position " + logicalPosition + ", found: " + this.columns[index]));
                }
                return byteArrays[offsetFromMap];
            }
            if (offsetFromMap == 0) {
                return this.columns[index].columnDefaultBytes;
            }
            SanityManager.THROWASSERT((String)("getLob: unexpected offsetFromMap=" + offsetFromMap + " for column at position " + logicalPosition + ", found: " + this.columns[index]));
            return null;
        }
        return this.columns[index].columnDefaultBytes;
    }

    public final byte[] getColumnAsByteSource(byte[][] byteArrays, int logicalPosition) {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (byteArrays != null) {
            if (!cd.isLob) {
                return byteArrays[0];
            }
            int offsetFromMap = this.positionMap[index];
            if (offsetFromMap > 0) {
                return byteArrays[offsetFromMap];
            }
            if (offsetFromMap == 0) {
                return cd.columnDefaultBytes;
            }
            SanityManager.THROWASSERT((String)("getLob: unexpected offsetFromMap=" + offsetFromMap + " for column at position " + logicalPosition + ", found: " + cd));
            return null;
        }
        return cd.columnDefaultBytes;
    }

    public final Object getColumnAsByteSource(OffHeapRowWithLobs byteArrays, int logicalPosition) {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (byteArrays != null) {
            if (!cd.isLob) {
                return byteArrays;
            }
            int offsetFromMap = this.positionMap[index];
            if (offsetFromMap > 0) {
                return byteArrays.getGfxdByteSource(offsetFromMap);
            }
            if (offsetFromMap == 0) {
                return cd.columnDefaultBytes;
            }
            SanityManager.THROWASSERT((String)("getLob: unexpected offsetFromMap=" + offsetFromMap + " for column at position " + logicalPosition + ", found: " + cd));
            return null;
        }
        return cd.columnDefaultBytes;
    }

    final UTF8String getAsUTF8String(int index, byte[] bytes) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        ColumnDescriptor cd = this.columns[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, bytes, offsetFromMap, cd, false);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsUTF8String(bytes, offset, columnWidth, cd);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -7L) {
            return null;
        }
        byte[] defaultBytes = cd.columnDefaultBytes;
        if (defaultBytes != null) {
            return UTF8String.fromAddress((Object)defaultBytes, (long)Platform.BYTE_ARRAY_OFFSET, (int)defaultBytes.length);
        }
        return null;
    }

    final UTF8String getAsUTF8String(int index, byte[][] byteArrays) throws StandardException {
        byte[] bytes;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            return this.getAsUTF8String(index, byteArrays[0]);
        }
        int offsetFromMap = this.positionMap[index];
        byte[] byArray = bytes = offsetFromMap != 0 ? byteArrays[offsetFromMap] : cd.columnDefaultBytes;
        if (bytes != null) {
            return DataTypeUtilities.getAsUTF8String(bytes, 0, bytes.length, cd);
        }
        return null;
    }

    private UTF8String getAsUTF8String(int index, UnsafeWrapper unsafe, long memAddr, int bytesLen) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        ColumnDescriptor cd = this.columns[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsUTF8String(memAddr + (long)offset, columnWidth, cd);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -7L) {
            return null;
        }
        byte[] defaultBytes = cd.columnDefaultBytes;
        if (defaultBytes != null) {
            return UTF8String.fromAddress((Object)defaultBytes, (long)Platform.BYTE_ARRAY_OFFSET, (int)defaultBytes.length);
        }
        return null;
    }

    final UTF8String getAsUTF8String(int index, OffHeapRow bytes) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        return this.getAsUTF8String(index, unsafe, memAddr, bytesLen);
    }

    final UTF8String getAsUTF8String(int index, OffHeapRowWithLobs byteArrays) throws StandardException {
        Object lob;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsUTF8String(index, unsafe, memAddr, bytesLen);
        }
        int offsetFromMap = this.positionMap[index];
        Object object = lob = offsetFromMap != 0 ? (Object)byteArrays.getGfxdByteSource(offsetFromMap) : cd.columnDefaultBytes;
        if (lob != null) {
            if (lob instanceof byte[]) {
                Object bytes = lob;
                return DataTypeUtilities.getAsUTF8String((byte[])bytes, 0, ((byte[])bytes).length, cd);
            }
            OffHeapByteSource bs = (OffHeapByteSource)((Object)lob);
            int bytesLen = bs.getLength();
            long memAddr = bs.getUnsafeAddress(0, bytesLen);
            return DataTypeUtilities.getAsUTF8String(memAddr, bytesLen, cd);
        }
        return null;
    }

    final String getAsString(int index, ColumnDescriptor cd, byte[] bytes, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, bytes, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsString(bytes, offset, columnWidth, cd.columnType);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getString();
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final String getAsString(int logicalPosition, byte[] bytes, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        return this.getAsString(index, this.columns[index], bytes, wasNull);
    }

    final String getAsString(int logicalPosition, byte[][] byteArrays, ResultWasNull wasNull) throws StandardException {
        byte[] bytes;
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            return this.getAsString(index, cd, byteArrays[0], wasNull);
        }
        int offsetFromMap = this.positionMap[index];
        byte[] byArray = bytes = offsetFromMap != 0 ? byteArrays[offsetFromMap] : cd.columnDefaultBytes;
        if (bytes != null) {
            return DataTypeUtilities.getAsString(bytes, 0, bytes.length, cd.columnType);
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final String getAsString(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsString(unsafe, memAddr + (long)offset, columnWidth, bs, cd.columnType);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getString();
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final String getAsString(int logicalPosition, OffHeapRow bytes, ResultWasNull wasNull) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        return this.getAsString(index, cd, unsafe, memAddr, bytesLen, bytes, wasNull);
    }

    final String getAsString(int logicalPosition, OffHeapRowWithLobs byteArrays, ResultWasNull wasNull) throws StandardException {
        Object lob;
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsString(index, cd, unsafe, memAddr, bytesLen, byteArrays, wasNull);
        }
        int offsetFromMap = this.positionMap[index];
        Object object = lob = offsetFromMap != 0 ? (Object)byteArrays.getGfxdByteSource(offsetFromMap) : cd.columnDefaultBytes;
        if (lob != null) {
            if (lob instanceof byte[]) {
                Object bytes = lob;
                return DataTypeUtilities.getAsString((byte[])bytes, 0, ((byte[])bytes).length, cd.columnType);
            }
            OffHeapByteSource bs = (OffHeapByteSource)((Object)lob);
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = bs.getLength();
            long memAddr = bs.getUnsafeAddress(0, bytesLen);
            return DataTypeUtilities.getAsString(unsafe, memAddr, bytesLen, bs, cd.columnType);
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final Object getAsObject(int index, ColumnDescriptor cd, byte[] bytes, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, bytes, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsObject(bytes, offset, columnWidth, cd.columnType);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getObject();
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    public final Object getAsObject(int logicalPosition, byte[] bytes, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        return this.getAsObject(index, this.columns[index], bytes, wasNull);
    }

    public final Object getAsObject(int logicalPosition, byte[][] byteArrays, ResultWasNull wasNull) throws StandardException {
        byte[] bytes;
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            return this.getAsObject(index, cd, byteArrays[0], wasNull);
        }
        int offsetFromMap = this.positionMap[index];
        byte[] byArray = bytes = offsetFromMap != 0 ? byteArrays[offsetFromMap] : cd.columnDefaultBytes;
        if (bytes != null) {
            return DataTypeUtilities.getAsObject(bytes, 0, bytes.length, cd.columnType);
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    public final Object getAsObject(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsObject(unsafe, memAddr + (long)offset, columnWidth, bs, cd.columnType);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getObject();
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    public final Object getAsObject(int logicalPosition, OffHeapRow bytes, ResultWasNull wasNull) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        return this.getAsObject(index, cd, unsafe, memAddr, bytesLen, bytes, wasNull);
    }

    public final Object getAsObject(int logicalPosition, OffHeapRowWithLobs byteArrays, ResultWasNull wasNull) throws StandardException {
        Object lob;
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsObject(index, cd, unsafe, memAddr, bytesLen, byteArrays, wasNull);
        }
        int offsetFromMap = this.positionMap[index];
        Object object = lob = offsetFromMap != 0 ? (Object)byteArrays.getGfxdByteSource(offsetFromMap) : cd.columnDefaultBytes;
        if (lob != null) {
            if (lob instanceof byte[]) {
                Object bytes = lob;
                return DataTypeUtilities.getAsObject((byte[])bytes, 0, ((byte[])bytes).length, cd.columnType);
            }
            OffHeapByteSource bs = (OffHeapByteSource)((Object)lob);
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = bs.getLength();
            long memAddr = bs.getUnsafeAddress(0, bytesLen);
            return DataTypeUtilities.getAsObject(unsafe, memAddr, bytesLen, bs, cd.columnType);
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final boolean getAsBoolean(int logicalPosition, byte[] bytes, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        int offsetFromMap = this.positionMap[index];
        if (offsetFromMap >= this.nVersionBytes) {
            return DataTypeUtilities.getAsBoolean(bytes, offsetFromMap, cd.fixedWidth, cd.columnType);
        }
        long offsetAndWidth = this.getVarOffsetAndWidth(bytes, offsetFromMap, cd, false);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsBoolean(bytes, offset, columnWidth, cd.columnType);
        }
        if (offsetAndWidth == -7L) {
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return false;
        }
        assert (offsetAndWidth == -6L) : offsetAndWidth;
        DataValueDescriptor dvd = cd.columnDefault;
        if (dvd != null && !dvd.isNull()) {
            return dvd.getBoolean();
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return false;
    }

    final boolean getAsBoolean(int logicalPosition, byte[][] byteArrays, ResultWasNull wasNull) throws StandardException {
        ColumnDescriptor cd = this.columns[logicalPosition - 1];
        if (!cd.isLob) {
            return this.getAsBoolean(logicalPosition, byteArrays[0], wasNull);
        }
        throw StandardException.newException("22005", (Object)"BOOLEAN", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final boolean getAsBoolean(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsBoolean(unsafe, memAddr + (long)offset, columnWidth, bs, cd.columnType);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getBoolean();
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return false;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return false;
    }

    final boolean getAsBoolean(int logicalPosition, OffHeapRow bytes, ResultWasNull wasNull) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        return this.getAsBoolean(index, this.columns[index], unsafe, memAddr, bytesLen, bytes, wasNull);
    }

    final boolean getAsBoolean(int logicalPosition, OffHeapRowWithLobs byteArrays, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsBoolean(index, cd, unsafe, memAddr, bytesLen, byteArrays, wasNull);
        }
        throw StandardException.newException("22005", (Object)"BOOLEAN", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final byte getAsByte(int logicalPosition, byte[] bytes, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        int offsetFromMap = this.positionMap[index];
        if (offsetFromMap >= this.nVersionBytes) {
            return DataTypeUtilities.getAsByte(bytes, offsetFromMap, cd.fixedWidth, cd);
        }
        long offsetAndWidth = this.getVarOffsetAndWidth(bytes, offsetFromMap, cd, false);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsByte(bytes, offset, columnWidth, cd);
        }
        if (offsetAndWidth == -7L) {
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return 0;
        }
        assert (offsetAndWidth == -6L) : offsetAndWidth;
        DataValueDescriptor dvd = cd.columnDefault;
        if (dvd != null && !dvd.isNull()) {
            return dvd.getByte();
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0;
    }

    final byte getAsByte(int logicalPosition, byte[][] byteArrays, ResultWasNull wasNull) throws StandardException {
        ColumnDescriptor cd = this.columns[logicalPosition - 1];
        if (!cd.isLob) {
            return this.getAsByte(logicalPosition, byteArrays[0], wasNull);
        }
        throw StandardException.newException("22005", (Object)"TINYINT", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final byte getAsByte(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsByte(unsafe, memAddr + (long)offset, columnWidth, bs, cd);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getByte();
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return 0;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0;
    }

    final byte getAsByte(int logicalPosition, OffHeapRow bytes, ResultWasNull wasNull) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        return this.getAsByte(index, this.columns[index], unsafe, memAddr, bytesLen, bytes, wasNull);
    }

    final byte getAsByte(int logicalPosition, OffHeapRowWithLobs byteArrays, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsByte(index, cd, unsafe, memAddr, bytesLen, byteArrays, wasNull);
        }
        throw StandardException.newException("22005", (Object)"TINYINT", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final short getAsShort(int logicalPosition, byte[] bytes, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        int offsetFromMap = this.positionMap[index];
        if (offsetFromMap >= this.nVersionBytes) {
            return DataTypeUtilities.getAsShort(bytes, offsetFromMap, cd.fixedWidth, cd);
        }
        long offsetAndWidth = this.getVarOffsetAndWidth(bytes, offsetFromMap, cd, false);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsShort(bytes, offset, columnWidth, cd);
        }
        if (offsetAndWidth == -7L) {
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return 0;
        }
        assert (offsetAndWidth == -6L) : offsetAndWidth;
        DataValueDescriptor dvd = cd.columnDefault;
        if (dvd != null && !dvd.isNull()) {
            return dvd.getShort();
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0;
    }

    final short getAsShort(int logicalPosition, byte[][] byteArrays, ResultWasNull wasNull) throws StandardException {
        ColumnDescriptor cd = this.columns[logicalPosition - 1];
        if (!cd.isLob) {
            return this.getAsShort(logicalPosition, byteArrays[0], wasNull);
        }
        throw StandardException.newException("22005", (Object)"SMALLINT", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final short getAsShort(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsShort(unsafe, memAddr + (long)offset, columnWidth, bs, cd);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getShort();
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return 0;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0;
    }

    final short getAsShort(int logicalPosition, OffHeapRow bytes, ResultWasNull wasNull) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        return this.getAsShort(index, this.columns[index], unsafe, memAddr, bytesLen, bytes, wasNull);
    }

    final short getAsShort(int logicalPosition, OffHeapRowWithLobs byteArrays, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsShort(index, cd, unsafe, memAddr, bytesLen, byteArrays, wasNull);
        }
        throw StandardException.newException("22005", (Object)"SMALLINT", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    public final int getAsInt(int logicalPosition, byte[] bytes, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        int offsetFromMap = this.positionMap[index];
        if (offsetFromMap >= this.nVersionBytes) {
            return DataTypeUtilities.getAsInt(bytes, offsetFromMap, cd.fixedWidth, cd);
        }
        long offsetAndWidth = this.getVarOffsetAndWidth(bytes, offsetFromMap, cd, false);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsInt(bytes, offset, columnWidth, cd);
        }
        if (offsetAndWidth == -7L) {
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return 0;
        }
        assert (offsetAndWidth == -6L) : offsetAndWidth;
        DataValueDescriptor dvd = cd.columnDefault;
        if (dvd != null && !dvd.isNull()) {
            return dvd.getInt();
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0;
    }

    public final int getAsInt(int logicalPosition, byte[][] byteArrays, ResultWasNull wasNull) throws StandardException {
        ColumnDescriptor cd = this.columns[logicalPosition - 1];
        if (!cd.isLob) {
            return this.getAsInt(logicalPosition, byteArrays[0], wasNull);
        }
        throw StandardException.newException("22005", (Object)"INTEGER", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final int getAsInt(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsInt(unsafe, memAddr + (long)offset, columnWidth, bs, cd);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getInt();
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return 0;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0;
    }

    public final int getAsInt(int logicalPosition, OffHeapRow bytes, ResultWasNull wasNull) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        return this.getAsInt(index, this.columns[index], unsafe, memAddr, bytesLen, bytes, wasNull);
    }

    public final int getAsInt(int logicalPosition, OffHeapRowWithLobs byteArrays, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsInt(index, cd, unsafe, memAddr, bytesLen, byteArrays, wasNull);
        }
        throw StandardException.newException("22005", (Object)"INTEGER", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final long getAsLong(int logicalPosition, byte[] bytes, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        int offsetFromMap = this.positionMap[index];
        if (offsetFromMap >= this.nVersionBytes) {
            return DataTypeUtilities.getAsLong(bytes, offsetFromMap, cd.fixedWidth, cd);
        }
        long offsetAndWidth = this.getVarOffsetAndWidth(bytes, offsetFromMap, cd, false);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsLong(bytes, offset, columnWidth, cd);
        }
        if (offsetAndWidth == -7L) {
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return 0L;
        }
        assert (offsetAndWidth == -6L) : offsetAndWidth;
        DataValueDescriptor dvd = cd.columnDefault;
        if (dvd != null && !dvd.isNull()) {
            return dvd.getLong();
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0L;
    }

    final long getAsLong(int logicalPosition, byte[][] byteArrays, ResultWasNull wasNull) throws StandardException {
        ColumnDescriptor cd = this.columns[logicalPosition - 1];
        if (!cd.isLob) {
            return this.getAsLong(logicalPosition, byteArrays[0], wasNull);
        }
        throw StandardException.newException("22005", (Object)"BIGINT", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final long getAsLong(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsLong(unsafe, memAddr + (long)offset, columnWidth, bs, cd);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getLong();
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return 0L;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0L;
    }

    final long getAsLong(int logicalPosition, OffHeapRow bytes, ResultWasNull wasNull) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        return this.getAsLong(index, this.columns[index], unsafe, memAddr, bytesLen, bytes, wasNull);
    }

    final long getAsLong(int logicalPosition, OffHeapRowWithLobs byteArrays, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsLong(index, cd, unsafe, memAddr, bytesLen, byteArrays, wasNull);
        }
        throw StandardException.newException("22005", (Object)"BIGINT", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final float getAsFloat(int logicalPosition, byte[] bytes, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        int offsetFromMap = this.positionMap[index];
        if (offsetFromMap >= this.nVersionBytes) {
            return DataTypeUtilities.getAsFloat(bytes, offsetFromMap, cd.fixedWidth, cd);
        }
        long offsetAndWidth = this.getVarOffsetAndWidth(bytes, offsetFromMap, cd, false);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsFloat(bytes, offset, columnWidth, cd);
        }
        if (offsetAndWidth == -7L) {
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return 0.0f;
        }
        assert (offsetAndWidth == -6L) : offsetAndWidth;
        DataValueDescriptor dvd = cd.columnDefault;
        if (dvd != null && !dvd.isNull()) {
            return dvd.getFloat();
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0.0f;
    }

    final float getAsFloat(int logicalPosition, byte[][] byteArrays, ResultWasNull wasNull) throws StandardException {
        ColumnDescriptor cd = this.columns[logicalPosition - 1];
        if (!cd.isLob) {
            return this.getAsFloat(logicalPosition, byteArrays[0], wasNull);
        }
        throw StandardException.newException("22005", (Object)"FLOAT", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final float getAsFloat(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsFloat(unsafe, memAddr + (long)offset, columnWidth, bs, cd);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getFloat();
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return 0.0f;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0.0f;
    }

    final float getAsFloat(int logicalPosition, OffHeapRow bytes, ResultWasNull wasNull) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        return this.getAsFloat(index, this.columns[index], unsafe, memAddr, bytesLen, bytes, wasNull);
    }

    final float getAsFloat(int logicalPosition, OffHeapRowWithLobs byteArrays, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsFloat(index, cd, unsafe, memAddr, bytesLen, byteArrays, wasNull);
        }
        throw StandardException.newException("22005", (Object)"FLOAT", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final double getAsDouble(int logicalPosition, byte[] bytes, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        int offsetFromMap = this.positionMap[index];
        if (offsetFromMap >= this.nVersionBytes) {
            return DataTypeUtilities.getAsDouble(bytes, offsetFromMap, cd.fixedWidth, cd);
        }
        long offsetAndWidth = this.getVarOffsetAndWidth(bytes, offsetFromMap, cd, false);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsDouble(bytes, offset, columnWidth, cd);
        }
        if (offsetAndWidth == -7L) {
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return 0.0;
        }
        assert (offsetAndWidth == -6L) : offsetAndWidth;
        DataValueDescriptor dvd = cd.columnDefault;
        if (dvd != null && !dvd.isNull()) {
            return dvd.getDouble();
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0.0;
    }

    final double getAsDouble(int logicalPosition, byte[][] byteArrays, ResultWasNull wasNull) throws StandardException {
        ColumnDescriptor cd = this.columns[logicalPosition - 1];
        if (!cd.isLob) {
            return this.getAsDouble(logicalPosition, byteArrays[0], wasNull);
        }
        throw StandardException.newException("22005", (Object)"DOUBLE", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final double getAsDouble(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsDouble(unsafe, memAddr + (long)offset, columnWidth, bs, cd);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getDouble();
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return 0.0;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0.0;
    }

    final double getAsDouble(int logicalPosition, OffHeapRow bytes, ResultWasNull wasNull) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        return this.getAsDouble(index, this.columns[index], unsafe, memAddr, bytesLen, bytes, wasNull);
    }

    final double getAsDouble(int logicalPosition, OffHeapRowWithLobs byteArrays, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsDouble(index, cd, unsafe, memAddr, bytesLen, byteArrays, wasNull);
        }
        throw StandardException.newException("22005", (Object)"DOUBLE", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final BigDecimal getAsBigDecimal(int index, ColumnDescriptor cd, byte[] bytes, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, bytes, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsBigDecimal(bytes, offset, columnWidth, cd);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return SQLDecimal.getBigDecimal(dvd);
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final BigDecimal getAsBigDecimal(int logicalPosition, byte[] bytes, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        return this.getAsBigDecimal(index, this.columns[index], bytes, wasNull);
    }

    final BigDecimal getAsBigDecimal(int logicalPosition, byte[][] byteArrays, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            return this.getAsBigDecimal(index, cd, byteArrays[0], wasNull);
        }
        throw StandardException.newException("22005", (Object)"DECIMAL", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final BigDecimal getAsBigDecimal(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsBigDecimal(unsafe, memAddr + (long)offset, columnWidth, bs, cd);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return SQLDecimal.getBigDecimal(dvd);
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final BigDecimal getAsBigDecimal(int logicalPosition, OffHeapRow bytes, ResultWasNull wasNull) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        return this.getAsBigDecimal(index, this.columns[index], unsafe, memAddr, bytesLen, bytes, wasNull);
    }

    final BigDecimal getAsBigDecimal(int logicalPosition, OffHeapRowWithLobs byteArrays, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsBigDecimal(index, cd, unsafe, memAddr, bytesLen, byteArrays, wasNull);
        }
        throw StandardException.newException("22005", (Object)"DECIMAL", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final byte[] getAsBytes(int index, ColumnDescriptor cd, byte[] bytes, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, bytes, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsBytes(bytes, offset, columnWidth, cd.columnType);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getBytes();
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final byte[] getAsBytes(int logicalPosition, byte[] bytes, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        return this.getAsBytes(index, this.columns[index], bytes, wasNull);
    }

    final byte[] getAsBytes(int logicalPosition, byte[][] byteArrays, ResultWasNull wasNull) throws StandardException {
        byte[] bytes;
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            return this.getAsBytes(index, cd, byteArrays[0], wasNull);
        }
        int offsetFromMap = this.positionMap[index];
        byte[] byArray = bytes = offsetFromMap != 0 ? byteArrays[offsetFromMap] : cd.columnDefaultBytes;
        if (bytes != null) {
            return DataTypeUtilities.getAsBytes(bytes, 0, bytes.length, cd.columnType);
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final byte[] getAsBytes(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsBytes(unsafe, memAddr, offset, columnWidth, bs, cd.columnType);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getBytes();
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final byte[] getAsBytes(int logicalPosition, OffHeapRow bytes, ResultWasNull wasNull) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        return this.getAsBytes(index, cd, unsafe, memAddr, bytesLen, bytes, wasNull);
    }

    final byte[] getAsBytes(int logicalPosition, OffHeapRowWithLobs byteArrays, ResultWasNull wasNull) throws StandardException {
        Object lob;
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsBytes(index, cd, unsafe, memAddr, bytesLen, byteArrays, wasNull);
        }
        int offsetFromMap = this.positionMap[index];
        Object object = lob = offsetFromMap != 0 ? (Object)byteArrays.getGfxdByteSource(offsetFromMap) : cd.columnDefaultBytes;
        if (lob != null) {
            if (lob instanceof byte[]) {
                Object bytes = lob;
                return DataTypeUtilities.getAsBytes((byte[])bytes, 0, ((byte[])bytes).length, cd.columnType);
            }
            OffHeapByteSource bs = (OffHeapByteSource)((Object)lob);
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = bs.getLength();
            long memAddr = bs.getUnsafeAddress(0, bytesLen);
            return DataTypeUtilities.getAsBytes(unsafe, memAddr, 0, bytesLen, bs, cd.columnType);
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final long getAsDateMillis(int index, byte[] bytes, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        ColumnDescriptor cd = this.columns[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, bytes, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsDateMillis(bytes, offset, columnWidth, cal, cd.columnType);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -7L) {
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return 0L;
        }
        DataValueDescriptor dvd = cd.columnDefault;
        if (dvd != null && !dvd.isNull()) {
            return dvd.getDate(cal).getTime();
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0L;
    }

    final long getAsDateMillis(int index, byte[][] byteArrays, Calendar cal, ResultWasNull wasNull) throws StandardException {
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            return this.getAsDateMillis(index, byteArrays[0], cal, wasNull);
        }
        throw StandardException.newException("22005", (Object)"DATE", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final long getAsDateMillis(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsDateMillis(unsafe, memAddr + (long)offset, columnWidth, bs, cal, cd.columnType);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -7L) {
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return 0L;
        }
        DataValueDescriptor dvd = cd.columnDefault;
        if (dvd != null && !dvd.isNull()) {
            return dvd.getDate(cal).getTime();
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0L;
    }

    final long getAsDateMillis(int index, OffHeapRow bytes, Calendar cal, ResultWasNull wasNull) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        return this.getAsDateMillis(index, this.columns[index], unsafe, memAddr, bytesLen, bytes, cal, wasNull);
    }

    final long getAsDateMillis(int logicalPosition, OffHeapRowWithLobs byteArrays, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsDateMillis(index, cd, unsafe, memAddr, bytesLen, byteArrays, cal, wasNull);
        }
        throw StandardException.newException("22005", (Object)"DATE", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final Date getAsDate(int index, ColumnDescriptor cd, byte[] bytes, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, bytes, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int offset = (int)(offsetAndWidth >>> 32);
            int columnWidth = (int)offsetAndWidth;
            Date v = DataTypeUtilities.getAsDate(bytes, offset, columnWidth, cal, cd.columnType);
            if (v != null) {
                return v;
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getDate(cal);
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final Date getAsDate(int logicalPosition, byte[] bytes, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        return this.getAsDate(index, this.columns[index], bytes, cal, wasNull);
    }

    final Date getAsDate(int logicalPosition, byte[][] byteArrays, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            return this.getAsDate(index, cd, byteArrays[0], cal, wasNull);
        }
        throw StandardException.newException("22005", (Object)"DATE", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final Date getAsDate(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int offset = (int)(offsetAndWidth >>> 32);
            int columnWidth = (int)offsetAndWidth;
            Date v = DataTypeUtilities.getAsDate(unsafe, memAddr + (long)offset, columnWidth, bs, cal, cd.columnType);
            if (v != null) {
                return v;
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getDate(cal);
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final Date getAsDate(int logicalPosition, OffHeapRow bytes, Calendar cal, ResultWasNull wasNull) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        return this.getAsDate(index, this.columns[index], unsafe, memAddr, bytesLen, bytes, cal, wasNull);
    }

    final Date getAsDate(int logicalPosition, OffHeapRowWithLobs byteArrays, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsDate(index, cd, unsafe, memAddr, bytesLen, byteArrays, cal, wasNull);
        }
        throw StandardException.newException("22005", (Object)"DATE", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final Time getAsTime(int index, ColumnDescriptor cd, byte[] bytes, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, bytes, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int offset = (int)(offsetAndWidth >>> 32);
            int columnWidth = (int)offsetAndWidth;
            Time v = DataTypeUtilities.getAsTime(bytes, offset, columnWidth, cal, cd.columnType);
            if (v != null) {
                return v;
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getTime(cal);
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final Time getAsTime(int logicalPosition, byte[] bytes, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        return this.getAsTime(index, this.columns[index], bytes, cal, wasNull);
    }

    final Time getAsTime(int logicalPosition, byte[][] byteArrays, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            return this.getAsTime(index, cd, byteArrays[0], cal, wasNull);
        }
        throw StandardException.newException("22005", (Object)"TIME", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final Time getAsTime(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int offset = (int)(offsetAndWidth >>> 32);
            int columnWidth = (int)offsetAndWidth;
            Time v = DataTypeUtilities.getAsTime(unsafe, memAddr + (long)offset, columnWidth, bs, cal, cd.columnType);
            if (v != null) {
                return v;
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getTime(cal);
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final Time getAsTime(int logicalPosition, OffHeapRow bytes, Calendar cal, ResultWasNull wasNull) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        return this.getAsTime(index, this.columns[index], unsafe, memAddr, bytesLen, bytes, cal, wasNull);
    }

    final Time getAsTime(int logicalPosition, OffHeapRowWithLobs byteArrays, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsTime(index, cd, unsafe, memAddr, bytesLen, byteArrays, cal, wasNull);
        }
        throw StandardException.newException("22005", (Object)"TIME", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final long getAsTimestampMicros(int index, byte[] bytes, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        ColumnDescriptor cd = this.columns[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, bytes, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsTimestampMicros(bytes, offset, columnWidth, cal, cd.columnType);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -7L) {
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return 0L;
        }
        DataValueDescriptor dvd = cd.columnDefault;
        if (dvd != null && !dvd.isNull()) {
            return DataTypeUtilities.getTimestampMicros(dvd.getTimestamp(cal));
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0L;
    }

    final long getAsTimestampMicros(int index, byte[][] byteArrays, Calendar cal, ResultWasNull wasNull) throws StandardException {
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            return this.getAsTimestampMicros(index, byteArrays[0], cal, wasNull);
        }
        throw StandardException.newException("22005", (Object)"TIMESTAMP", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final long getAsTimestampMicros(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int columnWidth = (int)offsetAndWidth;
            int offset = (int)(offsetAndWidth >>> 32);
            return DataTypeUtilities.getAsTimestampMicros(unsafe, memAddr + (long)offset, columnWidth, bs, cal, cd.columnType);
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -7L) {
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return 0L;
        }
        DataValueDescriptor dvd = cd.columnDefault;
        if (dvd != null && !dvd.isNull()) {
            return DataTypeUtilities.getTimestampMicros(dvd.getTimestamp(cal));
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0L;
    }

    final long getAsTimestampMicros(int index, OffHeapRow bytes, Calendar cal, ResultWasNull wasNull) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        return this.getAsTimestampMicros(index, this.columns[index], unsafe, memAddr, bytesLen, bytes, cal, wasNull);
    }

    final long getAsTimestampMicros(int index, OffHeapRowWithLobs byteArrays, Calendar cal, ResultWasNull wasNull) throws StandardException {
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsTimestampMicros(index, cd, unsafe, memAddr, bytesLen, byteArrays, cal, wasNull);
        }
        throw StandardException.newException("22005", (Object)"TIMESTAMP", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final Timestamp getAsTimestamp(int index, ColumnDescriptor cd, byte[] bytes, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, bytes, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int offset = (int)(offsetAndWidth >>> 32);
            int columnWidth = (int)offsetAndWidth;
            Timestamp v = DataTypeUtilities.getAsTimestamp(bytes, offset, columnWidth, cal, cd.columnType);
            if (v != null) {
                return v;
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getTimestamp(cal);
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final Timestamp getAsTimestamp(int logicalPosition, byte[] bytes, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        return this.getAsTimestamp(index, this.columns[index], bytes, cal, wasNull);
    }

    final Timestamp getAsTimestamp(int logicalPosition, byte[][] byteArrays, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            return this.getAsTimestamp(index, cd, byteArrays[0], cal, wasNull);
        }
        throw StandardException.newException("22005", (Object)"TIMESTAMP", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final Timestamp getAsTimestamp(int index, ColumnDescriptor cd, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapByteSource bs, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int offsetFromMap = this.positionMap[index];
        long offsetAndWidth = this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd);
        if (offsetAndWidth >= 0L) {
            int offset = (int)(offsetAndWidth >>> 32);
            int columnWidth = (int)offsetAndWidth;
            Timestamp v = DataTypeUtilities.getAsTimestamp(unsafe, memAddr + (long)offset, columnWidth, bs, cal, cd.columnType);
            if (v != null) {
                return v;
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
        if (offsetAndWidth == -6L) {
            DataValueDescriptor dvd = cd.columnDefault;
            if (dvd != null && !dvd.isNull()) {
                return dvd.getTimestamp(cal);
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    final Timestamp getAsTimestamp(int logicalPosition, OffHeapRow bytes, Calendar cal, ResultWasNull wasNull) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        return this.getAsTimestamp(index, this.columns[index], unsafe, memAddr, bytesLen, bytes, cal, wasNull);
    }

    final Timestamp getAsTimestamp(int logicalPosition, OffHeapRowWithLobs byteArrays, Calendar cal, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (!cd.isLob) {
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            int bytesLen = byteArrays.getLength();
            long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
            return this.getAsTimestamp(index, cd, unsafe, memAddr, bytesLen, byteArrays, cal, wasNull);
        }
        throw StandardException.newException("22005", (Object)"TIMESTAMP", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final Blob getAsBlob(int logicalPosition, byte[][] byteArrays, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (cd.isLob) {
            byte[] bytes;
            int offsetFromMap = this.positionMap[index];
            byte[] byArray = bytes = offsetFromMap != 0 ? byteArrays[offsetFromMap] : cd.columnDefaultBytes;
            if (bytes != null) {
                return new HarmonySerialBlob(bytes);
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        throw StandardException.newException("22005", (Object)"BLOB", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final Blob getAsBlob(int logicalPosition, OffHeapByteSource byteArrays, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (cd.isLob) {
            Object lob;
            int offsetFromMap = this.positionMap[index];
            Object object = lob = offsetFromMap != 0 ? (Object)byteArrays.getGfxdByteSource(offsetFromMap) : cd.columnDefaultBytes;
            if (lob != null) {
                if (lob instanceof byte[]) {
                    return new HarmonySerialBlob((byte[])lob);
                }
                return new HarmonySerialBlob((OffHeapByteSource)((Object)lob));
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        throw StandardException.newException("22005", (Object)"BLOB", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final Clob getAsClob(int logicalPosition, byte[][] byteArrays, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (cd.isLob) {
            byte[] bytes;
            int offsetFromMap = this.positionMap[index];
            byte[] byArray = bytes = offsetFromMap != 0 ? byteArrays[offsetFromMap] : cd.columnDefaultBytes;
            if (bytes != null) {
                int size = bytes.length;
                char[] chars = new char[size];
                int strlen = SQLChar.readIntoCharsFromByteArray(bytes, 0, size, chars);
                return new HarmonySerialClob(chars, strlen);
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        throw StandardException.newException("22005", (Object)"CLOB", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    final Clob getAsClob(int logicalPosition, OffHeapByteSource byteArrays, ResultWasNull wasNull) throws StandardException {
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        if (cd.isLob) {
            Object lob;
            int offsetFromMap = this.positionMap[index];
            Object object = lob = offsetFromMap != 0 ? (Object)byteArrays.getGfxdByteSource(offsetFromMap) : cd.columnDefaultBytes;
            if (lob != null) {
                int strlen;
                char[] chars;
                if (lob instanceof byte[]) {
                    Object bytes = lob;
                    chars = new char[((byte[])bytes).length];
                    strlen = SQLChar.readIntoCharsFromByteArray((byte[])bytes, 0, ((byte[])bytes).length, chars);
                } else {
                    OffHeapByteSource bs = (OffHeapByteSource)((Object)lob);
                    int bytesLen = bs.getLength();
                    chars = new char[bytesLen];
                    strlen = SQLChar.readIntoCharsFromByteSource(UnsafeMemoryChunk.getUnsafeWrapper(), bs.getUnsafeAddress(0, bytesLen), bytesLen, bs, chars);
                }
                return new HarmonySerialClob(chars, strlen);
            }
            if (wasNull != null) {
                wasNull.setWasNull();
            }
            return null;
        }
        throw StandardException.newException("22005", (Object)"CLOB", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    public final int[] readAsIntArray(int logicalPosition, AbstractCompactExecRow row, int numInts) throws StandardException {
        long memAddr;
        int bytesLen;
        UnsafeWrapper unsafe;
        int index = logicalPosition - 1;
        ColumnDescriptor cd = this.columns[index];
        int offsetFromMap = this.positionMap[index];
        int offset = -1;
        Object bs = row.getBaseByteSource();
        byte[] bytes = null;
        OffHeapByteSource obs = null;
        if (row.hasByteArrays()) {
            Object byteArrays = bs;
            if (byteArrays != null) {
                if (byteArrays instanceof byte[][]) {
                    if (cd.isLob) {
                        bytes = offsetFromMap != 0 ? ((byte[][])byteArrays)[offsetFromMap] : cd.columnDefaultBytes;
                        offset = 0;
                    } else {
                        bytes = ((byte[][])byteArrays)[0];
                    }
                } else {
                    OffHeapByteSource lbs = (OffHeapByteSource)((Object)bs);
                    if (cd.isLob) {
                        bs = offsetFromMap != 0 ? (Object)lbs.getGfxdByteSource(offsetFromMap) : cd.columnDefaultBytes;
                        offset = 0;
                    } else {
                        bs = lbs;
                    }
                    if (bs == null || bs instanceof byte[]) {
                        bytes = (byte[])bs;
                    } else {
                        obs = (OffHeapByteSource)((Object)bs);
                    }
                }
            }
        } else if (bs == null || bs instanceof byte[]) {
            bytes = (byte[])bs;
        } else {
            obs = (OffHeapByteSource)((Object)bs);
        }
        if (obs != null) {
            unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            bytesLen = obs.getLength();
            memAddr = obs.getUnsafeAddress(0, bytesLen);
        } else {
            unsafe = null;
            bytesLen = 0;
            memAddr = 0L;
        }
        if (offset == -1) {
            long offsetAndWidth;
            long l = offsetAndWidth = obs != null ? this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd) : this.getOffsetAndWidth(index, bytes, offsetFromMap, cd);
            if (offsetAndWidth >= 0L) {
                offset = (int)(offsetAndWidth >>> 32);
            } else {
                assert (offsetAndWidth == -7L || offsetAndWidth == -6L) : offsetAndWidth;
                return null;
            }
        }
        if (bs != null) {
            int[] ints = new int[numInts];
            for (int idx = 0; idx < numInts; ++idx) {
                ints[idx] = bytes != null ? RowFormatter.readInt(bytes, offset) : RowFormatter.readInt(unsafe, memAddr + (long)offset);
                offset += 4;
            }
            return ints;
        }
        return null;
    }

    public final long getOffsetAndWidth(int logicalPosition, byte[] bytes) {
        int index = logicalPosition - 1;
        return this.getOffsetAndWidth(index, bytes, this.positionMap[index], this.columns[index]);
    }

    public final long getOffsetAndWidth(int logicalPosition, byte[] bytes, boolean truncateSpaces) {
        int index = logicalPosition - 1;
        return this.getOffsetAndWidth(index, bytes, this.positionMap[index], this.columns[index], truncateSpaces);
    }

    public final long getOffsetAndWidth(int logicalPosition, OffHeapRow bytes) {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        return this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, this.positionMap[index], this.columns[index]);
    }

    public final long getOffsetAndWidth(int logicalPosition, OffHeapRowWithLobs bytes) {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        return this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, this.positionMap[index], this.columns[index]);
    }

    public final long getOffsetAndWidth(int logicalPosition, OffHeapByteSource bytes) {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bytes.getLength();
        long memAddr = bytes.getUnsafeAddress(0, bytesLen);
        int index = logicalPosition - 1;
        return this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, this.positionMap[index], this.columns[index]);
    }

    public final long getOffsetAndWidth(int logicalPosition, UnsafeWrapper unsafe, long memAddr, int bytesLen) {
        int index = logicalPosition - 1;
        return this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, this.positionMap[index], this.columns[index]);
    }

    public final long getOffsetAndWidth(int logicalPosition, UnsafeWrapper unsafe, long memAddr, int bytesLen, boolean truncateSpaces) {
        int index = logicalPosition - 1;
        return this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, this.positionMap[index], this.columns[index], truncateSpaces);
    }

    public final long getOffsetAndWidth(int logicalPosition, byte[] bytes, ColumnDescriptor cd) {
        int index = logicalPosition - 1;
        return this.getOffsetAndWidth(index, bytes, this.positionMap[index], cd);
    }

    public final long getOffsetAndWidth(int index, UnsafeWrapper unsafe, long memAddr, int bytesLen, ColumnDescriptor cd) {
        return this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, this.positionMap[index], cd);
    }

    final long getOffsetAndWidth(int index, byte[] bytes, int offsetFromMap, ColumnDescriptor cd) {
        return this.getOffsetAndWidth(index, bytes, offsetFromMap, cd, false);
    }

    final long getOffsetAndWidth(int index, byte[] bytes, int offsetFromMap, ColumnDescriptor cd, boolean truncateSpaces) {
        if (GemFireXDUtils.TraceRowFormatter) {
            SanityManager.DEBUG_PRINT((String)"TraceRowFormatter", (String)("RowFormatter#getOffsetAndWidth: byte[] getting column at position " + (index + 1) + ", cd: " + cd));
        }
        if (bytes != null) {
            if (offsetFromMap >= this.nVersionBytes) {
                if (!cd.isLob) {
                    int columnWidth = cd.fixedWidth;
                    assert (columnWidth > 0) : "unexpected columnWidth=" + columnWidth + " for " + cd;
                    return (long)offsetFromMap << 32 | (long)columnWidth;
                }
                return bytes.length;
            }
            if (offsetFromMap < 0) {
                int bytesLen = bytes.length;
                int offsetOffset = bytesLen + offsetFromMap;
                int offset = this.readVarDataOffset(bytes, offsetOffset);
                if (offset >= this.nVersionBytes) {
                    int columnWidth = this.getVarColumnWidth(bytes, bytesLen, offsetOffset, offset);
                    if (truncateSpaces && RowFormatter.shouldTrimTrailingSpaces(cd)) {
                        columnWidth = RowFormatter.trimTrailingSpaces(bytes, offset, columnWidth);
                    }
                    return (long)offset << 32 | (long)columnWidth;
                }
                if (!this.isVarDataOffsetDefaultToken(offset)) {
                    return -7L;
                }
                return -6L;
            }
            if (cd.columnDefault != null) {
                return -6L;
            }
        }
        return -7L;
    }

    private long getVarOffsetAndWidth(byte[] bytes, int offsetFromMap, ColumnDescriptor cd, boolean truncateSpaces) {
        if (offsetFromMap < 0) {
            int bytesLen = bytes.length;
            int offsetOffset = bytesLen + offsetFromMap;
            int offset = this.readVarDataOffset(bytes, offsetOffset);
            if (offset >= this.nVersionBytes) {
                int columnWidth = this.getVarColumnWidth(bytes, bytesLen, offsetOffset, offset);
                if (truncateSpaces && RowFormatter.shouldTrimTrailingSpaces(cd)) {
                    columnWidth = RowFormatter.trimTrailingSpaces(bytes, offset, columnWidth);
                }
                return (long)offset << 32 | (long)columnWidth;
            }
            if (!this.isVarDataOffsetDefaultToken(offset)) {
                return -7L;
            }
            return -6L;
        }
        if (cd.columnDefault == null) {
            return -7L;
        }
        return -6L;
    }

    final long getOffsetAndWidth(int index, UnsafeWrapper unsafe, long memAddr, int bytesLen, int offsetFromMap, ColumnDescriptor cd) {
        return this.getOffsetAndWidth(index, unsafe, memAddr, bytesLen, offsetFromMap, cd, false);
    }

    final long getOffsetAndWidth(int index, UnsafeWrapper unsafe, long memAddr, int bytesLen, int offsetFromMap, ColumnDescriptor cd, boolean truncateSpaces) {
        if (GemFireXDUtils.TraceRowFormatter) {
            SanityManager.DEBUG_PRINT((String)"TraceRowFormatter", (String)("RowFormatter#getOffsetAndWidth: byte[] getting column at position " + (index + 1) + ", cd: " + cd));
        }
        if (memAddr != 0L) {
            if (offsetFromMap >= this.nVersionBytes) {
                if (!cd.isLob) {
                    int columnWidth = cd.fixedWidth;
                    assert (columnWidth > 0) : "unexpected columnWidth=" + columnWidth;
                    return (long)offsetFromMap << 32 | (long)columnWidth;
                }
                return bytesLen;
            }
            if (offsetFromMap < 0) {
                int offsetOffset = bytesLen + offsetFromMap;
                int offset = this.readVarDataOffset(unsafe, memAddr, offsetOffset);
                if (offset >= this.nVersionBytes) {
                    int columnWidth = this.getVarColumnWidth(unsafe, memAddr, bytesLen, offsetOffset, offset);
                    if (truncateSpaces && RowFormatter.shouldTrimTrailingSpaces(cd)) {
                        columnWidth = RowFormatter.trimTrailingSpaces(unsafe, memAddr, offset, columnWidth);
                    }
                    return (long)offset << 32 | (long)columnWidth;
                }
                if (!this.isVarDataOffsetDefaultToken(offset)) {
                    return -7L;
                }
                return -6L;
            }
            if (cd.columnDefault != null) {
                return -6L;
            }
        }
        return -7L;
    }

    public final int getNumOffsetBytes() {
        return this.offsetBytes;
    }

    public final int hashCode() {
        int hash = 0;
        int numColumns = this.getNumColumns();
        hash = ResolverUtils.addIntToHash((int)numColumns, (int)hash);
        hash = ResolverUtils.addIntToHash((int)this.numLobs, (int)hash);
        hash = ResolverUtils.addIntToHash((int)this.numVarWidthColumns, (int)hash);
        hash = ResolverUtils.addIntToHash((int)this.offsetBytes, (int)hash);
        hash = ResolverUtils.addIntToHash((int)this.varDataOffset, (int)hash);
        for (int index = 0; index < numColumns; ++index) {
            hash = ResolverUtils.addIntToHash((int)this.positionMap[index], (int)hash);
            hash = ResolverUtils.addIntToHash((int)this.columns[index].getColumnName().hashCode(), (int)hash);
        }
        return hash;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RowFormatter) {
            RowFormatter other = (RowFormatter)o;
            int numColumns = this.getNumColumns();
            if (numColumns == other.getNumColumns() && this.numLobs == other.numLobs && this.schemaVersion == other.schemaVersion && this.numVarWidthColumns == other.numVarWidthColumns && this.offsetBytes == other.offsetBytes && this.varDataOffset == other.varDataOffset) {
                for (int index = 0; index < numColumns; ++index) {
                    if (this.positionMap[index] != other.positionMap[index]) {
                        return false;
                    }
                    if (this.columns[index].getColumnName().equals(other.columns[index].getColumnName())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public final boolean equals(RowFormatter other, int numColumns) {
        if (other == this) {
            return true;
        }
        for (int index = 0; index < numColumns; ++index) {
            if (this.positionMap[index] != other.positionMap[index]) {
                return false;
            }
            if (this.columns[index].getColumnName().equals(other.columns[index].getColumnName())) continue;
            return false;
        }
        return true;
    }

    public static interface ColumnProcessorOffHeap<O> {
        public int handleNull(O var1, int var2, RowFormatter var3, ColumnDescriptor var4, int var5, RowFormatter var6, int var7, int var8);

        public int handleDefault(O var1, int var2, RowFormatter var3, ColumnDescriptor var4, int var5, RowFormatter var6, int var7, int var8);

        public int handleFixed(UnsafeWrapper var1, long var2, int var4, int var5, O var6, int var7, RowFormatter var8, int var9, RowFormatter var10, int var11, int var12);

        public int handleVariable(UnsafeWrapper var1, long var2, int var4, int var5, O var6, int var7, RowFormatter var8, ColumnDescriptor var9, int var10, RowFormatter var11, int var12, int var13);

        public int handleLob(UnsafeWrapper var1, long var2, O var4, int var5, RowFormatter var6, ColumnDescriptor var7, int var8, RowFormatter var9, int var10, int var11);
    }

    public static interface ColumnProcessor<O> {
        public int handleNull(O var1, int var2, RowFormatter var3, ColumnDescriptor var4, int var5, RowFormatter var6, int var7, int var8);

        public int handleDefault(O var1, int var2, RowFormatter var3, ColumnDescriptor var4, int var5, RowFormatter var6, int var7, int var8);

        public int handleFixed(byte[] var1, int var2, int var3, O var4, int var5, RowFormatter var6, int var7, RowFormatter var8, int var9, int var10);

        public int handleVariable(byte[] var1, int var2, int var3, O var4, int var5, RowFormatter var6, ColumnDescriptor var7, int var8, RowFormatter var9, int var10, int var11);

        public int handleLob(byte[] var1, O var2, int var3, RowFormatter var4, ColumnDescriptor var5, int var6, RowFormatter var7, int var8, int var9);
    }
}

