/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.ResultWasNull;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TreeSet;
import org.apache.spark.unsafe.types.UTF8String;

public final class CompactExecRowWithLobs
extends AbstractCompactExecRow {
    private static final long serialVersionUID = 2591346199546303027L;
    private byte[][] source;

    public CompactExecRowWithLobs() {
    }

    private CompactExecRowWithLobs(RowFormatter rf) {
        super(rf);
        this.source = null;
    }

    CompactExecRowWithLobs(DataValueDescriptor[] dvds, RowFormatter rf) throws StandardException {
        super(rf);
        this.source = dvds != null ? rf.generateByteArrays(dvds) : (byte[][])null;
    }

    CompactExecRowWithLobs(byte[][] bytes, RowFormatter rf) {
        super(rf);
        this.source = bytes;
        assert (rf.isTableFormatter() || rf.hasLobs()) : "use a CompactExecRow instead";
    }

    CompactExecRowWithLobs(byte[][] source, RowFormatter rf, DataValueDescriptor[] row, int rowLen, boolean doClone) {
        super(rf, row, rowLen, doClone);
        this.source = source;
        assert (rf.isTableFormatter() || rf.hasLobs()) : "use a CompactExecRow instead";
    }

    @Override
    public final byte[][] getRowByteArrays() {
        return this.source;
    }

    @Override
    protected final byte[][] getRowByteArraysIfPresent() {
        return this.source;
    }

    @Override
    public final byte[] getRowBytes(int logicalPosition) {
        return this.getRowBytes(logicalPosition, this.source);
    }

    @Override
    public final boolean hasByteArrays() {
        return true;
    }

    public final byte[][] getRawRowValue(boolean doClone) {
        if (doClone) {
            byte[][] sourceBytes = this.source;
            byte[][] newBytes = new byte[sourceBytes.length][];
            int i = 0;
            for (byte[] row : sourceBytes) {
                newBytes[i] = new byte[row.length];
                System.arraycopy(row, 0, newBytes[i], 0, row.length);
            }
            return newBytes;
        }
        return this.source;
    }

    @Override
    public UTF8String getAsUTF8String(int index) throws StandardException {
        return this.formatter.getAsUTF8String(index, this.source);
    }

    @Override
    protected String getString(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsString(position, this.source, wasNull);
    }

    @Override
    protected Object getObject(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsObject(position, this.source, wasNull);
    }

    @Override
    protected boolean getBoolean(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsBoolean(position, this.source, wasNull);
    }

    @Override
    protected byte getByte(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsByte(position, this.source, wasNull);
    }

    @Override
    protected short getShort(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsShort(position, this.source, wasNull);
    }

    @Override
    protected int getInt(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsInt(position, this.source, wasNull);
    }

    @Override
    protected long getLong(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsLong(position, this.source, wasNull);
    }

    @Override
    protected float getFloat(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsFloat(position, this.source, wasNull);
    }

    @Override
    protected double getDouble(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsDouble(position, this.source, wasNull);
    }

    @Override
    protected byte[] getBytes(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsBytes(position, this.source, wasNull);
    }

    @Override
    protected BigDecimal getBigDecimal(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsBigDecimal(position, this.source, wasNull);
    }

    @Override
    public long getAsDateMillis(int index, Calendar cal, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsDateMillis(index, this.source, cal, wasNull);
    }

    @Override
    protected Date getDate(int position, Calendar cal, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsDate(position, this.source, cal, wasNull);
    }

    @Override
    protected Time getTime(int position, Calendar cal, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsTime(position, this.source, cal, wasNull);
    }

    @Override
    public long getAsTimestampMicros(int index, Calendar cal, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsTimestampMicros(index, this.source, cal, wasNull);
    }

    @Override
    protected Timestamp getTimestamp(int position, Calendar cal, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsTimestamp(position, this.source, cal, wasNull);
    }

    @Override
    protected final DataValueDescriptor basicGetColumn(int position) throws StandardException {
        return this.formatter.getColumn(position, this.source);
    }

    @Override
    protected final void basicSetColumns(FormatableBitSet columns, DataValueDescriptor[] values) throws StandardException {
        if (values.length > 0) {
            this.source = this.formatter.setColumns(columns, values, this.source, null, this.formatter);
        } else assert (this.formatter.getNumColumns() == 0) : "if none of the values are set such a condition can happen when DTD is also nothing";
    }

    @Override
    protected void basicSetColumn(int columnIndex, DataValueDescriptor value) throws StandardException {
        this.source = this.formatter.setColumn(columnIndex, value, this.source, this.formatter);
    }

    @Override
    protected final void basicSetCompactColumns(FormatableBitSet columns, DataValueDescriptor[] values) throws StandardException {
        this.source = this.formatter.setByteArrayCompactColumns(columns, values);
    }

    @Override
    protected final void basicSetColumns(int nCols, DataValueDescriptor[] values) throws StandardException {
        if (values.length > 0) {
            this.source = this.formatter.setColumns(nCols, values, this.source);
        } else assert (this.formatter.getNumColumns() == 0) : "if none of the values are set such a condition can happen when DTD is also nothing";
    }

    @Override
    protected final void basicSetColumns(FormatableBitSet columns, AbstractCompactExecRow srcRow, int[] baseColumnMap) throws StandardException {
        this.source = this.formatter.setColumns(columns, srcRow.getRowByteArraysIfPresent(), srcRow.getRowBytes(), srcRow.formatter, baseColumnMap);
    }

    @Override
    protected final void basicSetColumns(int[] columns, boolean zeroBased, AbstractCompactExecRow srcRow) throws StandardException {
        this.source = this.formatter.setColumns(columns, zeroBased, srcRow.getRowByteArraysIfPresent(), srcRow.getRowBytes(), srcRow.formatter);
    }

    @Override
    protected final void basicSetColumns(int nCols, AbstractCompactExecRow srcRow) throws StandardException {
        this.source = this.formatter.setColumns(nCols, srcRow.getRowByteArraysIfPresent(), srcRow.getRowBytes(), srcRow.formatter);
    }

    @Override
    protected final void basicResetRowArray() {
        this.source = null;
    }

    @Override
    protected final DataValueDescriptor[] basicGetRowArray() {
        try {
            return this.formatter.getAllColumns(this.source);
        }
        catch (StandardException e) {
            throw GemFireXDRuntimeException.newRuntimeException("CompactExecRowWithLobs#getRowArray: unexpected exception", e);
        }
    }

    @Override
    protected final void basicSetRowArray(ExecRow otherRow) {
        if (!(otherRow instanceof AbstractCompactExecRow)) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        this.basicSetRowArray((AbstractCompactExecRow)otherRow);
    }

    @Override
    protected final void basicSetRowArray(AbstractCompactExecRow otherRow) {
        RowFormatter otherFormatter = otherRow.formatter;
        if (otherRow.hasByteArrays()) {
            this.source = otherRow.getRowByteArrays();
        } else if (this.formatter.container == otherFormatter.container) {
            this.source = otherFormatter.createByteArraysWithDefaultLobs(otherRow.getRowBytes());
        } else {
            throw new UnsupportedOperationException("CompactExecRowWithLobs does not support byte[]");
        }
        if (this.formatter != otherFormatter) {
            this.formatter = otherFormatter;
        }
    }

    @Override
    protected void basicSetRowArray(byte[] rowArray, RowFormatter formatter) {
        if (this.formatter.container != formatter.container) {
            throw new UnsupportedOperationException("CompactExecRowWithLobs does not support byte[]");
        }
        this.basicSetRowArray(formatter.createByteArraysWithDefaultLobs(rowArray), formatter);
    }

    @Override
    protected final void basicSetRowArray(byte[][] rowArray, RowFormatter formatter) {
        this.source = rowArray;
        if (this.formatter != formatter) {
            this.formatter = formatter;
        }
    }

    @Override
    protected void basicSetDVDValues(DataValueDescriptor[] dvds, int[] srcColumns, boolean zeroBased) throws StandardException {
        super.basicSetDVDValues(dvds, srcColumns, zeroBased, this.source);
    }

    @Override
    protected final byte[] getRowBytes() {
        byte[][] source = this.source;
        return source != null ? source[0] : null;
    }

    protected final int numLobs() {
        byte[][] source = this.source;
        return source != null ? source.length - 1 : 0;
    }

    @Override
    public final void setRowArrayClone(ExecRow otherRow, TreeSet<RegionAndKey> allKeys) {
        if (otherRow instanceof AbstractCompactExecRow) {
            this.basicSetRowArray((AbstractCompactExecRow)otherRow);
        } else {
            this.setRowArray(otherRow.getRowArray());
        }
        this.setOfKeys = allKeys;
    }

    @Override
    public final CompactExecRowWithLobs getClone() {
        CompactExecRowWithLobs row = new CompactExecRowWithLobs(this.source, this.formatter);
        row.setOfKeys = this.setOfKeys;
        return row;
    }

    @Override
    public final CompactExecRowWithLobs getShallowClone() {
        return this.getClone();
    }

    @Override
    public final CompactExecRowWithLobs getNewNullRow() {
        return new CompactExecRowWithLobs(this.formatter);
    }

    @Override
    public final int compare(ExecRow row, int logicalPosition, long thisOffsetWidth, boolean nullsOrderedLow) throws StandardException {
        return this.compare(row, this.getRowBytes(logicalPosition, this.source), logicalPosition, thisOffsetWidth, nullsOrderedLow);
    }

    @Override
    public int compare(ExecRow row, int logicalPosition, boolean nullsOrderedLow) throws StandardException {
        byte[] bytes = this.getRowBytes(logicalPosition, this.source);
        return this.compare(row, bytes, logicalPosition, this.formatter.getOffsetAndWidth(logicalPosition, bytes), nullsOrderedLow);
    }

    @Override
    public final int computeHashCode(int position, int hash) {
        return this.formatter.computeHashCode(position, this.getRowBytes(position, this.source), hash);
    }

    @Override
    public long isNull(int logicalPosition) throws StandardException {
        return this.formatter.getOffsetAndWidth(logicalPosition, this.getRowBytes(logicalPosition, this.source));
    }

    @Override
    public final Blob getAsBlob(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsBlob(position, this.source, wasNull);
    }

    @Override
    public final Clob getAsClob(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsClob(position, this.source, wasNull);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        if (this.formatter != null) {
            sb.append('(');
            int rowLen = this.formatter.getNumColumns();
            try {
                for (int position = 1; position <= rowLen; ++position) {
                    if (position != 1) {
                        sb.append(',');
                    }
                    ColumnDescriptor cd = this.formatter.getColumnDescriptor(position - 1);
                    if (cd.isLob) {
                        sb.append("columnType=").append(cd.getType()).append(';');
                        byte[] lob = this.formatter.getLob(this.source, position);
                        CompactExecRowWithLobs.lobToString(lob, sb);
                        continue;
                    }
                    sb.append(this.getColumn(position));
                }
            }
            catch (StandardException e) {
                throw GemFireXDRuntimeException.newRuntimeException("CompactExecRowWithLobs#toString: unexpected exception", e);
            }
            sb.append(')');
        } else {
            sb.append("(NULL formatter) rawValue {");
            byte[] rowBytes = this.getRowBytes();
            ArrayUtils.objectStringNonRecursive((Object)rowBytes, (StringBuilder)sb);
            int len = this.numLobs();
            for (int index = 1; index <= len; ++index) {
                sb.append(',');
                CompactExecRowWithLobs.lobToString(this.source[index], sb);
            }
            sb.append('}');
        }
        return sb.toString();
    }

    private static void lobToString(byte[] column, StringBuilder sb) {
        if (column != null) {
            sb.append("length=").append(column.length);
            sb.append(";hash=").append(ResolverUtils.addBytesToHash((byte[])column, (int)0));
        } else {
            sb.append("(NULL)");
        }
    }

    @Override
    public byte getGfxdID() {
        return 87;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("CompactExecRowWithLobs does not support toData()");
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.source = DataSerializer.readArrayOfByteArrays((DataInput)in);
    }

    public byte[] getByteSource() {
        byte[][] source = this.source;
        return source != null ? source[0] : null;
    }

    public byte[] getByteSource(int logicalPosition) {
        return this.formatter.getColumnAsByteSource(this.source, logicalPosition);
    }

    @Override
    void basicSetByteSource(Object source) {
        throw new UnsupportedOperationException("CompactExecRowWithLobs does not support setByteSource");
    }

    @Override
    public void releaseByteSource() {
        this.source = null;
    }

    public byte[][] getBaseByteSource() {
        return this.source;
    }
}

