/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.catalog;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.gemstone.gnu.trove.TIntArrayList;
import com.gemstone.gnu.trove.TIntObjectHashMap;
import com.pivotal.gemfirexd.internal.catalog.DependableFinder;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraInfo;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.TableInfoRefresh;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Dependent;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public final class ExtraTableInfo
extends ExtraInfo
implements Dependent {
    private final UUID tableID;
    private final UUID oid;
    final DataDictionary dd;
    private TableDescriptor td;
    GemFireContainer container;
    private RowFormatter formatter;
    private boolean isLatestSchema;
    private volatile String[] pkColumnNames;
    private final int schemaVersion;
    private RowFormatter refKeyFormatter;
    private int[] referencedKeyColumns;
    private int[] referencedKeyFixedColumns;
    private int[] referencedKeyVarColumns;
    private GemFireContainer[] refContainers;
    private HashMap<int[], long[]> refKeyColumns2IndexNumbers;
    private TIntObjectHashMap autoGenColumns;
    private HashMap<String, ColumnDescriptor> autoGenColumnNames;
    private GemFireContainer[] fkContainers;

    private ExtraTableInfo(UUID oid, UUID tableID, DataDictionary dd, int schemaVersion) {
        this.oid = oid;
        this.tableID = tableID;
        this.dd = dd;
        this.schemaVersion = schemaVersion;
    }

    public final TableDescriptor getTableDescriptor() {
        return this.td;
    }

    public static ExtraTableInfo newExtraTableInfo(DataDictionary dd, TableDescriptor td, ContextManager cm, int schemaVersion, GemFireContainer gfc, boolean setAsCurrent) throws StandardException {
        ExtraTableInfo tableInfo = new ExtraTableInfo(dd.getUUIDFactory().createUUID(), td.getUUID(), dd, schemaVersion);
        dd.getDependencyManager().addDependency(tableInfo, td, cm);
        if (setAsCurrent) {
            if (gfc == null) {
                gfc = Misc.getMemStore().getContainer(ContainerKey.valueOf(0L, td.getHeapConglomerateId()));
            }
            gfc.setExtraTableInfo(tableInfo);
        }
        tableInfo.container = gfc;
        return tableInfo;
    }

    public void drop(GemFireTransaction tran) throws StandardException {
        this.dd.getDependencyManager().clearDependencies(tran.getLanguageConnectionContext(), this, tran);
    }

    private final void refreshRowFormatter(GemFireContainer container, TableDescriptor td) throws StandardException {
        this.container = container;
        this.formatter = new RowFormatter(td.getColumnDescriptorList(), container.getSchemaName(), container.getTableName(), this.schemaVersion, container, true);
        container.initCompactTemplateRow(this);
        container.refreshLockingInfo();
    }

    private final void refreshPrimaryKeyFormatter(GemFireContainer container, TableDescriptor td) {
        int[] pkColumns = this.getPrimaryKeyColumns();
        if (pkColumns != null && pkColumns.length > 0 && container.isByteArrayStore()) {
            this.setPrimaryKeyFormatter(container, td, pkColumns);
        } else {
            this.pkFormatter = null;
            this.primaryKeyFixedColumns = null;
            this.primaryKeyVarColumns = null;
        }
    }

    public final ExtraTableInfo getExtraTableInfo(byte[] vbytes) {
        if (this.isLatestSchema) {
            assert (ExtraTableInfo.getSchemaVersionFromValueBytes(vbytes) == this.formatter.schemaVersion) : "mismatch of versions: formatter=" + this.formatter.schemaVersion + ", fromBytes=" + ExtraTableInfo.getSchemaVersionFromValueBytes(vbytes);
            return this;
        }
        return this.container.getExtraTableInfo(vbytes);
    }

    public final RowFormatter getRowFormatter() {
        return this.formatter;
    }

    @Override
    public final RowFormatter getRowFormatter(OffHeapByteSource vbytes) {
        return this.container.getRowFormatter(vbytes);
    }

    @Override
    public final RowFormatter getRowFormatter(UnsafeWrapper unsafe, long memAddr, OffHeapByteSource vbytes) {
        return this.container.getRowFormatter(unsafe, memAddr, vbytes);
    }

    @Override
    public final RowFormatter getRowFormatter(byte[] vbytes) {
        return this.container.getRowFormatter(vbytes);
    }

    private static int getSchemaVersionFromValueBytes(byte[] vbytes) {
        return RowFormatter.readCompactInt(vbytes, 0);
    }

    private static int getSchemaVersionFromValueBytes(OffHeapByteSource vbytes) {
        return RowFormatter.readCompactInt(UnsafeMemoryChunk.getUnsafeWrapper(), vbytes.getUnsafeAddress(), 0);
    }

    private static int getSchemaVersionFromValueBytes(UnsafeWrapper unsafe, long memAddr) {
        return RowFormatter.readCompactInt(unsafe, memAddr, 0);
    }

    @Override
    public final boolean isValid() {
        return true;
    }

    public final RowFormatter getReferencedKeyRowFormatter() {
        return this.refKeyFormatter;
    }

    public final int[] getReferencedKeyColumns() {
        return this.referencedKeyColumns;
    }

    public final int[] getReferencedKeyFixedColumns() {
        return this.referencedKeyFixedColumns;
    }

    public final int[] getReferencedKeyVarColumns() {
        return this.referencedKeyVarColumns;
    }

    public final GemFireContainer[] getReferencedContainers() {
        return this.refContainers;
    }

    public final HashMap<int[], long[]> getReferencedKeyColumns2IndexNumbers() {
        return this.refKeyColumns2IndexNumbers;
    }

    public final void initRowFormatter(GemFireContainer container) throws StandardException {
        if (this.td == null) {
            this.td = this.dd.getTableDescriptor(this.tableID);
        }
        this.refreshRowFormatter(container, this.td);
        this.refreshPrimaryKeyFormatter(container, this.td);
        this.refreshReferencedKeyFormatter(container, this.td);
        this.isLatestSchema = true;
    }

    public final void setLatestSchema(boolean flag) {
        this.isLatestSchema = flag;
    }

    private final void refreshAutoGenColumnInfo() {
        this.autoGenColumns = null;
        this.autoGenColumnNames = null;
        ColumnDescriptorList cdl = this.td.getColumnDescriptorList();
        for (int index = 0; index < cdl.size(); ++index) {
            ColumnDescriptor cd = cdl.elementAt(index);
            if (!cd.isAutoincrement()) continue;
            if (this.autoGenColumns == null) {
                this.autoGenColumns = new TIntObjectHashMap();
                this.autoGenColumnNames = new HashMap();
            }
            this.autoGenColumns.put(cd.getPosition(), (Object)cd);
            this.autoGenColumnNames.put(cd.getColumnName(), cd);
        }
    }

    private final void refreshReferencedKeyInfo(GemFireContainer container, TableDescriptor td) throws StandardException {
        FormatableBitSet bitSet = this.getReferencedKeyColumnPositionsBitSet();
        this.referencedKeyColumns = GemFireXDUtils.getColumnPositionsFromBitSet(bitSet);
        this.refreshReferencedKeyFormatter(container, td);
    }

    private final void refreshReferencedKeyFormatter(GemFireContainer container, TableDescriptor td) {
        if (this.referencedKeyColumns != null && container.isByteArrayStore()) {
            int numColumns = this.referencedKeyColumns.length;
            TIntArrayList fixedCols = new TIntArrayList(numColumns);
            TIntArrayList varCols = new TIntArrayList(numColumns);
            this.refKeyFormatter = this.getRowFormatter(this.referencedKeyColumns, container, td, fixedCols, varCols, 0, false);
            if (fixedCols.size() > 0) {
                this.referencedKeyFixedColumns = fixedCols.toNativeArray();
            }
            if (varCols.size() > 0) {
                this.referencedKeyVarColumns = varCols.toNativeArray();
            }
        } else {
            this.refKeyFormatter = null;
            this.referencedKeyFixedColumns = null;
            this.referencedKeyVarColumns = null;
        }
    }

    private FormatableBitSet getReferencedKeyColumnPositionsBitSet() throws StandardException {
        ConstraintDescriptorList cdl = this.dd.getConstraintDescriptors(this.td);
        FormatableBitSet bitSet = new FormatableBitSet(this.td.getColumnDescriptorList().size() + 1);
        HashSet<GemFireContainer> refContainerSet = new HashSet<GemFireContainer>();
        this.refKeyColumns2IndexNumbers = new HashMap();
        for (int index = 0; index < cdl.size(); ++index) {
            int i;
            ReferencedKeyConstraintDescriptor refcd;
            ConstraintDescriptorList fkcdl;
            int size;
            ConstraintDescriptor cd = cdl.elementAt(index);
            if (!(cd instanceof ReferencedKeyConstraintDescriptor) || (size = (fkcdl = this.dd.getActiveConstraintDescriptors((refcd = (ReferencedKeyConstraintDescriptor)cd).getForeignKeyConstraints(1))).size()) == 0) continue;
            ConglomerateDescriptor pkIndexConglom = this.td.getConglomerateDescriptor(refcd.getIndexId());
            int[] baseColumnPositions = pkIndexConglom.getIndexDescriptor().baseColumnPositions();
            long[] conglomNumbers = new long[size];
            for (i = 0; i < baseColumnPositions.length; ++i) {
                int position = baseColumnPositions[i];
                if (bitSet.isSet(position)) continue;
                bitSet.set(position);
            }
            for (i = 0; i < size; ++i) {
                ForeignKeyConstraintDescriptor fkcd = (ForeignKeyConstraintDescriptor)fkcdl.elementAt(i);
                conglomNumbers[i] = fkcd.getIndexConglomerateDescriptor(this.dd).getConglomerateNumber();
                GemFireContainer container = GemFireTransaction.findExistingConglomerate(fkcd.getTableDescriptor().getHeapConglomerateId(), null, null).getGemFireContainer();
                refContainerSet.add(container);
            }
            this.refKeyColumns2IndexNumbers.put(baseColumnPositions, conglomNumbers);
        }
        if (refContainerSet.size() > 0) {
            this.refContainers = new GemFireContainer[refContainerSet.size()];
            this.refContainers = refContainerSet.toArray(this.refContainers);
        } else {
            this.refContainers = null;
        }
        if (this.refKeyColumns2IndexNumbers.size() == 0) {
            this.refKeyColumns2IndexNumbers = null;
        }
        return bitSet;
    }

    public final GemFireContainer[] getForeignKeyContainers() throws StandardException {
        return this.fkContainers;
    }

    public final ColumnDescriptor getAutoGeneratedColumn(int position) {
        if (this.autoGenColumns != null) {
            return (ColumnDescriptor)this.autoGenColumns.get(position);
        }
        return null;
    }

    public final ColumnDescriptor getAutoGeneratedColumn(String name) {
        if (this.autoGenColumnNames != null) {
            return this.autoGenColumnNames.get(name);
        }
        return null;
    }

    public final boolean isAutoGeneratedColumn(int position) {
        return this.autoGenColumns != null && this.autoGenColumns.containsKey(position);
    }

    public final int[] getAutoGeneratedColumns() {
        if (this.autoGenColumns != null) {
            return this.autoGenColumns.keys();
        }
        return null;
    }

    public final boolean hasAutoGeneratedColumns() {
        return this.autoGenColumns != null && this.autoGenColumns.size() > 0;
    }

    public final String[] getPrimaryKeyColumnNames() {
        return this.pkColumnNames;
    }

    public synchronized void refreshCachedInfo(TableDescriptor tableDesc, GemFireContainer gfc) throws StandardException {
        this.td = tableDesc != null ? tableDesc : this.dd.getTableDescriptor(this.tableID);
        if (this.td == null) {
            throw new IllegalStateException("table descriptor should not be null");
        }
        this.td.emptyConstraintDescriptorList();
        this.dd.getConstraintDescriptors(this.td);
        int[] pkColumns = GemFireXDUtils.getPrimaryKeyColumns(this.td);
        if (pkColumns != null && pkColumns.length > 0) {
            int[] primaryKeyColumns = (int[])pkColumns.clone();
            ColumnDescriptorList cdl = this.td.getPrimaryKey().getColumnDescriptors();
            String[] pkColumnNames = new String[cdl.size()];
            for (int index = 0; index < cdl.size(); ++index) {
                pkColumnNames[index] = cdl.elementAt(index).getColumnName();
            }
            this.pkColumnNames = pkColumnNames;
            this.primaryKeyColumns = primaryKeyColumns;
        } else {
            this.primaryKeyColumns = null;
            this.pkColumnNames = null;
        }
        ArrayList<ForeignKeyConstraintDescriptor> fkcdList = new ArrayList<ForeignKeyConstraintDescriptor>();
        ConstraintDescriptorList cdList = this.td.getConstraintDescriptorList();
        for (int index = 0; index < cdList.size(); ++index) {
            ConstraintDescriptor cd = cdList.elementAt(index);
            if (cd.getConstraintType() != 6) continue;
            fkcdList.add((ForeignKeyConstraintDescriptor)cd);
        }
        int numFKs = fkcdList.size();
        if (numFKs > 0) {
            this.fkContainers = new GemFireContainer[numFKs];
            for (int index = 0; index < numFKs; ++index) {
                ForeignKeyConstraintDescriptor fkcd = (ForeignKeyConstraintDescriptor)fkcdList.get(index);
                MemConglomerate conglom = GemFireTransaction.findExistingConglomerate(fkcd.getReferencedConstraint().getTableDescriptor().getHeapConglomerateId(), null, null);
                this.fkContainers[index] = conglom.getGemFireContainer();
            }
        } else {
            this.fkContainers = null;
        }
        if (gfc == null) {
            gfc = this.getGemFireContainer();
        }
        if (gfc != null) {
            LocalRegion r = gfc.getRegion();
            if (r != null) {
                r.setKeyRequiresRegionContext(gfc.regionKeyRequiresRegionContext());
            }
            if (this.formatter != null && gfc.getExtraTableInfo() == this) {
                this.refreshRowFormatter(gfc, this.td);
            }
            this.refreshPrimaryKeyFormatter(gfc, this.td);
            this.refreshReferencedKeyInfo(gfc, this.td);
        }
        this.refreshAutoGenColumnInfo();
    }

    public final int getSchemaVersion() {
        return this.schemaVersion;
    }

    public final void refreshAtCommit(ColumnDescriptor addColumn, int dropColumn, LanguageConnectionContext lcc) throws StandardException {
        TableInfoRefresh refresh;
        GemFireTransaction tc = (GemFireTransaction)lcc.getTransactionExecute();
        List<?> commitOps = tc.getLogAndDoListForCommit();
        if (commitOps != null) {
            for (Object op : commitOps) {
                if (!(op instanceof TableInfoRefresh)) continue;
                refresh = (TableInfoRefresh)op;
                if (refresh.tableInfo != this) continue;
                if (addColumn != null) {
                    refresh.scheduleAddColumn(addColumn);
                } else if (dropColumn > 0) {
                    refresh.scheduleDropColumn(dropColumn);
                }
                return;
            }
        }
        boolean schemaChanged = addColumn != null || dropColumn > 0;
        refresh = new TableInfoRefresh(this, schemaChanged, tc);
        if (schemaChanged) {
            if (addColumn != null) {
                refresh.scheduleAddColumn(addColumn);
            } else {
                refresh.scheduleDropColumn(dropColumn);
            }
        }
        tc.logAndDo(refresh);
    }

    @Override
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            case 12: 
            case 19: 
            case 22: 
            case 31: 
            case 37: 
            case 42: 
            case 46: {
                if (this.td == null) break;
                this.refreshAtCommit(null, -1, lcc);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
    }

    @Override
    public String getClassType() {
        return null;
    }

    @Override
    public DependableFinder getDependableFinder() {
        return null;
    }

    @Override
    public UUID getObjectID() {
        return this.oid;
    }

    @Override
    public String getObjectName() {
        return null;
    }

    @Override
    public boolean isDescriptorPersistent() {
        return false;
    }

    public final UUID getTableID() {
        return this.tableID;
    }

    public GemFireContainer getGemFireContainer() throws StandardException {
        GemFireContainer container = this.container;
        if (container != null) {
            return container;
        }
        this.container = Misc.getMemStore().getContainer(ContainerKey.valueOf(0L, this.td.getHeapConglomerateId()));
        return this.container;
    }
}

