/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler;

import com.gemstone.gemfire.pdx.PdxInstance;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.InvalidPathException;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.Option;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.PathNotFoundException;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.Utils;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.EvaluationContextImpl;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.WildcardPathToken;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.spi.json.JsonProvider;
import java.util.List;

abstract class PathToken {
    private PathToken next;
    private Boolean definite = null;

    PathToken() {
    }

    PathToken appendTailToken(PathToken next) {
        this.next = next;
        return next;
    }

    void handleObjectProperty(String currentPath, Object model, EvaluationContextImpl ctx, List<String> properties) {
        if (properties.size() == 1) {
            String property = properties.get(0);
            String evalPath = currentPath + "['" + property + "']";
            Object propertyVal = this.readObjectProperty(property, model, ctx);
            if (propertyVal == JsonProvider.UNDEFINED) {
                return;
            }
            if (this.isLeaf()) {
                ctx.addResult(evalPath, propertyVal);
            } else {
                if (this.next().isLeaf() && this.next() instanceof WildcardPathToken) {
                    ctx.addResult(evalPath, propertyVal);
                    return;
                }
                this.next().evaluate(evalPath, propertyVal, ctx);
            }
        } else {
            String evalPath = currentPath + "[" + Utils.join(", ", "'", properties) + "]";
            if (!this.isLeaf()) {
                throw new InvalidPathException("Multi properties can only be used as path leafs: " + evalPath);
            }
            if (ctx.configuration().containsOption(Option.MERGE_MULTI_PROPS)) {
                Object map = ctx.jsonProvider().createMap();
                for (String property : properties) {
                    Object propertyVal = this.readObjectProperty(property, model, ctx);
                    if (propertyVal == JsonProvider.UNDEFINED) continue;
                    ctx.jsonProvider().setProperty(map, property, propertyVal);
                }
                ctx.addResult(evalPath, map);
            } else {
                for (String property : properties) {
                    Object propertyVal;
                    evalPath = currentPath + "['" + property + "']";
                    if (!this.hasProperty(property, model, ctx) || (propertyVal = this.readObjectProperty(property, model, ctx)) == JsonProvider.UNDEFINED) continue;
                    ctx.addResult(evalPath, propertyVal);
                }
            }
        }
    }

    private boolean hasProperty(String property, Object model, EvaluationContextImpl ctx) {
        return ctx.jsonProvider().getPropertyKeys(model).contains(property);
    }

    private Object readObjectProperty(String property, Object model, EvaluationContextImpl ctx) {
        if (model instanceof PdxInstance) {
            Object val = ctx.jsonProvider().getPDXValue(model, property, true);
            if (val == JsonProvider.UNDEFINED && ctx.options().contains((Object)Option.THROW_ON_MISSING_PROPERTY)) {
                throw new PathNotFoundException("Property ['" + property + "'] not found in the current context");
            }
            return val;
        }
        return model;
    }

    void handleArrayIndex(int index, String currentPath, Object json, EvaluationContextImpl ctx) {
        String evalPath = currentPath + "[" + index + "]";
        try {
            Object evalHit = ctx.jsonProvider().getArrayIndex(json, index);
            if (this.isLeaf()) {
                ctx.addResult(evalPath, evalHit);
            } else {
                this.next().evaluate(evalPath, evalHit, ctx);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new PathNotFoundException("Index out of bounds when evaluating path " + currentPath + "[" + index + "]");
        }
    }

    PathToken next() {
        if (this.isLeaf()) {
            throw new IllegalStateException("Current path token is a leaf");
        }
        return this.next;
    }

    boolean isLeaf() {
        return this.next == null;
    }

    public int getTokenCount() {
        int cnt = 1;
        PathToken token = this;
        while (!token.isLeaf()) {
            token = token.next();
            ++cnt;
        }
        return cnt;
    }

    public boolean isPathDefinite() {
        if (this.definite != null) {
            return this.definite;
        }
        boolean isDefinite = this.isTokenDefinite();
        if (isDefinite && !this.isLeaf()) {
            isDefinite = this.next.isPathDefinite();
        }
        this.definite = isDefinite;
        return isDefinite;
    }

    public String toString() {
        if (this.isLeaf()) {
            return this.getPathFragment();
        }
        return this.getPathFragment() + this.next().toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    abstract void evaluate(String var1, Object var2, EvaluationContextImpl var3);

    abstract boolean isTokenDefinite();

    abstract String getPathFragment();
}

