/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler;

import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.Configuration;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.Option;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.PathNotFoundException;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.spi.compiler.EvaluationContext;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.spi.compiler.Path;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.spi.json.JsonProvider;
import java.util.List;
import java.util.Set;

class EvaluationContextImpl
implements EvaluationContext {
    private final Configuration configuration;
    private final Object valueResult;
    private final Path path;
    private int resultIndex = 0;

    EvaluationContextImpl(Path path, Configuration configuration) {
        this.path = path;
        this.configuration = configuration;
        this.valueResult = configuration.getProvider().createMap();
    }

    void addResult(String path, Object model) {
        this.configuration.getProvider().setProperty(this.valueResult, this.resultIndex, model);
        ++this.resultIndex;
    }

    public JsonProvider jsonProvider() {
        return this.configuration.getProvider();
    }

    public Set<Option> options() {
        return this.configuration.getOptions();
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    public <T> T getValue() {
        if (this.path.isDefinite()) {
            if (this.resultIndex == 0) {
                return null;
            }
            return (T)this.jsonProvider().getProperty(this.valueResult, 0);
        }
        return (T)this.valueResult;
    }

    @Override
    public <T> T getPath() {
        if (this.resultIndex == 0) {
            throw new PathNotFoundException("No results for path: " + this.path.toString());
        }
        return null;
    }

    @Override
    public List<String> getPathList() {
        return null;
    }
}

