/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal;

import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.Parser;
import java.util.ArrayList;
import java.util.List;

public class PathFormalizer
extends Parser {
    private static final Fragment ROOT = new Fragment(Type.ROOT, "$");
    private static final Fragment SCAN = new Fragment(Type.SCAN, "..");
    StringBuilder formalized = new StringBuilder();

    public PathFormalizer(String path) {
        super(path);
    }

    public String formalize() {
        TokenBuffer buffer = new TokenBuffer();
        block7: do {
            char current = this.next();
            switch (current) {
                case '$': {
                    buffer.append("$").flush();
                    break;
                }
                case '.': {
                    if (!buffer.isEmpty()) {
                        buffer.flush();
                    }
                    if (!this.peekIs(Parser.Token.DOT)) continue block7;
                    this.next();
                    buffer.append("..").flush();
                    break;
                }
                case '[': {
                    if (buffer.isEmpty()) continue block7;
                    buffer.flush();
                    break;
                }
                case ']': {
                    if (buffer.isEmpty()) continue block7;
                    buffer.flush();
                    break;
                }
                case '?': {
                    if (!this.peekIs(Parser.Token.OPEN_PARENTHESIS)) continue block7;
                    buffer.append("?" + this.nextUntil(Parser.Token.CLOSE_BRACKET));
                    buffer.flush();
                    break;
                }
                default: {
                    buffer.append(current);
                }
            }
        } while (this.hasNext());
        if (!buffer.isEmpty()) {
            buffer.flush();
        }
        for (Fragment f : buffer.getFragments()) {
            System.out.println("Fragment: " + f.frag + " Type: " + (Object)((Object)f.type));
            this.formalized.append(f.toString());
        }
        return this.formalized.toString();
    }

    private Fragment createFragment(String data) {
        if ("$".equals(data)) {
            return ROOT;
        }
        if ("..".equals(data)) {
            return SCAN;
        }
        if (this.isInts(data, true)) {
            return new Fragment(Type.INDEX, new String(data));
        }
        return new Fragment(Type.PROPERTY, new String(data));
    }

    public static void main(String[] args) {
        String path = "$.store['foo'].arr[10].monkey..book[?(@.isbn)].isbn";
        System.out.println(path);
        PathFormalizer p = new PathFormalizer(path);
        String f = p.formalize();
        System.out.println(f);
    }

    private static enum Type {
        ROOT,
        SCAN,
        PROPERTY,
        INDEX;

    }

    private static class Fragment {
        private Type type;
        private String frag;

        private Fragment(Type type, String frag) {
            this.type = type;
            this.frag = frag;
        }

        private static Fragment create(String str) {
            boolean isProperty;
            boolean bl = isProperty = str.startsWith("'") && str.endsWith("'");
            if (isProperty) {
                return new Fragment(Type.PROPERTY, new String(str.substring(1, str.length() - 1)));
            }
            if ("$".equals(str)) {
                return ROOT;
            }
            if ("..".equals(str)) {
                return SCAN;
            }
            if ("*".equals(str)) {
                return new Fragment(Type.INDEX, new String(str));
            }
            if ("-1:".equals(str)) {
                return new Fragment(Type.INDEX, new String(str));
            }
            if (":1".equals(str)) {
                return new Fragment(Type.INDEX, new String(str));
            }
            if ("1:2".equals(str)) {
                return new Fragment(Type.INDEX, new String(str));
            }
            if ("1".equals(str)) {
                return new Fragment(Type.INDEX, new String(str));
            }
            if ("1,2,3".equals(str)) {
                return new Fragment(Type.INDEX, new String(str));
            }
            if ("(@.length() - 1)".equals(str)) {
                return new Fragment(Type.INDEX, new String(str));
            }
            if ("?(@.foo == 'bar')".equals(str)) {
                return new Fragment(Type.INDEX, new String(str));
            }
            if ("1,2,3".equals(str)) {
                return new Fragment(Type.INDEX, new String(str));
            }
            return new Fragment(Type.PROPERTY, new String(str));
        }

        public String toString() {
            return this.frag;
        }
    }

    private static class TokenBuffer {
        private List<Fragment> fragments = new ArrayList<Fragment>();
        private StringBuilder sb = new StringBuilder();

        private TokenBuffer() {
        }

        public TokenBuffer append(String s) {
            this.sb.append(s);
            return this;
        }

        public TokenBuffer append(char c) {
            this.sb.append(c);
            return this;
        }

        public void flush() {
            this.fragments.add(new Fragment(Type.PROPERTY, this.sb.toString().trim()));
            this.sb = new StringBuilder();
        }

        public boolean isEmpty() {
            return this.sb.length() == 0;
        }

        public List<Fragment> getFragments() {
            return this.fragments;
        }
    }
}

