/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.utils;

import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedSQLException;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.AuthenticationServiceBase;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public class SecurityUtils {
    public static final String GFXD_SEC_PREFIX = GfxdConstants.GFXD_PREFIX + "security.";
    public static final String GFE_SEC_PREFIX = "gemfire.security-";
    public static final String SYSTEM_USER_KEY_PROPERTY = "gemfirexd.__rt.system-user-id";

    public static Properties transformGFXDToGemFireProperties(Properties gfxdSecurityProps) {
        if (gfxdSecurityProps == null) {
            return gfxdSecurityProps;
        }
        Properties gfeProps = new Properties();
        Enumeration<?> e = gfxdSecurityProps.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith(GFXD_SEC_PREFIX)) {
                gfeProps.put(GFE_SEC_PREFIX + key.substring(GFXD_SEC_PREFIX.length()), gfxdSecurityProps.getProperty(key));
                continue;
            }
            if (key.equals("user") || key.equals("UserName") || key.equals("password")) {
                gfeProps.put(GFE_SEC_PREFIX + key, gfxdSecurityProps.getProperty(key));
                continue;
            }
            String val = gfxdSecurityProps.getProperty(key);
            if (val == null) continue;
            gfeProps.put(key, val);
        }
        return gfeProps;
    }

    public static Properties transformCredentialsForAutoReconnect(Properties gfxdProps) {
        if (gfxdProps == null) {
            return gfxdProps;
        }
        Properties gfeProps = new Properties();
        Enumeration<?> e = gfxdProps.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith(GFXD_SEC_PREFIX)) {
                gfeProps.put("security-" + key.substring(GFXD_SEC_PREFIX.length()), gfxdProps.getProperty(key));
                continue;
            }
            if (!key.equals("user") && !key.equals("UserName") && !key.equals("password")) continue;
            gfeProps.put("security-" + key, gfxdProps.getProperty(key));
        }
        return gfeProps;
    }

    public static Properties transformGemFireToGFXDProperties(Properties gfeSecurityProps) {
        if (gfeSecurityProps == null) {
            return gfeSecurityProps;
        }
        Properties gfxdProps = new Properties();
        Enumeration<?> e = gfeSecurityProps.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith("security-")) {
                gfxdProps.put(GFXD_SEC_PREFIX + key.substring("security-".length()), gfeSecurityProps.getProperty(key));
                continue;
            }
            if (key.startsWith(GFE_SEC_PREFIX)) {
                gfxdProps.put(GFXD_SEC_PREFIX + key.substring(GFE_SEC_PREFIX.length()), gfeSecurityProps.getProperty(key));
                continue;
            }
            String val = gfeSecurityProps.getProperty(key);
            if (val == null) continue;
            gfxdProps.setProperty(key, val);
        }
        return gfxdProps;
    }

    public static Properties trimOffGemFireProperties(Properties inProperties) {
        Properties outProperties = new Properties();
        assert (inProperties != null) : "GFE wouldn't have called with null props.";
        Enumeration<?> e = inProperties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith("security-")) {
                outProperties.put(key.substring("security-".length()), inProperties.getProperty(key));
                continue;
            }
            if (key.startsWith(GFE_SEC_PREFIX)) {
                outProperties.put(key.substring(GFE_SEC_PREFIX.length()), inProperties.getProperty(key));
                continue;
            }
            String val = inProperties.getProperty(key);
            outProperties.put(key, val);
        }
        return outProperties;
    }

    public static final void processSystemUserDefinition(Properties properties) throws StandardException {
        String value = null;
        String key = null;
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            boolean sqlfireUserProp = key.startsWith("sqlfire.user.");
            if (!key.startsWith("gemfirexd.user.") && !sqlfireUserProp) continue;
            value = properties.getProperty(key);
            String origKey = key;
            key = IdUtil.getDBUserId(key, true);
            if (!AuthenticationServiceBase.isEncrypted(value)) {
                SanityManager.DEBUG_PRINT((String)"security-warning:TraceAuthentication", (String)("SecurityUtils: password not encrypted in user definition " + key + ". Encrypting... "));
                value = AuthenticationServiceBase.encryptPassword(key.substring(sqlfireUserProp ? "sqlfire.user.".length() : "gemfirexd.user.".length()), value);
            }
            properties.setProperty(key, value);
            if (!key.equals(origKey)) {
                properties.remove(origKey);
            }
            PropertyUtil.setSystemProperty(SYSTEM_USER_KEY_PROPERTY, key);
            PropertyUtil.setSystemProperty(key, value);
        }
    }

    public static void prepareUserDefinitionForBuiltInScheme(Properties properties) throws StandardException {
        String userAtt;
        block7: {
            SecurityUtils.processSystemUserDefinition(properties);
            userAtt = properties.getProperty("user");
            userAtt = userAtt == null ? properties.getProperty("UserName") : userAtt;
            String pwdAtt = properties.getProperty("password");
            if (userAtt != null) {
                userAtt = IdUtil.getUserAuthorizationId(userAtt);
            }
            try {
                AuthenticationServiceBase.validateUserPassword(userAtt, pwdAtt, true);
            }
            catch (SQLException sqle) {
                assert (sqle instanceof EmbedSQLException);
                assert (((EmbedSQLException)sqle).isSimpleWrapper());
                Throwable wrapped = sqle.getCause();
                if (!(wrapped instanceof StandardException)) break block7;
                throw (StandardException)wrapped;
            }
        }
        String value = PropertyUtil.getPropertyFromSet(properties, "gemfirexd.user." + userAtt);
        if (value == null) {
            value = PropertyUtil.getPropertyFromSet(properties, "sqlfire.user." + userAtt);
        }
        if (value == null) {
            SanityManager.DEBUG_PRINT((String)"warning:TraceAuthentication", (String)(" User definition for " + userAtt + " is missing."));
        }
    }

    public static Properties getCredentials(Properties securityProps) {
        if (securityProps == null) {
            return null;
        }
        String userName = securityProps.getProperty(GFXD_SEC_PREFIX + "user");
        boolean isUserNameAttribute = false;
        if (userName == null && (userName = securityProps.getProperty(GFXD_SEC_PREFIX + "UserName")) != null) {
            isUserNameAttribute = true;
        }
        String password = securityProps.getProperty(GFXD_SEC_PREFIX + "password");
        if (userName != null) {
            securityProps.put(isUserNameAttribute ? "UserName" : "user", userName);
        }
        if (password != null) {
            securityProps.put("password", password);
        }
        return securityProps;
    }
}

