/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.pivotal.gemfirexd.internal.engine.distributed.ByteArrayOutput;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataOutput;
import java.io.UTFDataFormatException;

public final class ByteArrayDataOutput
extends ByteArrayOutput
implements DataOutput {
    static void init() {
    }

    public ByteArrayDataOutput() {
    }

    public ByteArrayDataOutput(int allocSize) {
        super(allocSize);
    }

    @Override
    public final void writeBoolean(boolean v) {
        super.write(v ? 1 : 0);
    }

    @Override
    public final void writeByte(int v) {
        super.write(v);
    }

    @Override
    public final void writeShort(int v) {
        int pos = this.ensureCapacity(2, this.bufferPos);
        byte[] buffer = this.buffer;
        buffer[pos++] = (byte)(v >>> 8 & 0xFF);
        buffer[pos++] = (byte)(v & 0xFF);
        this.bufferPos = pos;
    }

    @Override
    public final void writeChar(int v) {
        this.writeShort(v);
    }

    @Override
    public final void writeInt(int v) {
        int pos = this.ensureCapacity(4, this.bufferPos);
        byte[] buffer = this.buffer;
        buffer[pos++] = (byte)(v >>> 24 & 0xFF);
        buffer[pos++] = (byte)(v >>> 16 & 0xFF);
        buffer[pos++] = (byte)(v >>> 8 & 0xFF);
        buffer[pos++] = (byte)(v & 0xFF);
        this.bufferPos = pos;
    }

    @Override
    public final void writeLong(long v) {
        int pos = this.ensureCapacity(8, this.bufferPos);
        byte[] buffer = this.buffer;
        buffer[pos++] = (byte)(v >>> 56 & 0xFFL);
        buffer[pos++] = (byte)(v >>> 48 & 0xFFL);
        buffer[pos++] = (byte)(v >>> 40 & 0xFFL);
        buffer[pos++] = (byte)(v >>> 32 & 0xFFL);
        buffer[pos++] = (byte)(v >>> 24 & 0xFFL);
        buffer[pos++] = (byte)(v >>> 16 & 0xFFL);
        buffer[pos++] = (byte)(v >>> 8 & 0xFFL);
        buffer[pos++] = (byte)(v & 0xFFL);
        this.bufferPos = pos;
    }

    @Override
    public final void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    final void writeBytes(char[] str, int strlen) {
        int pos = this.ensureCapacity(strlen, this.bufferPos);
        byte[] buffer = this.buffer;
        for (char c : str) {
            buffer[pos++] = (byte)c;
        }
        this.bufferPos = pos;
    }

    public final void writeBytes(char[] str, int offset, int end) {
        int pos = this.ensureCapacity(end - offset, this.bufferPos);
        byte[] buffer = this.buffer;
        while (offset < end) {
            buffer[pos++] = (byte)str[offset++];
        }
        this.bufferPos = pos;
    }

    public final void writeBytes(String str, int strlen) {
        char[] chars = ResolverUtils.getInternalCharsOnly((String)str, (int)strlen);
        if (chars != null) {
            this.writeBytes(chars, strlen);
            return;
        }
        int pos = this.ensureCapacity(strlen, this.bufferPos);
        byte[] buffer = this.buffer;
        for (int i = 0; i < strlen; ++i) {
            buffer[pos++] = (byte)str.charAt(i);
        }
        this.bufferPos = pos;
    }

    @Override
    public final void writeBytes(String str) {
        this.writeBytes(str, str.length());
    }

    @Override
    public final void writeChars(String str) {
        int strlen = str.length();
        int pos = this.ensureCapacity(strlen << 1, this.bufferPos);
        byte[] buffer = this.buffer;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            buffer[pos++] = (byte)(c >>> 8 & 0xFF);
            buffer[pos++] = (byte)(c & 0xFF);
        }
        this.bufferPos = pos;
    }

    public static final int getUTFLength(char[] str, int strlen) {
        int utflen = strlen;
        for (char c : str) {
            if (c >= '\u0001' && c <= '\u007f') continue;
            if (c > '\u07ff') {
                utflen += 2;
                continue;
            }
            ++utflen;
        }
        return utflen;
    }

    public static final int getUTFLength(String str, int strlen) {
        int utflen = strlen;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') continue;
            if (c > '\u07ff') {
                utflen += 2;
                continue;
            }
            ++utflen;
        }
        return utflen;
    }

    final void writeUTFNoLength(char[] str, int strlen, int utflen) {
        if (strlen == utflen) {
            this.writeBytes(str, strlen);
        } else {
            int pos = this.ensureCapacity(utflen, this.bufferPos);
            byte[] buffer = this.buffer;
            for (char c : str) {
                if (c >= '\u0001' && c <= '\u007f') {
                    buffer[pos++] = (byte)(c & 0xFF);
                    continue;
                }
                if (c > '\u07ff') {
                    buffer[pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                    buffer[pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                    buffer[pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                    continue;
                }
                buffer[pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
                buffer[pos++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            this.bufferPos = pos;
        }
    }

    public final void writeUTFNoLength(String str, int strlen, int utflen) {
        if (strlen == utflen) {
            this.writeBytes(str, strlen);
        } else {
            int pos = this.ensureCapacity(utflen, this.bufferPos);
            byte[] buffer = this.buffer;
            for (int i = 0; i < strlen; ++i) {
                char c = str.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    buffer[pos++] = (byte)(c & 0xFF);
                    continue;
                }
                if (c > '\u07ff') {
                    buffer[pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                    buffer[pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                    buffer[pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                    continue;
                }
                buffer[pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
                buffer[pos++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            this.bufferPos = pos;
        }
    }

    public static final int getUTFLength(String str) {
        int strlen = str.length();
        char[] chars = ResolverUtils.getInternalCharsOnly((String)str, (int)strlen);
        if (chars != null) {
            return ByteArrayDataOutput.getUTFLength(chars, strlen);
        }
        return ByteArrayDataOutput.getUTFLength(str, strlen);
    }

    public final void writeUTFNoLength(String str, int utflen) {
        int strlen = str.length();
        char[] chars = ResolverUtils.getInternalCharsOnly((String)str, (int)strlen);
        if (chars != null) {
            this.writeUTFNoLength(chars, strlen, utflen);
        } else {
            this.writeUTFNoLength(str, strlen, utflen);
        }
    }

    public final void writeUTFNoLength(String str) {
        int strlen = str.length();
        char[] chars = ResolverUtils.getInternalCharsOnly((String)str, (int)strlen);
        if (chars != null) {
            int utflen = ByteArrayDataOutput.getUTFLength(chars, strlen);
            this.writeUTFNoLength(chars, strlen, utflen);
        } else {
            int utflen = ByteArrayDataOutput.getUTFLength(str, strlen);
            this.writeUTFNoLength(str, strlen, utflen);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void writeUTF(String str) throws UTFDataFormatException {
        int strlen = str.length();
        char[] chars = ResolverUtils.getInternalCharsOnly((String)str, (int)strlen);
        if (chars != null) {
            int utflen = ByteArrayDataOutput.getUTFLength(chars, strlen);
            if (utflen > 65535) throw new UTFDataFormatException("ByteArrayDataOutput#writeUTF: encoded string too long: " + utflen + " bytes");
            this.writeShort(utflen);
            this.writeUTFNoLength(chars, strlen, utflen);
            return;
        } else {
            int utflen = ByteArrayDataOutput.getUTFLength(str, strlen);
            if (utflen > 65535) throw new UTFDataFormatException("ByteArrayDataOutput#writeUTF: encoded string too long: " + utflen + " bytes");
            this.writeShort(utflen);
            this.writeUTFNoLength(str, strlen, utflen);
        }
    }
}

