/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.wan.messages;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.DSFIDFactory;
import com.gemstone.gemfire.internal.cache.AbstractOperationMessage;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisee;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public abstract class AbstractDBSynchronizerMessage
extends GfxdMessage {
    private transient EntryEventImpl event = null;
    final transient LocalRegion rgn;

    AbstractDBSynchronizerMessage() {
        this.rgn = null;
    }

    AbstractDBSynchronizerMessage(LocalRegion rgn) {
        GemFireCacheImpl cache = rgn.getCache();
        EventID eventId = new EventID((DistributedSystem)cache.getDistributedSystem());
        InternalDistributedMember member = cache.getMyId();
        this.initializeEvent(rgn, eventId, (DistributedMember)member);
        this.rgn = rgn;
    }

    final void initializeEvent(LocalRegion rgn, EventID eventId, DistributedMember member) {
        this.event = EntryEventImpl.create((LocalRegion)rgn, (Operation)this.getOperation(), null, null, null, (boolean)true, (DistributedMember)member);
        this.event.setEventId(eventId);
    }

    final void addToLocalDBSynchronizerConditionally(boolean isQueryNode) {
        LocalRegion rgn = this.event.getRegion();
        List remoteDsIds = rgn.getRemoteDsIds(rgn.getAllGatewaySenderIds());
        boolean didLocalPublish = false;
        if (remoteDsIds != null && remoteDsIds.size() > 0) {
            Set senderIds;
            Set asyncQueueIds;
            if (!this.skipListeners() && (asyncQueueIds = rgn.getAsyncEventQueueIds()).size() > 0) {
                for (Object q : rgn.getCache().getAsyncEventQueues()) {
                    AsyncEventQueueImpl asyncQueue = (AsyncEventQueueImpl)q;
                    if (asyncQueue.isParallel() || !asyncQueueIds.contains(asyncQueue.getId())) continue;
                    if (GemFireXDUtils.TraceDBSynchronizer) {
                        SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("BaseActivation:addToLocalDBSynchronizerConditionally: adding EntryEventImpl to local AsyncEventQueue=" + asyncQueue.getId() + ": " + this.event));
                    }
                    asyncQueue.getSender().distribute(this.getListenerEvent(), this.event, remoteDsIds);
                    didLocalPublish = true;
                }
            }
            if ((senderIds = rgn.getGatewaySenderIds()).size() > 0) {
                for (Object s : rgn.getCache().getAllGatewaySenders()) {
                    AbstractGatewaySender sender = (AbstractGatewaySender)s;
                    if (sender.isForInternalUse() || sender.isParallel() || !senderIds.contains(sender.getId())) continue;
                    if (GemFireXDUtils.TraceDBSynchronizer) {
                        SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("BaseActivation:addToLocalDBSynchronizerConditionally: adding EntryEventImpl to local GatewaySender=" + sender.getId() + ": " + this.event));
                    }
                    sender.distribute(this.getListenerEvent(), this.event, remoteDsIds);
                    didLocalPublish = true;
                }
            }
        }
        if (!(didLocalPublish || isQueryNode || this.skipListeners())) {
            throw new IllegalStateException("Unexpected AbstractDBSynchronizerMessage received that was not applied anywhere " + this.toString());
        }
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        try {
            DataSerializer.writeObject((Object)this.event.getEventId(), (DataOutput)out);
            ((InternalDistributedMember)this.event.getDistributedMember()).toData(out);
            DataSerializer.writeString((String)this.event.getRegion().getFullPath(), (DataOutput)out);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public final EntryEventImpl getEntryEventImpl() {
        return this.event;
    }

    @Override
    protected void processMessage(DistributionManager dm) {
        block7: {
            if (this.event != null) {
                LocalRegion rgn = this.event.getRegion();
                if (rgn != null) {
                    rgn.waitOnInitialization();
                }
                if (GemFireXDUtils.TraceDBSynchronizer) {
                    SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("DBSynchronizerMessage: Executing with fields as: " + this.toString()));
                }
                try {
                    this.addToLocalDBSynchronizerConditionally(false);
                    if (GemFireXDUtils.TraceDBSynchronizer) {
                        SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("DBSynchronizerMessage: Successfully executed message with fields: " + this.toString()));
                    }
                }
                catch (Exception ex) {
                    LogWriter logger = this.event.getRegion().getCache().getLogger();
                    if (logger.severeEnabled()) {
                        logger.severe("DBSynchronizerMessage: SQL exception in executing message with fields as " + this.toString(), (Throwable)ex);
                    }
                    if (this.processorId <= 0 && dm != null) break block7;
                    throw new ReplyException("Unexpected SQLException on member " + dm.getDistributionManagerId(), (Throwable)ex);
                }
            }
        }
    }

    @Override
    protected void sendReply(ReplyException ex, DistributionManager dm) {
        ReplyMessage.send((InternalDistributedMember)this.getSender(), (int)this.processorId, (ReplyException)ex, (ReplySender)dm, (AbstractOperationMessage)this);
    }

    @Override
    protected boolean waitForNodeInitialization() {
        return true;
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append("; entryEvent=").append(this.event);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        try {
            EventID eventID = (EventID)DataSerializer.readObject((DataInput)in);
            InternalDistributedMember member = DSFIDFactory.readInternalDistributedMember((DataInput)in);
            String regionName = DataSerializer.readString((DataInput)in);
            LocalRegion rgn = Misc.getGemFireCache().getRegionByPathForProcessing(regionName);
            if (rgn != null) {
                this.initializeEvent(rgn, eventID, (DistributedMember)member);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public final void applyOperation() throws StandardException {
        try {
            Set members = ((CacheDistributionAdvisee)this.rgn).getCacheDistributionAdvisor().adviseSerialAsyncEventQueueOrGatewaySender();
            if (GemFireXDUtils.TraceDBSynchronizer) {
                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("BaseActivation: distributing bulk DML to remote nodes. Message={" + this + "} to members=" + members));
            }
            this.send(this.rgn.getSystem(), members);
        }
        catch (SQLException sqle) {
            throw Misc.wrapSQLException(sqle, sqle);
        }
        this.addToLocalDBSynchronizerConditionally(true);
    }

    @Override
    protected void handleProcessorReplyException(String exPrefix, ReplyException replyEx) throws SQLException, StandardException {
        Throwable t = replyEx.getCause();
        if (!GemFireXDUtils.retryToBeDone(t)) {
            if (GemFireXDUtils.TraceFunctionException) {
                SanityManager.DEBUG_PRINT((String)"TraceFunctionException", (String)(exPrefix + ": unexpected exception"), (Throwable)replyEx);
            }
            try {
                GemFireXDRuntimeException.throwSQLOrRuntimeException(this.toString() + ": unexpected exception", t);
            }
            catch (SQLException sqle) {
                throw Misc.wrapRemoteSQLException(sqle, replyEx, (DistributedMember)replyEx.getSender());
            }
        }
    }

    abstract Operation getOperation();

    abstract EnumListenerEvent getListenerEvent();

    abstract boolean skipListeners();
}

