/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;

public class EvictionTableAttribute {
    public static final byte ID_MEMSIZE = 1;
    public static final byte ID_HEAPPERCENT = 2;
    public static final byte ID_COUNT = 3;
    private EvictionAction evictAction;
    private byte lruType;
    private int count;

    public EvictionTableAttribute(byte lruType) {
        this.lruType = lruType;
        this.evictAction = null;
    }

    public EvictionTableAttribute() {
        this.evictAction = null;
    }

    public byte getLRUType() {
        return this.lruType;
    }

    public void setEvictionAction(EvictionAction eaction) {
        this.evictAction = eaction;
    }

    public EvictionAction getEvictionAction() {
        return this.evictAction;
    }

    public void setValue(int i) {
        this.count = i;
    }

    public void setType(byte evctType) {
        this.lruType = evctType;
    }

    public void setEvictionAttributes(AttributesFactory afact) throws StandardException {
        EvictionAttributes evictAttr;
        ObjectSizer osizer = Misc.getMemStore().getObjectSizer();
        if (this.evictAction == null) {
            this.evictAction = EvictionAction.DEFAULT_EVICTION_ACTION;
        }
        switch (this.lruType) {
            case 1: {
                evictAttr = EvictionAttributes.createLRUMemoryAttributes((int)this.count, (ObjectSizer)osizer, (EvictionAction)this.evictAction);
                break;
            }
            case 2: {
                evictAttr = EvictionAttributes.createLRUHeapAttributes((ObjectSizer)osizer, (EvictionAction)this.evictAction);
                break;
            }
            case 3: {
                evictAttr = EvictionAttributes.createLRUEntryAttributes((int)this.count, (EvictionAction)this.evictAction);
                break;
            }
            default: {
                throw StandardException.newException("XCY04.S: unknown eviction type " + this.lruType);
            }
        }
        afact.setEvictionAttributes(evictAttr);
    }
}

