/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.server;

import com.gemstone.gemfire.internal.SocketCreator;
import com.pivotal.gemfirexd.NetworkInterface;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import io.snappydata.thrift.common.SocketParameters;
import io.snappydata.thrift.common.ThriftUtils;
import io.snappydata.thrift.server.LocatorServiceImpl;
import io.snappydata.thrift.server.SnappyDataServiceImpl;
import io.snappydata.thrift.server.SnappyTSSLServerSocketFactory;
import io.snappydata.thrift.server.SnappyTServerSocket;
import io.snappydata.thrift.server.SnappyThriftServerSelector;
import io.snappydata.thrift.server.SnappyThriftServerThreadPool;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;

public final class SnappyThriftServer {
    private InetAddress thriftAddress;
    private int thriftPort;
    private LocatorServiceImpl service;
    private TServer thriftServer;
    private ExecutorService thriftExecutor;
    private ThreadPoolExecutor thriftThreadPerConnExecutor;
    private Thread thriftMainThread;

    public InetAddress getThriftAddress() {
        return this.thriftAddress;
    }

    public int getThriftPort() {
        return this.thriftPort;
    }

    public synchronized void start(InetAddress thriftAddress, int thriftPort, int maxThreads, boolean isServer, boolean useBinaryProtocol, boolean useSSL, SocketParameters socketParams, NetworkInterface.ConnectionListener listener) throws TTransportException {
        Object processor;
        LocatorServiceImpl service;
        InetSocketAddress bindAddress;
        this.thriftAddress = thriftAddress;
        this.thriftPort = thriftPort;
        if (this.isServing()) {
            throw GemFireXDRuntimeException.newRuntimeException("A thrift server is already running", null);
        }
        if (this.thriftAddress != null) {
            bindAddress = new InetSocketAddress(this.thriftAddress, this.thriftPort);
        } else {
            try {
                bindAddress = new InetSocketAddress(SocketCreator.getLocalHost(), this.thriftPort);
            }
            catch (UnknownHostException uhe) {
                throw new TTransportException("Could not determine localhost for default bind address.", (Throwable)uhe);
            }
        }
        Object serverTransport = useSSL ? SnappyTSSLServerSocketFactory.getServerSocket(bindAddress, socketParams) : new SnappyTServerSocket(bindAddress, true, true, socketParams);
        String hostAddress = bindAddress.getAddress().toString();
        if (isServer) {
            service = new SnappyDataServiceImpl(hostAddress, this.thriftPort);
            processor = new SnappyDataServiceImpl.Processor((SnappyDataServiceImpl)service);
            this.service = service;
        } else {
            service = new LocatorServiceImpl(hostAddress, this.thriftPort);
            processor = new LocatorServiceImpl.Processor(service);
            this.service = service;
        }
        int parallelism = Math.max(Runtime.getRuntime().availableProcessors(), 4);
        if (useSSL || !ThriftUtils.isThriftSelectorServer()) {
            SnappyThriftServerThreadPool.Args serverArgs = new SnappyThriftServerThreadPool.Args((TServerTransport)serverTransport);
            TBinaryProtocol.Factory protocolFactory = useBinaryProtocol ? new TBinaryProtocol.Factory() : new TCompactProtocol.Factory();
            ((SnappyThriftServerThreadPool.Args)serverArgs.processor((TProcessor)processor)).protocolFactory((TProtocolFactory)protocolFactory);
            this.thriftExecutor = new ThreadPoolExecutor(parallelism * 2, maxThreads, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            serverArgs.setExecutorService(this.thriftExecutor).setConnectionListener(listener);
            this.thriftServer = new SnappyThriftServerThreadPool(serverArgs);
        } else {
            SnappyThriftServerSelector.Args serverArgs = new SnappyThriftServerSelector.Args((TServerTransport)serverTransport);
            TBinaryProtocol.Factory protocolFactory = useBinaryProtocol ? new TBinaryProtocol.Factory() : new TCompactProtocol.Factory();
            int numSelectors = parallelism * 2;
            int numThreads = parallelism * 2;
            ((SnappyThriftServerSelector.Args)((SnappyThriftServerSelector.Args)serverArgs.processor((TProcessor)processor)).protocolFactory((TProtocolFactory)protocolFactory)).setNumSelectors(numSelectors).setConnectionListener(listener);
            this.thriftExecutor = new ThreadPoolExecutor(1, maxThreads, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            this.thriftThreadPerConnExecutor = new ThreadPoolExecutor(1, numThreads, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            serverArgs.setExecutorService(this.thriftExecutor);
            serverArgs.setThreadPerConnExecutor(this.thriftThreadPerConnExecutor);
            this.thriftServer = new SnappyThriftServerSelector(serverArgs);
        }
        this.thriftMainThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SnappyThriftServer.this.thriftServer.serve();
            }
        }, "ThriftServerThread");
        this.thriftMainThread.setDaemon(true);
        this.thriftMainThread.start();
    }

    public synchronized void stop() {
        TServer thriftServer = this.thriftServer;
        if (thriftServer != null) {
            this.service.stop();
            thriftServer.stop();
            ThreadPoolExecutor connExecutor = this.thriftThreadPerConnExecutor;
            if (connExecutor != null) {
                connExecutor.shutdown();
            }
            this.thriftExecutor.shutdown();
            try {
                this.thriftMainThread.join(5000L);
                if (this.thriftMainThread.isAlive()) {
                    if (connExecutor != null) {
                        connExecutor.shutdownNow();
                    }
                    this.thriftExecutor.shutdownNow();
                    this.thriftMainThread.join();
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public final boolean isServing() {
        TServer thriftServer = this.thriftServer;
        return thriftServer != null && thriftServer.isServing();
    }
}

