/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.jdbc;

import com.pivotal.gemfirexd.internal.iapi.jdbc.JDBCBoot;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public final class EmbeddedSimpleDataSource
implements DataSource {
    private String password;
    private String user;
    private String databaseName;
    private String dataSourceName;
    private String description;
    private String createDatabase;
    private String shutdownDatabase;
    private String connectionAttributes;
    private transient PrintWriter printer;
    private transient int loginTimeout;
    private transient InternalDriver driver;
    private transient String jdbcurl;

    public EmbeddedSimpleDataSource() {
        this.update();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printer;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printer = out;
    }

    public final synchronized void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        this.update();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public final void setDataSourceName(String dsn) {
        this.dataSourceName = dsn;
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    public final void setDescription(String desc) {
        this.description = desc;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setUser(String user) {
        this.user = user;
    }

    public final String getUser() {
        return this.user;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setCreateDatabase(String create) {
        this.createDatabase = create != null && create.toLowerCase(Locale.ENGLISH).equals("create") ? create : null;
    }

    public final String getCreateDatabase() {
        return this.createDatabase;
    }

    public final void setShutdownDatabase(String shutdown) {
        this.shutdownDatabase = shutdown != null && shutdown.equalsIgnoreCase("shutdown") ? shutdown : null;
    }

    public final String getShutdownDatabase() {
        return this.shutdownDatabase;
    }

    public final void setConnectionAttributes(String prop) {
        this.connectionAttributes = prop;
        this.update();
    }

    public final String getConnectionAttributes() {
        return this.connectionAttributes;
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.getConnection(this.getUser(), this.getPassword());
    }

    @Override
    public final Connection getConnection(String username, String password) throws SQLException {
        Connection conn;
        Properties info = new Properties();
        if (username != null) {
            info.put("user", username);
        }
        if (password != null) {
            info.put("password", password);
        }
        if (this.createDatabase != null) {
            info.put("create", "true");
        }
        if (this.shutdownDatabase != null) {
            info.put("shutdown", "true");
        }
        if ((conn = this.findDriver().connect(this.jdbcurl, info)) == null) {
            throw Util.generateCsSQLException("XCY00.S", (Object)"databaseName", this.getDatabaseName());
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalDriver findDriver() throws SQLException {
        String url = this.jdbcurl;
        if (this.driver == null || !this.driver.acceptsURL(url)) {
            EmbeddedSimpleDataSource embeddedSimpleDataSource = this;
            synchronized (embeddedSimpleDataSource) {
                if (this.driver == null || !this.driver.acceptsURL(url)) {
                    new JDBCBoot().boot("jdbc:gemfirexd:", System.err);
                    this.driver = InternalDriver.activeDriver();
                    if (this.driver == null) {
                        throw new SQLException(MessageService.getTextMessage("I015"));
                    }
                }
            }
        }
        return this.driver;
    }

    private void update() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("jdbc:gemfirexd:");
        String dbName = this.getDatabaseName();
        if (dbName != null) {
            dbName = dbName.trim();
        }
        if (dbName == null || dbName.length() == 0) {
            dbName = " ";
        }
        sb.append(dbName);
        String connAttrs = this.getConnectionAttributes();
        if (connAttrs != null && (connAttrs = connAttrs.trim()).length() != 0) {
            sb.append(';');
            sb.append(this.connectionAttributes);
        }
        this.jdbcurl = sb.toString();
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.1");
    }
}

