/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.log;

import com.pivotal.gemfirexd.internal.iapi.error.ErrorStringBuilder;
import com.pivotal.gemfirexd.internal.iapi.error.ShutdownException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.DaemonService;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.Serviceable;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.info.ProductVersionHolder;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.FileUtil;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleSupportable;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.PersistentService;
import com.pivotal.gemfirexd.internal.iapi.services.property.PersistentSet;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.DatabaseInstant;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Loggable;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RawStoreFactory;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ScanHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.data.DataFactory;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogFactory;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogScan;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.Logger;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.TransactionFactory;
import com.pivotal.gemfirexd.internal.iapi.store.replication.master.MasterFactory;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.impl.store.raw.log.CheckpointOperation;
import com.pivotal.gemfirexd.internal.impl.store.raw.log.FileLogger;
import com.pivotal.gemfirexd.internal.impl.store.raw.log.FlushedScan;
import com.pivotal.gemfirexd.internal.impl.store.raw.log.FlushedScanHandle;
import com.pivotal.gemfirexd.internal.impl.store.raw.log.LogAccessFile;
import com.pivotal.gemfirexd.internal.impl.store.raw.log.LogCounter;
import com.pivotal.gemfirexd.internal.impl.store.raw.log.Scan;
import com.pivotal.gemfirexd.internal.impl.store.raw.log.StreamLogScan;
import com.pivotal.gemfirexd.internal.io.StorageFactory;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import com.pivotal.gemfirexd.internal.io.StorageRandomAccessFile;
import com.pivotal.gemfirexd.internal.io.WritableStorageFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.SyncFailedException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.zip.CRC32;

public final class LogToFile
implements LogFactory,
ModuleControl,
ModuleSupportable,
Serviceable,
PrivilegedExceptionAction {
    private static int fid = 128;
    public static final int LOG_FILE_HEADER_SIZE = 24;
    protected static final int LOG_FILE_HEADER_PREVIOUS_LOG_INSTANT_OFFSET = 16;
    public static final int LOG_RECORD_OVERHEAD = 16;
    public static final String DBG_FLAG = "LogTrace";
    public static final String DUMP_LOG_ONLY = "DumpLogOnly";
    public static final String DUMP_LOG_FROM_LOG_FILE = "gemfirexd.storage.logDumpStart";
    protected static final String LOG_SYNC_STATISTICS = "LogSyncStatistics";
    private static final int OBSOLETE_LOG_VERSION_NUMBER = 9;
    private static final int DEFAULT_LOG_SWITCH_INTERVAL = 0x100000;
    private static final int LOG_SWITCH_INTERVAL_MIN = 100000;
    private static final int LOG_SWITCH_INTERVAL_MAX = 0x8000000;
    private static final int CHECKPOINT_INTERVAL_MIN = 100000;
    private static final int CHECKPOINT_INTERVAL_MAX = 0x8000000;
    private static final int DEFAULT_CHECKPOINT_INTERVAL = 0xA00000;
    private static final int DEFAULT_LOG_BUFFER_SIZE = 32768;
    private static final int LOG_BUFFER_SIZE_MIN = 8192;
    private static final int LOG_BUFFER_SIZE_MAX = 0x8000000;
    private int logBufferSize = 32768;
    private static final byte IS_BETA_FLAG = 1;
    private static final byte IS_DURABILITY_TESTMODE_NO_SYNC_FLAG = 2;
    private static boolean wasDBInDurabilityTestModeNoSync = false;
    private static final String DEFAULT_LOG_ARCHIVE_DIRECTORY = "DEFAULT";
    private int logSwitchInterval = 0x100000;
    private int checkpointInterval = 0xA00000;
    String dataDirectory;
    private WritableStorageFactory logStorageFactory;
    private boolean logBeingFlushed;
    protected LogAccessFile logOut;
    private StorageRandomAccessFile firstLog = null;
    protected long endPosition = -1L;
    long lastFlush = 0L;
    long logFileNumber = -1L;
    long bootTimeLogFileNumber = -1L;
    long firstLogFileNumber = -1L;
    private long maxLogFileNumber = Integer.MAX_VALUE;
    private CheckpointOperation currentCheckpoint;
    long checkpointInstant;
    private DaemonService checkpointDaemon;
    private int myClientNumber;
    private volatile boolean checkpointDaemonCalled;
    private long logWrittenFromLastCheckPoint = 0L;
    private RawStoreFactory rawStoreFactory;
    protected DataFactory dataFactory;
    protected boolean ReadOnlyDB;
    private MasterFactory masterFactory;
    private boolean inReplicationMasterMode = false;
    private boolean inReplicationSlaveMode = false;
    private volatile StandardException replicationSlaveException = null;
    private boolean inReplicationSlavePreMode = false;
    private Object slaveRecoveryMonitor;
    private long allowedToReadFileNumber = -1L;
    private boolean keepAllLogs;
    private boolean databaseEncrypted;
    private boolean recoveryNeeded = true;
    private boolean inCheckpoint = false;
    private boolean inRedo = false;
    private boolean inLogSwitch = false;
    private boolean stopped = false;
    String logDevice;
    private boolean logNotSynced = false;
    private volatile boolean logArchived = false;
    private boolean logSwitchRequired = false;
    int test_logWritten = 0;
    int test_numRecordToFillLog = -1;
    private int mon_flushCalls;
    private int mon_syncCalls;
    private int mon_numLogFlushWaits;
    private boolean mon_LogSyncStatistics;
    private int mon_numBytesToLog;
    protected volatile StandardException corrupt;
    private boolean isFrozen;
    ProductVersionHolder jbmsVersion;
    private int onDiskMajorVersion;
    private int onDiskMinorVersion;
    private boolean onDiskBeta;
    private CRC32 checksum = new CRC32();
    private boolean isWriteSynced = false;
    private boolean jvmSyncErrorChecked = false;
    private volatile long logFileToBackup;
    private volatile boolean backupInProgress = false;
    public static final String TEST_LOG_SWITCH_LOG = "TEST_LOG_SWITCH_LOG";
    public static final String TEST_LOG_INCOMPLETE_LOG_WRITE = "TEST_LOG_INCOMPLETE_LOG_WRITE";
    public static final String TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES = "derbyTesting.unittest.partialLogWrite";
    public static final String TEST_LOG_FULL = "TEST_LOG_FULL";
    public static final String TEST_SWITCH_LOG_FAIL1 = "TEST_SWITCH_LOG_FAIL1";
    public static final String TEST_SWITCH_LOG_FAIL2 = "TEST_SWITCH_LOG_FAIL2";
    public static final String TEST_RECORD_TO_FILL_LOG = "derbyTesting.unittest.recordToFillLog";
    public static final String TEST_MAX_LOGFILE_NUMBER = "testMaxLogFileNumber";
    private int action;
    private StorageFile activeFile;
    private File toFile;
    private String activePerms;

    public int getTypeFormatId() {
        return 128;
    }

    public LogToFile() {
        this.keepAllLogs = PropertyUtil.getSystemBoolean("gemfirexd.storage.keepTransactionLog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StandardException markCorrupt(StandardException originalError) {
        boolean firsttime = false;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (this.corrupt == null && originalError != null) {
                this.corrupt = originalError;
                firsttime = true;
            }
        }
        if (this.corrupt == originalError) {
            this.logErrMsg(this.corrupt);
        }
        if (firsttime) {
            logToFile = this;
            synchronized (logToFile) {
                this.stopped = true;
                if (this.logOut != null) {
                    try {
                        this.logOut.corrupt();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.logOut = null;
            }
            if (this.dataFactory != null) {
                this.dataFactory.markCorrupt(null);
            }
        }
        return originalError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCorrupt() throws StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (this.corrupt != null) {
                throw StandardException.newException("XSLAA.D", this.corrupt);
            }
        }
    }

    @Override
    public Logger getLogger() {
        if (this.ReadOnlyDB) {
            return null;
        }
        return new FileLogger(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover(RawStoreFactory rsf, DataFactory df, TransactionFactory tf) throws StandardException {
        SanityManager.ASSERT((rsf != null ? 1 : 0) != 0, (String)"raw store factory == null");
        SanityManager.ASSERT((df != null ? 1 : 0) != 0, (String)"data factory == null");
        this.checkCorrupt();
        this.rawStoreFactory = rsf;
        this.dataFactory = df;
        if (this.firstLog != null) {
            this.logOut = new LogAccessFile(this, this.firstLog, this.logBufferSize);
        }
        if (this.inReplicationSlaveMode) {
            Object object = this.slaveRecoveryMonitor;
            synchronized (object) {
                while (this.inReplicationSlaveMode && this.allowedToReadFileNumber < this.bootTimeLogFileNumber) {
                    if (this.replicationSlaveException != null) {
                        throw this.replicationSlaveException;
                    }
                    try {
                        this.slaveRecoveryMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (this.recoveryNeeded) {
            try {
                StorageFile logFile;
                FileLogger logger = (FileLogger)this.getLogger();
                if (this.checkpointInstant != 0L) {
                    this.currentCheckpoint = this.findCheckpoint(this.checkpointInstant, logger);
                }
                if (SanityManager.DEBUG_ON((String)DUMP_LOG_ONLY)) {
                    this.currentCheckpoint = null;
                    System.out.println("Dump log only");
                    String beginLogFileNumber = PropertyUtil.getSystemProperty(DUMP_LOG_FROM_LOG_FILE);
                    this.bootTimeLogFileNumber = beginLogFileNumber != null ? Long.valueOf(beginLogFileNumber) : 1L;
                }
                if (SanityManager.DEBUG_ON((String)"setCheckpoint")) {
                    this.currentCheckpoint = null;
                    System.out.println("Set Checkpoint.");
                    String checkpointStartLogStr = PropertyUtil.getSystemProperty("gemfirexd.storage.checkpointStartLog");
                    String checkpointStartOffsetStr = PropertyUtil.getSystemProperty("gemfirexd.storage.checkpointStartOffset");
                    if (checkpointStartLogStr != null && checkpointStartOffsetStr != null) {
                        this.checkpointInstant = LogCounter.makeLogInstantAsLong(Long.valueOf(checkpointStartLogStr), Long.valueOf(checkpointStartOffsetStr));
                    } else {
                        SanityManager.THROWASSERT((String)"must set gemfirexd.storage.checkpointStartLog and gemfirexd.storage.checkpointStartOffset, if setting setCheckpoint.");
                    }
                    this.currentCheckpoint = this.findCheckpoint(this.checkpointInstant, logger);
                }
                long redoLWM = 0L;
                long undoLWM = 0L;
                long ttabInstant = 0L;
                StreamLogScan redoScan = null;
                if (this.currentCheckpoint != null) {
                    Formatable transactionTable = null;
                    tf.useTransactionTable(transactionTable);
                    redoLWM = this.currentCheckpoint.redoLWM();
                    undoLWM = this.currentCheckpoint.undoLWM();
                    if (transactionTable != null) {
                        ttabInstant = this.checkpointInstant;
                    }
                    if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                        SanityManager.DEBUG((String)DBG_FLAG, (String)("Found checkpoint at " + LogCounter.toDebugString(this.checkpointInstant) + " " + this.currentCheckpoint.toString()));
                    }
                    this.firstLogFileNumber = LogCounter.getLogFileNumber(redoLWM);
                    if (LogCounter.getLogFileNumber(undoLWM) < this.firstLogFileNumber) {
                        this.firstLogFileNumber = LogCounter.getLogFileNumber(undoLWM);
                    }
                    redoScan = (StreamLogScan)this.openForwardsScan(undoLWM, (LogInstant)null);
                } else {
                    tf.useTransactionTable(null);
                    long start = LogCounter.makeLogInstantAsLong(this.bootTimeLogFileNumber, 24L);
                    this.firstLogFileNumber = this.bootTimeLogFileNumber;
                    redoScan = (StreamLogScan)this.openForwardsScan(start, (LogInstant)null);
                }
                RawTransaction recoveryTransaction = tf.startTransaction(rsf, ContextService.getFactory().getCurrentContextManager(), "UserTransaction");
                recoveryTransaction.recoveryTransaction();
                this.inRedo = true;
                long logEnd = logger.redo(recoveryTransaction, tf, redoScan, redoLWM, ttabInstant);
                this.inRedo = false;
                this.logFileNumber = this.bootTimeLogFileNumber;
                if (SanityManager.DEBUG_ON((String)DUMP_LOG_ONLY)) {
                    Monitor.logMessage("_____________________________________________________");
                    Monitor.logMessage("\n\t\t Log dump finished");
                    Monitor.logMessage("_____________________________________________________");
                    this.logOut = null;
                    return;
                }
                StorageRandomAccessFile theLog = null;
                if (logEnd == 0L) {
                    Monitor.logTextMessage("L007");
                    logFile = this.getLogFileName(this.logFileNumber);
                    if (this.privExists(logFile) && !this.privDelete(logFile)) {
                        logFile = this.getLogFileName(++this.logFileNumber);
                    }
                    try {
                        theLog = this.privRandomAccessFile(logFile, "rw");
                    }
                    catch (IOException ioe) {
                        theLog = null;
                    }
                    if (theLog == null || !this.privCanWrite(logFile)) {
                        if (theLog != null) {
                            theLog.close();
                        }
                        theLog = null;
                        this.ReadOnlyDB = true;
                    } else {
                        try {
                            if (!this.initLogFile(theLog, this.logFileNumber, 0L)) {
                                throw this.markCorrupt(StandardException.newException("XSLAQ.D", logFile.getPath()));
                            }
                        }
                        catch (IOException ioe) {
                            throw this.markCorrupt(StandardException.newException("XSLA2.D", ioe));
                        }
                        this.lastFlush = this.endPosition = theLog.getFilePointer();
                        if (this.isWriteSynced) {
                            this.preAllocateNewLogFile(theLog);
                            theLog.close();
                            theLog = this.openLogFileInWriteMode(logFile);
                            theLog.seek(this.endPosition);
                        }
                        SanityManager.ASSERT((this.endPosition == 24L ? 1 : 0) != 0, (String)"empty log file has wrong size");
                        this.logSwitchRequired = false;
                    }
                } else {
                    this.logFileNumber = LogCounter.getLogFileNumber(logEnd);
                    this.ReadOnlyDB = df.isReadOnly();
                    logFile = this.getLogFileName(this.logFileNumber);
                    if (!this.ReadOnlyDB) {
                        try {
                            theLog = this.isWriteSynced ? this.openLogFileInWriteMode(logFile) : this.privRandomAccessFile(logFile, "rw");
                        }
                        catch (IOException ioe) {
                            theLog = null;
                        }
                        if (theLog == null || !this.privCanWrite(logFile)) {
                            if (theLog != null) {
                                theLog.close();
                            }
                            theLog = null;
                            this.ReadOnlyDB = true;
                        }
                    }
                    if (!this.ReadOnlyDB) {
                        this.endPosition = LogCounter.getLogFilePosition(logEnd);
                        if (redoScan.isLogEndFuzzy()) {
                            theLog.seek(this.endPosition);
                            long eof = theLog.length();
                            Monitor.logTextMessage("L010", logFile, new Long(this.endPosition), new Long(eof));
                            long nWrites = (eof - this.endPosition) / (long)this.logBufferSize;
                            int rBytes = (int)((eof - this.endPosition) % (long)this.logBufferSize);
                            byte[] zeroBuf = new byte[this.logBufferSize];
                            while (nWrites-- > 0L) {
                                theLog.write(zeroBuf);
                            }
                            if (rBytes != 0) {
                                theLog.write(zeroBuf, 0, rBytes);
                            }
                            if (!this.isWriteSynced) {
                                this.syncFile(theLog);
                            }
                        }
                        if (theLog.length() != this.endPosition) {
                            SanityManager.ASSERT((theLog.length() > this.endPosition ? 1 : 0) != 0, (String)"log end > log file length, bad scan");
                        }
                        this.lastFlush = this.endPosition;
                        theLog.seek(this.endPosition);
                    }
                }
                if (theLog != null) {
                    this.logOut = new LogAccessFile(this, theLog, this.logBufferSize);
                }
                if (this.logSwitchRequired) {
                    this.switchLogFile();
                }
                boolean noInFlightTransactions = tf.noActiveUpdateTransaction();
                if (this.ReadOnlyDB && !noInFlightTransactions) {
                    throw StandardException.newException("XSLAF.D");
                }
                if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                    SanityManager.DEBUG((String)DBG_FLAG, (String)("About to call undo(), transaction table =" + tf.getTransactionTable()));
                }
                if (!noInFlightTransactions) {
                    if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                        SanityManager.DEBUG((String)DBG_FLAG, (String)"In recovery undo, rollback inflight transactions");
                    }
                    tf.rollbackAllTransactions(recoveryTransaction, rsf);
                    if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                        SanityManager.DEBUG((String)DBG_FLAG, (String)"finish recovery undo,");
                    }
                } else if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                    SanityManager.DEBUG((String)DBG_FLAG, (String)"No in flight transaction, no recovery undo work");
                }
                if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                    SanityManager.DEBUG((String)DBG_FLAG, (String)("About to call rePrepare(), transaction table =" + tf.getTransactionTable()));
                }
                tf.handlePreparedXacts(rsf);
                if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                    SanityManager.DEBUG((String)DBG_FLAG, (String)("Finished rePrepare(), transaction table =" + tf.getTransactionTable()));
                }
                recoveryTransaction.close();
                this.dataFactory.postRecovery();
                tf.resetTranId();
                if (!this.ReadOnlyDB) {
                    boolean needCheckpoint = true;
                    if (this.currentCheckpoint != null && noInFlightTransactions && redoLWM != 0L && undoLWM != 0L && this.logFileNumber == LogCounter.getLogFileNumber(redoLWM) && this.logFileNumber == LogCounter.getLogFileNumber(undoLWM) && this.endPosition < LogCounter.getLogFilePosition(redoLWM) + 1000L) {
                        needCheckpoint = false;
                    }
                    if (needCheckpoint && !this.checkpoint(rsf, df, tf, false)) {
                        this.flush(this.logFileNumber, this.endPosition);
                    }
                }
                logger.close();
                this.recoveryNeeded = false;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw this.markCorrupt(StandardException.newException("XSLA2.D", ioe));
            }
            catch (ClassNotFoundException cnfe) {
                throw this.markCorrupt(StandardException.newException("XSLA3.D", cnfe));
            }
            catch (StandardException se) {
                throw this.markCorrupt(se);
            }
            catch (Throwable th) {
                SanityManager.showTrace((Throwable)th);
                th.printStackTrace();
                throw this.markCorrupt(StandardException.newException("XSLA6.D", th));
            }
        }
        tf.useTransactionTable(null);
        tf.resetTranId();
        this.checkpointDaemon = this.rawStoreFactory.getDaemon();
        if (this.checkpointDaemon != null) {
            this.myClientNumber = this.checkpointDaemon.subscribe(this, true);
            this.dataFactory.setupCacheCleaner(this.checkpointDaemon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkpoint(RawStoreFactory rsf, DataFactory df, TransactionFactory tf, boolean wait) throws StandardException {
        if (this.inReplicationSlavePreMode) {
            return true;
        }
        boolean done = this.checkpointWithTran(null, rsf, df, tf);
        if (!done && wait) {
            LogToFile logToFile = this;
            synchronized (logToFile) {
                while (this.inCheckpoint) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        throw StandardException.interrupt(ie);
                    }
                }
                done = true;
            }
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkpointWithTran(RawTransaction cptran, RawStoreFactory rsf, DataFactory df, TransactionFactory tf) throws StandardException {
        boolean needCPTran;
        long approxLogLength;
        boolean proceed = true;
        if (this.logOut == null) {
            return false;
        }
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (this.corrupt != null) {
                throw StandardException.newException("XSLAA.D", this.corrupt);
            }
            if (this.inCheckpoint) {
                proceed = false;
            } else {
                this.inCheckpoint = true;
            }
            approxLogLength = this.endPosition;
        }
        if (!proceed) {
            return false;
        }
        boolean bl = needCPTran = cptran == null;
        if (this.logSwitchInterval == 0) {
            SanityManager.THROWASSERT((String)("switching log file: Approx log length = " + approxLogLength + " logSwitchInterval = 0"));
        }
        try {
            long undoLWM_long;
            LogCounter redoLWM;
            long redoLWM_long;
            if (approxLogLength > (long)this.logSwitchInterval) {
                this.switchLogFile();
                this.logWrittenFromLastCheckPoint = 0L;
            } else {
                this.logWrittenFromLastCheckPoint = -this.endPosition;
            }
            if (SanityManager.DEBUG_ON((String)TEST_LOG_SWITCH_LOG)) {
                boolean bl2 = false;
                return bl2;
            }
            if (needCPTran) {
                cptran = tf.startInternalTransaction(rsf, ContextService.getFactory().getCurrentContextManager());
            }
            LogToFile logToFile2 = this;
            synchronized (logToFile2) {
                redoLWM_long = this.currentInstant();
                redoLWM = new LogCounter(redoLWM_long);
                LogCounter undoLWM = (LogCounter)tf.firstUpdateInstant();
                undoLWM_long = undoLWM == null ? redoLWM_long : undoLWM.getValueAsLong();
            }
            df.checkpoint();
            Formatable transactionTable = tf.getTransactionTable();
            CheckpointOperation nextCheckpoint = new CheckpointOperation(redoLWM_long, undoLWM_long, transactionTable);
            cptran.logAndDo(nextCheckpoint);
            LogCounter checkpointInstant = (LogCounter)cptran.getLastLogInstant();
            if (checkpointInstant == null) {
                throw StandardException.newException("XSLAI.D");
            }
            this.flush(checkpointInstant);
            cptran.commit();
            if (needCPTran) {
                cptran.close();
                cptran = null;
            }
            if (!this.writeControlFile(this.getControlFileName(), checkpointInstant.getValueAsLong())) {
                throw StandardException.newException("XSLAE.D", this.getControlFileName());
            }
            this.currentCheckpoint = nextCheckpoint;
            if (!this.logArchived()) {
                this.truncateLog(this.currentCheckpoint);
            }
            if (!this.backupInProgress) {
                df.removeDroppedContainerFileStubs(redoLWM);
            }
        }
        catch (IOException ioe) {
            throw this.markCorrupt(StandardException.newException("XSLA2.D", ioe));
        }
        finally {
            LogToFile logToFile3 = this;
            synchronized (logToFile3) {
                this.inCheckpoint = false;
                this.notifyAll();
            }
            if (cptran != null && needCPTran) {
                try {
                    cptran.commit();
                    cptran.close();
                }
                catch (StandardException se) {
                    throw this.markCorrupt(StandardException.newException("XSLA3.D", se));
                }
            }
        }
        return true;
    }

    @Override
    public void flush(LogInstant where) throws StandardException {
        long wherePosition;
        long fileNumber;
        if (where == null) {
            fileNumber = 0L;
            wherePosition = 0L;
        } else {
            LogCounter whereC = (LogCounter)where;
            fileNumber = whereC.getLogFileNumber();
            wherePosition = whereC.getLogFilePosition();
        }
        this.flush(fileNumber, wherePosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll() throws StandardException {
        long whereTo;
        long fnum;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            fnum = this.logFileNumber;
            whereTo = this.endPosition;
        }
        this.flush(fnum, whereTo);
    }

    private boolean verifyLogFormat(StorageFile logFileName, long number) throws StandardException {
        boolean ret = false;
        try {
            StorageRandomAccessFile log = this.privRandomAccessFile(logFileName, "r");
            ret = this.verifyLogFormat(log, number);
            log.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    private boolean verifyLogFormat(StorageRandomAccessFile log, long number) throws StandardException {
        try {
            log.seek(0L);
            int logfid = log.readInt();
            int obsoleteLogVersion = log.readInt();
            long logNumber = log.readLong();
            if (logfid != fid || logNumber != number) {
                throw StandardException.newException("XSLAC.D", this.dataDirectory);
            }
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSLAM.D", (Throwable)ioe, (Object)this.dataDirectory);
        }
        return true;
    }

    private boolean initLogFile(StorageRandomAccessFile newlog, long number, long prevLogRecordEndInstant) throws IOException, StandardException {
        if (newlog.length() != 0L) {
            return false;
        }
        if (SanityManager.DEBUG_ON((String)TEST_LOG_FULL)) {
            this.testLogFull();
        }
        if (SanityManager.DEBUG_ON((String)TEST_SWITCH_LOG_FAIL1)) {
            throw new IOException("TestLogSwitchFail1");
        }
        newlog.seek(0L);
        newlog.writeInt(fid);
        newlog.writeInt(9);
        newlog.writeLong(number);
        newlog.writeLong(prevLogRecordEndInstant);
        this.syncFile(newlog);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchLogFile() throws StandardException {
        boolean switchedOver = false;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            block29: {
                while (this.logBeingFlushed | this.isFrozen) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        throw StandardException.interrupt(ie);
                    }
                }
                if (this.endPosition == 24L) {
                    Monitor.logMessage("not switching from an empty log file (" + this.logFileNumber + ")");
                    return;
                }
                StorageFile newLogFile = this.getLogFileName(this.logFileNumber + 1L);
                if (this.logFileNumber + 1L >= this.maxLogFileNumber) {
                    throw StandardException.newException("XSLAK.D", new Long(this.maxLogFileNumber));
                }
                StorageRandomAccessFile newLog = null;
                try {
                    if (this.privExists(newLogFile) && !this.privDelete(newLogFile)) {
                        this.logErrMsg(MessageService.getTextMessage("L015", newLogFile.getPath()));
                        return;
                    }
                    try {
                        newLog = this.privRandomAccessFile(newLogFile, "rw");
                    }
                    catch (IOException ioe) {
                        newLog = null;
                    }
                    if (newLog == null || !this.privCanWrite(newLogFile)) {
                        if (newLog != null) {
                            newLog.close();
                        }
                        newLog = null;
                        return;
                    }
                    if (this.initLogFile(newLog, this.logFileNumber + 1L, LogCounter.makeLogInstantAsLong(this.logFileNumber, this.endPosition))) {
                        switchedOver = true;
                        this.logOut.writeEndMarker(0);
                        this.endPosition += 4L;
                        this.inLogSwitch = true;
                        this.flush(this.logFileNumber, this.endPosition);
                        if (SanityManager.DEBUG_ON((String)TEST_SWITCH_LOG_FAIL2)) {
                            throw new IOException("TestLogSwitchFail2");
                        }
                        this.logOut.close();
                        this.logWrittenFromLastCheckPoint += this.endPosition;
                        this.lastFlush = this.endPosition = newLog.getFilePointer();
                        if (this.isWriteSynced) {
                            this.preAllocateNewLogFile(newLog);
                            newLog.close();
                            newLog = this.openLogFileInWriteMode(newLogFile);
                            newLog.seek(this.endPosition);
                        }
                        this.logOut = new LogAccessFile(this, newLog, this.logBufferSize);
                        newLog = null;
                        if (this.endPosition != 24L) {
                            SanityManager.THROWASSERT((String)("new log file has unexpected size" + this.endPosition));
                        }
                        ++this.logFileNumber;
                        SanityManager.ASSERT((this.endPosition == 24L ? 1 : 0) != 0, (String)"empty log file has wrong size");
                    } else {
                        newLog.close();
                        newLog = null;
                        if (this.privExists(newLogFile)) {
                            this.privDelete(newLogFile);
                        }
                        newLogFile = null;
                        this.logErrMsg(MessageService.getTextMessage("L016", newLogFile.getPath()));
                    }
                }
                catch (IOException ioe) {
                    this.inLogSwitch = false;
                    this.logErrMsg(MessageService.getTextMessage("L017", newLogFile.getPath(), ioe.toString()));
                    try {
                        if (newLog != null) {
                            newLog.close();
                            newLog = null;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (newLogFile != null && this.privExists(newLogFile)) {
                        this.privDelete(newLogFile);
                        newLogFile = null;
                    }
                    if (!switchedOver) break block29;
                    this.logOut = null;
                    throw this.markCorrupt(StandardException.newException("XSLA2.D", ioe));
                }
            }
            if (this.inReplicationSlaveMode) {
                this.allowedToReadFileNumber = this.logFileNumber - 1L;
                Object object = this.slaveRecoveryMonitor;
                synchronized (object) {
                    this.slaveRecoveryMonitor.notify();
                }
            }
            this.inLogSwitch = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer(long fileNumber, long wherePosition) throws IOException, StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (fileNumber < this.logFileNumber) {
                return;
            }
            if (wherePosition < this.lastFlush) {
                return;
            }
            this.logOut.flushLogAccessFile();
        }
    }

    private void truncateLog(CheckpointOperation checkpoint) {
        long firstLogNeeded = this.getFirstLogNeeded(checkpoint);
        if (firstLogNeeded == -1L) {
            return;
        }
        this.truncateLog(firstLogNeeded);
    }

    private void truncateLog(long firstLogNeeded) {
        long logFileNeededForBackup;
        if (this.keepAllLogs) {
            return;
        }
        if (this.backupInProgress && (logFileNeededForBackup = this.logFileToBackup) < firstLogNeeded) {
            firstLogNeeded = logFileNeededForBackup;
        }
        this.firstLogFileNumber = firstLogNeeded;
        for (long oldFirstLog = this.firstLogFileNumber; oldFirstLog < firstLogNeeded; ++oldFirstLog) {
            StorageFile uselessLogFile = null;
            try {
                uselessLogFile = this.getLogFileName(oldFirstLog);
                if (this.privDelete(uselessLogFile)) {
                    if (!SanityManager.DEBUG_ON((String)DBG_FLAG)) continue;
                    SanityManager.DEBUG((String)DBG_FLAG, (String)("truncating useless log file " + uselessLogFile.getPath()));
                    continue;
                }
                if (!SanityManager.DEBUG_ON((String)DBG_FLAG)) continue;
                SanityManager.DEBUG((String)DBG_FLAG, (String)("Fail to truncate useless log file " + uselessLogFile.getPath()));
                continue;
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT((String)("error opening log segment while deleting " + uselessLogFile.getPath()), (Throwable)se);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getFirstLogNeeded(CheckpointOperation checkpoint) {
        long firstLogNeeded;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            long l = firstLogNeeded = checkpoint != null ? LogCounter.getLogFileNumber(checkpoint.undoLWM()) : -1L;
            if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                SanityManager.DEBUG((String)DBG_FLAG, (String)("truncatLog: undoLWM firstlog needed " + firstLogNeeded));
            }
            if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                SanityManager.DEBUG((String)DBG_FLAG, (String)("truncatLog: checkpoint truncationLWM firstlog needed " + firstLogNeeded));
                SanityManager.DEBUG((String)DBG_FLAG, (String)("truncatLog: firstLogFileNumber = " + this.firstLogFileNumber));
            }
        }
        return firstLogNeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean writeControlFile(StorageFile logControlFileName, long value) throws IOException, StandardException {
        StorageRandomAccessFile logControlFile = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(64);
        DataOutputStream daos = new DataOutputStream(baos);
        daos.writeInt(fid);
        daos.writeInt(9);
        daos.writeLong(value);
        if (this.onDiskMajorVersion == 0) {
            this.onDiskMajorVersion = this.jbmsVersion.getMajorVersion();
            this.onDiskMinorVersion = this.jbmsVersion.getMinorVersion();
            this.onDiskBeta = this.jbmsVersion.isBeta();
        }
        daos.writeInt(this.onDiskMajorVersion);
        daos.writeInt(this.onDiskMinorVersion);
        daos.writeInt(this.jbmsVersion.getBuildNumberAsInt());
        byte flags = 0;
        if (this.onDiskBeta) {
            flags = (byte)(flags | 1);
        }
        if (this.logNotSynced || wasDBInDurabilityTestModeNoSync) {
            flags = (byte)(flags | 2);
        }
        daos.writeByte(flags);
        long spare = 0L;
        daos.writeByte(0);
        daos.writeByte(0);
        daos.writeByte(0);
        daos.writeLong(spare);
        daos.flush();
        this.checksum.reset();
        this.checksum.update(baos.toByteArray(), 0, baos.size());
        daos.writeLong(this.checksum.getValue());
        daos.flush();
        try {
            this.checkCorrupt();
            try {
                logControlFile = this.privRandomAccessFile(logControlFileName, "rw");
            }
            catch (IOException ioe) {
                logControlFile = null;
                boolean bl = false;
                if (logControlFile != null) {
                    logControlFile.close();
                }
                return bl;
            }
            if (!this.privCanWrite(logControlFileName)) {
                boolean ioe = false;
                return ioe;
            }
            if (SanityManager.DEBUG_ON((String)TEST_LOG_FULL)) {
                this.testLogFull();
            }
            logControlFile.seek(0L);
            logControlFile.write(baos.toByteArray());
            this.syncFile(logControlFile);
            logControlFile.close();
            try {
                logControlFile = this.privRandomAccessFile(this.getMirrorControlFileName(), "rw");
            }
            catch (IOException ioe) {
                logControlFile = null;
                boolean bl = false;
                if (logControlFile != null) {
                    logControlFile.close();
                }
                return bl;
            }
            logControlFile.seek(0L);
            logControlFile.write(baos.toByteArray());
            this.syncFile(logControlFile);
        }
        finally {
            if (logControlFile != null) {
                logControlFile.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readControlFile(StorageFile logControlFileName, Properties startParams) throws IOException, StandardException {
        StorageRandomAccessFile logControlFile = null;
        ByteArrayInputStream bais = null;
        FilterInputStream dais = null;
        logControlFile = this.privRandomAccessFile(logControlFileName, "r");
        boolean upgradeNeeded = false;
        long value = 0L;
        long onDiskChecksum = 0L;
        long controlFilelength = logControlFile.length();
        byte[] barray = null;
        try {
            if (controlFilelength < 16L) {
                onDiskChecksum = -1L;
            } else if (controlFilelength == 16L) {
                barray = new byte[16];
                logControlFile.readFully(barray);
            } else if (controlFilelength > 16L) {
                barray = new byte[(int)logControlFile.length() - 8];
                logControlFile.readFully(barray);
                onDiskChecksum = logControlFile.readLong();
                if (onDiskChecksum != 0L) {
                    this.checksum.reset();
                    this.checksum.update(barray, 0, barray.length);
                }
            }
            if (onDiskChecksum == this.checksum.getValue() || onDiskChecksum == 0L) {
                bais = new ByteArrayInputStream(barray);
                dais = new DataInputStream(bais);
                if (((DataInputStream)dais).readInt() != fid) {
                    throw StandardException.newException("XSLAC.D", this.dataDirectory);
                }
                int obsoleteVersion = ((DataInputStream)dais).readInt();
                value = ((DataInputStream)dais).readLong();
                if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                    SanityManager.DEBUG((String)DBG_FLAG, (String)("log control file ckp instance = " + LogCounter.toDebugString(value)));
                }
                this.onDiskMajorVersion = ((DataInputStream)dais).readInt();
                this.onDiskMinorVersion = ((DataInputStream)dais).readInt();
                int dbBuildNumber = ((DataInputStream)dais).readInt();
                byte flags = ((DataInputStream)dais).readByte();
                boolean bl = wasDBInDurabilityTestModeNoSync = (flags & 2) != 0;
                if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                    SanityManager.DEBUG((String)DBG_FLAG, (String)("log control file, was gemfirexd.system.durability set to test = " + wasDBInDurabilityTestModeNoSync));
                }
                boolean bl2 = this.onDiskBeta = (flags & 1) != 0;
                if (this.onDiskBeta && (!this.jbmsVersion.isBeta() || this.onDiskMajorVersion != this.jbmsVersion.getMajorVersion() || this.onDiskMinorVersion != this.jbmsVersion.getMinorVersion())) {
                    boolean forceBetaUpgrade = false;
                    if (SanityManager.DEBUG_ON((String)"forceBetaUpgrade")) {
                        Monitor.logMessage("WARNING !! : forcing beta upgrade.");
                        forceBetaUpgrade = true;
                    }
                    if (!forceBetaUpgrade) {
                        throw StandardException.newException("XSLAP.D", (Object)this.dataDirectory, (Object)ProductVersionHolder.simpleVersionString((int)this.onDiskMajorVersion, (int)this.onDiskMinorVersion, (boolean)this.onDiskBeta));
                    }
                }
                if (this.onDiskMajorVersion > this.jbmsVersion.getMajorVersion() || this.onDiskMajorVersion == this.jbmsVersion.getMajorVersion() && this.onDiskMinorVersion > this.jbmsVersion.getMinorVersion()) {
                    throw StandardException.newException("XSLAN.D", (Object)this.dataDirectory, (Object)ProductVersionHolder.simpleVersionString((int)this.onDiskMajorVersion, (int)this.onDiskMinorVersion, (boolean)this.onDiskBeta));
                }
                if (this.onDiskMajorVersion != this.jbmsVersion.getMajorVersion() || this.onDiskMinorVersion != this.jbmsVersion.getMinorVersion()) {
                    upgradeNeeded = true;
                }
                if (onDiskChecksum == 0L && (this.onDiskMajorVersion > 3 || this.onDiskMinorVersion > 5 || this.onDiskMajorVersion == 0)) {
                    value = 0L;
                }
            }
        }
        finally {
            if (logControlFile != null) {
                logControlFile.close();
            }
            if (bais != null) {
                bais.close();
            }
            if (dais != null) {
                dais.close();
            }
        }
        if (upgradeNeeded && Monitor.isFullUpgrade(startParams, ProductVersionHolder.simpleVersionString((int)this.onDiskMajorVersion, (int)this.onDiskMinorVersion, (boolean)this.onDiskBeta))) {
            this.onDiskMajorVersion = this.jbmsVersion.getMajorVersion();
            this.onDiskMinorVersion = this.jbmsVersion.getMinorVersion();
            this.onDiskBeta = this.jbmsVersion.isBeta();
            if (!this.writeControlFile(logControlFileName, value)) {
                throw StandardException.newException("XSLAE.D", logControlFileName);
            }
        }
        return value;
    }

    private void createLogDirectory() throws StandardException {
        StorageFile logDir = this.logStorageFactory.newStorageFile("log");
        if (this.privExists(logDir)) {
            String[] logfiles = this.privList(logDir);
            if (logfiles != null && logfiles.length != 0) {
                throw StandardException.newException("XSLAT.D", logDir.getPath());
            }
        } else if (!this.privMkdirs(logDir)) {
            throw StandardException.newException("XSLAQ.D", logDir.getPath());
        }
    }

    @Override
    public StorageFile getLogDirectory() throws StandardException {
        StorageFile logDir = null;
        logDir = this.logStorageFactory.newStorageFile("log");
        if (!this.privExists(logDir)) {
            throw StandardException.newException("XSLAQ.D", logDir.getPath());
        }
        return logDir;
    }

    @Override
    public String getCanonicalLogPath() {
        if (this.logDevice == null) {
            return null;
        }
        try {
            return this.logStorageFactory.getCanonicalName();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private StorageFile getControlFileName() throws StandardException {
        return this.logStorageFactory.newStorageFile(this.getLogDirectory(), "log.ctrl");
    }

    private StorageFile getMirrorControlFileName() throws StandardException {
        return this.logStorageFactory.newStorageFile(this.getLogDirectory(), "logmirror.ctrl");
    }

    private StorageFile getLogFileName(long filenumber) throws StandardException {
        return this.logStorageFactory.newStorageFile(this.getLogDirectory(), "log" + filenumber + ".dat");
    }

    private CheckpointOperation findCheckpoint(long checkpointInstant, FileLogger logger) throws IOException, StandardException, ClassNotFoundException {
        StreamLogScan scan = (StreamLogScan)this.openForwardsScan(checkpointInstant, (LogInstant)null);
        Loggable lop = logger.readLogRecord(scan, 100);
        scan.close();
        if (lop instanceof CheckpointOperation) {
            return (CheckpointOperation)lop;
        }
        return null;
    }

    protected LogScan openBackwardsScan(long startAt, LogInstant stopAt) throws IOException, StandardException {
        this.checkCorrupt();
        if (startAt == 0L) {
            return this.openBackwardsScan(stopAt);
        }
        this.flushBuffer(LogCounter.getLogFileNumber(startAt), LogCounter.getLogFilePosition(startAt));
        return new Scan(this, startAt, stopAt, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogScan openBackwardsScan(LogInstant stopAt) throws IOException, StandardException {
        long startAt;
        this.checkCorrupt();
        LogToFile logToFile = this;
        synchronized (logToFile) {
            this.logOut.flushLogAccessFile();
            startAt = this.currentInstant();
        }
        return new Scan(this, startAt, stopAt, 4);
    }

    @Override
    public ScanHandle openFlushedScan(DatabaseInstant start, int groupsIWant) throws StandardException {
        return new FlushedScanHandle(this, start, groupsIWant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogScan openForwardsScan(long startAt, LogInstant stopAt) throws IOException, StandardException {
        this.checkCorrupt();
        if (startAt == 0L) {
            startAt = this.firstLogInstant();
        }
        if (stopAt != null) {
            LogCounter stopCounter = (LogCounter)stopAt;
            this.flushBuffer(stopCounter.getLogFileNumber(), stopCounter.getLogFilePosition());
        } else {
            LogToFile logToFile = this;
            synchronized (logToFile) {
                if (this.logOut != null) {
                    this.logOut.flushLogAccessFile();
                }
            }
        }
        return new Scan(this, startAt, stopAt, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StorageRandomAccessFile getLogFileAtBeginning(long filenumber) throws IOException, StandardException {
        if (this.inReplicationSlaveMode && this.allowedToReadFileNumber != -1L) {
            Object object = this.slaveRecoveryMonitor;
            synchronized (object) {
                while (this.inReplicationSlaveMode && filenumber > this.allowedToReadFileNumber) {
                    if (this.replicationSlaveException != null) {
                        throw this.replicationSlaveException;
                    }
                    try {
                        this.slaveRecoveryMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        long instant = LogCounter.makeLogInstantAsLong(filenumber, 24L);
        return this.getLogFileAtPosition(instant);
    }

    protected StorageRandomAccessFile getLogFileAtPosition(long logInstant) throws IOException, StandardException {
        this.checkCorrupt();
        long filenum = LogCounter.getLogFileNumber(logInstant);
        long filepos = LogCounter.getLogFilePosition(logInstant);
        StorageFile fileName = this.getLogFileName(filenum);
        if (!this.privExists(fileName)) {
            if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                SanityManager.DEBUG((String)DBG_FLAG, (String)(fileName.getPath() + " does not exist"));
            }
            return null;
        }
        StorageRandomAccessFile log = null;
        try {
            log = this.privRandomAccessFile(fileName, "r");
            if (!this.verifyLogFormat(log, filenum)) {
                if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                    SanityManager.DEBUG((String)DBG_FLAG, (String)(fileName.getPath() + " format mismatch"));
                }
                log.close();
                log = null;
            } else {
                log.seek(filepos);
            }
        }
        catch (IOException ioe) {
            try {
                if (log != null) {
                    log.close();
                    log = null;
                }
                SanityManager.THROWASSERT((String)("cannot get to position " + filepos + " for log file " + fileName.getPath()), (Throwable)ioe);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ioe;
        }
        return log;
    }

    @Override
    public boolean canSupport(String identifier, Properties startParams) {
        String runtimeLogAttributes = startParams.getProperty("gemfirexd.__rt.storage.log");
        return runtimeLogAttributes == null || !runtimeLogAttributes.equals("readonly");
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        String mode = startParams.getProperty("replication.slave.mode");
        if (mode != null && mode.equals("slavemode")) {
            this.inReplicationSlaveMode = true;
            this.slaveRecoveryMonitor = new Object();
        } else if (mode != null && mode.equals("slavepremode")) {
            this.inReplicationSlavePreMode = true;
        }
        this.dataDirectory = startParams.getProperty("gemfirexd.__rt.serviceDirectory");
        this.logDevice = startParams.getProperty("logDevice");
        if (this.logDevice != null) {
            String logDeviceURL = null;
            try {
                URL url = new URL(this.logDevice);
                logDeviceURL = url.getFile();
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
            if (logDeviceURL != null) {
                this.logDevice = logDeviceURL;
            }
        }
        if (create) {
            this.getLogStorageFactory();
            this.createLogDirectory();
        } else if (!this.restoreLogs(startParams)) {
            StorageFile checklogDir;
            this.getLogStorageFactory();
            if (this.logDevice != null && !this.privExists(checklogDir = this.logStorageFactory.newStorageFile("log"))) {
                throw StandardException.newException("XSLAB.D", checklogDir.getPath());
            }
        }
        this.logBufferSize = PropertyUtil.getSystemInt("gemfirexd.storage.logBufferSize", 8192, 0x8000000, 32768);
        this.jbmsVersion = Monitor.getMonitor().getEngineVersion();
        String logArchiveMode = startParams.getProperty("gemfirexd.storage.logArchiveMode");
        this.logArchived = Boolean.valueOf(logArchiveMode);
        this.getLogFactoryProperties(null);
        this.isWriteSynced = this.logStorageFactory.supportsWriteSync() ? !PropertyUtil.getSystemBoolean("gemfirexd.storage.fileSyncTransactionLog") : false;
        if ("test".equalsIgnoreCase(PropertyUtil.getSystemProperty("gemfirexd.system.durability"))) {
            this.logNotSynced = true;
            this.isWriteSynced = false;
        }
        boolean createNewLog = create;
        SanityManager.ASSERT((fid != -1 ? 1 : 0) != 0, (String)"invalid log format Id");
        this.checkpointInstant = 0L;
        try {
            StorageFile logFile;
            StorageFile logControlFileName = this.getControlFileName();
            if (!createNewLog) {
                if (this.privExists(logControlFileName)) {
                    this.checkpointInstant = this.readControlFile(logControlFileName, startParams);
                    if (wasDBInDurabilityTestModeNoSync) {
                        Monitor.logMessage(MessageService.getTextMessage("L020", "gemfirexd.system.durability", "test"));
                    }
                    if (this.checkpointInstant == 0L && this.privExists(this.getMirrorControlFileName())) {
                        this.checkpointInstant = this.readControlFile(this.getMirrorControlFileName(), startParams);
                    }
                } else if (this.logDevice != null) {
                    throw StandardException.newException("XSLAB.D", logControlFileName.getPath());
                }
                this.logFileNumber = this.checkpointInstant != 0L ? LogCounter.getLogFileNumber(this.checkpointInstant) : 1L;
                logFile = this.getLogFileName(this.logFileNumber);
                if (!this.privExists(logFile)) {
                    if (this.logDevice != null) {
                        throw StandardException.newException("XSLAB.D", logControlFileName.getPath());
                    }
                    this.logErrMsg(MessageService.getTextMessage("L018", logFile.getPath()));
                    createNewLog = true;
                } else if (!this.verifyLogFormat(logFile, this.logFileNumber)) {
                    Monitor.logTextMessage("L008", logFile);
                    if (!this.privDelete(logFile) && this.logFileNumber == 1L) {
                        this.logErrMsgForDurabilityTestModeNoSync();
                        throw StandardException.newException("XSLAC.D", this.dataDirectory);
                    }
                    createNewLog = true;
                }
            }
            if (createNewLog) {
                if (this.writeControlFile(logControlFileName, 0L)) {
                    this.firstLogFileNumber = 1L;
                    this.logFileNumber = 1L;
                    if (SanityManager.DEBUG_ON((String)TEST_MAX_LOGFILE_NUMBER)) {
                        this.firstLogFileNumber = 0x7FFFFFFDL;
                        this.logFileNumber = 0x7FFFFFFDL;
                    }
                    if (this.privExists(logFile = this.getLogFileName(this.logFileNumber))) {
                        Monitor.logTextMessage("L009", logFile);
                        if (!this.privDelete(logFile)) {
                            this.logErrMsgForDurabilityTestModeNoSync();
                            throw StandardException.newException("XSLAC.D", this.dataDirectory);
                        }
                    }
                    this.firstLog = this.privRandomAccessFile(logFile, "rw");
                    if (!this.initLogFile(this.firstLog, this.logFileNumber, 0L)) {
                        throw StandardException.newException("XSLAQ.D", logFile.getPath());
                    }
                    this.endPosition = this.firstLog.getFilePointer();
                    this.lastFlush = this.firstLog.getFilePointer();
                    if (this.isWriteSynced) {
                        this.preAllocateNewLogFile(this.firstLog);
                        this.firstLog.close();
                        this.firstLog = this.openLogFileInWriteMode(logFile);
                        this.firstLog.seek(this.endPosition);
                    }
                    SanityManager.ASSERT((this.endPosition == 24L ? 1 : 0) != 0, (String)"empty log file has wrong size");
                } else {
                    this.ReadOnlyDB = true;
                    this.logOut = null;
                    this.firstLog = null;
                }
                this.recoveryNeeded = false;
            } else {
                this.recoveryNeeded = true;
            }
        }
        catch (IOException ioe) {
            throw Monitor.exceptionStartingModule(ioe);
        }
        if (!this.checkVersion(10, 1)) {
            this.maxLogFileNumber = 0x3FFFFFL;
        }
        this.bootTimeLogFileNumber = this.logFileNumber;
    }

    private void getLogStorageFactory() throws StandardException {
        if (this.logDevice == null) {
            DataFactory df = (DataFactory)Monitor.findServiceModule(this, "com.pivotal.gemfirexd.internal.iapi.store.raw.data.DataFactory");
            this.logStorageFactory = (WritableStorageFactory)df.getStorageFactory();
        } else {
            try {
                PersistentService ps = Monitor.getMonitor().getServiceType(this);
                this.logStorageFactory = (WritableStorageFactory)ps.getStorageFactoryInstance(false, this.logDevice, null, null);
            }
            catch (IOException ioe) {
                SanityManager.NOTREACHED();
                throw StandardException.newException("XSLAB.D", (Throwable)ioe, (Object)this.logDevice);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.checkpointDaemon != null) {
            this.checkpointDaemon.unsubscribe(this.myClientNumber);
            this.checkpointDaemon.stop();
        }
        LogToFile logToFile = this;
        synchronized (logToFile) {
            this.stopped = true;
            if (this.logOut != null) {
                try {
                    this.logOut.flushLogAccessFile();
                    this.logOut.close();
                }
                catch (IOException iOException) {
                }
                catch (StandardException standardException) {
                    // empty catch block
                }
                this.logOut = null;
            }
        }
        if (!(this.corrupt != null || this.logArchived() || this.keepAllLogs || this.ReadOnlyDB)) {
            this.deleteObsoleteLogfiles();
        }
        if (this.logDevice != null) {
            this.logStorageFactory.shutdown();
        }
        this.logStorageFactory = null;
    }

    private void deleteObsoleteLogfiles() {
        StorageFile logDir;
        long logFileNeededForBackup;
        long firstLogNeeded = this.getFirstLogNeeded(this.currentCheckpoint);
        if (firstLogNeeded == -1L) {
            return;
        }
        if (this.backupInProgress && (logFileNeededForBackup = this.logFileToBackup) < firstLogNeeded) {
            firstLogNeeded = logFileNeededForBackup;
        }
        try {
            logDir = this.getLogDirectory();
        }
        catch (StandardException se) {
            if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                SanityManager.DEBUG((String)DBG_FLAG, (String)"error opening log segment dir");
            }
            return;
        }
        String[] logfiles = this.privList(logDir);
        if (logfiles != null) {
            StorageFile uselessLogFile = null;
            for (int i = 0; i < logfiles.length; ++i) {
                long fileNumber;
                if (!logfiles[i].startsWith("log") || !logfiles[i].endsWith(".dat") || (fileNumber = Long.parseLong(logfiles[i].substring(3, logfiles[i].length() - 4))) >= firstLogNeeded) continue;
                uselessLogFile = this.logStorageFactory.newStorageFile(logDir, logfiles[i]);
                if (this.privDelete(uselessLogFile)) {
                    if (!SanityManager.DEBUG_ON((String)DBG_FLAG)) continue;
                    SanityManager.DEBUG((String)DBG_FLAG, (String)("truncating obsolete log file " + uselessLogFile.getPath()));
                    continue;
                }
                if (!SanityManager.DEBUG_ON((String)DBG_FLAG)) continue;
                SanityManager.DEBUG((String)DBG_FLAG, (String)("Fail to truncate obsolete log file " + uselessLogFile.getPath()));
            }
        }
    }

    @Override
    public boolean serviceASAP() {
        return false;
    }

    @Override
    public boolean serviceImmediately() {
        return false;
    }

    @Override
    public void getLogFactoryProperties(PersistentSet set) throws StandardException {
        String cpInterval;
        String lsInterval;
        if (set == null) {
            lsInterval = PropertyUtil.getSystemProperty("gemfirexd.storage.logSwitchInterval");
            cpInterval = PropertyUtil.getSystemProperty("gemfirexd.storage.checkpointInterval");
        } else {
            lsInterval = PropertyUtil.getServiceProperty(set, "gemfirexd.storage.logSwitchInterval");
            cpInterval = PropertyUtil.getServiceProperty(set, "gemfirexd.storage.checkpointInterval");
        }
        if (lsInterval != null) {
            this.logSwitchInterval = Integer.parseInt(lsInterval);
            if (this.logSwitchInterval < 100000) {
                this.logSwitchInterval = 100000;
            } else if (this.logSwitchInterval > 0x8000000) {
                this.logSwitchInterval = 0x8000000;
            }
        }
        if (cpInterval != null) {
            this.checkpointInterval = Integer.parseInt(cpInterval);
            if (this.checkpointInterval < 100000) {
                this.checkpointInterval = 100000;
            } else if (this.checkpointInterval > 0x8000000) {
                this.checkpointInterval = 0x8000000;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performWork(ContextManager context) {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (this.corrupt != null) {
                return 1;
            }
        }
        AccessFactory af = (AccessFactory)Monitor.getServiceModule(this, "com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory");
        try {
            if (af != null) {
                TransactionController tc = null;
                try {
                    tc = af.getAndNameTransaction(context, "SystemTransaction");
                    this.getLogFactoryProperties(tc);
                }
                finally {
                    if (tc != null) {
                        tc.commit();
                    }
                }
            }
            this.rawStoreFactory.checkpoint();
        }
        catch (StandardException se) {
            Monitor.logTextMessage("L011");
            this.logErrMsg(se);
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        this.checkpointDaemonCalled = false;
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long appendLogRecord(byte[] data, int offset, int length, byte[] optionalData, int optionalDataOffset, int optionalDataLength) throws StandardException {
        long instant;
        if (this.inReplicationSlavePreMode) {
            return LogCounter.makeLogInstantAsLong(this.logFileNumber, this.endPosition);
        }
        boolean testIncompleteLogWrite = false;
        if (this.ReadOnlyDB) {
            throw StandardException.newException("XSLAH.D");
        }
        if (length <= 0) {
            throw StandardException.newException("XSLB6.S");
        }
        if (SanityManager.DEBUG_ON((String)TEST_LOG_INCOMPLETE_LOG_WRITE)) {
            return this.logtest_appendPartialLogRecord(data, offset, length, optionalData, optionalDataOffset, optionalDataLength);
        }
        try {
            if (SanityManager.DEBUG_ON((String)TEST_LOG_FULL)) {
                this.testLogFull();
            }
            LogToFile logToFile = this;
            synchronized (logToFile) {
                if (this.corrupt != null) {
                    throw StandardException.newException("XSLAA.D", this.corrupt);
                }
                if (this.logOut == null) {
                    throw StandardException.newException("XSLAJ.D");
                }
                if (this.endPosition + 16L + (long)length >= 0xFFFFFFFL) {
                    this.switchLogFile();
                    if (this.endPosition + 16L + (long)length >= 0xFFFFFFFL) {
                        throw StandardException.newException("XSLAL.D", new Long(this.logFileNumber), (Object)new Long(this.endPosition), (Object)new Long(length), (Object)new Long(0xFFFFFFFL));
                    }
                }
                this.endPosition += this.logOut.reserveSpaceForChecksum(length, this.logFileNumber, this.endPosition);
                instant = LogCounter.makeLogInstantAsLong(this.logFileNumber, this.endPosition);
                this.logOut.writeLogRecord(length, instant, data, offset, optionalData, optionalDataOffset, optionalDataLength);
                if (optionalDataLength != 0) {
                    if (optionalData == null) {
                        SanityManager.THROWASSERT((String)("optionalDataLength = " + optionalDataLength + " with null Optional data"));
                    }
                    if (optionalData.length < optionalDataOffset + optionalDataLength) {
                        SanityManager.THROWASSERT((String)("optionalDataLength = " + optionalDataLength + " optionalDataOffset = " + optionalDataOffset + " optionalData.length = " + optionalData.length));
                    }
                }
                this.endPosition += (long)(length + 16);
            }
        }
        catch (IOException ioe) {
            throw this.markCorrupt(StandardException.newException("XSLA4.D", ioe));
        }
        return instant;
    }

    protected synchronized long currentInstant() {
        return LogCounter.makeLogInstantAsLong(this.logFileNumber, this.endPosition);
    }

    protected synchronized long endPosition() {
        return this.endPosition;
    }

    private synchronized long getLogFileNumber() {
        return this.logFileNumber;
    }

    private synchronized long firstLogInstant() {
        return LogCounter.makeLogInstantAsLong(this.firstLogFileNumber, 24L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(long fileNumber, long wherePosition) throws StandardException {
        LogToFile logToFile;
        long potentialLastFlush = 0L;
        LogToFile logToFile2 = this;
        synchronized (logToFile2) {
            try {
                boolean waited;
                do {
                    if (this.corrupt != null) {
                        throw StandardException.newException("XSLAA.D", this.corrupt);
                    }
                    while (this.isFrozen) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ie) {
                            throw StandardException.interrupt(ie);
                        }
                    }
                    if (wherePosition == 0L || fileNumber < this.logFileNumber || wherePosition < this.lastFlush) {
                        return;
                    }
                    if (this.recoveryNeeded && this.inRedo && !this.inReplicationSlaveMode) {
                        return;
                    }
                    if (fileNumber > this.getLogFileNumber()) {
                        SanityManager.THROWASSERT((String)("trying to flush a file that is not there yet " + fileNumber + " " + this.logFileNumber));
                    }
                    if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                        SanityManager.DEBUG((String)DBG_FLAG, (String)("Flush log to " + wherePosition));
                    }
                    if (this.logBeingFlushed) {
                        waited = true;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ie) {
                            throw StandardException.interrupt(ie);
                        }
                    } else {
                        waited = false;
                        if (!this.isWriteSynced) {
                            this.logOut.flushLogAccessFile();
                        } else {
                            this.logOut.switchLogBuffer();
                        }
                        potentialLastFlush = this.endPosition;
                        this.logBeingFlushed = true;
                        if (!this.inReplicationMasterMode) continue;
                        this.masterFactory.flushedTo(LogCounter.makeLogInstantAsLong(fileNumber, wherePosition));
                    }
                } while (waited);
            }
            catch (IOException ioe) {
                throw this.markCorrupt(StandardException.newException("XSLA0.D", (Throwable)ioe, (Object)this.getLogFileName(this.logFileNumber).getPath()));
            }
        }
        boolean syncSuceed = false;
        try {
            SanityManager.ASSERT((boolean)this.logBeingFlushed, (String)"flushing log without logBeingFlushed set");
            SanityManager.ASSERT((potentialLastFlush > 0L ? 1 : 0) != 0, (String)"potentialLastFlush not set");
            if (SanityManager.DEBUG_ON((String)TEST_LOG_FULL)) {
                this.testLogFull();
            }
            if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                SanityManager.DEBUG((String)DBG_FLAG, (String)"Begin log sync...");
            }
            if (this.isWriteSynced) {
                this.logOut.flushDirtyBuffers();
            } else if (!this.logNotSynced) {
                this.logOut.syncLogAccessFile();
            }
            syncSuceed = true;
            if (SanityManager.DEBUG_ON((String)DBG_FLAG)) {
                SanityManager.DEBUG((String)DBG_FLAG, (String)"end log sync.");
            }
        }
        catch (SyncFailedException sfe) {
            throw this.markCorrupt(StandardException.newException("XSLA0.D", (Throwable)sfe, (Object)this.getLogFileName(this.logFileNumber).getPath()));
        }
        catch (IOException ioe) {
            throw this.markCorrupt(StandardException.newException("XSLA0.D", (Throwable)ioe, (Object)this.getLogFileName(this.logFileNumber).getPath()));
        }
        finally {
            LogToFile logToFile3 = this;
            synchronized (logToFile3) {
                this.logBeingFlushed = false;
                if (syncSuceed) {
                    this.lastFlush = potentialLastFlush;
                }
                this.notifyAll();
            }
        }
        if (this.logWrittenFromLastCheckPoint + potentialLastFlush > (long)this.checkpointInterval && this.checkpointDaemon != null && !this.checkpointDaemonCalled && !this.inLogSwitch) {
            logToFile = this;
            synchronized (logToFile) {
                if (this.logWrittenFromLastCheckPoint + potentialLastFlush > (long)this.checkpointInterval && this.checkpointDaemon != null && !this.checkpointDaemonCalled && !this.inLogSwitch) {
                    this.checkpointDaemonCalled = true;
                    this.checkpointDaemon.serviceNow(this.myClientNumber);
                }
            }
        }
        if (potentialLastFlush > (long)this.logSwitchInterval && !this.checkpointDaemonCalled && !this.inLogSwitch) {
            logToFile = this;
            synchronized (logToFile) {
                if (potentialLastFlush > (long)this.logSwitchInterval && !this.checkpointDaemonCalled && !this.inLogSwitch) {
                    this.inLogSwitch = true;
                    this.switchLogFile();
                }
            }
        }
    }

    private void syncFile(StorageRandomAccessFile raf) throws StandardException {
        int i = 0;
        while (true) {
            try {
                raf.sync(false);
            }
            catch (IOException ioe) {
                ++i;
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (i <= 20) continue;
                throw StandardException.newException("XSLA4.D", ioe);
            }
            break;
        }
    }

    @Override
    public LogScan openForwardsFlushedScan(LogInstant startAt) throws StandardException {
        this.checkCorrupt();
        return new FlushedScan(this, ((LogCounter)startAt).getValueAsLong());
    }

    @Override
    public LogScan openForwardsScan(LogInstant startAt, LogInstant stopAt) throws StandardException {
        try {
            long startLong = startAt == null ? 0L : ((LogCounter)startAt).getValueAsLong();
            return this.openForwardsScan(startLong, stopAt);
        }
        catch (IOException ioe) {
            throw this.markCorrupt(StandardException.newException("XSLA2.D", ioe));
        }
    }

    public final boolean databaseEncrypted() {
        return this.databaseEncrypted;
    }

    @Override
    public void setDatabaseEncrypted(boolean flushLog) throws StandardException {
        if (flushLog) {
            this.flushAll();
        }
        this.databaseEncrypted = true;
    }

    @Override
    public void startNewLogFile() throws StandardException {
        this.switchLogFile();
    }

    @Override
    public boolean isCheckpointInLastLogFile() throws StandardException {
        long logFileNumberAfterCheckpoint = LogCounter.getLogFileNumber(this.checkpointInstant) + 1L;
        StorageFile logFileAfterCheckpoint = this.getLogFileName(logFileNumberAfterCheckpoint);
        return !this.privExists(logFileAfterCheckpoint);
    }

    @Override
    public void deleteLogFileAfterCheckpointLogFile() throws StandardException {
        long logFileNumberAfterCheckpoint = LogCounter.getLogFileNumber(this.checkpointInstant) + 1L;
        StorageFile logFileAfterCheckpoint = this.getLogFileName(logFileNumberAfterCheckpoint);
        if (this.privExists(logFileAfterCheckpoint) && !this.privDelete(logFileAfterCheckpoint)) {
            throw StandardException.newException("XBM0R.D", logFileAfterCheckpoint);
        }
    }

    public int encrypt(byte[] cleartext, int offset, int length, byte[] ciphertext, int outputOffset) throws StandardException {
        return this.rawStoreFactory.encrypt(cleartext, offset, length, ciphertext, outputOffset, false);
    }

    public int decrypt(byte[] ciphertext, int offset, int length, byte[] cleartext, int outputOffset) throws StandardException {
        return this.rawStoreFactory.decrypt(ciphertext, offset, length, cleartext, outputOffset);
    }

    public int getEncryptionBlockSize() {
        return this.rawStoreFactory.getEncryptionBlockSize();
    }

    public int getEncryptedDataLength(int length) {
        if (length % this.getEncryptionBlockSize() != 0) {
            return length + this.getEncryptionBlockSize() - length % this.getEncryptionBlockSize();
        }
        return length;
    }

    @Override
    public synchronized LogInstant getFirstUnflushedInstant() {
        SanityManager.ASSERT((this.logFileNumber > 0L && this.lastFlush > 0L ? 1 : 0) != 0);
        return new LogCounter(this.logFileNumber, this.lastFlush);
    }

    @Override
    public synchronized long getFirstUnflushedInstantAsLong() {
        SanityManager.ASSERT((this.logFileNumber > 0L && this.lastFlush > 0L ? 1 : 0) != 0);
        return LogCounter.makeLogInstantAsLong(this.logFileNumber, this.lastFlush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freezePersistentStore() throws StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            this.isFrozen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unfreezePersistentStore() throws StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            this.isFrozen = false;
            this.notifyAll();
        }
    }

    @Override
    public boolean logArchived() {
        return this.logArchived;
    }

    boolean checkVersion(int requiredMajorVersion, int requiredMinorVersion) {
        if (this.onDiskMajorVersion > requiredMajorVersion) {
            return true;
        }
        return this.onDiskMajorVersion == requiredMajorVersion && this.onDiskMinorVersion >= requiredMinorVersion;
    }

    @Override
    public boolean checkVersion(int requiredMajorVersion, int requiredMinorVersion, String feature) throws StandardException {
        boolean isRequiredVersion = this.checkVersion(requiredMajorVersion, requiredMinorVersion);
        if (!isRequiredVersion && feature != null) {
            throw StandardException.newException("XCL47.S", (Object)feature, (Object)ProductVersionHolder.simpleVersionString((int)this.onDiskMajorVersion, (int)this.onDiskMinorVersion, (boolean)this.onDiskBeta), (Object)ProductVersionHolder.simpleVersionString((int)requiredMajorVersion, (int)requiredMinorVersion, (boolean)false));
        }
        return isRequiredVersion;
    }

    protected void logErrMsg(String msg) {
        this.logErrMsgForDurabilityTestModeNoSync();
        Monitor.logTextMessage("L001");
        Monitor.logMessage(msg);
        Monitor.logTextMessage("L002");
    }

    protected void logErrMsg(Throwable t) {
        this.logErrMsgForDurabilityTestModeNoSync();
        if (this.corrupt != null) {
            Monitor.logTextMessage("L003");
            this.printErrorStack(this.corrupt);
            Monitor.logTextMessage("L004");
        }
        if (t != this.corrupt) {
            Monitor.logTextMessage("L005");
            this.printErrorStack(t);
            Monitor.logTextMessage("L006");
        }
    }

    private void logErrMsgForDurabilityTestModeNoSync() {
        if (this.logNotSynced || wasDBInDurabilityTestModeNoSync) {
            Monitor.logTextMessage("L021", "gemfirexd.system.durability", "test");
        }
    }

    private void printErrorStack(Throwable t) {
        ErrorStringBuilder esb = new ErrorStringBuilder(Monitor.getStream().getHeader());
        esb.stackTrace(t);
        Monitor.logMessage(esb.get().toString());
        esb.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long logtest_appendPartialLogRecord(byte[] data, int offset, int length, byte[] optionalData, int optionalDataOffset, int optionalDataLength) throws StandardException {
        long instant;
        int bytesToWrite = 1;
        String TestPartialLogWrite = PropertyUtil.getSystemProperty(TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES);
        if (TestPartialLogWrite != null) {
            bytesToWrite = Integer.valueOf(TestPartialLogWrite);
        }
        Monitor.logMessage("TEST_LOG_INCOMPLETE_LOG_WRITE: writing " + bytesToWrite + " bytes out of " + length + " + " + 16 + " log record");
        try {
            LogToFile logToFile = this;
            synchronized (logToFile) {
                this.endPosition += this.logOut.reserveSpaceForChecksum(length + 16 < bytesToWrite ? length : bytesToWrite - 16, this.logFileNumber, this.endPosition);
                instant = this.currentInstant();
                this.endPosition = length + 16 < bytesToWrite ? (this.endPosition += (long)(length + 16)) : (this.endPosition += (long)bytesToWrite);
                if (bytesToWrite < 4) {
                    int shift = 3;
                    while (bytesToWrite-- > 0) {
                        this.logOut.write((byte)(length >>> 8 * shift & 0xFF));
                        --shift;
                    }
                } else {
                    this.logOut.writeInt(length);
                    if ((bytesToWrite -= 4) < 8) {
                        int shift = 7;
                        while (bytesToWrite-- > 0) {
                            this.logOut.write((byte)(instant >>> 8 * shift & 0xFFL));
                            --shift;
                        }
                    } else {
                        this.logOut.writeLong(instant);
                        if ((bytesToWrite -= 8) < length) {
                            int dataLength = length - optionalDataLength;
                            if (bytesToWrite < dataLength) {
                                this.logOut.write(data, offset, bytesToWrite);
                            } else {
                                this.logOut.write(data, offset, dataLength);
                                if (optionalDataLength != 0 && (bytesToWrite -= dataLength) > 0) {
                                    this.logOut.write(optionalData, optionalDataOffset, bytesToWrite);
                                }
                            }
                        } else {
                            this.logOut.write(data, offset, length - optionalDataLength);
                            if (optionalDataLength != 0) {
                                this.logOut.write(optionalData, optionalDataOffset, optionalDataLength);
                            }
                            if ((bytesToWrite -= length) < 4) {
                                int shift = 3;
                                while (bytesToWrite-- > 0) {
                                    this.logOut.write((byte)(length >>> 8 * shift & 0xFF));
                                    --shift;
                                }
                            } else {
                                this.logOut.writeInt(length);
                            }
                        }
                    }
                }
                this.flush(this.logFileNumber, this.endPosition);
            }
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSLA4.D", ioe);
        }
        return instant;
    }

    protected void testLogFull() throws IOException {
        if (this.test_numRecordToFillLog < 0) {
            String RecordToFillLog = PropertyUtil.getSystemProperty(TEST_RECORD_TO_FILL_LOG);
            this.test_numRecordToFillLog = RecordToFillLog != null ? Integer.valueOf(RecordToFillLog) : 100;
        }
        if (++this.test_logWritten > this.test_numRecordToFillLog) {
            throw new IOException("TestLogFull " + this.test_numRecordToFillLog + " written " + this.test_logWritten);
        }
    }

    public StorageRandomAccessFile getLogFileToSimulateCorruption(long filenum) throws IOException, StandardException {
        StorageFile fileName = this.getLogFileName(filenum);
        Object log = null;
        return this.privRandomAccessFile(fileName, "rw");
    }

    @Override
    public boolean inReplicationMasterMode() {
        return this.inReplicationMasterMode;
    }

    @Override
    public void enableLogArchiveMode() throws StandardException {
        if (!this.logArchived) {
            this.logArchived = true;
            AccessFactory af = (AccessFactory)Monitor.getServiceModule(this, "com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory");
            if (af != null) {
                TransactionController tc = null;
                tc = af.getTransaction(ContextService.getFactory().getCurrentContextManager());
                tc.setProperty("gemfirexd.storage.logArchiveMode", (Serializable)((Object)"true"), true);
            }
        }
    }

    @Override
    public void disableLogArchiveMode() throws StandardException {
        AccessFactory af = (AccessFactory)Monitor.getServiceModule(this, "com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory");
        if (af != null) {
            TransactionController tc = null;
            tc = af.getTransaction(ContextService.getFactory().getCurrentContextManager());
            tc.setProperty("gemfirexd.storage.logArchiveMode", (Serializable)((Object)"false"), true);
        }
        this.logArchived = false;
    }

    @Override
    public void deleteOnlineArchivedLogFiles() {
        this.deleteObsoleteLogfiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLogBackup(File toDir) throws StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            File toFile;
            while (this.inCheckpoint) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    throw StandardException.interrupt(ie);
                }
            }
            this.backupInProgress = true;
            StorageFile fromFile = this.getControlFileName();
            if (!this.privCopyFile(fromFile, toFile = new File(toDir, fromFile.getName()))) {
                throw StandardException.newException("XSRS5.S", (Object)fromFile, (Object)toFile);
            }
            fromFile = this.getMirrorControlFileName();
            if (!this.privCopyFile(fromFile, toFile = new File(toDir, fromFile.getName()))) {
                throw StandardException.newException("XSRS5.S", (Object)fromFile, (Object)toFile);
            }
            this.logFileToBackup = this.getFirstLogNeeded(this.currentCheckpoint);
        }
        this.backupLogFiles(toDir, this.getLogFileNumber() - 1L);
    }

    private void backupLogFiles(File toDir, long lastLogFileToBackup) throws StandardException {
        while (this.logFileToBackup <= lastLogFileToBackup) {
            File toFile;
            StorageFile fromFile = this.getLogFileName(this.logFileToBackup);
            if (!this.privCopyFile(fromFile, toFile = new File(toDir, fromFile.getName()))) {
                throw StandardException.newException("XSRS5.S", (Object)fromFile, (Object)toFile);
            }
            ++this.logFileToBackup;
        }
    }

    @Override
    public void endLogBackup(File toDir) throws StandardException {
        long lastLogFileToBackup;
        this.flush(this.logFileNumber, this.endPosition);
        if (this.logArchived) {
            this.switchLogFile();
            lastLogFileToBackup = this.getLogFileNumber() - 1L;
        } else {
            lastLogFileToBackup = this.getLogFileNumber();
        }
        this.backupLogFiles(toDir, lastLogFileToBackup);
        this.backupInProgress = false;
    }

    @Override
    public void abortLogBackup() {
        this.backupInProgress = false;
    }

    @Override
    public boolean inRFR() {
        if (this.recoveryNeeded) {
            boolean readOnly = false;
            try {
                readOnly = !this.privCanWrite(this.getControlFileName());
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            readOnly = readOnly || this.dataFactory != null && this.dataFactory.isReadOnly();
            return !readOnly;
        }
        return false;
    }

    @Override
    public void checkpointInRFR(LogInstant cinstant, long redoLWM, long undoLWM, DataFactory df) throws StandardException {
        df.checkpoint();
        try {
            if (!this.writeControlFile(this.getControlFileName(), ((LogCounter)cinstant).getValueAsLong())) {
                throw StandardException.newException("XSLAE.D", this.getControlFileName());
            }
        }
        catch (IOException ioe) {
            throw this.markCorrupt(StandardException.newException("XSLA2.D", ioe));
        }
        df.removeDroppedContainerFileStubs(new LogCounter(redoLWM));
        if (this.inReplicationSlaveMode) {
            this.truncateLog(LogCounter.getLogFileNumber(undoLWM));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReplicationMasterRole(MasterFactory masterFactory) throws StandardException {
        this.masterFactory = masterFactory;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            this.inReplicationMasterMode = true;
            this.logOut.setReplicationMasterRole(masterFactory);
        }
    }

    @Override
    public void stopReplicationMasterRole() {
        this.inReplicationMasterMode = false;
        this.masterFactory = null;
        if (this.logOut != null) {
            this.logOut.stopReplicationMasterRole();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReplicationSlaveRole() throws StandardException {
        if (!this.stopped) {
            this.flushAll();
        }
        this.replicationSlaveException = StandardException.newException("08006.D");
        Object object = this.slaveRecoveryMonitor;
        synchronized (object) {
            this.slaveRecoveryMonitor.notify();
        }
    }

    protected void checkForReplication(LogAccessFile log) {
        if (this.inReplicationMasterMode) {
            log.setReplicationMasterRole(this.masterFactory);
        } else if (this.inReplicationSlaveMode) {
            log.setReplicationSlaveRole();
        }
    }

    public void initializeReplicationSlaveRole() throws StandardException {
        SanityManager.ASSERT((boolean)this.inReplicationSlaveMode, (String)"This method should only be used when in slave replication mode");
        try {
            while (this.getLogFileAtBeginning(this.logFileNumber + 1L) != null) {
                ++this.logFileNumber;
            }
            long startInstant = LogCounter.makeLogInstantAsLong(this.logFileNumber, 24L);
            long logEndInstant = 24L;
            StreamLogScan scanOfHighestLogFile = (StreamLogScan)this.openForwardsScan(startInstant, (LogInstant)null);
            ArrayInputStream scanInputStream = new ArrayInputStream();
            while (scanOfHighestLogFile.getNextRecord(scanInputStream, null, 0) != null) {
                logEndInstant = scanOfHighestLogFile.getLogRecordEnd();
            }
            this.endPosition = LogCounter.getLogFilePosition(logEndInstant);
            StorageRandomAccessFile logFile = null;
            logFile = this.isWriteSynced ? this.openLogFileInWriteMode(this.getLogFileName(this.logFileNumber)) : this.privRandomAccessFile(this.getLogFileName(this.logFileNumber), "rw");
            this.logOut = new LogAccessFile(this, logFile, this.logBufferSize);
            this.lastFlush = this.endPosition;
            logFile.seek(this.endPosition);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XRE03", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failoverSlave() {
        if (!this.stopped) {
            try {
                this.flushAll();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        this.inReplicationSlaveMode = false;
        Object object = this.slaveRecoveryMonitor;
        synchronized (object) {
            this.slaveRecoveryMonitor.notify();
        }
    }

    private boolean restoreLogs(Properties properties) throws StandardException {
        String backupPath = null;
        boolean isCreateFrom = false;
        boolean isRestoreFrom = false;
        backupPath = properties.getProperty("createFrom");
        if (backupPath != null) {
            isCreateFrom = true;
        } else {
            backupPath = properties.getProperty("restoreFrom");
            if (backupPath != null) {
                isRestoreFrom = true;
            } else {
                backupPath = properties.getProperty("rollForwardRecoveryFrom");
            }
        }
        if (backupPath != null) {
            File backupLogDir;
            String[] logfilelist;
            if (!isCreateFrom && this.logDevice == null) {
                this.logDevice = properties.getProperty("gemfirexd.storage.logDeviceWhenBackedUp");
            }
            this.getLogStorageFactory();
            StorageFile logDir = this.logStorageFactory.newStorageFile("log");
            if (isRestoreFrom && this.logDevice != null && !this.privRemoveDirectory(logDir) && !this.privDelete(logDir)) {
                throw StandardException.newException("XSDG7.D", this.getLogDirPath(logDir));
            }
            if (isCreateFrom || isRestoreFrom) {
                this.createLogDirectory();
            }
            if ((logfilelist = this.privList(backupLogDir = new File(backupPath, "log"))) != null) {
                for (int i = 0; i < logfilelist.length; ++i) {
                    File blogFile = new File(backupLogDir, logfilelist[i]);
                    StorageFile clogFile = this.logStorageFactory.newStorageFile(logDir, logfilelist[i]);
                    if (this.privCopyFile(blogFile, clogFile)) continue;
                    throw StandardException.newException("XSLAR.D", (Object)blogFile, (Object)clogFile);
                }
            } else {
                throw StandardException.newException("XSLAS.D", backupLogDir);
            }
            this.logSwitchRequired = true;
            return true;
        }
        return false;
    }

    private void preAllocateNewLogFile(StorageRandomAccessFile log) throws IOException, StandardException {
        int currentPostion = (int)log.getFilePointer();
        SanityManager.ASSERT((currentPostion == 24 ? 1 : 0) != 0, (String)"New Log File Is not Correctly Initialized");
        int amountToWrite = this.logSwitchInterval - 24;
        int bufferSize = this.logBufferSize * 2;
        byte[] emptyBuffer = new byte[bufferSize];
        int nWrites = amountToWrite / bufferSize;
        int remainingBytes = amountToWrite % bufferSize;
        while (nWrites-- > 0) {
            log.write(emptyBuffer);
        }
        if (remainingBytes != 0) {
            log.write(emptyBuffer, 0, remainingBytes);
        }
        this.syncFile(log);
    }

    private StorageRandomAccessFile openLogFileInWriteMode(StorageFile logFile) throws IOException {
        if (!this.jvmSyncErrorChecked && this.checkJvmSyncError(logFile)) {
            this.isWriteSynced = false;
            return this.privRandomAccessFile(logFile, "rw");
        }
        StorageRandomAccessFile log = this.privRandomAccessFile(logFile, "rwd");
        return log;
    }

    private String getLogDirPath(StorageFile logDir) {
        if (this.logDevice == null) {
            return logDir.toString();
        }
        return this.logDevice + this.logStorageFactory.getSeparator() + logDir.toString();
    }

    private boolean checkJvmSyncError(StorageFile logFile) throws IOException {
        boolean hasJvmSyncError = false;
        StorageRandomAccessFile rwsTest = this.privRandomAccessFile(logFile, "rw");
        rwsTest.close();
        try {
            rwsTest = this.privRandomAccessFile(logFile, "rws");
            rwsTest.close();
        }
        catch (FileNotFoundException ex) {
            this.logErrMsg("LogToFile.checkJvmSyncError: Your JVM seems to have a problem with implicit syncing of log files. Will use explicit syncing instead.");
            hasJvmSyncError = true;
        }
        this.jvmSyncErrorChecked = true;
        return hasJvmSyncError;
    }

    protected boolean privExists(StorageFile file) {
        return this.runBooleanAction(0, file);
    }

    protected boolean privDelete(StorageFile file) {
        return this.runBooleanAction(1, file);
    }

    private synchronized StorageRandomAccessFile privRandomAccessFile(StorageFile file, String perms) throws IOException {
        this.action = 2;
        this.activeFile = file;
        this.activePerms = perms;
        try {
            return (StorageRandomAccessFile)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    protected boolean privCanWrite(StorageFile file) {
        return this.runBooleanAction(3, file);
    }

    protected boolean privMkdirs(StorageFile file) {
        return this.runBooleanAction(4, file);
    }

    private synchronized String[] privList(File file) {
        this.action = 8;
        this.toFile = file;
        try {
            return (String[])AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            return null;
        }
    }

    private synchronized String[] privList(StorageFile file) {
        this.action = 5;
        this.activeFile = file;
        try {
            return (String[])AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            return null;
        }
    }

    private synchronized boolean privCopyFile(StorageFile from, File to) {
        this.action = 6;
        this.activeFile = from;
        this.toFile = to;
        try {
            return (Boolean)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            return false;
        }
    }

    private synchronized boolean privCopyFile(File from, StorageFile to) {
        this.action = 9;
        this.activeFile = to;
        this.toFile = from;
        try {
            return (Boolean)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            return false;
        }
    }

    private boolean privRemoveDirectory(StorageFile file) {
        return this.runBooleanAction(7, file);
    }

    private synchronized boolean runBooleanAction(int action, StorageFile file) {
        this.action = action;
        this.activeFile = file;
        try {
            return (Boolean)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            return false;
        }
    }

    public final Object run() throws IOException {
        switch (this.action) {
            case 0: {
                return ReuseFactory.getBoolean(this.activeFile.exists());
            }
            case 1: {
                return ReuseFactory.getBoolean(this.activeFile.delete());
            }
            case 2: {
                return this.activeFile.getRandomAccessFile(this.activePerms);
            }
            case 3: {
                return ReuseFactory.getBoolean(this.activeFile.canWrite());
            }
            case 4: {
                return ReuseFactory.getBoolean(this.activeFile.mkdirs());
            }
            case 5: {
                return this.activeFile.list();
            }
            case 6: {
                return ReuseFactory.getBoolean(FileUtil.copyFile((StorageFactory)this.logStorageFactory, this.activeFile, this.toFile));
            }
            case 7: {
                if (!this.activeFile.exists()) {
                    return ReuseFactory.getBoolean(true);
                }
                return ReuseFactory.getBoolean(this.activeFile.deleteAll());
            }
            case 8: {
                return this.toFile.list();
            }
            case 9: {
                return ReuseFactory.getBoolean(FileUtil.copyFile(this.logStorageFactory, this.toFile, this.activeFile));
            }
        }
        return null;
    }
}

