/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.CompressedNumber;
import com.pivotal.gemfirexd.internal.iapi.services.io.DynamicByteArrayOutputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.LogicalUndo;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BasePage;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.LogicalPageOperation;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public final class UpdateFieldOperation
extends LogicalPageOperation {
    protected int doMeSlot;
    protected int fieldId;
    protected transient ByteArray preparedLog;

    public UpdateFieldOperation(RawTransaction t, BasePage page, int slot, int recordId, int fieldId, Object column, LogicalUndo undo) throws StandardException {
        super(page, undo, recordId);
        this.doMeSlot = slot;
        this.fieldId = fieldId;
        try {
            this.writeOptionalDataToBuffer(t, column);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDA4.S", ioe);
        }
    }

    public UpdateFieldOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        CompressedNumber.writeInt(out, this.doMeSlot);
        CompressedNumber.writeInt(out, this.fieldId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.doMeSlot = CompressedNumber.readInt(in);
        this.fieldId = CompressedNumber.readInt(in);
    }

    @Override
    public int getTypeFormatId() {
        return 109;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        this.page.storeField(instant, this.doMeSlot, this.fieldId, in);
    }

    @Override
    public void undoMe(Transaction xact, BasePage undoPage, int undoRecordId, LogInstant CLRInstant, LimitObjectInput in) throws StandardException, IOException {
        int slot = undoPage.findRecordById(undoRecordId, 0);
        if (undoRecordId != this.recordId && undoPage.getPageNumber() == this.getPageId().getPageNumber()) {
            SanityManager.THROWASSERT((String)("recordId changed from " + this.recordId + " to " + undoRecordId + " but page number did not change " + undoPage.getPageNumber()));
        }
        if (slot == -1) {
            SanityManager.THROWASSERT((String)("recordId " + undoRecordId + " not found on page " + undoPage.getPageNumber()));
        }
        undoPage.skipField(in);
        undoPage.storeField(CLRInstant, slot, this.fieldId, in);
        undoPage.setAuxObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreLoggedRow(Object[] row, LimitObjectInput in) throws StandardException, IOException {
        BasePage p = null;
        try {
            p = (BasePage)this.getContainer().getPage(this.getPageId().getPageNumber());
            p.skipField(in);
            p.skipField(in);
            p.restoreRecordFromStream(in, row);
        }
        finally {
            if (p != null) {
                p.unlatch();
                p = null;
            }
        }
    }

    @Override
    public void restoreMe(Transaction xact, BasePage undoPage, LogInstant CLRInstant, LimitObjectInput in) throws StandardException, IOException {
        int slot = undoPage.findRecordById(this.recordId, 0);
        if (!this.getPageId().equals(undoPage.getPageId())) {
            SanityManager.THROWASSERT((String)("restoreMe cannot restore to a different page. doMe page:" + this.getPageId() + " undoPage:" + undoPage.getPageId()));
        }
        if (slot != this.doMeSlot) {
            SanityManager.THROWASSERT((String)("restoreMe cannot restore to a different slot. doMe slot:" + this.doMeSlot + " undoMe slot: " + slot + " recordId:" + this.recordId));
        }
        undoPage.skipField(in);
        undoPage.storeField(CLRInstant, slot, this.fieldId, in);
        undoPage.setAuxObject(null);
    }

    @Override
    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    private void writeOptionalDataToBuffer(RawTransaction t, Object column) throws StandardException, IOException {
        int optionalDataLength;
        SanityManager.ASSERT((this.page != null ? 1 : 0) != 0);
        DynamicByteArrayOutputStream logBuffer = t.getLogBuffer();
        int optionalDataStart = logBuffer.getPosition();
        SanityManager.ASSERT((optionalDataStart == 0 ? 1 : 0) != 0, (String)"Buffer for writing optional data should start at position 0");
        this.page.logColumn(this.doMeSlot, this.fieldId, column, logBuffer, 100);
        this.page.logField(this.doMeSlot, this.fieldId, (OutputStream)((Object)logBuffer));
        if (this.undo != null) {
            this.page.logRecord(this.doMeSlot, 0, this.recordId, null, (OutputStream)((Object)logBuffer), null);
        }
        if ((optionalDataLength = logBuffer.getPosition() - optionalDataStart) != logBuffer.getUsed()) {
            SanityManager.THROWASSERT((String)("wrong optional data length, optionalDataLength = " + optionalDataLength + ", logBuffer.getUsed() = " + logBuffer.getUsed()));
        }
        logBuffer.setPosition(optionalDataStart);
        this.preparedLog = new ByteArray(logBuffer.getByteArray(), optionalDataStart, optionalDataLength);
    }

    @Override
    public String toString() {
        return super.toString() + "UpdateField : " + " Slot=" + this.doMeSlot + " recordId=" + this.recordId + " fieldId=" + this.fieldId;
    }
}

