/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.heap;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanInfo;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.Heap;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.HeapScan;
import java.util.Properties;

class HeapScanInfo
implements ScanInfo {
    private int stat_numpages_visited = 0;
    private int stat_numrows_visited = 0;
    private int stat_numrows_qualified = 0;
    private int stat_numColumnsFetched = 0;
    private FormatableBitSet stat_validColumns = null;

    HeapScanInfo(HeapScan scan) {
        this.stat_numpages_visited = scan.getNumPagesVisited();
        this.stat_numrows_visited = scan.getNumRowsVisited();
        this.stat_numrows_qualified = scan.getNumRowsQualified();
        FormatableBitSet formatableBitSet = this.stat_validColumns = scan.getScanColumnList() == null ? null : scan.getScanColumnList().clone();
        if (this.stat_validColumns == null) {
            this.stat_numColumnsFetched = ((Heap)scan.getOpenConglom().getConglomerate()).format_ids.length;
        } else {
            for (int i = 0; i < this.stat_validColumns.getLength(); ++i) {
                if (!this.stat_validColumns.get(i)) continue;
                ++this.stat_numColumnsFetched;
            }
        }
    }

    @Override
    public Properties getAllScanInfo(Properties prop) throws StandardException {
        if (prop == null) {
            prop = new Properties();
        }
        prop.put(MessageService.getTextMessage("XSAJ0.U"), MessageService.getTextMessage("XSAJG.U"));
        prop.put(MessageService.getTextMessage("XSAJ1.U"), Integer.toString(this.stat_numpages_visited));
        prop.put(MessageService.getTextMessage("XSAJ2.U"), Integer.toString(this.stat_numrows_visited));
        prop.put(MessageService.getTextMessage("XSAJ4.U"), Integer.toString(this.stat_numrows_qualified));
        prop.put(MessageService.getTextMessage("XSAJ5.U"), Integer.toString(this.stat_numColumnsFetched));
        prop.put(MessageService.getTextMessage("XSAJ6.U"), this.stat_validColumns == null ? MessageService.getTextMessage("XSAJE.U") : this.stat_validColumns.toString());
        return prop;
    }
}

