/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.btree.index;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.DynamicCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTreeController;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTreeLockingPolicy;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.index.B2I;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.index.B2IRowLocking3;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.index.B2IStaticCompiledInfo;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.index.B2ITableLocking3;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.index.B2IUndo;

public class B2IController
extends BTreeController {
    private ConglomerateController base_cc_for_locking;

    B2IController() {
    }

    void init(TransactionManager xact_manager, Transaction rawtran, boolean hold, int open_mode, int lock_level, LockingPolicy locking_policy, boolean get_locks, B2I conglomerate, B2IUndo undo, B2IStaticCompiledInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        BTreeLockingPolicy b2i_locking_policy;
        int base_open_mode = open_mode | 0x40;
        this.base_cc_for_locking = static_info != null ? xact_manager.openCompiledConglomerate(false, base_open_mode, lock_level, 4, static_info.base_table_static_info, ((Conglomerate)static_info.getConglom()).getDynamicCompiledConglomInfo()) : xact_manager.openConglomerate(conglomerate.baseConglomerateId, false, base_open_mode, lock_level, 4);
        if (lock_level == 7) {
            b2i_locking_policy = new B2ITableLocking3(rawtran, lock_level, locking_policy, this.base_cc_for_locking, this);
        } else if (lock_level == 6) {
            b2i_locking_policy = new B2IRowLocking3(rawtran, lock_level, locking_policy, this.base_cc_for_locking, this);
        } else {
            SanityManager.THROWASSERT((String)("Bad lock level: " + lock_level));
            b2i_locking_policy = null;
        }
        super.init(xact_manager, hold, (ContainerHandle)null, rawtran, open_mode, lock_level, b2i_locking_policy, conglomerate, undo, static_info, dynamic_info);
        SanityManager.ASSERT((conglomerate != null ? 1 : 0) != 0);
    }

    @Override
    public void close() throws StandardException {
        super.close();
        if (this.base_cc_for_locking != null) {
            this.base_cc_for_locking.close();
            this.base_cc_for_locking = null;
        }
    }

    @Override
    public int insert(DataValueDescriptor[] row) throws StandardException {
        if (this.container != null) {
            SanityManager.ASSERT((boolean)(this.getConglomerate() instanceof B2I));
            RowLocation rowloc = (RowLocation)row[((B2I)this.getConglomerate()).rowLocationColumn];
            SanityManager.ASSERT((!rowloc.isNull() ? 1 : 0) != 0, (String)"RowLocation value is null");
        }
        return super.insert(row);
    }
}

