/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BasicNoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

class UnionResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public int rowsSeenLeft;
    public int rowsSeenRight;
    public int rowsReturned;
    private int whichSource = 1;
    private int source1FinalRowCount = -1;
    public NoPutResultSet source1;
    public NoPutResultSet source2;
    public ValueRow candidateRow;
    private boolean ignoreSourceOneIfReplicate = false;
    private boolean ignoreSourceTwoIfReplicate = false;

    public UnionResultSet(NoPutResultSet source1, NoPutResultSet source2, Activation activation, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source1 = source1;
        this.source2 = source2;
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    @Override
    public void openCore() throws StandardException {
        FunctionContext fc;
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"UnionResultSet already open");
        this.isOpen = true;
        this.source1.openCore();
        ++this.numOpens;
        if (this.lcc.isConnectionForRemote() && (fc = this.activation.getFunctionContext()) != null && !((RegionExecutorMessage)fc).allTablesAreReplicatedOnRemote()) {
            if (!(fc instanceof RegionExecutorMessage)) {
                SanityManager.THROWASSERT((String)("Given FunctionContext is expected to be of type RegionExecutorMessage, got " + fc));
            }
            if (((RegionExecutorMessage)fc).doIgnoreReplicatesIfSetOperatorsOnRemote()) {
                SanityManager.ASSERT((boolean)(this.source1 instanceof BasicNoPutResultSetImpl), (String)"Member 'source1' is expected to be of type BasicNoPutResultSetImpl");
                this.ignoreSourceOneIfReplicate = ((BasicNoPutResultSetImpl)this.source1).isReplicateIfSetOpSupported();
                SanityManager.ASSERT((boolean)(this.source2 instanceof BasicNoPutResultSetImpl), (String)"Member 'source2' is expected to be of type BasicNoPutResultSetImpl");
                this.ignoreSourceTwoIfReplicate = ((BasicNoPutResultSetImpl)this.source2).isReplicateIfSetOpSupported();
            }
        }
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        ExecRow result = null;
        boolean isOffHeapEnabled = GemFireXDUtils.isOffHeapEnabled();
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            switch (this.whichSource) {
                case 1: {
                    if (!this.ignoreSourceOneIfReplicate) {
                        if (isOffHeapEnabled) {
                            this.source1.releasePreviousByteSource();
                        }
                        result = this.source1.getNextRowCore();
                    }
                    if (result == (ExecRow)null) {
                        this.source1.close(false);
                        this.whichSource = 2;
                        this.source2.openCore();
                        if (!this.ignoreSourceTwoIfReplicate) {
                            if (isOffHeapEnabled) {
                                this.source2.releasePreviousByteSource();
                            }
                            result = this.source2.getNextRowCore();
                        }
                        if (result == null) break;
                        ++this.rowsSeenRight;
                        break;
                    }
                    ++this.rowsSeenLeft;
                    break;
                }
                case 2: {
                    if (isOffHeapEnabled) {
                        this.source2.releasePreviousByteSource();
                    }
                    if ((result = this.source2.getNextRowCore()) == null) break;
                    ++this.rowsSeenRight;
                    break;
                }
                default: {
                    SanityManager.THROWASSERT((String)"Bad source number in union");
                }
            }
        }
        this.setCurrentRow(result);
        if (result != null) {
            ++this.rowsReturned;
            if (this.candidateRow == null) {
                this.candidateRow = new ValueRow(result.nColumns());
            }
            this.candidateRow.setRowArray(result);
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return result != null ? this.candidateRow : null;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.clearCurrentRow();
            switch (this.whichSource) {
                case 1: {
                    this.source1.close(cleanupOnError);
                    break;
                }
                case 2: {
                    this.source2.close(cleanupOnError);
                    this.source1FinalRowCount = -1;
                    this.whichSource = 1;
                    break;
                }
                default: {
                    SanityManager.THROWASSERT((String)"Bad source number in union");
                }
            }
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of UnionResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void finish() throws StandardException {
        this.source1.finish();
        this.source2.finish();
        this.finishAndRTS();
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.source1.getTimeSpent(1, timeType) - this.source2.getTimeSpent(1, timeType);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        switch (this.whichSource) {
            case 1: {
                SanityManager.ASSERT((boolean)(this.source1 instanceof CursorResultSet), (String)"source not CursorResultSet");
                return ((CursorResultSet)((Object)this.source1)).getRowLocation();
            }
            case 2: {
                SanityManager.ASSERT((boolean)(this.source2 instanceof CursorResultSet), (String)"source2 not CursorResultSet");
                return ((CursorResultSet)((Object)this.source2)).getRowLocation();
            }
        }
        SanityManager.THROWASSERT((String)"Bad source number in union");
        return null;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        ExecRow result = null;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"TSRS expected to be open");
        if (this.whichSource != 1 && this.whichSource != 2) {
            SanityManager.THROWASSERT((String)("whichSource expected to be 1 or 2, not " + this.whichSource));
        }
        switch (this.whichSource) {
            case 1: {
                result = ((CursorResultSet)((Object)this.source1)).getCurrentRow();
                break;
            }
            case 2: {
                result = ((CursorResultSet)((Object)this.source2)).getCurrentRow();
            }
        }
        this.setCurrentRow(result);
        if (result != null) {
            if (this.candidateRow == null) {
                this.candidateRow = new ValueRow(result.nColumns());
            }
            this.candidateRow.setRowArray(result);
            return this.candidateRow;
        }
        return null;
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        switch (this.whichSource) {
            case 1: {
                this.source1.updateRowLocationPostRead();
                break;
            }
            case 2: {
                this.source2.updateRowLocationPostRead();
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Bad source number " + this.whichSource + " in union"));
            }
        }
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        switch (this.whichSource) {
            case 1: {
                this.source1.filteredRowLocationPostRead(localTXState);
                break;
            }
            case 2: {
                this.source2.filteredRowLocationPostRead(localTXState);
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Bad source number " + this.whichSource + " in union"));
            }
        }
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        int numChildren = 0;
        if (this.source1 != null) {
            ++numChildren;
        }
        if (this.source2 != null) {
            ++numChildren;
        }
        visitor.setNumberOfChildren(numChildren);
        visitor.visit(this);
        if (this.source1 != null) {
            this.source1.accept(visitor);
        }
        if (this.source2 != null) {
            this.source2.accept(visitor);
        }
    }

    @Override
    public void resetStatistics() {
        this.rowsSeenLeft = 0;
        this.rowsSeenRight = 0;
        this.rowsReturned = 0;
        super.resetStatistics();
        this.source1.resetStatistics();
        this.source2.resetStatistics();
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "UNION");
        if (this.source1 != null) {
            this.source1.buildQueryPlan(builder, context.pushContext());
        }
        if (this.source2 != null) {
            PlanUtils.xmlAddTag(builder, context, "union");
            this.source2.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with left-source = " + (this.source1 != null ? this.source1.getClass().getSimpleName() : null) + " and left-source ResultSetNumber = " + (this.source1 != null && this.source1 instanceof NoPutResultSetImpl ? ((NoPutResultSetImpl)this.source1).resultSetNumber() : -1) + " with right-source = " + (this.source2 != null ? this.source2.getClass().getSimpleName() : null) + " and right-source ResultSetNumber = " + (this.source2 != null && this.source2 instanceof NoPutResultSetImpl ? ((NoPutResultSetImpl)this.source2).resultSetNumber() : -1)));
        }
    }
}

