/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.ObjectEqualsHashingStrategy;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gnu.trove.THashSet;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeap;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndex;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TemporaryRowHolder;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TableScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderResultSet;

final class MultiColumnTableScanResultSet
extends ScanResultSet
implements CursorResultSet,
Cloneable {
    protected final GeneratedMethod resultRowAllocator;
    protected final TableScanResultSet[] resultSets;
    protected int scanIndex;
    protected final THashSet rowLocations;
    protected final GemFireContainer container;
    protected final boolean addRegionAndKey;
    protected final boolean addKeyForSelectForUpdate;
    protected RowLocation currentRL;

    MultiColumnTableScanResultSet(TableScanResultSet[] resultSets, StaticCompiledOpenConglomInfo scoci, Activation activation, GeneratedMethod resultRowAllocator, int resultSetNumber, int colRefItem, int lockMode, boolean tableLocked, int isolationLevel, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(activation, resultSetNumber, resultRowAllocator, lockMode, tableLocked, isolationLevel, colRefItem, optimizerEstimatedRowCount, optimizerEstimatedCost);
        DataValueDescriptor conglom = scoci.getConglom();
        this.container = conglom instanceof MemHeap ? ((MemHeap)conglom).getGemFireContainer() : ((MemIndex)conglom).getBaseContainer();
        this.resultRowAllocator = resultRowAllocator;
        this.addRegionAndKey = this.activation.isSpecialCaseOuterJoin();
        this.addKeyForSelectForUpdate = this.activation.getFunctionContext() != null ? this.activation.needKeysForSelectForUpdate() : false;
        this.resultSets = resultSets;
        this.rowLocations = new THashSet((TObjectHashingStrategy)ObjectEqualsHashingStrategy.getInstance());
    }

    @Override
    public void openCore() throws StandardException {
        this.scanIndex = 0;
        this.isOpen = true;
        this.compactRow = this.accessedCols != null && this.accessedCols.getLength() != this.accessedCols.getNumBitsSet() ? this.getCompactRow(this.candidate, this.accessedCols, false, false, null, null, true) : null;
        this.resultSets[0].openCore();
    }

    @Override
    public void reopenCore() throws StandardException {
        this.scanIndex = 0;
        this.resultSets[0].reopenCore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.scanIndex >= 0) {
            TableScanResultSet scan = this.resultSets[this.scanIndex];
            while (true) {
                if (scan.getNextRowCore() != null) {
                    RowLocation rl = scan.getRowLocation();
                    if (rl == null || !this.rowLocations.add((Object)rl)) continue;
                    this.currentRow = rl.getRowWithoutFaultIn(this.container);
                    if (this.currentRow == null) continue;
                    Object byteSource = this.currentRow.getByteSource();
                    try {
                        if (this.compactRow != null) {
                            int i = 1;
                            int pos = this.accessedCols.anySetBit();
                            while (pos != -1) {
                                this.compactRow.setColumn(i, this.currentRow.getColumn(pos + 1));
                                ++i;
                                pos = this.accessedCols.anySetBit(pos);
                            }
                            this.currentRL = rl;
                            ExecRow execRow = this.currentRow = this.compactRow;
                            return execRow;
                        }
                        this.currentRL = rl;
                        ExecRow execRow = this.currentRow;
                        return execRow;
                    }
                    finally {
                        if (this.container.isOffHeap()) {
                            if (byteSource instanceof OffHeapByteSource) {
                                scan.addByteSource((OffHeapByteSource)((Object)byteSource));
                            } else {
                                scan.addByteSource(null);
                            }
                        }
                    }
                }
                ++this.scanIndex;
                if (this.scanIndex >= this.resultSets.length) break;
                scan = this.resultSets[this.scanIndex];
                if (scan.isOpen) {
                    scan.reopenCore();
                    continue;
                }
                scan.openCore();
            }
            this.scanIndex = -1;
            this.currentRL = null;
            this.currentRow = null;
            return null;
        }
        this.currentRL = null;
        this.currentRow = null;
        return null;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        for (TableScanResultSet scan : this.resultSets) {
            scan.close(cleanupOnError);
        }
        this.scanIndex = -1;
        this.currentRow = null;
        this.currentRL = null;
        this.rowLocations.clear();
        super.close(cleanupOnError);
        this.isOpen = false;
    }

    @Override
    boolean canGetInstantaneousLocks() {
        return false;
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        if (this.scanIndex >= 0) {
            this.resultSets[this.scanIndex].updateRowLocationPostRead();
        }
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        if (this.scanIndex >= 0) {
            TableScanResultSet rs = this.resultSets[this.scanIndex];
            rs.filteredRowLocationPostRead(localTXState);
            rs.releaseByteSource(0);
        }
    }

    @Override
    public void releasePreviousByteSource() {
        if (this.scanIndex >= 0) {
            this.resultSets[this.scanIndex].releasePreviousByteSource();
        }
    }

    @Override
    public long getTimeSpent(int type, int timeType) {
        long totalTime = 0L;
        for (TableScanResultSet scan : this.resultSets) {
            totalTime += scan.getTimeSpent(type, timeType);
        }
        return totalTime;
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        for (TableScanResultSet scan : this.resultSets) {
            scan.accept(visitor);
        }
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return this.currentRL;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    protected final TemporaryRowHolder getFutureForUpdateRows() {
        return this.resultSets[this.scanIndex].getFutureForUpdateRows();
    }

    @Override
    protected final TemporaryRowHolderResultSet getFutureRowResultSet() {
        return this.resultSets[this.scanIndex].getFutureRowResultSet();
    }

    @Override
    protected final void setFutureRowResultSet(TemporaryRowHolderResultSet futureRowResultSet) {
        this.resultSets[this.scanIndex].setFutureRowResultSet(futureRowResultSet);
    }

    @Override
    protected final boolean sourceDrained() {
        return this.resultSets[this.scanIndex].sourceDrained();
    }

    @Override
    public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, GemFireContainer container) throws StandardException {
        return this.resultSets[this.scanIndex].fetch(loc, destRow, validColumns, faultIn, container);
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "MULTITABLESCAN");
        for (TableScanResultSet scan : this.resultSets) {
            scan.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }
}

