/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.Storable;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecAggregator;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.UserDataValue;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AggregatorInfo;

public class GenericAggregator {
    protected final AggregatorInfo aggInfo;
    protected int aggregatorColumnId;
    protected int inputColumnId;
    protected int resultColumnId;
    protected final ClassFactory cf;
    protected ExecAggregator cachedAggregator;

    public GenericAggregator(AggregatorInfo aggInfo, ClassFactory cf) {
        this.aggInfo = aggInfo;
        this.aggregatorColumnId = aggInfo.getAggregatorColNum();
        this.inputColumnId = aggInfo.getInputColNum();
        this.resultColumnId = aggInfo.getOutputColNum();
        this.cf = cf;
    }

    public void initialize(ExecRow row) throws StandardException {
        SanityManager.ASSERT((row != null ? 1 : 0) != 0, (String)"row is null");
        UserDataValue aggregatorColumn = (UserDataValue)row.getColumn(this.aggregatorColumnId + 1);
        ExecAggregator ua = (ExecAggregator)aggregatorColumn.getObject();
        if (ua == null) {
            ua = this.getAggregatorInstance();
            aggregatorColumn.setValue(ua);
        }
    }

    public void accumulate(ExecRow inputRow, ExecRow accumulateRow) throws StandardException {
        DataValueDescriptor inputColumn = null;
        SanityManager.ASSERT((inputRow != null && accumulateRow != null ? 1 : 0) != 0, (String)"bad accumulate call");
        DataValueDescriptor aggregatorColumn = accumulateRow.getColumn(this.aggregatorColumnId + 1);
        inputColumn = inputRow.getColumn(this.inputColumnId + 1);
        if (this.aggInfo.isAccumulateDistinctValues()) {
            DataValueDescriptor aggregateResult = accumulateRow.getColumn(this.resultColumnId + 1);
            GenericAggregator.addEntryToDVDSet(inputColumn, aggregateResult);
            return;
        }
        this.accumulate(inputColumn, aggregatorColumn);
    }

    void accumulate(Object[] inputRow, Object[] accumulateRow) throws StandardException {
        DataValueDescriptor inputColumn = null;
        SanityManager.ASSERT((inputRow != null && accumulateRow != null ? 1 : 0) != 0, (String)"bad accumulate call");
        DataValueDescriptor aggregatorColumn = (DataValueDescriptor)accumulateRow[this.aggregatorColumnId];
        inputColumn = (DataValueDescriptor)inputRow[this.inputColumnId];
        if (this.aggInfo.isAccumulateDistinctValues()) {
            DataValueDescriptor aggregateResult = (DataValueDescriptor)accumulateRow[this.resultColumnId];
            GenericAggregator.addEntryToDVDSet(inputColumn, aggregateResult);
            return;
        }
        this.accumulate(inputColumn, aggregatorColumn);
    }

    protected void accumulate(DataValueDescriptor inputColumn, DataValueDescriptor aggregatorColumn) throws StandardException {
        ExecAggregator ua;
        if (!(aggregatorColumn instanceof UserDataValue)) {
            SanityManager.THROWASSERT((String)("accumlator column is not a UserDataValue as expected, it is a " + aggregatorColumn.getClass().getName()));
        }
        if ((ua = (ExecAggregator)aggregatorColumn.getObject()) == null) {
            ua = this.getAggregatorInstance();
        }
        ua.accumulate(inputColumn);
    }

    public void merge(ExecRow inputRow, ExecRow mergeRow) throws StandardException {
        if (this.aggInfo.isAccumulateDistinctValues()) {
            DataValueDescriptor mergeResult = mergeRow.getColumn(this.resultColumnId + 1);
            DataValueDescriptor inputResult = inputRow.getColumn(this.resultColumnId + 1);
            ((DVDSet)mergeResult).merge((DVDSet)inputResult);
            return;
        }
        DataValueDescriptor mergeColumn = mergeRow.getColumn(this.aggregatorColumnId + 1);
        DataValueDescriptor inputColumn = inputRow.getColumn(this.aggregatorColumnId + 1);
        this.merge(inputColumn, mergeColumn);
    }

    void merge(Object[] inputRow, Object[] mergeRow) throws StandardException {
        if (this.aggInfo.isAccumulateDistinctValues()) {
            DataValueDescriptor mergeResult = (DataValueDescriptor)mergeRow[this.resultColumnId];
            DataValueDescriptor inputResult = (DataValueDescriptor)inputRow[this.resultColumnId];
            ((DVDSet)mergeResult).merge((DVDSet)inputResult);
            return;
        }
        DataValueDescriptor mergeColumn = (DataValueDescriptor)mergeRow[this.aggregatorColumnId];
        DataValueDescriptor inputColumn = (DataValueDescriptor)inputRow[this.aggregatorColumnId];
        this.merge(inputColumn, mergeColumn);
    }

    boolean finish(ExecRow row) throws StandardException {
        return this.finish(row, this.resultColumnId + 1);
    }

    protected boolean finish(ExecRow row, int resultColumn) throws StandardException {
        if (this.aggInfo.isAccumulateDistinctValues()) {
            DataValueDescriptor outputColumn = row.getColumn(resultColumn);
            if (outputColumn.getClass() != DVDSet.class) {
                SanityManager.THROWASSERT((String)("aggregate Result must be of type " + DVDSet.class.getSimpleName() + ", but was " + outputColumn.getClass().getName()));
            }
            return false;
        }
        DataValueDescriptor aggregatorColumn = row.getColumn(this.aggregatorColumnId + 1);
        SanityManager.ASSERT((aggregatorColumn != null ? 1 : 0) != 0, (String)"aggregatorColumn is null");
        SanityManager.ASSERT((boolean)(aggregatorColumn instanceof UserDataValue), (String)"accumlator column is not a UserDataValue as expected");
        ExecAggregator ua = (ExecAggregator)aggregatorColumn.getObject();
        if (ua == null) {
            ua = this.getAggregatorInstance();
        }
        ua.setResult(row, resultColumn);
        return ua.didEliminateNulls();
    }

    protected ExecAggregator getAggregatorInstance() throws StandardException {
        ExecAggregator aggregatorInstance;
        if (this.cachedAggregator == null) {
            try {
                Class aggregatorClass = this.cf.loadApplicationClass(this.aggInfo.getAggregatorClassName());
                Object agg = aggregatorClass.newInstance();
                this.cachedAggregator = aggregatorInstance = (ExecAggregator)agg;
                aggregatorInstance.setup(this.aggInfo.getAggregateName(), (AggregatorInfo)null);
            }
            catch (Exception e) {
                throw StandardException.unexpectedUserException(e);
            }
        } else {
            aggregatorInstance = this.cachedAggregator.newAggregator();
        }
        return aggregatorInstance;
    }

    int getColumnId() {
        return this.aggregatorColumnId;
    }

    protected void merge(Storable aggregatorColumnIn, Storable aggregatorColumnOut) throws StandardException {
        if (!(aggregatorColumnIn instanceof UserDataValue)) {
            SanityManager.THROWASSERT((String)("aggregatorColumnOut column is not a UserAggreator as expected, it is a " + aggregatorColumnIn.getClass().getName()));
        }
        if (!(aggregatorColumnOut instanceof UserDataValue)) {
            SanityManager.THROWASSERT((String)("aggregatorColumnIn column is not a UserAggreator as expected, it is a " + aggregatorColumnOut.getClass().getName()));
        }
        ExecAggregator uaIn = (ExecAggregator)((UserDataValue)aggregatorColumnIn).getObject();
        ExecAggregator uaOut = (ExecAggregator)((UserDataValue)aggregatorColumnOut).getObject();
        uaOut.merge(uaIn);
    }

    AggregatorInfo getAggregatorInfo() {
        return this.aggInfo;
    }

    static void addEntryToDVDSet(DataValueDescriptor inputColumn, DataValueDescriptor aggregateResult) {
        if (aggregateResult.getClass() != DVDSet.class) {
            SanityManager.THROWASSERT((String)("aggregate Result must be of type " + DVDSet.class.getSimpleName() + ", but was " + aggregateResult.getClass().getName()));
        }
        ((DVDSet)aggregateResult).addValue(inputColumn);
    }
}

