/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexConstantAction;

class DropIndexConstantAction
extends IndexConstantAction {
    private String fullIndexName;
    private long tableConglomerateId;
    private boolean onlyIfExists;

    DropIndexConstantAction(String fullIndexName, String indexName, String tableName, String schemaName, UUID tableId, long tableConglomerateId, boolean onlyIfExists) {
        super(tableId, indexName, tableName, schemaName);
        this.fullIndexName = fullIndexName;
        this.tableConglomerateId = tableConglomerateId;
        this.onlyIfExists = onlyIfExists;
    }

    public String toString() {
        return "DROP INDEX " + (this.onlyIfExists ? "IF EXISTS " : "") + this.fullIndexName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        TableDescriptor td = null;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        if ((this.tableId == null || this.tableConglomerateId == 0L) && this.onlyIfExists) {
            this.invalidatePreparedStatement(activation, 2);
            return;
        }
        if (this.tableConglomerateId == 0L) {
            td = dd.getTableDescriptor(this.tableId);
            if (td == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            this.tableConglomerateId = td.getHeapConglomerateId();
        }
        if (td == null) {
            td = dd.getTableDescriptor(this.tableId);
        }
        lcc.verifyNoOpenResultSets(null, td, 2);
        this.lockTableForDDL(tc, this.tableConglomerateId, true);
        td = dd.getTableDescriptor(this.tableId);
        if (td == null) {
            throw StandardException.newException("X0X05.S", this.tableName);
        }
        SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaName, tc, true);
        ConglomerateDescriptor cd = dd.getConglomerateDescriptor(this.indexName, sd, true);
        if (cd == null) {
            if (this.onlyIfExists) {
                this.invalidatePreparedStatement(activation, 2);
                return;
            }
            throw StandardException.newException("X0X99.S", this.fullIndexName);
        }
        SanityManager.DEBUG_PRINT((String)"info:TraceConglom", (String)("Dropping index with descriptor: " + cd));
        this.tableName = td.getName();
        this.dropConglomerate(cd, td, activation, lcc);
        if (GemFireXDUtils.TraceConglom) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("Dropped index with descriptor {" + cd + "} of table: " + this.schemaName + '.' + this.tableName));
        }
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public boolean isDropStatement() {
        return true;
    }

    @Override
    public String getObjectName() {
        return this.indexName;
    }

    @Override
    public boolean isCancellable() {
        return false;
    }

    @Override
    public boolean isDropIfExists() {
        return this.onlyIfExists;
    }
}

