/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.ServerGroupsTableAttribute;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;

public class CreateSchemaConstantAction
extends DDLConstantAction {
    private ServerGroupsTableAttribute defaultSGs = null;
    private final String aid;
    private final String schemaName;

    public void setDefaultSG(ServerGroupsTableAttribute defSGs) {
        this.defaultSGs = defSGs;
    }

    public CreateSchemaConstantAction(String schemaName, String aid) {
        this.schemaName = schemaName;
        this.aid = aid;
    }

    public String toString() {
        return "CREATE SCHEMA " + this.schemaName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        TransactionController tc = activation.getLanguageConnectionContext().getTransactionExecute();
        this.executeConstantActionMinion(activation, tc);
    }

    public void executeConstantAction(Activation activation, TransactionController tc) throws StandardException {
        this.executeConstantActionMinion(activation, tc);
    }

    private void executeConstantActionMinion(Activation activation, TransactionController tc) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaName, lcc.getTransactionExecute(), false);
        if (sd != null && sd.getUUID() != null) {
            throw StandardException.newException("X0Y68.S", (Object)"Schema", (Object)this.schemaName);
        }
        UUID tmpSchemaId = dd.getUUIDFactory().createUUID();
        String thisAid = this.aid;
        if (thisAid == null) {
            thisAid = lcc.getAuthorizationId();
        }
        dd.startWriting(lcc);
        sd = ddg.newSchemaDescriptor(this.schemaName, thisAid, tmpSchemaId);
        sd.setDefaultServerGroups(this.defaultSGs != null ? this.defaultSGs.getServerGroupSet() : null);
        dd.addDescriptor(sd, null, 3, false, tc);
        Misc.getMemStore().createSchemaRegion(this.schemaName, lcc.getTransactionExecute());
    }

    @Override
    public final boolean isReplayable() {
        return !"SESSION".equalsIgnoreCase(this.schemaName);
    }

    @Override
    public final String getSchemaName() {
        return this.schemaName;
    }
}

