/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAttributesMutator;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.pivotal.gemfirexd.internal.catalog.DependableFinder;
import com.pivotal.gemfirexd.internal.catalog.IndexDescriptor;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.catalog.types.ReferencedColumnsDescriptorImpl;
import com.pivotal.gemfirexd.internal.catalog.types.StatisticsImpl;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeap;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdAttributesMutator;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdCacheLoader;
import com.pivotal.gemfirexd.internal.engine.ddl.PersistIdentityStart;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdSingleResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.management.GfxdManagementService;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireRegionSizeResultSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.StreamStorable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.PreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CheckConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DefaultDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DependencyDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GenericDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexLister;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.KeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatisticsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.GroupFetchScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowLocationRetRowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DDColumnDependableFinder;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BasicSortObserver;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CardinalityCounter;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ColumnInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ConstraintConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateConstraintConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateIndexConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLSingleTableConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DropConstraintConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DropIndexConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexColumnOrder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;

public class AlterTableConstantAction
extends DDLSingleTableConstantAction
implements RowLocationRetRowSource {
    private GfxdAttributesMutator mutator;
    private SchemaDescriptor sd;
    private String tableName;
    private UUID schemaId;
    private int tableType;
    private ColumnInfo[] columnInfo;
    private ConstraintConstantAction[] constraintActions;
    private char lockGranularity;
    private long tableConglomerateId;
    private boolean compressTable;
    private int behavior;
    private boolean sequential;
    private boolean truncateTable;
    private boolean doneScan;
    private boolean[] needToDropSort;
    private boolean[] validRow;
    private int bulkFetchSize = 16;
    private int currentCompressRow;
    private int numIndexes;
    private int rowCount;
    private long estimatedRowCount;
    private long[] indexConglomerateNumbers;
    private long[] sortIds;
    private FormatableBitSet indexedCols;
    private ConglomerateController compressHeapCC;
    private ExecIndexRow[] indexRows;
    private ExecRow[] baseRow;
    private ExecRow currentRow;
    private GroupFetchScanController compressHeapGSC;
    private IndexRowGenerator[] compressIRGs;
    private DataValueDescriptor[][] baseRowArray;
    private RowLocation[] compressRL;
    private SortController[] sorters;
    private int droppedColumnPosition;
    private ColumnOrdering[][] ordering;
    private int[][] collation;
    private TableDescriptor td;
    private LanguageConnectionContext lcc;
    private DataDictionary dd;
    private DependencyManager dm;
    private TransactionController tc;
    private Activation activation;
    private boolean isSet;
    private boolean refreshAllDone;
    private int numBuckets;
    private boolean isPkAdd;

    public void setAttributesMutator(GfxdAttributesMutator mutator) {
        if (!Misc.getMemStoreBooting().isHadoopGfxdLonerMode()) {
            this.mutator = mutator;
        }
    }

    AlterTableConstantAction(SchemaDescriptor sd, String tableName, UUID tableId, long tableConglomerateId, int tableType, ColumnInfo[] columnInfo, ConstraintConstantAction[] constraintActions, char lockGranularity, boolean compressTable, boolean isSet, int behavior, boolean sequential, boolean truncateTable) {
        super(tableId);
        this.sd = sd;
        this.tableName = tableName;
        this.tableConglomerateId = tableConglomerateId;
        this.tableType = tableType;
        this.columnInfo = columnInfo;
        if (Misc.getMemStoreBooting().isHadoopGfxdLonerMode() && constraintActions != null) {
            ArrayList<ConstraintConstantAction> pkConstraints = new ArrayList<ConstraintConstantAction>(1);
            for (ConstraintConstantAction constraint : constraintActions) {
                if (constraint.getConstraintType() != 2) continue;
                pkConstraints.add(constraint);
            }
            this.constraintActions = pkConstraints.toArray(new ConstraintConstantAction[pkConstraints.size()]);
        } else {
            this.constraintActions = constraintActions;
        }
        this.lockGranularity = lockGranularity;
        this.compressTable = compressTable;
        this.isSet = isSet;
        this.behavior = behavior;
        this.sequential = sequential;
        this.truncateTable = truncateTable;
        SanityManager.ASSERT((sd != null ? 1 : 0) != 0, (String)"schema descriptor is null");
    }

    public String toString() {
        if (this.truncateTable) {
            return "TRUNCATE TABLE " + this.tableName;
        }
        return "ALTER TABLE " + this.tableName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        GemFireContainer container;
        PartitionResolver pr;
        TXStateInterface tx;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        this.tc = lcc.getTransactionExecute();
        int numRows = 0;
        boolean tableScanned = false;
        GemFireTransaction parentTran = lcc.getParentOfNestedTransactionExecute();
        if (parentTran != null && (tx = parentTran.getSuspendedTXState()) != null && tx.getProxy().isDirty()) {
            throw StandardException.newException("0A000.S", "Cannot alter/truncate table in the middle of transaction that has data changes (commit or rollback the transaction first)");
        }
        dd.startWriting(lcc);
        if (this.tableConglomerateId == 0L) {
            this.td = dd.getTableDescriptor(this.tableId);
            if (this.td == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            this.tableConglomerateId = this.td.getHeapConglomerateId();
        }
        if (this.td == null) {
            this.td = dd.getTableDescriptor(this.tableId);
        }
        lcc.verifyNoOpenResultSets(null, this.td, this.truncateTable ? 42 : 12);
        this.lockTableForDDL(this.tc, this.tableConglomerateId, true);
        this.td = dd.getTableDescriptor(this.tableId);
        if (this.td == null) {
            throw StandardException.newException("X0X05.S", this.tableName);
        }
        boolean isHadoopLoner = Misc.getMemStoreBooting().isHadoopGfxdLonerMode();
        Region region = Misc.getRegionForTableByPath(Misc.getFullTableName(this.td, lcc), false);
        if (region == null) {
            throw StandardException.newException("X0X05.S", this.td.getQualifiedName());
        }
        this.numBuckets = AlterTableConstantAction.getNumBucketsOrSize(region, lcc);
        RegionAttributes attrs = region.getAttributes();
        PartitionAttributesImpl pattrs = (PartitionAttributesImpl)attrs.getPartitionAttributes();
        GfxdPartitionResolver spr = null;
        if (pattrs != null && (pr = pattrs.getPartitionResolver()) != null && pr instanceof GfxdPartitionResolver) {
            spr = (GfxdPartitionResolver)pr;
        }
        if (this.truncateTable) {
            dm.invalidateFor(this.td, 42, lcc);
        } else {
            dm.invalidateFor(this.td, 12, lcc);
        }
        activation.setDDLTableDescriptor(this.td);
        if (this.sd == null) {
            this.sd = AlterTableConstantAction.getAndCheckSchemaDescriptor(dd, this.schemaId, "ALTER TABLE");
        }
        if (this.truncateTable) {
            dm.invalidateFor(this.td, 42, lcc);
        } else {
            dm.invalidateFor(this.td, 12, lcc);
        }
        if (this.columnInfo != null) {
            int ix;
            boolean tableNeedsScanning = false;
            for (ix = 0; ix < this.columnInfo.length; ++ix) {
                int colAction;
                if (this.columnInfo[ix].action == 0 && !this.columnInfo[ix].dataType.isNullable() && this.columnInfo[ix].defaultInfo == null && this.columnInfo[ix].autoincInc == 0L) {
                    tableNeedsScanning = true;
                }
                if ((colAction = this.columnInfo[ix].action) == 2 || colAction == 7 || colAction == 3 || colAction == 4) {
                    throw StandardException.newException("0A000.S", "Column modification not yet supported.");
                }
                if (colAction == 1 || colAction == 2) {
                    ConstraintDescriptorList cdl = dd.getConstraintDescriptors(this.td);
                    for (int index = 0; index < cdl.size(); ++index) {
                        List<String> columnNames;
                        TupleDescriptor cd = cdl.elementAt(index);
                        if (((ConstraintDescriptor)cd).getConstraintType() != 2 || !(columnNames = Arrays.asList(((ConstraintDescriptor)cd).getColumnDescriptors().getColumnNames())).contains(this.columnInfo[ix].name)) continue;
                        throw StandardException.newException("0A000.S", "PK COLUMN drop/alter in ALTER TABLE");
                    }
                }
                if (spr == null || !spr.isUsedInPartitioning(this.columnInfo[ix].name) || colAction != 1) continue;
                throw StandardException.newException("0A000.S", "COLUMN drop of partitioning column '" + this.columnInfo[ix].name + "' in ALTER TABLE with data or data history");
            }
            if (tableNeedsScanning) {
                numRows = this.getSemiRowCount(this.tc);
                if (numRows > 0) {
                    throw StandardException.newException("X0Y57.S", this.td.getQualifiedName());
                }
                tableScanned = true;
            }
            for (ix = 0; ix < this.columnInfo.length; ++ix) {
                ColumnDescriptorList cdl = new ColumnDescriptorList();
                if (this.columnInfo[ix].action == 0) {
                    this.addNewColumnToTable(activation, lcc, dd, this.tc, ix);
                    continue;
                }
                if (this.columnInfo[ix].action == 5 || this.columnInfo[ix].action == 6 || this.columnInfo[ix].action == 7) {
                    this.modifyColumnDefault(activation, ix);
                    continue;
                }
                if (this.columnInfo[ix].action == 2) {
                    this.modifyColumnType(activation, ix, false);
                    continue;
                }
                if (this.columnInfo[ix].action == 3) {
                    if (isHadoopLoner) continue;
                    this.modifyColumnConstraint(activation, this.columnInfo[ix].name, true);
                    continue;
                }
                if (this.columnInfo[ix].action == 4) {
                    boolean[] nullCols;
                    String[] colNames;
                    if (isHadoopLoner) continue;
                    if (!tableScanned) {
                        tableScanned = true;
                        numRows = this.getSemiRowCount(this.tc);
                    }
                    if (!this.validateNotNullConstraint(colNames = new String[]{this.columnInfo[ix].name}, nullCols = new boolean[1], numRows, lcc, "X0Y80.S")) continue;
                    this.modifyColumnConstraint(activation, this.columnInfo[ix].name, false);
                    continue;
                }
                if (this.columnInfo[ix].action == 8) {
                    long maxValue;
                    Object context = lcc.getContextObject();
                    if (context != null && context instanceof PersistIdentityStart) {
                        PersistIdentityStart id = (PersistIdentityStart)context;
                        id.checkMatchingColumn(this.getSchemaName(), this.getTableName(), this.columnInfo[ix].name);
                        maxValue = id.getStartValue();
                        lcc.setContextObject(null);
                    } else {
                        if (lcc.isConnectionForRemote()) {
                            SanityManager.THROWASSERT((String)"Alter column add identity: unexpected call to maxValue on remote node");
                        }
                        if (Misc.initialDDLReplayInProgress()) {
                            SanityManager.THROWASSERT((String)"Alter column add identity: unexpected call to maxValue during DDL replay");
                        }
                        maxValue = this.getColumnMax(activation, this.td, this.columnInfo[ix].name, this.columnInfo[ix].autoincInc, this.columnInfo[ix].autoincStart);
                        lcc.setContextObject(new PersistIdentityStart(this.getSchemaName(), this.getTableName(), this.columnInfo[ix].name, maxValue));
                    }
                    if (maxValue > 0L) {
                        this.columnInfo[ix].autoincStart = maxValue + 1L;
                    }
                    this.columnInfo[ix].autoinc_create_or_modify_Start_Increment = 0L;
                    this.modifyColumnType(activation, ix, true);
                    continue;
                }
                if (this.columnInfo[ix].action == 1) {
                    this.dropColumnFromTable(activation, ix);
                    continue;
                }
                SanityManager.THROWASSERT((String)"Unexpected action in AlterTableConstantAction");
            }
        }
        this.adjustUDTDependencies(lcc, dd, this.td, this.columnInfo, false);
        if (this.constraintActions != null) {
            for (int conIndex = 0; conIndex < this.constraintActions.length; ++conIndex) {
                ConstraintConstantAction cca = this.constraintActions[conIndex];
                if (cca instanceof CreateConstraintConstantAction) {
                    int constraintType = cca.getConstraintType();
                    switch (constraintType) {
                        case 2: {
                            ConstraintDescriptorList cdl = dd.getConstraintDescriptors(this.td);
                            if (cdl.getPrimaryKey() != null) {
                                throw StandardException.newException("X0Y58.S", this.td.getQualifiedName());
                            }
                            if (!tableScanned) {
                                tableScanned = true;
                                numRows = this.getSemiRowCount(this.tc);
                            }
                            if (this.numBuckets > 0) {
                                numRows = this.getSemiRowCount(this.tc);
                                if (numRows <= 0) break;
                                throw StandardException.newException("0A000.S", "PRIMARY KEY create in ALTER TABLE with data");
                            }
                            this.isPkAdd = true;
                            break;
                        }
                        case 4: {
                            if (!tableScanned) {
                                tableScanned = true;
                                numRows = this.getSemiRowCount(this.tc);
                            }
                            if (numRows <= 0) break;
                            ConstraintConstantAction.validateConstraint(cca.getConstraintName(), ((CreateConstraintConstantAction)cca).getConstraintText(), this.td, lcc, true);
                            break;
                        }
                        case 6: {
                            if (region.getAttributes().getCustomEvictionAttributes() == null) break;
                            throw StandardException.newException("0A000.S.30");
                        }
                    }
                } else if (!(cca instanceof DropConstraintConstantAction)) {
                    SanityManager.THROWASSERT((String)("constraintActions[" + conIndex + "] expected to be instanceof " + "DropConstraintConstantAction not " + cca.getClass().getName()));
                }
                this.constraintActions[conIndex].executeConstantAction(activation);
            }
        }
        if (this.lockGranularity != '\u0000') {
            if (this.lockGranularity != 'T' && this.lockGranularity != 'R') {
                SanityManager.THROWASSERT((String)("lockGranularity expected to be 'T'or 'R', not " + this.lockGranularity));
            }
            this.td.setLockGranularity(this.lockGranularity);
            dd.updateLockGranularity(this.td, this.sd, this.lockGranularity, this.tc);
        }
        if (this.compressTable) {
            this.compressTable(activation);
        }
        if (this.truncateTable) {
            this.truncateTable(activation);
        }
        this.td = dd.getTableDescriptor(this.td.getUUID());
        if (this.mutator != null && !this.truncateTable) {
            CacheLoader ldr = attrs.getCacheLoader();
            if (ldr != null) {
                GfxdCacheLoader gfxdldr = (GfxdCacheLoader)ldr;
                gfxdldr.setTableDetails(this.td);
            }
            if (!this.isSet && spr != null) {
                DistributionDescriptor distributionDesc = spr.getDistributionDescriptor();
                distributionDesc.resolveColumnPositions(this.td);
                spr.setColumnInfo(this.td, activation);
                if (this.numBuckets == 0 && this.isPkAdd && distributionDesc.getPolicy() == 3) {
                    String[] partCols = spr.getColumnNames();
                    if (partCols != null && partCols.length > 0) {
                        distributionDesc.setPartitionColumnNames(partCols);
                    }
                    this.refreshAllKeyConstraints(activation, dd, distributionDesc);
                }
            }
            int evictionLimit = this.mutator.getEvictionMaximum();
            int expirationKind = this.mutator.getExpirationKind();
            if (evictionLimit >= 0 || expirationKind != 0) {
                AttributesMutator attrsMutator = region.getAttributesMutator();
                ExpirationAttributes expirationAttrs = this.mutator.getExpirationAttributes();
                switch (expirationKind) {
                    case 1: {
                        attrsMutator.setRegionTimeToLive(expirationAttrs);
                        break;
                    }
                    case 2: {
                        attrsMutator.setRegionIdleTimeout(expirationAttrs);
                        break;
                    }
                    case 3: {
                        attrsMutator.setEntryTimeToLive(expirationAttrs);
                        break;
                    }
                    case 4: {
                        attrsMutator.setEntryIdleTimeout(expirationAttrs);
                    }
                }
                if (evictionLimit >= 0) {
                    EvictionAttributesMutator evictMutator = attrsMutator.getEvictionAttributesMutator();
                    if (region.getAttributes().getPartitionAttributes() != null && region.getAttributes().getEvictionAttributes() != null && region.getAttributes().getEvictionAttributes().getAlgorithm().isLRUMemory() && region.getAttributes().getPartitionAttributes().getLocalMaxMemory() != 0 && evictionLimit != region.getAttributes().getPartitionAttributes().getLocalMaxMemory()) {
                        evictMutator.setMaximum(region.getAttributes().getPartitionAttributes().getLocalMaxMemory());
                    } else {
                        evictMutator.setMaximum(evictionLimit);
                    }
                }
            }
            if (this.mutator.isAlterGatewaySender()) {
                GemFireContainer cntr = GemFireContainer.getGemFireContainer(this.td, (GemFireTransaction)this.tc);
                for (TupleDescriptor cd : this.td.getColumnDescriptorList()) {
                    if (!((ColumnDescriptor)cd).isAutoincAlways() || ((ColumnDescriptor)cd).getType().getJDBCTypeId() != 4) continue;
                    throw StandardException.newException("42Z29", (Object)this.td.getName(), (Object)((ColumnDescriptor)cd).getColumnName());
                }
                LocalRegion r = (LocalRegion)region;
                boolean sendRequiresNotification = false;
                Set oldSenderIds = r.getGatewaySenderIds();
                Set<String> senderIds = this.mutator.getGatewaySenderIds();
                HashSet<String> activeSenderIds = new HashSet<String>();
                for (GatewaySender gatewaySender : r.getCache().getGatewaySenders()) {
                    activeSenderIds.add(gatewaySender.getId());
                }
                for (String string : senderIds) {
                    if (oldSenderIds.contains(string)) continue;
                    r.addGatewaySenderId(string);
                    if (!activeSenderIds.contains(string)) continue;
                    sendRequiresNotification = true;
                }
                for (String string : oldSenderIds) {
                    if (senderIds.contains(string)) continue;
                    r.removeGatewaySenderId(string);
                    if (!activeSenderIds.contains(string)) continue;
                    sendRequiresNotification = true;
                }
                if (sendRequiresNotification) {
                    r.distributeUpdatedProfileOnSenderChange();
                }
                GemFireContainer container2 = GemFireContainer.getGemFireContainer(this.td, (GemFireTransaction)this.tc);
                GemFireCacheImpl gemFireCacheImpl = Misc.getGemFireCache();
                for (String id : container2.getRegion().getGatewaySenderIds()) {
                    if (gemFireCacheImpl.getGatewaySender(id) != null) continue;
                    StringBuilder sb = new StringBuilder();
                    for (GatewaySender s : gemFireCacheImpl.getAllGatewaySenders()) {
                        sb.append(s.getId()).append(",");
                    }
                    if (container2.isAccessorForRegion()) continue;
                    activation.addWarning(StandardException.newWarning("01507", new Object[]{id, container2.getQualifiedTableName(), "GatewaySenders", sb.toString()}, null));
                }
            }
            if (this.mutator.isAlterAsyncEventListener()) {
                LocalRegion r = (LocalRegion)region;
                boolean sendRequiresNotification = false;
                Set oldAsyncQueueIds = r.getAsyncEventQueueIds();
                Set<String> asyncQueueIds = this.mutator.getAsyncEventQueueIds();
                HashSet<String> activeAsyncQueueIds = new HashSet<String>();
                for (AsyncEventQueue asyncQueue : r.getCache().getAsyncEventQueues()) {
                    activeAsyncQueueIds.add(asyncQueue.getId());
                }
                for (String id : asyncQueueIds) {
                    if (oldAsyncQueueIds.contains(id)) continue;
                    r.addAsyncEventQueueId(id);
                    if (!activeAsyncQueueIds.contains(id)) continue;
                    sendRequiresNotification = true;
                }
                for (String id : oldAsyncQueueIds) {
                    if (asyncQueueIds.contains(id)) continue;
                    r.removeAsyncEventQueueId(id);
                    if (!activeAsyncQueueIds.contains(id)) continue;
                    sendRequiresNotification = true;
                }
                if (sendRequiresNotification) {
                    r.distributeUpdatedProfileOnSenderChange();
                }
                GemFireContainer container3 = GemFireContainer.getGemFireContainer(this.td, (GemFireTransaction)this.tc);
                GemFireCacheImpl cache = Misc.getGemFireCache();
                for (Object object : container3.getRegion().getAsyncEventQueueIds()) {
                    if (cache.getAsyncEventQueue((String)object) != null) continue;
                    StringBuilder sb = new StringBuilder();
                    for (AsyncEventQueue q : cache.getAsyncEventQueues()) {
                        sb.append(q.getId()).append(",");
                    }
                    if (container3.isAccessorForRegion()) continue;
                    activation.addWarning(StandardException.newWarning("01507", new Object[]{object, container3.getQualifiedTableName(), "AsyncEventQueues", sb.toString()}, null));
                }
            }
            if (this.mutator.isAlterCustomEviction()) {
                try {
                    region.getAttributesMutator().setCustomEvictionAttributes(this.mutator.getCustomEvictionStart(), this.mutator.getCustomEvictionInterval());
                }
                catch (IllegalArgumentException iae) {
                    throw StandardException.newException("X0Z29.S", (Throwable)iae, (Object)this.td.getQualifiedName());
                }
            }
        }
        if ((container = GemFireContainer.getGemFireContainer(this.td, (GemFireTransaction)this.tc)).isApplicationTable()) {
            GfxdManagementService.handleEvent(9, new Object[]{container});
        }
    }

    private String getNewIndexName(String name) {
        if (name != null) {
            int delimIndex = name.lastIndexOf("__");
            int count = 0;
            if (delimIndex > 0) {
                try {
                    count = Integer.parseInt(name.substring(delimIndex + "__".length()));
                    name = name.substring(0, delimIndex);
                }
                catch (NumberFormatException ex) {
                    count = 0;
                }
            }
            name = name + "__" + Integer.toString(++count);
        }
        return name;
    }

    private void refreshAllKeyConstraints(Activation activation, DataDictionary dd, DistributionDescriptor distributionDesc) throws StandardException {
        if (this.refreshAllDone) {
            return;
        }
        this.refreshAllDone = true;
        ConstraintDescriptorList constraints = dd.getConstraintDescriptors(this.td);
        for (int index = 0; index < constraints.size(); ++index) {
            ConstraintDescriptor constraint = constraints.elementAt(index);
            int constraintType = constraint.getConstraintType();
            if (constraintType != 3 && constraintType != 2 && constraintType != 6) continue;
            ConglomerateDescriptor conglom = ((KeyConstraintDescriptor)constraint).getIndexConglomerateDescriptor(dd);
            Properties createProps = new Properties();
            createProps.setProperty(GfxdConstants.PROPERTY_CONSTRAINT_TYPE, Integer.toString(constraintType));
            String name = conglom.getConglomerateName();
            name = this.getNewIndexName(name);
            createProps.setProperty(GfxdConstants.PROPERTY_TABLE_NAME, name);
            String fullIndexName = this.sd.getSchemaName() + "." + conglom.getConglomerateName();
            DropIndexConstantAction dropAction = new DropIndexConstantAction(fullIndexName, conglom.getConglomerateName(), this.td.getName(), this.sd.getSchemaName(), this.td.getUUID(), this.td.getHeapConglomerateId(), false);
            CreateIndexConstantAction createAction = new CreateIndexConstantAction(conglom, this.td, createProps);
            createAction.clearDroppedConglomerateNumber();
            createAction.skipLoadConglomerate();
            distributionDesc.resolveColumnPositions(this.td);
            activation.setDDLTableDescriptor(this.td);
            dropAction.executeConstantAction(activation);
            this.td = dd.getTableDescriptor(this.td.getUUID());
            activation.setDDLTableDescriptor(this.td);
            createAction.executeConstantAction(activation);
            UUID newIndexUUID = createAction.getCreatedUUID();
            if (constraintType == 6) {
                ForeignKeyConstraintDescriptor fkcd = new ForeignKeyConstraintDescriptor((ForeignKeyConstraintDescriptor)constraint, newIndexUUID);
                dd.dropConstraintDescriptor(constraint, this.tc);
                dd.addConstraintDescriptor(fkcd, this.tc);
            }
            this.td = dd.getTableDescriptor(this.td.getUUID());
        }
    }

    private void addNewColumnToTable(Activation activation, LanguageConnectionContext lcc, DataDictionary dd, TransactionController tc, int ix) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[ix].name);
        int colNumber = this.td.getMaxColumnID() + ix;
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        if (columnDescriptor != null) {
            throw StandardException.newException("X0Y32.S", columnDescriptor.getDescriptorType(), (Object)this.columnInfo[ix].name, (Object)this.td.getDescriptorType(), (Object)this.td.getQualifiedName());
        }
        if (this.columnInfo[ix].autoincInc != 0L && this.getSemiRowCount(tc) > 0) {
            throw StandardException.newException("0A000.S", "Autoincrement column add in table having data");
        }
        DataValueDescriptor storableDV = this.columnInfo[ix].defaultValue != null ? this.columnInfo[ix].defaultValue : this.columnInfo[ix].dataType.getNull();
        tc.addColumnToConglomerate(this.td.getHeapConglomerateId(), colNumber, storableDV, this.columnInfo[ix].dataType.getCollationType());
        UUID defaultUUID = this.columnInfo[ix].newDefaultUUID;
        if (this.columnInfo[ix].defaultInfo != null && defaultUUID == null) {
            defaultUUID = dd.getUUIDFactory().createUUID();
        }
        columnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, colNumber + 1, this.columnInfo[ix].dataType, this.columnInfo[ix].defaultValue, this.columnInfo[ix].defaultInfo, this.td, defaultUUID, this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc, this.columnInfo[ix].isGeneratedByDefault);
        dd.addDescriptor(columnDescriptor, this.td, 2, false, tc);
        this.td.getColumnDescriptorList().add(columnDescriptor);
        ColumnDescriptor cdWithDefault = columnDescriptor;
        if (columnDescriptor.getDefaultInfo() != null) {
            cdWithDefault = columnDescriptor.cloneObject();
            this.updateNewColumnToDefault(activation, this.columnInfo[ix].name, this.columnInfo[ix].defaultInfo.getDefaultText(), lcc, cdWithDefault);
        }
        dd.updateSYSCOLPERMSforAddColumnToUserTable(this.td.getUUID(), tc);
        GemFireContainer gfc = GemFireContainer.getGemFireContainer(this.td, (GemFireTransaction)tc);
        gfc.scheduleAddColumn(cdWithDefault, lcc);
    }

    private void dropColumnFromTable(Activation activation, int ix) throws StandardException {
        ConstraintDescriptor cd;
        int i;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[ix].name);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", (Object)this.columnInfo[ix].name, (Object)this.td.getQualifiedName());
        }
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        ColumnDescriptorList tab_cdl = this.td.getColumnDescriptorList();
        int size = tab_cdl.size();
        if (size == 1) {
            throw StandardException.newException("X0Y25.S", dm.getActionString(37), (Object)("THE *LAST* COLUMN " + this.columnInfo[ix].name), (Object)"TABLE", (Object)this.td.getQualifiedName());
        }
        this.droppedColumnPosition = columnDescriptor.getPosition();
        boolean cascade = this.behavior == 0;
        FormatableBitSet toDrop = new FormatableBitSet(size + 1);
        toDrop.set(this.droppedColumnPosition);
        this.td.setReferencedColumnMap(toDrop);
        dm.invalidateFor(this.td, cascade ? 37 : 46, lcc);
        if (columnDescriptor.getDefaultInfo() != null) {
            dm.clearDependencies(lcc, columnDescriptor.getDefaultDescriptor(dd));
        }
        GenericDescriptorList tdl = dd.getTriggerDescriptors(this.td);
        Enumeration descs = tdl.elements();
        while (descs.hasMoreElements()) {
            int j;
            TriggerDescriptor trd = (TriggerDescriptor)descs.nextElement();
            int[] referencedCols = trd.getReferencedCols();
            if (referencedCols == null) continue;
            int refColLen = referencedCols.length;
            boolean changed = false;
            for (j = 0; j < refColLen; ++j) {
                if (referencedCols[j] > this.droppedColumnPosition) {
                    changed = true;
                    continue;
                }
                if (referencedCols[j] != this.droppedColumnPosition) continue;
                if (cascade) {
                    trd.drop(lcc);
                    activation.addWarning(StandardException.newWarning("01502", trd.getName(), this.td.getName()));
                    break;
                }
                throw StandardException.newException("X0Y25.S", dm.getActionString(37), (Object)this.columnInfo[ix].name, (Object)"TRIGGER", (Object)trd.getName());
            }
            if (j != refColLen || !changed) continue;
            dd.dropTriggerDescriptor(trd, tc);
            for (j = 0; j < refColLen; ++j) {
                if (referencedCols[j] <= this.droppedColumnPosition) continue;
                int n = j;
                referencedCols[n] = referencedCols[n] - 1;
            }
            dd.addDescriptor(trd, this.sd, 13, false, tc);
        }
        ConstraintDescriptorList csdl = dd.getConstraintDescriptors(this.td);
        int csdl_size = csdl.size();
        ArrayList newCongloms = new ArrayList();
        int tbr_size = 0;
        ConstraintDescriptor[] toBeRemoved = new ConstraintDescriptor[csdl_size];
        for (i = csdl_size - 1; i >= 0; --i) {
            int j;
            cd = csdl.elementAt(i);
            int[] referencedColumns = (int[])cd.getReferencedColumns().clone();
            int numRefCols = referencedColumns.length;
            boolean changed = false;
            for (j = 0; j < numRefCols; ++j) {
                if (referencedColumns[j] > this.droppedColumnPosition) {
                    changed = true;
                }
                if (referencedColumns[j] == this.droppedColumnPosition) break;
            }
            if (j == numRefCols) {
                if (!changed) continue;
                for (j = 0; j < numRefCols; ++j) {
                    if (referencedColumns[j] <= this.droppedColumnPosition) continue;
                    int n = j;
                    referencedColumns[n] = referencedColumns[n] - 1;
                }
                if (cd instanceof CheckConstraintDescriptor) {
                    dd.dropConstraintDescriptor(cd, tc);
                    ((CheckConstraintDescriptor)cd).setReferencedColumnsDescriptor(new ReferencedColumnsDescriptorImpl(referencedColumns));
                    dd.addConstraintDescriptor(cd, tc);
                    continue;
                }
                cd.setReferencedColumns(referencedColumns);
                cd.refreshDescriptors(tc);
                continue;
            }
            if (!cascade) {
                throw StandardException.newException("X0Y25.S", dm.getActionString(37), (Object)this.columnInfo[ix].name, (Object)"CONSTRAINT", (Object)cd.getConstraintName());
            }
            if (cd instanceof ReferencedKeyConstraintDescriptor) {
                toBeRemoved[tbr_size++] = cd;
                continue;
            }
            dm.invalidateFor(cd, 19, lcc);
            this.dropConstraint(cd, this.td, newCongloms, activation, lcc, true);
            activation.addWarning(StandardException.newWarning("01500", cd.getConstraintName(), this.td.getName()));
        }
        for (i = tbr_size - 1; i >= 0; --i) {
            cd = toBeRemoved[i];
            this.dropConstraint(cd, this.td, newCongloms, activation, lcc, false);
            activation.addWarning(StandardException.newWarning("01500", cd.getConstraintName(), this.td.getName()));
            if (cascade) {
                ConstraintDescriptorList fkcdl = dd.getForeignKeys(cd.getUUID());
                for (int j = 0; j < fkcdl.size(); ++j) {
                    ConstraintDescriptor fkcd = fkcdl.elementAt(j);
                    dm.invalidateFor(fkcd, 19, lcc);
                    this.dropConstraint(fkcd, this.td, newCongloms, activation, lcc, true);
                    activation.addWarning(StandardException.newWarning("01500", fkcd.getConstraintName(), fkcd.getTableDescriptor().getName()));
                }
            }
            dm.invalidateFor(cd, 19, lcc);
            dm.clearDependencies(lcc, cd);
        }
        this.updateRefColsForIndexes(cascade, activation, this.columnInfo[ix].name);
        this.createNewBackingCongloms(newCongloms, null, activation, dd);
        this.td = dd.getTableDescriptor(this.tableId);
        if (tbr_size > 0) {
            this.refreshAllKeyConstraints(activation, dd, this.td.getDistributionDescriptor());
        }
        dd.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[ix].name, tc);
        TupleDescriptor[] cdlArray = new ColumnDescriptor[size - columnDescriptor.getPosition()];
        int i2 = columnDescriptor.getPosition();
        int j = 0;
        while (i2 < size) {
            ColumnDescriptor cd2 = tab_cdl.elementAt(i2);
            dd.dropColumnDescriptor(this.td.getUUID(), cd2.getColumnName(), tc);
            cd2.setPosition(i2);
            if (cd2.isAutoincrement()) {
                cd2.setAutoinc_create_or_modify_Start_Increment(0);
            }
            cdlArray[j] = cd2;
            ++i2;
            ++j;
        }
        dd.addDescriptorArray(cdlArray, this.td, 2, false, tc);
        List deps = dd.getProvidersDescriptorList(this.td.getObjectID().toString());
        ListIterator depsIterator = deps.listIterator();
        while (depsIterator.hasNext()) {
            DependencyDescriptor depDesc = (DependencyDescriptor)depsIterator.next();
            DependableFinder finder = depDesc.getProviderFinder();
            if (!(finder instanceof DDColumnDependableFinder)) continue;
            DDColumnDependableFinder colFinder = (DDColumnDependableFinder)finder;
            FormatableBitSet oldColumnBitMap = new FormatableBitSet(colFinder.getColumnBitMap());
            FormatableBitSet newColumnBitMap = new FormatableBitSet(oldColumnBitMap);
            newColumnBitMap.clear();
            int bitLen = oldColumnBitMap.getLength();
            for (int i3 = 0; i3 < bitLen; ++i3) {
                if (i3 < this.droppedColumnPosition && oldColumnBitMap.isSet(i3)) {
                    newColumnBitMap.set(i3);
                }
                if (i3 <= this.droppedColumnPosition || !oldColumnBitMap.isSet(i3)) continue;
                newColumnBitMap.set(i3 - 1);
            }
            if (newColumnBitMap.equals(oldColumnBitMap)) continue;
            dd.dropStoredDependency(depDesc, tc);
            colFinder.setColumnBitMap(newColumnBitMap.getByteArray());
            dd.addDescriptor(depDesc, null, 6, true, tc);
        }
        dd.updateSYSCOLPERMSforDropColumn(this.td.getUUID(), tc, columnDescriptor);
        GemFireContainer gfc = GemFireContainer.getGemFireContainer(this.td, (GemFireTransaction)tc);
        gfc.scheduleDropColumn(columnDescriptor.getPosition(), lcc);
    }

    private void modifyColumnType(Activation activation, int ix, boolean setAutoInc) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[ix].name);
        ColumnDescriptor newColumnDescriptor = null;
        newColumnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, columnDescriptor.getPosition(), this.columnInfo[ix].dataType, columnDescriptor.getDefaultValue(), columnDescriptor.getDefaultInfo(), this.td, columnDescriptor.getDefaultUUID(), this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc, this.columnInfo[ix].isGeneratedByDefault);
        if (setAutoInc) {
            newColumnDescriptor.setAutoinc_create_or_modify_Start_Increment((int)this.columnInfo[ix].autoinc_create_or_modify_Start_Increment);
        }
        dd.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[ix].name, tc);
        dd.addDescriptor(newColumnDescriptor, this.td, 2, false, tc);
    }

    private void modifyColumnConstraint(Activation activation, String colName, boolean nullability) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(colName);
        ColumnDescriptor newColumnDescriptor = null;
        DataTypeDescriptor dataType = columnDescriptor.getType().getNullabilityType(nullability);
        ConstraintDescriptorList cdl = dd.getConstraintDescriptors(this.td);
        int columnPostion = columnDescriptor.getPosition();
        for (int i = 0; i < cdl.size(); ++i) {
            ConglomerateDescriptor desc;
            ConstraintDescriptor cd = cdl.elementAt(i);
            if (cd.getConstraintType() != 3) continue;
            ColumnDescriptorList columns = cd.getColumnDescriptors();
            for (int count = 0; count < columns.size() && columns.elementAt(count).getPosition() == columnPostion && (desc = this.td.getConglomerateDescriptor(cd.getConglomerateId())).getIndexDescriptor().isUnique(); ++count) {
                this.recreateUniqueConstraintBackingIndexAsUniqueWhenNotNull(desc, this.td, activation, lcc);
            }
        }
        newColumnDescriptor = new ColumnDescriptor(colName, columnDescriptor.getPosition(), dataType, columnDescriptor.getDefaultValue(), columnDescriptor.getDefaultInfo(), this.td, columnDescriptor.getDefaultUUID(), columnDescriptor.getAutoincStart(), columnDescriptor.getAutoincInc(), columnDescriptor.isGeneratedByDefault());
        dd.dropColumnDescriptor(this.td.getUUID(), colName, tc);
        dd.addDescriptor(newColumnDescriptor, this.td, 2, false, tc);
    }

    private void modifyColumnDefault(Activation activation, int ix) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[ix].name);
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        int columnPosition = columnDescriptor.getPosition();
        if (columnDescriptor.hasNonNullDefault()) {
            DefaultDescriptor defaultDescriptor = new DefaultDescriptor(dd, this.columnInfo[ix].oldDefaultUUID, this.td.getUUID(), columnPosition);
            dm.invalidateFor(defaultDescriptor, 31, lcc);
            dm.clearDependencies(lcc, defaultDescriptor);
        }
        UUID defaultUUID = this.columnInfo[ix].newDefaultUUID;
        if (this.columnInfo[ix].defaultInfo != null && defaultUUID == null) {
            defaultUUID = dd.getUUIDFactory().createUUID();
        }
        columnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, columnPosition, this.columnInfo[ix].dataType, this.columnInfo[ix].defaultValue, this.columnInfo[ix].defaultInfo, this.td, defaultUUID, this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc, this.columnInfo[ix].autoinc_create_or_modify_Start_Increment, this.columnInfo[ix].isGeneratedByDefault);
        dd.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[ix].name, tc);
        dd.addDescriptor(columnDescriptor, this.td, 2, false, tc);
        if (this.columnInfo[ix].action == 6) {
            if (!this.columnInfo[ix].isGeneratedByDefault) {
                long maxValue = this.getColumnMax(activation, this.td, this.columnInfo[ix].name, this.columnInfo[ix].autoincInc, this.columnInfo[ix].autoincStart);
                dd.setAutoincrementValue(tc, this.td.getUUID(), this.columnInfo[ix].name, maxValue, true);
            } else {
                dd.setAutoincrementValue(tc, this.td.getUUID(), this.columnInfo[ix].name, this.columnInfo[ix].autoincStart, false);
            }
        } else if (this.columnInfo[ix].action == 5) {
            dd.setAutoincrementValue(tc, this.td.getUUID(), this.columnInfo[ix].name, this.columnInfo[ix].autoincStart, false);
            GemFireTransaction tran = (GemFireTransaction)tc;
            GemFireContainer container = GemFireContainer.getGemFireContainer(this.td, tran);
            container.removeIdentityRegionEntries(tran);
        }
    }

    private void compressTable(Activation activation) throws StandardException {
        Properties properties = new Properties();
        this.lcc = activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
        this.dm = this.dd.getDependencyManager();
        this.tc = this.lcc.getTransactionExecute();
        this.activation = activation;
        if (this.lockGranularity != '\u0000') {
            SanityManager.THROWASSERT((String)("lockGranularity expected to be '\u0000', not " + this.lockGranularity));
        }
        SanityManager.ASSERT((!this.compressTable || this.columnInfo == null ? 1 : 0) != 0, (String)"columnInfo expected to be null");
        SanityManager.ASSERT((this.constraintActions == null ? 1 : 0) != 0, (String)"constraintActions expected to be null");
        ExecRow emptyHeapRow = this.td.getEmptyExecRow();
        int[] collation_ids = this.td.getColumnCollationIds();
        this.compressHeapCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        this.dm.invalidateFor(this.td, 33, this.lcc);
        RowLocation rl = this.compressHeapCC.newRowLocationTemplate();
        this.compressHeapCC.getInternalTablePropertySet(properties);
        this.compressHeapCC.close();
        this.compressHeapCC = null;
        this.baseRow = new ExecRow[this.bulkFetchSize];
        this.baseRowArray = new DataValueDescriptor[this.bulkFetchSize][];
        this.validRow = new boolean[this.bulkFetchSize];
        this.getAffectedIndexes(activation);
        this.compressRL = new RowLocation[this.bulkFetchSize];
        this.indexRows = new ExecIndexRow[this.numIndexes];
        if (!this.compressTable) {
            ExecRow newRow = activation.getExecutionFactory().getValueRow(emptyHeapRow.nColumns() - 1);
            int[] new_collation_ids = new int[collation_ids.length - 1];
            for (int i = 0; i < newRow.nColumns(); ++i) {
                newRow.setColumn(i + 1, i < this.droppedColumnPosition - 1 ? emptyHeapRow.getColumn(i + 1) : emptyHeapRow.getColumn(i + 1 + 1));
                new_collation_ids[i] = collation_ids[i < this.droppedColumnPosition - 1 ? i : i + 1];
            }
            emptyHeapRow = newRow;
            collation_ids = new_collation_ids;
        }
        this.setUpAllSorts(emptyHeapRow, rl);
        this.openBulkFetchScan(this.td.getHeapConglomerateId());
        this.estimatedRowCount = this.compressHeapGSC.getEstimatedRowCount();
        for (int i = 0; i < this.bulkFetchSize; ++i) {
            this.baseRow[i] = this.td.getEmptyExecRow();
            this.baseRowArray[i] = this.baseRow[i].getRowArray();
            this.compressRL[i] = this.compressHeapGSC.newRowLocationTemplate();
        }
        long newHeapConglom = this.tc.createAndLoadConglomerate("heap", emptyHeapRow.getRowArray(), null, collation_ids, properties, 0, this, null);
        this.closeBulkFetchScan();
        ScanController compressHeapSC = this.tc.openScan(newHeapConglom, false, 4, 7, 5, null, null, 0, null, null, 0, null);
        compressHeapSC.setEstimatedRowCount(this.rowCount);
        compressHeapSC.close();
        compressHeapSC = null;
        this.dd.startWriting(this.lcc);
        if (this.compressIRGs.length > 0) {
            this.updateAllIndexes(newHeapConglom, this.dd);
        }
        long oldHeapConglom = this.td.getHeapConglomerateId();
        ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(oldHeapConglom);
        this.dd.updateConglomerateDescriptor(cd, newHeapConglom, this.tc);
        this.tc.dropConglomerate(oldHeapConglom);
        this.cleanUp();
    }

    private void truncateTable(Activation activation) throws StandardException {
        Properties properties = new Properties();
        this.lcc = activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
        this.dm = this.dd.getDependencyManager();
        this.tc = this.lcc.getTransactionExecute();
        this.activation = activation;
        if (this.lockGranularity != '\u0000') {
            SanityManager.THROWASSERT((String)("lockGranularity expected to be '\u0000', not " + this.lockGranularity));
        }
        SanityManager.ASSERT((this.columnInfo == null ? 1 : 0) != 0, (String)"columnInfo expected to be null");
        SanityManager.ASSERT((this.constraintActions == null ? 1 : 0) != 0, (String)"constraintActions expected to be null");
        if (Misc.initialDDLReplayInProgress()) {
            return;
        }
        ConstraintDescriptorList cdl = this.dd.getConstraintDescriptors(this.td);
        for (int index = 0; index < cdl.size(); ++index) {
            ConstraintDescriptor cd = cdl.elementAt(index);
            if (cd instanceof ReferencedKeyConstraintDescriptor) {
                ReferencedKeyConstraintDescriptor rfcd = (ReferencedKeyConstraintDescriptor)cd;
                ConstraintDescriptorList fkcdl = rfcd.getForeignKeyConstraints(1);
                for (Object fcd : fkcdl) {
                    GemFireContainer refContainer;
                    ForeignKeyConstraintDescriptor fkcd;
                    if (!(fcd instanceof ForeignKeyConstraintDescriptor) || (fkcd = (ForeignKeyConstraintDescriptor)fcd).getTableId().equals(rfcd.getTableId()) || (refContainer = ((MemHeap)((GemFireTransaction)this.tc).findExistingConglomerate(fkcd.getTableDescriptor().getHeapConglomerateId())).getGemFireContainer()).getTotalNumRows(this.lcc) <= 0) continue;
                    throw StandardException.newException("XCL48.S", (Object)this.td.getQualifiedName(), (Object)fkcd.getTableDescriptor().getQualifiedName());
                }
                continue;
            }
            if (!(cd instanceof ForeignKeyConstraintDescriptor)) continue;
            ForeignKeyConstraintDescriptor fkcd = (ForeignKeyConstraintDescriptor)cd;
            this.dm.invalidateFor(fkcd.getReferencedConstraint().getTableDescriptor(), 42, this.lcc);
        }
        GenericDescriptorList tdl = this.dd.getTriggerDescriptors(this.td);
        Enumeration descs = tdl.elements();
        while (descs.hasMoreElements()) {
            TriggerDescriptor trd = (TriggerDescriptor)descs.nextElement();
            if (!trd.listensForEvent(2) || !trd.isEnabled()) continue;
            throw StandardException.newException("XCL49.S", (Object)this.td.getName(), (Object)trd.getName());
        }
        GemFireTransaction tran = (GemFireTransaction)this.tc;
        GemFireContainer container = ((MemHeap)tran.findExistingConglomerate(this.td.getHeapConglomerateId())).getGemFireContainer();
        container.clear(this.lcc, tran);
    }

    private void updateAllIndexes(long newHeapConglom, DataDictionary dd) throws StandardException {
        long[] newIndexCongloms = new long[this.numIndexes];
        if (this.sequential) {
            if (this.numIndexes >= 1) {
                this.updateIndex(newHeapConglom, dd, 0, newIndexCongloms);
            }
            for (int index = 1; index < this.numIndexes; ++index) {
                this.openBulkFetchScan(newHeapConglom);
                while (this.getNextRowFromRowSource() != null) {
                    this.objectifyStreamingColumns();
                    this.insertIntoSorter(index, this.compressRL[this.currentCompressRow - 1]);
                }
                this.updateIndex(newHeapConglom, dd, index, newIndexCongloms);
                this.closeBulkFetchScan();
            }
        } else {
            for (int index = 0; index < this.numIndexes; ++index) {
                this.updateIndex(newHeapConglom, dd, index, newIndexCongloms);
            }
        }
    }

    private void updateIndex(long newHeapConglom, DataDictionary dd, int index, long[] newIndexCongloms) throws StandardException {
        Properties properties = new Properties();
        ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[index]);
        ConglomerateController indexCC = this.tc.openConglomerate(this.indexConglomerateNumbers[index], false, 4, 7, 5);
        indexCC.getInternalTablePropertySet(properties);
        int indexRowLength = this.indexRows[index].nColumns();
        properties.put("baseConglomerateId", Long.toString(newHeapConglom));
        IndexRowGenerator indexDesc = cd.getIndexDescriptor();
        boolean unique = indexDesc.isUnique();
        boolean uniqueWithDuplicateNulls = indexDesc.isUniqueWithDuplicateNulls();
        String indexType = indexDesc.indexType();
        if (uniqueWithDuplicateNulls) {
            if (this.lcc.getDataDictionary().checkVersion(160, null)) {
                properties.put("uniqueWithDuplicateNulls", Boolean.toString(true));
            } else {
                unique = true;
            }
        }
        if (unique) {
            properties.put("nUniqueColumns", Integer.toString(indexRowLength - 1));
        } else {
            properties.put("nUniqueColumns", Integer.toString(indexRowLength));
        }
        properties.put("com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary", this.dd);
        String oldName = properties.getProperty(GfxdConstants.PROPERTY_TABLE_NAME);
        String newName = null;
        if (oldName != null) {
            newName = this.getNewIndexName(oldName);
            properties.setProperty(GfxdConstants.PROPERTY_TABLE_NAME, newName);
        }
        properties.put("rowLocationColumn", Integer.toString(indexRowLength - 1));
        properties.put("nKeyFields", Integer.toString(indexRowLength));
        indexCC.close();
        CardinalityCounter cCount = null;
        boolean statisticsExist = false;
        if (!this.truncateTable) {
            long numRows;
            this.sorters[index].completedInserts();
            this.sorters[index] = null;
            if (this.td.statisticsExist(cd)) {
                cCount = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[index]));
                statisticsExist = true;
            } else {
                cCount = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[index]));
            }
            newIndexCongloms[index] = this.tc.createAndLoadConglomerate(indexType, this.indexRows[index].getRowArray(), this.ordering[index], this.collation[index], properties, 0, cCount, null);
            if (statisticsExist) {
                dd.dropStatisticsDescriptors(this.td.getUUID(), cd.getUUID(), this.tc);
            }
            if ((numRows = cCount.getRowCount()) > 0L) {
                long[] c = cCount.getCardinality();
                for (int i = 0; i < c.length; ++i) {
                    StatisticsDescriptor statDesc = new StatisticsDescriptor(dd, dd.getUUIDFactory().createUUID(), cd.getUUID(), this.td.getUUID(), "I", new StatisticsImpl(numRows, c[i]), i + 1);
                    dd.addDescriptor(statDesc, null, 14, true, this.tc);
                }
            }
        } else {
            newIndexCongloms[index] = this.tc.createConglomerate(indexType, this.indexRows[index].getRowArray(), this.ordering[index], this.collation[index], properties, 0);
            if (this.td.statisticsExist(cd)) {
                dd.dropStatisticsDescriptors(this.td.getUUID(), cd.getUUID(), this.tc);
            }
        }
        if (oldName != null) {
            this.updateIndex(this.sd, this.td, this.activation, oldName, newName, newIndexCongloms[index]);
        } else {
            dd.updateConglomerateDescriptor(this.td.getConglomerateDescriptors(this.indexConglomerateNumbers[index]), newIndexCongloms[index], this.tc);
        }
        this.tc.dropConglomerate(this.indexConglomerateNumbers[index]);
    }

    private void updateRefColsForIndexes(boolean cascade, Activation activation, String columnName) throws StandardException {
        int k;
        int size;
        int[] baseColumnPositions;
        IndexRowGenerator irg;
        int i;
        IndexLister indexLister = this.td.getIndexLister();
        IndexRowGenerator[] irgs = indexLister.getIndexRowGenerators();
        long[] indexCongloms = indexLister.getIndexConglomerateNumbers();
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        if (!cascade) {
            for (i = 0; i < irgs.length; ++i) {
                irg = irgs[i];
                if (irg == null) continue;
                baseColumnPositions = irg.baseColumnPositions();
                size = baseColumnPositions.length;
                for (k = 0; k < size; ++k) {
                    if (baseColumnPositions[k] != this.droppedColumnPosition) continue;
                    ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(indexCongloms[i]);
                    throw StandardException.newException("X0Y25.S", dd.getDependencyManager().getActionString(37), (Object)columnName, (Object)"INDEX", (Object)cd.getConglomerateName());
                }
            }
        }
        for (i = 0; i < irgs.length; ++i) {
            irg = irgs[i];
            if (irg == null) continue;
            baseColumnPositions = irg.baseColumnPositions();
            size = baseColumnPositions.length;
            for (k = 0; k < size; ++k) {
                if (baseColumnPositions[k] > this.droppedColumnPosition) {
                    int n = k;
                    baseColumnPositions[n] = baseColumnPositions[n] - 1;
                    continue;
                }
                if (baseColumnPositions[k] != this.droppedColumnPosition) continue;
                assert (cascade);
                ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(indexCongloms[i]);
                this.dropConglomerate(cd, this.td, activation, lcc);
                activation.addWarning(StandardException.newWarning("01506", new Object[]{cd.getConglomerateName(), this.td.getName(), "ALTER TABLE DROP COLUMN " + columnName}, null));
            }
        }
    }

    private void getAffectedIndexes(Activation activation) throws StandardException {
        Object[] compressIndexResult;
        IndexLister indexLister = this.td.getIndexLister();
        this.compressIRGs = indexLister.getIndexRowGenerators();
        this.numIndexes = this.compressIRGs.length;
        this.indexConglomerateNumbers = indexLister.getIndexConglomerateNumbers();
        ArrayList newCongloms = new ArrayList();
        if (!this.compressTable && !this.truncateTable) {
            for (int i = 0; i < this.compressIRGs.length; ++i) {
                ConglomerateDescriptor cd;
                int j;
                int[] baseColumnPositions = this.compressIRGs[i].baseColumnPositions();
                for (j = 0; j < baseColumnPositions.length && baseColumnPositions[j] != this.droppedColumnPosition; ++j) {
                }
                if (j == baseColumnPositions.length) continue;
                if (baseColumnPositions.length == 1 || this.behavior == 0 && this.compressIRGs[i].isUnique()) {
                    --this.numIndexes;
                    cd = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[i]);
                    this.dropConglomerate(cd, this.td, true, newCongloms, activation, activation.getLanguageConnectionContext());
                    this.compressIRGs[i] = null;
                    continue;
                }
                if (!this.compressIRGs[i].isUnique()) continue;
                cd = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[i]);
                throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), (Object)this.columnInfo[0].name, (Object)"UNIQUE INDEX", (Object)cd.getConglomerateName());
            }
            this.createNewBackingCongloms(newCongloms, this.indexConglomerateNumbers, activation, this.dd);
            IndexRowGenerator[] newIRGs = new IndexRowGenerator[this.numIndexes];
            long[] newIndexConglomNumbers = new long[this.numIndexes];
            int i = 0;
            int j = 0;
            while (i < this.numIndexes) {
                while (this.compressIRGs[j] == null) {
                    ++j;
                }
                int[] baseColumnPositions = this.compressIRGs[j].baseColumnPositions();
                newIRGs[i] = this.compressIRGs[j];
                newIndexConglomNumbers[i] = this.indexConglomerateNumbers[j];
                boolean[] isAscending = this.compressIRGs[j].isAscending();
                boolean reMakeArrays = false;
                int size = baseColumnPositions.length;
                for (int k = 0; k < size; ++k) {
                    if (baseColumnPositions[k] > this.droppedColumnPosition) {
                        int n = k;
                        baseColumnPositions[n] = baseColumnPositions[n] - 1;
                        continue;
                    }
                    if (baseColumnPositions[k] != this.droppedColumnPosition) continue;
                    baseColumnPositions[k] = 0;
                    reMakeArrays = true;
                }
                if (reMakeArrays) {
                    int[] newBCP = new int[--size];
                    boolean[] newIsAscending = new boolean[size];
                    int step = 0;
                    for (int k = 0; k < size; ++k) {
                        if (step == 0 && baseColumnPositions[k + step] == 0) {
                            ++step;
                        }
                        newBCP[k] = baseColumnPositions[k + step];
                        newIsAscending[k] = isAscending[k + step];
                    }
                    IndexDescriptor id = this.compressIRGs[j].getIndexDescriptor();
                    id.setBaseColumnPositions(newBCP);
                    id.setIsAscending(newIsAscending);
                    id.setNumberOfOrderedColumns(id.numberOfOrderedColumns() - 1);
                }
                ++i;
                ++j;
            }
            this.compressIRGs = newIRGs;
            this.indexConglomerateNumbers = newIndexConglomNumbers;
        }
        if ((compressIndexResult = this.compressIndexArrays(this.indexConglomerateNumbers, this.compressIRGs)) != null) {
            this.indexConglomerateNumbers = (long[])compressIndexResult[1];
            this.compressIRGs = (IndexRowGenerator[])compressIndexResult[2];
            this.numIndexes = this.indexConglomerateNumbers.length;
        }
        this.indexedCols = new FormatableBitSet(this.compressTable || this.truncateTable ? this.td.getNumberOfColumns() + 1 : this.td.getNumberOfColumns());
        for (int index = 0; index < this.numIndexes; ++index) {
            int[] colIds = this.compressIRGs[index].getIndexDescriptor().baseColumnPositions();
            for (int index2 = 0; index2 < colIds.length; ++index2) {
                this.indexedCols.set(colIds[index2]);
            }
        }
    }

    private void createNewBackingCongloms(ArrayList newConglomActions, long[] ixCongNums, Activation activation, DataDictionary dd) throws StandardException {
        int sz = newConglomActions.size();
        for (int i = 0; i < sz; ++i) {
            int j;
            CreateIndexConstantAction ca = (CreateIndexConstantAction)newConglomActions.get(i);
            if (dd.getConglomerateDescriptor(ca.getCreatedUUID()) == null) continue;
            this.executeConglomReplacement(ca, activation);
            long oldCongNum = ca.getReplacedConglomNumber();
            long newCongNum = ca.getCreatedConglomNumber();
            ConglomerateDescriptor[] tdCDs = this.td.getConglomerateDescriptors(oldCongNum);
            for (j = 0; j < tdCDs.length; ++j) {
                tdCDs[j].setConglomerateNumber(newCongNum);
            }
            if (ixCongNums == null) continue;
            for (j = 0; j < ixCongNums.length; ++j) {
                if (ixCongNums[j] != oldCongNum) continue;
                ixCongNums[j] = newCongNum;
            }
        }
    }

    private void setUpAllSorts(ExecRow sourceRow, RowLocation rl) throws StandardException {
        int index;
        this.ordering = new ColumnOrdering[this.numIndexes][];
        this.collation = new int[this.numIndexes][];
        this.needToDropSort = new boolean[this.numIndexes];
        this.sortIds = new long[this.numIndexes];
        int[] base_table_collation_ids = this.td.getColumnCollationIds();
        for (index = 0; index < this.numIndexes; ++index) {
            this.indexRows[index] = this.compressIRGs[index].getIndexRowTemplate();
            this.compressIRGs[index].getIndexRow(sourceRow, rl, this.indexRows[index], null);
            this.collation[index] = this.compressIRGs[index].getColumnCollationIds(this.td.getColumnDescriptorList());
            int[] baseColumnPositions = this.compressIRGs[index].baseColumnPositions();
            boolean[] isAscending = this.compressIRGs[index].isAscending();
            int numColumnOrderings = baseColumnPositions.length + 1;
            boolean reuseWrappers = this.numIndexes == 1;
            BasicSortObserver sortObserver = new BasicSortObserver(false, false, this.indexRows[index], reuseWrappers);
            this.ordering[index] = new ColumnOrdering[numColumnOrderings];
            for (int ii = 0; ii < numColumnOrderings - 1; ++ii) {
                this.ordering[index][ii] = new IndexColumnOrder(ii, isAscending[ii]);
            }
            this.ordering[index][numColumnOrderings - 1] = new IndexColumnOrder(numColumnOrderings - 1);
            this.sortIds[index] = this.tc.createSort(null, this.indexRows[index].getClone(), this.ordering[index], sortObserver, false, this.estimatedRowCount, -1, 0L);
        }
        this.sorters = new SortController[this.numIndexes];
        for (index = 0; index < this.numIndexes; ++index) {
            this.sorters[index] = this.tc.openSort(this.sortIds[index]);
            this.needToDropSort[index] = true;
        }
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return null;
    }

    @Override
    public ExecRow getNextRowFromRowSource() throws StandardException {
        this.currentRow = null;
        if (!(this.doneScan || this.currentCompressRow != this.bulkFetchSize && this.validRow[this.currentCompressRow])) {
            int index;
            int bulkFetched = 0;
            bulkFetched = this.compressHeapGSC.fetchNextGroup(this.baseRowArray, this.compressRL);
            this.doneScan = bulkFetched != this.bulkFetchSize;
            this.currentCompressRow = 0;
            this.rowCount += bulkFetched;
            for (index = 0; index < bulkFetched; ++index) {
                this.validRow[index] = true;
            }
            for (index = bulkFetched; index < this.bulkFetchSize; ++index) {
                this.validRow[index] = false;
            }
        }
        if (this.validRow[this.currentCompressRow]) {
            if (this.compressTable) {
                this.currentRow = this.baseRow[this.currentCompressRow];
            } else {
                if (this.currentRow == null) {
                    this.currentRow = this.activation.getExecutionFactory().getValueRow(this.baseRowArray[this.currentCompressRow].length - 1);
                }
                for (int i = 0; i < this.currentRow.nColumns(); ++i) {
                    this.currentRow.setColumn(i + 1, i < this.droppedColumnPosition - 1 ? this.baseRow[this.currentCompressRow].getColumn(i + 1) : this.baseRow[this.currentCompressRow].getColumn(i + 1 + 1));
                }
            }
            ++this.currentCompressRow;
        }
        if (this.currentRow != null) {
            if (this.compressIRGs.length > 0) {
                this.currentRow = this.currentRow.getClone(this.indexedCols);
            }
            return this.currentRow;
        }
        return null;
    }

    @Override
    public boolean needsToClone() {
        return true;
    }

    @Override
    public void closeRowSource() {
    }

    @Override
    public boolean needsRowLocation() {
        return this.numIndexes > 0;
    }

    @Override
    public void rowLocation(RowLocation rl) throws StandardException {
        if (this.compressIRGs.length > 0) {
            this.objectifyStreamingColumns();
            int maxIndex = this.compressIRGs.length;
            if (maxIndex > 1 && this.sequential) {
                maxIndex = 1;
            }
            for (int index = 0; index < maxIndex; ++index) {
                this.insertIntoSorter(index, rl);
            }
        }
    }

    private void objectifyStreamingColumns() throws StandardException {
        for (int i = 0; i < this.currentRow.getRowArray().length; ++i) {
            if (!this.indexedCols.get(i + 1) || !(this.currentRow.getRowArray()[i] instanceof StreamStorable)) continue;
            this.currentRow.getRowArray()[i].getObject();
        }
    }

    private void insertIntoSorter(int index, RowLocation rl) throws StandardException {
        this.indexRows[index].getNewObjectArray();
        this.compressIRGs[index].getIndexRow(this.currentRow, (RowLocation)rl.cloneObject(), this.indexRows[index], null);
        this.sorters[index].insert(this.indexRows[index]);
    }

    private void cleanUp() throws StandardException {
        int index;
        if (this.compressHeapCC != null) {
            this.compressHeapCC.close();
            this.compressHeapCC = null;
        }
        if (this.compressHeapGSC != null) {
            this.closeBulkFetchScan();
        }
        if (this.sorters != null) {
            for (index = 0; index < this.compressIRGs.length; ++index) {
                if (this.sorters[index] != null) {
                    this.sorters[index].completedInserts();
                }
                this.sorters[index] = null;
            }
        }
        if (this.needToDropSort != null) {
            for (index = 0; index < this.needToDropSort.length; ++index) {
                if (!this.needToDropSort[index]) continue;
                this.tc.dropSort(this.sortIds[index]);
                this.needToDropSort[index] = false;
            }
        }
    }

    @Override
    public final String getSchemaName() {
        return this.sd.getSchemaName();
    }

    @Override
    public final String getTableName() {
        return this.tableName;
    }

    static int getNumBucketsOrSize(Region<?, ?> region, LanguageConnectionContext lcc) throws StandardException {
        if (Misc.initialDDLReplayInProgress()) {
            return 0;
        }
        DataPolicy policy = region.getAttributes().getDataPolicy();
        if (policy.withPartitioning()) {
            PartitionedRegion pregion = (PartitionedRegion)region;
            return pregion.getRegionAdvisor().getCreatedBucketsCount();
        }
        if (policy.withReplication() || !policy.withStorage()) {
            GemFireRegionSizeResultSet.RegionSizeMessage rmsg = new GemFireRegionSizeResultSet.RegionSizeMessage(region.getFullPath(), new GfxdSingleResultCollector(), (LocalRegion)region, null, lcc);
            try {
                Object result = rmsg.executeFunction();
                assert (result instanceof Integer);
                return (Integer)result;
            }
            catch (SQLException sqle) {
                throw Misc.wrapRemoteSQLException(sqle, sqle, null);
            }
        }
        return region.size();
    }

    private int getSemiRowCount(TransactionController tc) throws StandardException {
        switch (AlterTableConstantAction.getRowCount(tc, this.td, this.numBuckets)) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    public boolean isTruncateTable() {
        return this.truncateTable;
    }

    public static int getRowCount(TransactionController tc, TableDescriptor td, int numBuckets) throws StandardException {
        if (Misc.initialDDLReplayInProgress()) {
            return 0;
        }
        LanguageConnectionContext lcc = tc.getLanguageConnectionContext();
        Region region = Misc.getRegionForTableByPath(Misc.getFullTableName(td, lcc), false);
        DataPolicy policy = region.getAttributes().getDataPolicy();
        if (policy.withReplication() || !policy.withStorage()) {
            if (numBuckets > 0) {
                return numBuckets;
            }
            GemFireRegionSizeResultSet.RegionSizeMessage rmsg = new GemFireRegionSizeResultSet.RegionSizeMessage(region.getFullPath(), new GfxdSingleResultCollector(), (LocalRegion)region, null, lcc);
            try {
                Object result = rmsg.executeFunction();
                assert (result instanceof Integer);
                return (Integer)result;
            }
            catch (SQLException sqle) {
                throw Misc.wrapRemoteSQLException(sqle, sqle, null);
            }
        }
        return region.size();
    }

    private void updateNewColumnToDefault(Activation activation, String columnName, String defaultText, LanguageConnectionContext lcc, ColumnDescriptor cd) throws StandardException {
        String defaultQuery = "VALUES " + defaultText;
        PreparedStatement ps = lcc.prepareInternalStatement(defaultQuery, (short)0);
        ResultSet rs = ps.execute(lcc, true, 0L);
        ExecRow row = rs.getNextRow();
        if (row != null) {
            DataValueDescriptor columnDefault = row.getColumn(1);
            if (columnDefault.getTypeFormatId() != cd.getType().getDVDTypeFormatId()) {
                DataValueDescriptor dvd = cd.getType().getNull();
                dvd.setValue(columnDefault);
                columnDefault = dvd;
            }
            cd.setColumnDefault(columnDefault);
        }
        rs.close(false);
    }

    private static void executeUpdate(LanguageConnectionContext lcc, String updateStmt) throws StandardException {
        PreparedStatement ps = lcc.prepareInternalStatement(updateStmt, (short)0);
        ResultSet rs = ps.execute(lcc, true, 0L);
        rs.close(false);
    }

    private long getColumnMax(Activation activation, TableDescriptor td, String columnName, long increment, long initial) throws StandardException {
        String maxStr = increment > 0L ? "MAX" : "MIN";
        String maxStmt = "SELECT  " + maxStr + "(" + IdUtil.normalToDelimited(columnName) + ") FROM " + IdUtil.mkQualifiedName(td.getSchemaName(), td.getName());
        short execFlags = 0;
        execFlags = GemFireXDUtils.set(execFlags, (short)2);
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        PreparedStatement ps = lcc.prepareInternalStatement(maxStmt, execFlags);
        ResultSet rs = ps.execute(lcc, false, 0L);
        DataValueDescriptor[] rowArray = rs.getNextRow().getRowArray();
        rs.close(false);
        rs.finish();
        return rowArray[0].getLong();
    }

    private void dropAllColumnDefaults(UUID tableId, DataDictionary dd) throws StandardException {
        ColumnDescriptorList cdl = this.td.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor cd = cdl.elementAt(index);
            if (cd.getDefaultInfo() == null) continue;
            DefaultDescriptor defaultDesc = cd.getDefaultDescriptor(dd);
            this.dm.clearDependencies(this.lcc, defaultDesc);
        }
    }

    private void openBulkFetchScan(long heapConglomNumber) throws StandardException {
        this.doneScan = false;
        this.compressHeapGSC = this.tc.openGroupFetchScan(heapConglomNumber, false, 0, 7, 5, null, null, 0, null, null, 0);
    }

    private void closeBulkFetchScan() throws StandardException {
        this.compressHeapGSC.close();
        this.compressHeapGSC = null;
    }

    private void updateNewAutoincrementColumn(Activation activation, String columnName, long initial, long increment) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        lcc.setAutoincrementUpdate(true);
        lcc.autoincrementCreateCounter(this.td.getSchemaName(), this.td.getName(), columnName, new Long(initial), increment, 0);
        String updateStmt = "UPDATE " + IdUtil.mkQualifiedName(this.td.getSchemaName(), this.td.getName()) + " SET " + IdUtil.normalToDelimited(columnName) + "=" + "com.pivotal.gemfirexd.internal.iapi.db.ConnectionInfo::" + "nextAutoincrementValue(" + StringUtil.quoteStringLiteral(this.td.getSchemaName()) + "," + StringUtil.quoteStringLiteral(this.td.getName()) + "," + StringUtil.quoteStringLiteral(columnName) + ")";
        try {
            AlterTableConstantAction.executeUpdate(lcc, updateStmt);
        }
        catch (StandardException se) {
            if (se.getMessageId().equals("22003")) {
                throw StandardException.newException("42Z24", se, (Object)this.td.getName(), (Object)columnName);
            }
            throw se;
        }
        finally {
            lcc.autoincrementFlushCache(this.td.getUUID());
            lcc.setAutoincrementUpdate(false);
        }
    }

    private boolean validateNotNullConstraint(String[] columnNames, boolean[] nullCols, int numRows, LanguageConnectionContext lcc, String errorMsg) throws StandardException {
        boolean foundNullable = false;
        StringBuilder constraintText = new StringBuilder();
        for (int colCtr = 0; colCtr < columnNames.length; ++colCtr) {
            ColumnDescriptor cd = this.td.getColumnDescriptor(columnNames[colCtr]);
            if (cd == null) {
                throw StandardException.newException("42X14", (Object)columnNames[colCtr], (Object)this.td.getName());
            }
            if (!cd.getType().isNullable()) continue;
            if (numRows > 0) {
                if (foundNullable) {
                    constraintText.append(" AND ");
                }
                constraintText.append(IdUtil.normalToDelimited(columnNames[colCtr]) + " IS NOT NULL ");
            }
            foundNullable = true;
            nullCols[colCtr] = true;
        }
        if (foundNullable && numRows > 0 && !ConstraintConstantAction.validateConstraint(null, constraintText.toString(), this.td, lcc, false)) {
            if (errorMsg.equals("X0Y63.S")) {
                throw StandardException.newException("X0Y63.S", this.td.getQualifiedName());
            }
            throw StandardException.newException("X0Y80.S", (Object)this.td.getQualifiedName(), (Object)columnNames[0]);
        }
        return foundNullable;
    }

    private Object[] compressIndexArrays(long[] indexCIDS, IndexRowGenerator[] irgs) {
        long[] workSpace = new long[indexCIDS.length];
        int j = 0;
        int k = indexCIDS.length - 1;
        for (int i = 0; i < indexCIDS.length; ++i) {
            int m;
            for (m = 0; m < j; ++m) {
                if (indexCIDS[i] != workSpace[m]) continue;
                workSpace[k--] = i;
                break;
            }
            if (m != j) continue;
            workSpace[j++] = indexCIDS[i];
        }
        if (j < indexCIDS.length) {
            long[] newIndexCIDS = new long[j];
            IndexRowGenerator[] newIrgs = new IndexRowGenerator[j];
            int[] duplicateIndexes = new int[indexCIDS.length - j];
            k = 0;
            int n = indexCIDS.length - 1;
            for (int m = 0; m < indexCIDS.length; ++m) {
                if (m < j) {
                    newIndexCIDS[m] = workSpace[m];
                } else {
                    duplicateIndexes[indexCIDS.length - m - 1] = (int)workSpace[m];
                }
                if (n >= j && m == (int)workSpace[n]) {
                    --n;
                    continue;
                }
                newIrgs[k] = irgs[m];
                ++k;
            }
            Object[] returnValue = new Object[]{duplicateIndexes, newIndexCIDS, newIrgs};
            return returnValue;
        }
        return null;
    }

    @Override
    public boolean isCancellable() {
        return !this.truncateTable;
    }

    public ConstraintConstantAction[] getConstraintConstantActions() {
        return this.constraintActions;
    }
}

