/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.sql.compile.SQLMatcher;
import com.pivotal.gemfirexd.internal.engine.sql.compile.SQLMatcherTokenManager;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Parser;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CharStream;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParseException;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SQLParser;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SQLParserTokenManager;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TokenMgrError;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UCode_CharStream;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UCode_MatcherCharStream;
import java.io.StringReader;

public class ParserImpl
implements Parser {
    static final int LARGE_TOKEN_SIZE = 128;
    private SQLParser cachedParser;
    private SQLMatcher cachedMatcher;
    protected Object cachedTokenManager;
    protected Object cachedMatcherTokenManager;
    protected CharStream charStream;
    protected com.pivotal.gemfirexd.internal.engine.sql.compile.CharStream matcherCharStream;
    protected String SQLtext;
    protected final CompilerContext cc;
    private boolean gfxdSubactivationNeeded = false;

    public ParserImpl(CompilerContext cc) {
        this.cc = cc;
    }

    @Override
    public StatementNode parseStatement(String statementSQLText) throws StandardException {
        return this.parseStatement(statementSQLText, null);
    }

    protected Object getTokenManager() {
        SQLParserTokenManager tm = (SQLParserTokenManager)this.cachedTokenManager;
        if (tm == null) {
            tm = new SQLParserTokenManager(this.charStream);
            this.cachedTokenManager = tm;
        } else {
            tm.ReInit(this.charStream);
        }
        return tm;
    }

    protected Object getMatcherTokenManager() {
        SQLMatcherTokenManager tm = (SQLMatcherTokenManager)this.cachedTokenManager;
        if (tm == null) {
            tm = new SQLMatcherTokenManager(this.matcherCharStream);
            this.cachedTokenManager = tm;
        } else {
            tm.ReInit(this.matcherCharStream);
        }
        return tm;
    }

    private SQLParser getParser() {
        SQLParserTokenManager tm = (SQLParserTokenManager)this.getTokenManager();
        SQLParser p = this.cachedParser;
        if (p == null) {
            p = new SQLParser(tm);
            p.setCompilerContext(this.cc);
            this.cachedParser = p;
        } else {
            p.ReInit(tm);
        }
        p.setGfxdSubactivationFlag(this.gfxdSubactivationNeeded);
        return p;
    }

    private SQLMatcher getMatcher() {
        SQLMatcherTokenManager tm = (SQLMatcherTokenManager)this.getMatcherTokenManager();
        SQLMatcher m = this.cachedMatcher;
        if (m == null) {
            m = new SQLMatcher(tm);
            m.setCompilerContext(this.cc);
            this.cachedMatcher = m;
        } else {
            m.ReInit(tm);
        }
        return m;
    }

    @Override
    public StatementNode parseStatement(String statementSQLText, Object[] paramDefaults) throws StandardException {
        StringReader sqlText = new StringReader(statementSQLText);
        if (this.charStream == null) {
            this.charStream = new UCode_CharStream(sqlText, 1, 1, 128);
        } else {
            this.charStream.ReInit(sqlText, 1, 1, 128);
        }
        this.SQLtext = statementSQLText;
        try {
            return this.getParser().Statement(statementSQLText, paramDefaults);
        }
        catch (TokenMgrError e) {
            this.cachedParser = null;
            throw StandardException.newException("42X02", e.getMessage());
        }
        catch (ParseException e) {
            throw StandardException.newException("42X01", e.getMessage());
        }
    }

    @Override
    public int matchStatement(String statementSQLText, Object[] paramDefaults) throws StandardException {
        StringReader sqlText = new StringReader(statementSQLText);
        if (this.matcherCharStream == null) {
            this.matcherCharStream = new UCode_MatcherCharStream(sqlText, 1, 1, 128);
        } else {
            this.matcherCharStream.ReInit(sqlText, 1, 1, 128);
        }
        this.SQLtext = statementSQLText;
        try {
            return this.getMatcher().Statement(statementSQLText, paramDefaults);
        }
        catch (com.pivotal.gemfirexd.internal.engine.sql.compile.ParseException e) {
            throw StandardException.newException("42X01", e.getMessage());
        }
        catch (com.pivotal.gemfirexd.internal.engine.sql.compile.TokenMgrError e) {
            this.cachedMatcher = null;
            SanityManager.DEBUG_PRINT((String)"warning:StatementMatching", (String)("Exception while parsing generalized statement " + this.SQLtext + ": " + e));
            throw StandardException.newException("42X02", e.getMessage());
        }
    }

    @Override
    public String getSQLtext() {
        return this.SQLtext;
    }

    @Override
    public void setGfxdSubactivationFlag(boolean flag) {
        this.gfxdSubactivationNeeded = flag;
    }
}

