/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.sql.compile.CollectExpressionOperandsVisitor;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RequiredRowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RowOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortCostController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseTableNumbersVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderedColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderedColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;

public class OrderByList
extends OrderedColumnList
implements RequiredRowOrdering {
    private boolean allAscending = true;
    private boolean alwaysSort;
    private ResultSetNode resultToSort;
    private SortCostController scc;
    private Object[] resultRow;
    private ColumnOrdering[] columnOrdering;
    private int estimatedRowSize;
    private boolean sortNeeded = true;

    public void addOrderByColumn(OrderByColumn column) {
        this.addElement(column);
        if (!column.isAscending()) {
            this.allAscending = false;
        }
    }

    boolean allAscending() {
        return this.allAscending;
    }

    @Override
    public void printSubNodes(int depth) {
        for (int index = 0; index < this.size(); ++index) {
            ((OrderByColumn)this.elementAt(index)).treePrint(depth);
        }
    }

    public void bindOrderByColumns(ResultSetNode target) throws StandardException {
        this.resultToSort = target;
        int size = this.size();
        if (size > 1012) {
            throw StandardException.newException("54004", 1012);
        }
        for (int index = 0; index < size; ++index) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(index);
            obc.bindOrderByColumn(target, this);
            if (obc.getResultColumn().getExpression() instanceof ColumnReference) continue;
            this.alwaysSort = true;
        }
    }

    void closeGap(int gap) {
        for (int index = 0; index < this.size(); ++index) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(index);
            obc.collapseAddedColumnGap(gap);
        }
    }

    public void pullUpOrderByColumns(ResultSetNode target) throws StandardException {
        this.resultToSort = target;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(index);
            obc.pullUpOrderByColumn(target);
        }
    }

    boolean isInOrderPrefix(ResultColumnList sourceRCL) {
        boolean inOrderPrefix = true;
        int rclSize = sourceRCL.size();
        if (this.size() > sourceRCL.size()) {
            SanityManager.THROWASSERT((String)("size() (" + this.size() + ") expected to be <= sourceRCL.size() (" + sourceRCL.size() + ")"));
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if (((OrderByColumn)this.elementAt(index)).getResultColumn() == (ResultColumn)sourceRCL.elementAt(index)) continue;
            return false;
        }
        return true;
    }

    void resetToSourceRCs() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(index);
            obc.resetToSourceRC();
        }
    }

    ResultColumnList reorderRCL(ResultColumnList resultColumns) throws StandardException {
        ResultColumnList newRCL = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(index);
            newRCL.addElement(obc.getResultColumn());
            resultColumns.removeElement(obc.getResultColumn());
        }
        newRCL.destructiveAppend(resultColumns);
        newRCL.resetVirtualColumnIds();
        newRCL.copyOrderBySelect(resultColumns);
        return newRCL;
    }

    void removeConstantColumns(PredicateList whereClause) {
        for (int loc = this.size() - 1; loc >= 0; --loc) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(loc);
            if (!obc.constantColumn(whereClause)) continue;
            this.removeElementAt(loc);
        }
    }

    void removeDupColumns() {
        block0: for (int loc = this.size() - 1; loc > 0; --loc) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(loc);
            int colPosition = obc.getColumnPosition();
            for (int inner = 0; inner < loc; ++inner) {
                OrderByColumn prev_obc = (OrderByColumn)this.elementAt(inner);
                if (colPosition != prev_obc.getColumnPosition()) continue;
                this.removeElementAt(loc);
                continue block0;
            }
        }
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb, ResultSetNode child) throws StandardException {
        if (!this.sortNeeded) {
            child.generate(acb, mb);
            return;
        }
        CompilerContext cc = this.getCompilerContext();
        int orderItem = acb.addItem(acb.getColumnOrdering(this));
        acb.pushGetResultSetFactoryExpression(mb);
        child.generate(acb, mb);
        int resultSetNumber = cc.getNextResultSetNumber();
        mb.push(false);
        mb.push(false);
        mb.push(orderItem);
        child.getResultColumns().generateHolder(acb, mb);
        mb.push(child.getResultColumns().getTotalColumnSize());
        mb.push(resultSetNumber);
        CostEstimate costEstimate = child.getFinalCostEstimate();
        mb.push(costEstimate.rowCount());
        mb.push(costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getSortResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 9);
    }

    @Override
    public int sortRequired(RowOrdering rowOrdering) throws StandardException {
        return this.sortRequired(rowOrdering, null);
    }

    @Override
    public int sortRequired(RowOrdering rowOrdering, JBitSet tableMap) throws StandardException {
        if (this.alwaysSort) {
            return 1;
        }
        int position = 0;
        int size = this.size();
        for (int loc = 0; loc < size; ++loc) {
            OrderedColumn obc = this.getOrderedColumn(loc);
            if (obc.isNullsOrderedLow()) {
                return 1;
            }
            ValueNode expr = obc.getResultColumn().getExpression();
            if (!(expr instanceof ColumnReference)) {
                return 1;
            }
            ColumnReference cr = (ColumnReference)expr;
            if (tableMap != null && !tableMap.get(cr.getTableNumber())) {
                for (int remainingPosition = loc + 1; remainingPosition < this.size(); ++remainingPosition) {
                    ColumnReference remainingcr;
                    OrderedColumn remainingobc = this.getOrderedColumn(loc);
                    ResultColumn remainingrc = remainingobc.getResultColumn();
                    ValueNode remainingexpr = remainingrc.getExpression();
                    if (!(remainingexpr instanceof ColumnReference) || !tableMap.get((remainingcr = (ColumnReference)remainingexpr).getTableNumber())) continue;
                    return 1;
                }
                return 3;
            }
            if (rowOrdering.alwaysOrdered(cr.getTableNumber())) continue;
            if (!rowOrdering.orderedOnColumn(obc.isAscending() ? 1 : 2, position, cr.getTableNumber(), cr.getColumnNumber())) {
                return 1;
            }
            ++position;
        }
        return 3;
    }

    @Override
    public void estimateCost(double estimatedInputRows, RowOrdering rowOrdering, CostEstimate resultCost) throws StandardException {
        long inputRows;
        if (this.scc == null) {
            this.scc = this.getCompilerContext().getSortCostController();
            this.resultRow = this.resultToSort.getResultColumns().buildEmptyRow().getRowArray();
            this.columnOrdering = this.getColumnOrdering();
            this.estimatedRowSize = this.resultToSort.getResultColumns().getTotalColumnSize();
        }
        long exportRows = inputRows = (long)estimatedInputRows;
        double sortCost = this.scc.getSortCost((DataValueDescriptor[])this.resultRow, this.columnOrdering, false, inputRows, exportRows, this.estimatedRowSize);
        resultCost.setCost(sortCost, estimatedInputRows, estimatedInputRows);
    }

    @Override
    public void sortNeeded() {
        this.sortNeeded = true;
    }

    @Override
    public void sortNotNeeded() {
        this.sortNeeded = false;
    }

    void remapColumnReferencesToExpressions() throws StandardException {
    }

    @Override
    public boolean getSortNeeded() {
        return this.sortNeeded;
    }

    boolean requiresDescending(ColumnReference cRef, int numOptimizables) throws StandardException {
        int size = this.size();
        JBitSet tNum = new JBitSet(numOptimizables);
        BaseTableNumbersVisitor btnVis = new BaseTableNumbersVisitor(tNum);
        cRef.accept(btnVis);
        int crTableNumber = tNum.getFirstSetBit();
        int crColPosition = btnVis.getColumnNumber();
        if (crTableNumber < 0 || crColPosition < 0) {
            SanityManager.THROWASSERT((String)("Failed to find table/column number for column '" + cRef.getColumnName() + "' when checking for an " + "ORDER BY requirement."));
        }
        if (!tNum.hasSingleBitSet()) {
            SanityManager.THROWASSERT((String)("Expected ColumnReference '" + cRef.getColumnName() + "' to reference exactly one table, but tables found " + "were: " + tNum));
        }
        for (int loc = 0; loc < size; ++loc) {
            OrderedColumn obc = this.getOrderedColumn(loc);
            ResultColumn rcOrderBy = obc.getResultColumn();
            btnVis.reset();
            rcOrderBy.accept(btnVis);
            int obTableNumber = tNum.getFirstSetBit();
            int obColPosition = btnVis.getColumnNumber();
            if (!tNum.hasSingleBitSet()) {
                SanityManager.THROWASSERT((String)("Expected ResultColumn '" + rcOrderBy.getColumnName() + "' to reference " + "exactly one table, but found: " + tNum));
            }
            if (obColPosition < 0) {
                SanityManager.THROWASSERT((String)("Failed to find orderBy column number for ORDER BY check on column '" + cRef.getColumnName() + "'."));
            }
            if (crTableNumber != obTableNumber || crColPosition != obColPosition) continue;
            return !obc.isAscending();
        }
        return false;
    }

    public void adjustForWindowFunctionColumns() throws StandardException {
        this.resultRow = this.resultToSort.getResultColumns().buildEmptyRow().getRowArray();
        for (int index = 0; index < this.size(); ++index) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(index);
            obc.bindOrderByColumn(this.resultToSort, this);
        }
        this.columnOrdering = this.getColumnOrdering();
    }

    public boolean isDistinctOrderable() {
        if (this.hasNullsOrderedLow()) {
            return false;
        }
        boolean isExpr = false;
        int size = this.size();
        for (int i = 0; i < size && !isExpr; ++i) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(i);
            ValueNode expr = obc.getResultColumn().getExpression();
            isExpr = expr instanceof ColumnReference || expr instanceof VirtualColumnNode;
        }
        return isExpr;
    }

    public final boolean hasNullsOrderedLow() {
        int size = this.size();
        for (int loc = 0; loc < size; ++loc) {
            OrderedColumn obc = this.getOrderedColumn(loc);
            if (!obc.isNullsOrderedLow()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyAgrregateInOrderByList(boolean isCompilationAsDataStoreNode) throws StandardException {
        boolean isAgg = false;
        CollectExpressionOperandsVisitor exprSubstitutor = new CollectExpressionOperandsVisitor(null, null, isCompilationAsDataStoreNode);
        int size = this.size();
        for (int i = 0; i < size && !isAgg; ++i) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(i);
            ValueNode expr = obc.getResultColumn().getExpression();
            isAgg = exprSubstitutor.visitHasAggregateVisitorOnly(expr);
        }
        return isAgg;
    }
}

