/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AndNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryRelationalOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNodeList;
import java.util.ArrayList;
import java.util.List;

public final class OrListNode
extends AndNode {
    protected int tableNumber;
    protected THashSet columns;
    protected ValueNodeList vnl;
    protected transient ArrayList<ElementSpecification> elements;

    @Override
    public void init(Object tableNum, Object cols, Object operandList) {
        this.tableNumber = (Integer)tableNum;
        this.columns = (THashSet)cols;
        this.vnl = (ValueNodeList)operandList;
        int size = this.vnl.size();
        OrNode lastNode = (OrNode)this.vnl.elementAt(size - 1);
        ValueNode ln = lastNode.getLeftOperand();
        ValueNode rn = lastNode.getRightOperand();
        while (ln instanceof AndNode) {
            AndNode an = (AndNode)ln;
            ln = an.getLeftOperand();
            rn = an.getRightOperand();
        }
        while (rn instanceof AndNode) {
            rn = ((AndNode)rn).getRightOperand();
        }
        super.init(ln, rn);
    }

    @Override
    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        if (this.getCompilerContext().orListOptimizationAllowed()) {
            return this;
        }
        return this.getOrNode(0).preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
    }

    @Override
    public ValueNode changeToCNF(boolean underTopAndNode) throws StandardException {
        return this;
    }

    public final void addElement(ConglomerateDescriptor bestConglom, PredicateList predList, CostEstimate bestCost, int bulkFetch, boolean multiProbing) {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        this.elements.add(new ElementSpecification(bestConglom, predList, bestCost, bulkFetch, multiProbing));
    }

    public final boolean hasOptimizedList() {
        return this.elements != null && this.elements.size() > 0;
    }

    final List<ElementSpecification> getElements() {
        return this.elements;
    }

    public final int getTableNumber() {
        return this.tableNumber;
    }

    public final OrNode getOrNode(int index) {
        return (OrNode)this.vnl.elementAt(index);
    }

    public final ValueNodeList getValueNodes() {
        return this.vnl;
    }

    public final THashSet getColumns() {
        return this.columns;
    }

    @Override
    public String getTableName() {
        return this.getOrNode(0).getTableName();
    }

    @Override
    public String getSchemaName() {
        return this.getOrNode(0).getSchemaName();
    }

    @Override
    public String findSourceSchemaName() {
        return this.getOrNode(0).findSourceSchemaName();
    }

    @Override
    public String findSourceTableName() {
        return this.getOrNode(0).findSourceTableName();
    }

    @Override
    public double selectivity(Optimizable optTable) throws StandardException {
        double sel = 0.0;
        for (QueryTreeNode vn : this.vnl) {
            double v = ((ValueNode)vn).selectivity(optTable);
            if (!(v > sel)) continue;
            sel = v;
        }
        return sel;
    }

    @Override
    public int getLeftOperatorForCompare() {
        return 5;
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        int variantType = 3;
        int size = this.vnl.size();
        for (int index = 0; index < size; ++index) {
            OrNode on = (OrNode)this.vnl.elementAt(index);
            ValueNode vn = index != size - 1 ? on.getLeftOperand() : on;
            int vt = vn.getOrderableVariantType();
            if (variantType <= vt) continue;
            variantType = vt;
        }
        return variantType;
    }

    @Override
    protected boolean isEquivalent(ValueNode other) throws StandardException {
        if (this.isSameNodeType(other)) {
            ValueNodeList ovnl = ((OrListNode)other).vnl;
            int size = this.vnl.size();
            if (size == ovnl.size()) {
                for (int index = 0; index < size; ++index) {
                    ValueNode vn2;
                    ValueNode vn;
                    OrNode on = (OrNode)this.vnl.elementAt(index);
                    OrNode on2 = (OrNode)ovnl.elementAt(index);
                    if (index != size - 1) {
                        vn = on.getLeftOperand();
                        vn2 = on2.getLeftOperand();
                    } else {
                        vn = on;
                        vn2 = on2;
                    }
                    if (vn.isEquivalent(vn2)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        return this.getOrNode(0).categorize(referencedTabs, simplePredsOnly);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (QueryTreeNode qtn : this.vnl) {
            sb.append("ValueNode: ").append(qtn.toString());
        }
        return sb.toString();
    }

    public ColumnReference getColumnOperand(Optimizable optTable, int columnPosition) {
        FromTable ft = (FromTable)optTable;
        for (ColumnReference cr : this.columns) {
            if (!((BinaryRelationalOperatorNode)this.leftOperand).valNodeReferencesOptTable(cr, ft, false, true) || cr.getSource().getColumnPosition() != columnPosition) continue;
            return cr;
        }
        return null;
    }

    static final class ElementSpecification {
        final ConglomerateDescriptor conglom;
        final PredicateList predList;
        final CostEstimate costEstimate;
        final int bulkFetch;
        final boolean multiProbing;

        ElementSpecification(ConglomerateDescriptor conglom, PredicateList predList, CostEstimate costEstimate, int bulkFetch, boolean multiProbing) {
            this.conglom = conglom;
            this.predList = predList;
            this.costEstimate = costEstimate;
            this.bulkFetch = bulkFetch;
            this.multiProbing = multiProbing;
        }
    }
}

