/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.ExpressionClassBuilderInterface;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseJoinStrategy;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;

public class NestedLoopJoinStrategy
extends BaseJoinStrategy {
    @Override
    public boolean feasible(Optimizable innerTable, OptimizablePredicateList predList, Optimizer optimizer) throws StandardException {
        if (innerTable.supportsMultipleInstantiations()) {
            return true;
        }
        return innerTable.isMaterializable();
    }

    @Override
    public boolean multiplyBaseCostByOuterRows() {
        return true;
    }

    @Override
    public OptimizablePredicateList getBasePredicates(OptimizablePredicateList predList, OptimizablePredicateList basePredicates, Optimizable innerTable) throws StandardException {
        SanityManager.ASSERT((basePredicates == null || basePredicates.size() == 0 ? 1 : 0) != 0, (String)"The base predicate list should be empty.");
        if (predList != null) {
            predList.transferAllPredicates(basePredicates);
            basePredicates.classify(innerTable, innerTable.getCurrentAccessPath().getConglomerateDescriptor());
        }
        return basePredicates;
    }

    @Override
    public double nonBasePredicateSelectivity(Optimizable innerTable, OptimizablePredicateList predList) {
        return 1.0;
    }

    @Override
    public void putBasePredicates(OptimizablePredicateList predList, OptimizablePredicateList basePredicates) throws StandardException {
        for (int i = basePredicates.size() - 1; i >= 0; --i) {
            OptimizablePredicate pred = basePredicates.getOptPredicate(i);
            predList.addOptPredicate(pred);
            basePredicates.removeOptPredicate(i);
        }
    }

    @Override
    public void estimateCost(Optimizable innerTable, OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, CostEstimate costEstimate) {
        costEstimate.multiply(outerCost.rowCount(), costEstimate);
        optimizer.trace(23, innerTable.getTableNumber(), 0, outerCost.rowCount(), costEstimate);
    }

    @Override
    public int maxCapacity(int userSpecifiedCapacity, int maxMemoryPerTable, double perRowUsage) {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getName() {
        return "NESTEDLOOP";
    }

    @Override
    public int scanCostType() {
        return 2;
    }

    @Override
    public String resultSetMethodName(boolean bulkFetch, boolean multiprobe) {
        if (bulkFetch) {
            return "getBulkTableScanResultSet";
        }
        if (multiprobe) {
            return "getMultiProbeTableScanResultSet";
        }
        return "getTableScanResultSet";
    }

    @Override
    public String joinResultSetMethodName() {
        return "getNestedLoopJoinResultSet";
    }

    @Override
    public String halfOuterJoinResultSetMethodName() {
        return "getNestedLoopLeftOuterJoinResultSet";
    }

    @Override
    public int getScanArgs(TransactionController tc, MethodBuilder mb, Optimizable innerTable, OptimizablePredicateList storeRestrictionList, OptimizablePredicateList nonStoreRestrictionList, ExpressionClassBuilderInterface acbi, int bulkFetch, MethodBuilder resultRowAllocator, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, int maxMemoryPerTable, boolean genInListVals, boolean delayScanOpening, boolean optimizeForOffHeap, boolean indexAccessesBaseTable) throws StandardException {
        int i;
        ExpressionClassBuilder acb = (ExpressionClassBuilder)acbi;
        if (nonStoreRestrictionList.size() != 0) {
            SanityManager.THROWASSERT((String)("nonStoreRestrictionList should be empty for nested loop join strategy, but it contains " + nonStoreRestrictionList.size() + " elements"));
        }
        int numArgs = genInListVals ? 31 : (bulkFetch > 1 ? 30 : 29);
        this.fillInScanArgs1(tc, mb, innerTable, storeRestrictionList, acb, resultRowAllocator);
        if (genInListVals) {
            ((PredicateList)storeRestrictionList).generateInListValues(acb, mb);
        }
        if (!genInListVals) {
            Predicate pred = null;
            for (i = storeRestrictionList.size() - 1; i >= 0; --i) {
                pred = (Predicate)storeRestrictionList.getOptPredicate(i);
                if (!pred.isInListProbePredicate()) continue;
                SanityManager.THROWASSERT((String)("Found IN-list probing predicate (" + pred.binaryRelOpColRefsToString() + ") when no such predicates were expected."));
            }
        }
        this.fillInScanArgs2(mb, innerTable, bulkFetch, colRefItem, indexColItem, lockMode, tableLocked, isolationLevel, delayScanOpening, optimizeForOffHeap, indexAccessesBaseTable);
        String myNonQualPreds = "";
        for (i = 0; i < storeRestrictionList.size(); ++i) {
            Predicate pred;
            if (storeRestrictionList.getOptPredicate(i) == null || (pred = (Predicate)storeRestrictionList.getOptPredicate(i)).isQualifier()) continue;
            myNonQualPreds = myNonQualPreds + ((Predicate)storeRestrictionList.getOptPredicate(i)).getAndNode().printExplainInfo();
        }
        if (myNonQualPreds.length() > 0) {
            mb.push(myNonQualPreds);
        } else {
            mb.pushNull("java.lang.String");
        }
        return numArgs;
    }

    @Override
    public void divideUpPredicateLists(Optimizable innerTable, OptimizablePredicateList originalRestrictionList, OptimizablePredicateList storeRestrictionList, OptimizablePredicateList nonStoreRestrictionList, OptimizablePredicateList requalificationRestrictionList, DataDictionary dd) throws StandardException {
        originalRestrictionList.setPredicatesAndProperties(storeRestrictionList);
    }

    @Override
    public boolean doesMaterialization() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    protected boolean validForOutermostTable() {
        return true;
    }
}

