/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.sql.compile.VerifySysfunctionExpressionVisitor;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RequiredRowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RowOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortCostController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaToSQLValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderedColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class GroupByList
extends OrderedColumnList
implements RequiredRowOrdering {
    int numGroupingColsAdded = 0;
    private boolean sortNeeded = true;
    private Object[] resultRow;
    private ResultSetNode resultToSort;
    private SortCostController scc;
    private int estimatedRowSize;

    public void addGroupByColumn(GroupByColumn column) {
        this.addElement(column);
    }

    public GroupByColumn getGroupByColumn(int position) {
        SanityManager.ASSERT((position >= 0 && position < this.size() ? 1 : 0) != 0, (String)("position (" + position + ") expected to be between 0 and " + this.size()));
        return (GroupByColumn)this.elementAt(position);
    }

    @Override
    public void printSubNodes(int depth) {
        for (int index = 0; index < this.size(); ++index) {
            ((GroupByColumn)this.elementAt(index)).treePrint(depth);
        }
    }

    public int getNumNeedToAddGroupingCols() {
        return this.numGroupingColsAdded;
    }

    public void bindGroupByColumns(SelectNode select, Vector aggregateVector) throws StandardException {
        FromList fromList = select.getFromList();
        ResultColumnList selectRCL = select.getResultColumns();
        SubqueryList dummySubqueryList = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        VerifySysfunctionExpressionVisitor checkJavaValueNode = new VerifySysfunctionExpressionVisitor();
        int numColsAddedHere = 0;
        int size = this.size();
        if (size > 32677) {
            throw StandardException.newException("54004", 32677);
        }
        for (int index = 0; index < size; ++index) {
            GroupByColumn groupByCol = (GroupByColumn)this.elementAt(index);
            groupByCol.bindExpression(fromList, dummySubqueryList, aggregateVector);
        }
        int rclSize = selectRCL.size();
        for (int index = 0; index < size; ++index) {
            boolean matchFound = false;
            GroupByColumn groupingCol = (GroupByColumn)this.elementAt(index);
            for (int inner = 0; inner < rclSize; ++inner) {
                ResultColumn selectListRC = (ResultColumn)selectRCL.elementAt(inner);
                if (!selectListRC.getExpression().isEquivalent(groupingCol.getColumnExpression())) continue;
                groupingCol.setColumnPosition(inner + 1);
                selectListRC.markAsGroupingColumn();
                matchFound = true;
                break;
            }
            if (!matchFound && !select.hasDistinct()) {
                ValueNode groupingExpr = groupingCol.getColumnExpression();
                ResultColumn newRC = (ResultColumn)this.getNodeFactory().getNode(80, groupingCol.getColumnName(), groupingExpr instanceof ColumnReference ? groupingCol.getColumnExpression().getClone() : groupingExpr, this.getContextManager());
                newRC.setVirtualColumnId(selectRCL.size() + 1);
                newRC.markGenerated();
                newRC.markAsGroupingColumn();
                selectRCL.addElement(newRC);
                groupingCol.setColumnPosition(selectRCL.size());
                selectRCL.setCountMismatchAllowed(true);
                ++numColsAddedHere;
            }
            if (!(groupingCol.getColumnExpression() instanceof JavaToSQLValueNode)) continue;
            groupingCol.getColumnExpression().accept(checkJavaValueNode);
            if (checkJavaValueNode.hasSysFun()) continue;
            throw StandardException.newException("42Y30");
        }
        SanityManager.ASSERT((dummySubqueryList.size() == 0 ? 1 : 0) != 0, (String)"dummySubqueryList.size() is expected to be 0");
        this.numGroupingColsAdded += numColsAddedHere;
        this.resultToSort = select;
    }

    public GroupByColumn findGroupingColumn(ValueNode node) throws StandardException {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            GroupByColumn gbc = (GroupByColumn)this.elementAt(i);
            if (!gbc.getColumnExpression().isEquivalent(node)) continue;
            return gbc;
        }
        return null;
    }

    public void remapColumnReferencesToExpressions() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            GroupByColumn gbc = (GroupByColumn)this.elementAt(index);
            ValueNode retVN = gbc.getColumnExpression().remapColumnReferencesToExpressions();
            SanityManager.ASSERT((boolean)(retVN instanceof ColumnReference), (String)("retVN expected to be instanceof ColumnReference, not " + retVN.getClass().getName()));
            gbc.setColumnExpression(retVN);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int index = 0; index < this.size(); ++index) {
            GroupByColumn groupingCol = (GroupByColumn)this.elementAt(index);
            buf.append(groupingCol.toString());
        }
        return buf.toString();
    }

    public void preprocess(int numTables, FromList fromList, SubqueryList whereSubquerys, PredicateList wherePredicates) throws StandardException {
        for (int index = 0; index < this.size(); ++index) {
            GroupByColumn groupingCol = (GroupByColumn)this.elementAt(index);
            groupingCol.setColumnExpression(groupingCol.getColumnExpression().preprocess(numTables, fromList, whereSubquerys, wherePredicates));
        }
    }

    public boolean isDSIDOnly() throws StandardException {
        if (this.size() != 1) {
            return false;
        }
        GroupByColumn groupingCol = (GroupByColumn)this.elementAt(0);
        return groupingCol.hasDSID();
    }

    @Override
    public int sortRequired(RowOrdering rowOrdering) throws StandardException {
        return this.sortRequired(rowOrdering, null);
    }

    @Override
    public int sortRequired(RowOrdering rowOrdering, JBitSet tableMap) throws StandardException {
        int position = 0;
        int size = this.size();
        for (int loc = 0; loc < size; ++loc) {
            GroupByColumn gbc = this.getGroupByColumn(loc);
            ValueNode expr = gbc.getColumnExpression();
            if (!(expr instanceof ColumnReference)) {
                return 1;
            }
            ColumnReference cr = (ColumnReference)expr;
            if (tableMap != null && !tableMap.get(cr.getTableNumber())) {
                for (int remainingPosition = loc + 1; remainingPosition < this.size(); ++remainingPosition) {
                    ColumnReference remainingcr;
                    GroupByColumn remaininggbc = this.getGroupByColumn(loc);
                    ValueNode remainingexpr = remaininggbc.getColumnExpression();
                    if (!(remainingexpr instanceof ColumnReference) || !tableMap.get((remainingcr = (ColumnReference)remainingexpr).getTableNumber())) continue;
                    return 1;
                }
                return 3;
            }
            if (rowOrdering.alwaysOrdered(cr.getTableNumber())) continue;
            if (!rowOrdering.orderedOnColumn(1, position, cr.getTableNumber(), cr.getColumnNumber()) && !rowOrdering.orderedOnColumn(2, position, cr.getTableNumber(), cr.getColumnNumber())) {
                return 1;
            }
            ++position;
        }
        return 3;
    }

    public void setTargetResultSet(ResultSetNode target) {
        this.resultToSort = target;
    }

    @Override
    public void estimateCost(double estimatedInputRows, RowOrdering rowOrdering, CostEstimate resultCost) throws StandardException {
        long inputRows;
        if (this.scc == null) {
            this.scc = this.getCompilerContext().getSortCostController();
            this.resultRow = this.resultToSort.getResultColumns().buildEmptyRow().getRowArray();
            this.estimatedRowSize = this.resultToSort.getResultColumns().getTotalColumnSize();
        }
        long exportRows = inputRows = (long)estimatedInputRows;
        double sortCost = this.scc.getSortCost((DataValueDescriptor[])this.resultRow, this.getColumnOrdering(), false, inputRows, exportRows, this.estimatedRowSize);
        resultCost.setCost(sortCost, estimatedInputRows, estimatedInputRows);
    }

    @Override
    public void sortNeeded() {
        this.sortNeeded = true;
    }

    @Override
    public void sortNotNeeded() {
        this.sortNeeded = false;
    }

    @Override
    public boolean getSortNeeded() {
        return this.sortNeeded;
    }
}

