/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DistinctQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ProjectRestrictNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SingleChildResultSetNode;
import java.util.Vector;

public class DistinctNode
extends SingleChildResultSetNode {
    boolean inSortedOrder;

    @Override
    public void init(Object childResult, Object inSortedOrder, Object tableProperties) throws StandardException {
        super.init(childResult, tableProperties);
        if (!(childResult instanceof Optimizable)) {
            SanityManager.THROWASSERT((String)("childResult, " + childResult.getClass().getName() + ", expected to be instanceof Optimizable"));
        }
        if (!(childResult instanceof FromTable)) {
            SanityManager.THROWASSERT((String)("childResult, " + childResult.getClass().getName() + ", expected to be instanceof FromTable"));
        }
        ResultColumnList prRCList = this.childResult.getResultColumns().copyListAndObjects();
        this.resultColumns = this.childResult.getResultColumns();
        this.childResult.setResultColumns(prRCList);
        this.resultColumns.genVirtualColumnNodes(this, prRCList);
        this.resultColumns.verifyAllOrderable();
        this.inSortedOrder = (Boolean)inSortedOrder;
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        CostEstimate childCost = ((Optimizable)((Object)this.childResult)).optimizeIt(optimizer, predList, outerCost, rowOrdering);
        return super.optimizeIt(optimizer, predList, outerCost, rowOrdering);
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        CostEstimate childCost = ((Optimizable)((Object)this.childResult)).estimateCost(predList, cd, outerCost, optimizer, rowOrdering);
        this.costEstimate = this.getCostEstimate(optimizer);
        this.costEstimate.setCost(childCost.getEstimatedCost(), childCost.rowCount(), childCost.singleScanRowCount());
        return this.costEstimate;
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        return false;
    }

    @Override
    public String toString() {
        return this.childResult.toString() + "\n" + super.toString();
    }

    @Override
    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicates, double outerRows) throws StandardException {
        this.childResult = (ProjectRestrictNode)this.childResult.optimize(dataDictionary, predicates, outerRows);
        Optimizer optimizer = this.getOptimizer((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this, this.getContextManager()), predicates, dataDictionary, null);
        this.costEstimate = optimizer.newCostEstimate();
        this.costEstimate.setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    @Override
    boolean isOrderedOn(ColumnReference[] crs, boolean permuteOrdering, Vector fbtVector) {
        return false;
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.assignResultSetNumber();
        this.costEstimate = this.childResult.getFinalCostEstimate();
        int orderItem = acb.addItem(acb.getColumnOrdering(this.resultColumns));
        acb.pushGetResultSetFactoryExpression(mb);
        this.childResult.generate(acb, mb);
        mb.push(true);
        mb.push(this.inSortedOrder);
        mb.push(orderItem);
        this.resultColumns.generateHolder(acb, mb);
        mb.push(this.resultColumns.getTotalColumnSize());
        mb.push(this.resultSetNumber);
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getSortResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 9);
    }

    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        return new DistinctQueryInfo(qic, this.resultColumns, qic.getParentPRN() != null ? qic.getParentPRN().getResultColumns() : null, true);
    }

    @Override
    public ResultSetNode getInnerMostPRN() {
        return this;
    }

    @Override
    public QueryInfo computeSubSelectQueryInfo(QueryInfoContext qic) throws StandardException {
        return ProjectRestrictNode.getSelectQueryInfo(qic, this);
    }

    @Override
    protected void optimizeForOffHeap(boolean shouldOptimize) {
        this.childResult.optimizeForOffHeap(false);
    }
}

