/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.CursorInfo;
import com.pivotal.gemfirexd.internal.impl.sql.CursorTableReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CollectAndEliminateColumnsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DMLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParameterNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.ArrayList;
import java.util.Vector;

public class CursorNode
extends DMLStatementNode {
    public static final int UNSPECIFIED = 0;
    public static final int READ_ONLY = 1;
    public static final int UPDATE = 2;
    public static final String SELECT_QUERY = "SELECT";
    private String name;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;
    private String statementType;
    private int updateMode;
    private boolean needTarget;
    private Vector updatableColumns;
    private FromTable updateTable;
    private ResultColumnDescriptor[] targetColumnDescriptors;
    private int indexOfSessionTableNamesInSavedObjects = -1;

    @Override
    public void init(Object statementType, Object resultSet, Object name, Object orderByList, Object offset, Object fetchFirst, Object updateMode, Object updatableColumns) {
        this.init(resultSet);
        this.name = (String)name;
        this.statementType = (String)statementType;
        this.orderByList = (OrderByList)orderByList;
        this.offset = (ValueNode)offset;
        this.fetchFirst = (ValueNode)fetchFirst;
        this.updateMode = (Integer)updateMode;
        this.updatableColumns = (Vector)updatableColumns;
        SanityManager.ASSERT((this.updatableColumns == null || this.updatableColumns.size() == 0 || this.updateMode == 2 ? 1 : 0) != 0, (String)"Can only have explicit updatable columns if update mode is UPDATE");
    }

    @Override
    public String toString() {
        return "name: " + this.name + "\n" + "updateMode: " + CursorNode.updateModeString(this.updateMode) + "\n" + super.toString();
    }

    @Override
    public String statementToString() {
        return this.statementType;
    }

    private static String updateModeString(int updateMode) {
        switch (updateMode) {
            case 0: {
                return "UNSPECIFIED (0)";
            }
            case 1: {
                return "READ_ONLY (1)";
            }
            case 2: {
                return "UPDATE (2)";
            }
        }
        return "UNKNOWN VALUE (" + updateMode + ")";
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "orderByList: ");
        if (this.orderByList != null) {
            this.orderByList.treePrint(depth + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindStatement() throws StandardException {
        ArrayList sessionSchemaTableNames;
        DataDictionary dataDictionary = this.getDataDictionary();
        if (this.orderByList != null) {
            this.orderByList.pullUpOrderByColumns(this.resultSet);
        }
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        try {
            FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            this.resultSet.eliminateExtraColumns();
            this.resultSet.rejectParameters();
            super.bind(dataDictionary);
            this.resultSet.bindResultColumns(fromList);
            this.resultSet.bindUntypedNullsToResultColumns(null);
            this.resultSet.rejectXMLValues();
            SanityManager.ASSERT((fromList.size() == 0 ? 1 : 0) != 0, (String)("fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()"));
        }
        finally {
            this.getCompilerContext().popCurrentPrivType();
        }
        if (this.orderByList != null) {
            this.orderByList.bindOrderByColumns(this.resultSet);
        }
        this.bindOffsetFetch();
        if (this.updateMode == 2) {
            int checkedUpdateMode = this.determineUpdateMode(dataDictionary);
            SanityManager.DEBUG((String)"DumpUpdateCheck", (String)("update mode is UPDATE (" + this.updateMode + ") checked mode is " + checkedUpdateMode));
            if (this.updateMode != checkedUpdateMode) {
                throw StandardException.newException("42Y90");
            }
        }
        if (this.updateMode == 0) {
            this.updateMode = this.getLanguageConnectionContext().getStatementContext().isForReadOnly() ? 1 : this.determineUpdateMode(dataDictionary);
        }
        if (this.updateMode == 1) {
            this.updatableColumns = null;
        }
        if (this.updateMode == 2) {
            this.bindUpdateColumns(this.updateTable);
            if (this.updateTable instanceof FromTable) {
                this.updateTable.markUpdatableByCursor(this.updatableColumns);
                this.resultSet.getResultColumns().markColumnsInSelectListUpdatableByCursor(this.updatableColumns);
            }
        }
        this.resultSet.renameGeneratedResultNames();
        if (this.getLanguageConnectionContext().checkIfAnyDeclaredGlobalTempTablesForThisConnection() && (sessionSchemaTableNames = this.getSessionSchemaTableNamesForCursor()) != null) {
            this.indexOfSessionTableNamesInSavedObjects = this.getCompilerContext().addSavedObject(sessionSchemaTableNames);
        }
        if (!Boolean.parseBoolean(PropertyUtil.getSystemProperty(GfxdConstants.GFXD_DISABLE_COLUMN_ELIMINATION))) {
            CollectAndEliminateColumnsVisitor finder = new CollectAndEliminateColumnsVisitor();
            this.accept(finder);
            finder.stopCollectingColumnReferences();
            this.resultSet.eliminateUnUsedColumns(null, finder);
        }
    }

    private void eliminateUnUsedColumns() throws StandardException {
        this.resultSet.eliminateUnUsedColumns(null, null);
    }

    private void bindOffsetFetch() throws StandardException {
        long val;
        DataValueDescriptor dvd;
        if (this.offset instanceof ConstantNode) {
            dvd = ((ConstantNode)this.offset).getValue();
            val = dvd.getLong();
            if (val < 0L) {
                throw StandardException.newException("2201X", Long.toString(val));
            }
        } else if (this.offset instanceof ParameterNode) {
            this.offset.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(-5), false));
        }
        if (this.fetchFirst instanceof ConstantNode) {
            dvd = ((ConstantNode)this.fetchFirst).getValue();
            val = dvd.getLong();
            if (val < 1L) {
                throw StandardException.newException("2201W", Long.toString(val));
            }
        } else if (this.fetchFirst instanceof ParameterNode) {
            this.fetchFirst.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(-5), false));
        }
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    protected ArrayList getSessionSchemaTableNamesForCursor() throws StandardException {
        FromList fromList = this.resultSet.getFromList();
        int fromListSize = fromList.size();
        ArrayList<String> sessionSchemaTableNames = null;
        for (int i = 0; i < fromListSize; ++i) {
            FromTable fromTable = (FromTable)fromList.elementAt(i);
            if (!(fromTable instanceof FromBaseTable) || !this.isSessionSchema(fromTable.getTableDescriptor().getSchemaDescriptor())) continue;
            if (sessionSchemaTableNames == null) {
                sessionSchemaTableNames = new ArrayList<String>();
            }
            sessionSchemaTableNames.add(fromTable.getTableName().getTableName());
        }
        return sessionSchemaTableNames;
    }

    private int determineUpdateMode(DataDictionary dataDictionary) throws StandardException {
        if (this.updateMode == 1) {
            return 1;
        }
        if (this.orderByList != null) {
            SanityManager.DEBUG((String)"DumpUpdateCheck", (String)"cursor has order by");
            return 1;
        }
        if (!this.resultSet.isUpdatableCursor(dataDictionary)) {
            return 1;
        }
        this.updateTable = this.resultSet.getCursorTargetTable();
        if (this.updateTable.markAsCursorTargetTable()) {
            this.needTarget = true;
            this.genTargetResultColList();
        }
        return 2;
    }

    @Override
    public void optimizeStatement() throws StandardException {
        if (this.orderByList != null) {
            if (this.orderByList.size() > 1) {
                this.orderByList.removeDupColumns();
            }
            this.resultSet.pushOrderByList(this.orderByList);
            this.orderByList = null;
        }
        super.optimizeStatement(this.offset, this.fetchFirst);
    }

    @Override
    int activationKind() {
        return 4;
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.indexOfSessionTableNamesInSavedObjects != -1) {
            MethodBuilder constructor = acb.getConstructor();
            constructor.pushThis();
            constructor.push(this.indexOfSessionTableNamesInSavedObjects);
            constructor.putField("com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "indexOfSessionTableNamesInSavedObjects", "int");
            constructor.endStatement();
        }
        this.generateParameterValueSet(acb);
        this.optimizeForOffHeap(true);
        this.resultSet.markStatementResultSet();
        this.generateAuthorizeCheck(acb, mb, 1);
        this.resultSet.generate(acb, mb);
        if (this.needTarget) {
            acb.rememberCursor(mb);
            acb.addCursorPositionCode();
        }
    }

    public String getUpdateBaseTableName() {
        return this.updateTable == null ? null : this.updateTable.getBaseTableName();
    }

    public String getUpdateExposedTableName() throws StandardException {
        return this.updateTable == null ? null : this.updateTable.getExposedName();
    }

    public String getUpdateSchemaName() throws StandardException {
        return this.updateTable == null ? null : ((FromBaseTable)this.updateTable).getTableNameField().getSchemaName();
    }

    public int getUpdateMode() {
        return this.updateMode;
    }

    private String[] getUpdatableColumns() {
        return this.updatableColumns == null ? (String[])null : this.getUpdateColumnNames();
    }

    private ResultColumnDescriptor[] genTargetResultColList() throws StandardException {
        if (this.updateTable == null) {
            return null;
        }
        if (this.targetColumnDescriptors != null) {
            return this.targetColumnDescriptors;
        }
        ResultColumnList newList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ResultColumnList rcl = this.updateTable.getResultColumns();
        int rclSize = rcl.size();
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn origCol = (ResultColumn)rcl.elementAt(index);
            ValueNode newNode = (ValueNode)this.getNodeFactory().getNode(94, origCol.getName(), this.makeTableName(origCol.getSchemaName(), origCol.getTableName()), origCol.getTypeServices(), this.getContextManager());
            ResultColumn newCol = (ResultColumn)this.getNodeFactory().getNode(80, origCol.columnDescriptor, newNode, this.getContextManager());
            newList.addResultColumn(newCol);
        }
        this.targetColumnDescriptors = newList.makeResultDescriptors();
        return this.targetColumnDescriptors;
    }

    @Override
    public boolean needsSavepoint() {
        return false;
    }

    @Override
    public Object getCursorInfo() throws StandardException {
        if (!this.needTarget) {
            return null;
        }
        return new CursorInfo(this.updateMode, new CursorTableReference(this.getUpdateExposedTableName(), this.getUpdateBaseTableName(), this.getUpdateSchemaName()), this.genTargetResultColList(), this.getUpdatableColumns());
    }

    private void bindUpdateColumns(FromTable targetTable) throws StandardException {
        int size = this.updatableColumns.size();
        ResultColumnList rcls = this.resultSet.getResultColumns();
        for (int index = 0; index < size; ++index) {
            String columnName = (String)this.updatableColumns.elementAt(index);
            TableDescriptor tableDescriptor = targetTable.getTableDescriptor();
            if (tableDescriptor.getColumnDescriptor(columnName) == null) {
                throw StandardException.newException("42X04", columnName);
            }
            for (int rclsIndex = 0; rclsIndex < rcls.size(); ++rclsIndex) {
                ResultColumn rc = (ResultColumn)rcls.elementAt(rclsIndex);
                if (rc.getSourceTableName() == null || rc.getExpression() == null || !rc.getExpression().getColumnName().equals(columnName) || rc.getName().equals(columnName)) continue;
                throw StandardException.newException("42X42", columnName);
            }
        }
    }

    private String[] getUpdateColumnNames() {
        int size = this.updatableColumns.size();
        if (size == 0) {
            return null;
        }
        Object[] names = new String[size];
        this.updatableColumns.copyInto(names);
        return names;
    }

    public String getXML() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        if (this.statementType.equals(SELECT_QUERY)) {
            SelectQueryInfo info = new SelectQueryInfo(qic, this.updatableColumns);
            qic.setOptimizer(this.optimizer);
            try {
                qic.setRootQueryInfo(info);
                this.accept(info);
                if (this.updatableColumns != null && !this.updatableColumns.isEmpty()) {
                    info.setPrimaryKeyColumnsInformationFromProjection(this.getLanguageConnectionContext(), this.getUpdateSchemaName(), this.getUpdateBaseTableName());
                }
                SelectQueryInfo selectQueryInfo = info;
                return selectQueryInfo;
            }
            finally {
                qic.cleanUp();
            }
        }
        return null;
    }
}

