/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;

public class CreateSchemaNode
extends DDLStatementNode {
    private String name;
    private String aid;

    @Override
    public void init(Object schemaName, Object aid) throws StandardException {
        this.initAndCheck(null);
        this.name = (String)schemaName;
        this.aid = (String)aid;
    }

    @Override
    public String toString() {
        return super.toString() + "schemaName: " + "\n" + this.name + "\n" + "authorizationId: " + "\n" + this.aid + "\n";
    }

    @Override
    public void bindStatement() throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        if (this.isPrivilegeCollectionRequired()) {
            cc.addRequiredSchemaPriv(this.name, this.aid, 16);
        }
    }

    @Override
    public String statementToString() {
        return "CREATE SCHEMA";
    }

    @Override
    public ConstantAction makeConstantAction() {
        return this.getGenericConstantActionFactory().getCreateSchemaConstantAction(this.name, this.aid);
    }
}

